/**********************************************************************
 
	Copyright (C) 2003-2004
	Hirohisa MORI <joshua@nichibun.ac.jp>
	Tomoki SEKIYAMA <sekiyama@yahoo.co.jp>
 
	This program is free software; you can redistribute it 
	and/or modify it under the terms of the GLOBALBASE 
	Library General Public License (G-LGPL) as published by 

	http://www.globalbase.org/
 
	This program is distributed in the hope that it will be 
	useful, but WITHOUT ANY WARRANTY; without even the 
	implied warranty of MERCHANTABILITY or FITNESS FOR A 
	PARTICULAR PURPOSE.

**********************************************************************/



#include <string.h>

#include "v/VMenu.h"
#include "v/VWindow.h"
#include "v/VEditable.h"
#include "v/VWindow.h"
extern "C" {
#include "memory_debug.h"
#include "lock_level.h"
}

/*
typedef struct menu_lock_inheritance {
	struct menu_lock_inheritance *	next;
	int				tid;
} MENU_LOCK_INHERITANCE;
*/

int	VMenuItem::cnt = 0;
SEM _menu_lock;
int menu_lock_cnt;
int menu_lock_line;
int menu_lock_tid;
char * menu_lock_file;
int menu_unlock_line;
char * menu_unlock_file;
int inheritance_id;

extern "C" {
void (*ms_lock_func)(char *,int);
void (*ms_unlock_func)();
void (*ms_inheritance_func)(int,char*,int);

int inheritance_mode;
}


void
VMenuItem::set_member_vars(
		int id,
		short type,
		short flag,
		L_CHAR *name,
		LC_WRITING_STYLE *ws,
		short modifier,
		char shortcut_key,
		char access_key,
		V_CALLBACK(func),
		int func_data,
		VMenuBar *menu_bar) {
	this->id = id;
	this->name = name ? ll_copy_str(name) : 0;
	this->ws = ws;
	this->flag = flag;
	this->type = type;
	this->modifier = modifier;
	this->shortcut_key = shortcut_key;
	this->access_key = access_key;
	this->func = func;
	this->menu_bar = menu_bar;
	this->submenu = 0;
	this->next = 0;
	this->user_work = func_data;
	memset(&info, 0, sizeof(VMenuItemInfo));
	cnt++;
}

VMenuItem::VMenuItem(VMenuItem& menu)
{
	set_member_vars(
		menu.id, menu.type, menu.flag,
		0, menu.ws,
		menu.modifier,
		menu.shortcut_key,
		menu.access_key,
		menu.func,
		menu.user_work, 0);
	name = menu.name ? ll_copy_str(menu.name) : 0;
}


VMenuItem::VMenuItem(VMenuItem& menu, VMenuBar *menu_bar)
{
	set_member_vars(
		menu.id, menu.type, menu.flag,
		0, menu.ws,
		menu.modifier,
		menu.shortcut_key,
		menu.access_key,
		menu.func,menu.user_work,
		 menu_bar);
	name = menu.name ? ll_copy_str(menu.name) : 0;
	VMenuItem *last = 0, *m, *item;
	if ( menu.submenu )
		submenu = new VMenuItem(*menu.submenu, menu_bar);
	for ( m = menu.next ; m ; m = m->next ) {
		item = new VMenuItem(*m);
		item->menu_bar = menu_bar;
		if ( last )
			last->next = item;
		else
			next = item;
		last = item;
		if ( m->submenu )
			item->submenu = new VMenuItem(*m->submenu, menu_bar);
	}
}


VMenuItem::~VMenuItem()
{
	if ( name )
		d_f_ree(name);
	if ( next )
		delete next;
	if ( submenu )
		delete submenu;
	cnt--;
}


VMenuItem*
VMenuItem::_modify_VMenuItem(VMenuItem * start,short * type_list,int cmd,VMenuItem * itm)
{
int count;
VMenuItem * last,*ret;
	count = 0;
	for ( ; start ; start = start->next ) {
		if ( start->type != type_list[0] )
			continue;
		count ++;
		if ( count < type_list[1] )
			continue;
		if ( type_list[2] ) 
			return _modify_VMenuItem(start->submenu,&type_list[2],cmd,itm);
		switch ( cmd ) {
		case VMI_MOD_SEARCH:
			return start;
		case VMI_MOD_INSERT_AFTER:
			if ( itm == 0 )
				return 0;
			for ( last = itm ; last->next ; last = last->next );
			last->next = start->next;
			start->next = itm;
			return itm;
		case VMI_MOD_DEL_AFTERALL:
			ret = start->next;
			start->next = 0;
			return ret;
		default:
			er_panic("VMenuItem");
		}
	}
	return 0;
}

VMenuItem*
VMenuItem::_modify_VMenuItem(VMenuItem **prev,short * type_list,int cmd,VMenuItem * itm)
{
int count;
VMenuItem * ret,* last,* target;
	count = 0;
	for ( ; *prev ; prev = &(*prev)->next ) {
		target = *prev;
		if ( target->type != type_list[0] )
			continue;
		count ++;
		if ( count < type_list[1] )
			continue;
		if ( type_list[2] )
			return _modify_VMenuItem(&target->submenu,&type_list[2],cmd,itm);
		switch ( cmd ) {
		case VMI_MOD_INSERT_BEFORE:
			if ( itm == 0 )
				return 0;
			for ( last = itm ; last->next ; last = last->next );
			last->next = target;
			*prev = itm;
			return itm;
		case VMI_MOD_DELETE:
			ret = target;
			*prev = target->next;
			return ret;
		default:
			er_panic("VMenuItem");
		}
	}
	return 0;
}

VMenuItem *
VMenuItem::modify_VMenuItem(short * type_list,int cmd,VMenuItem *itm)
{
	return _modify_VMenuItem(this,type_list,cmd,itm);
}

VMenuItem *
VMenuItem::modify_VMenuItem(short * type_list,int cmd,VMenuItem *itm,VMenuItem ** prev)
{
	return _modify_VMenuItem(prev,type_list,cmd,itm);
}

VMenuItem * 
VMenuItem::search_VMenuItem(VMenuItem * itm,short id)
{
VMenuItem * ret;
	for ( ; itm ; itm = itm->next ) {
		if ( itm->type == id )
			return itm;
		if ( itm->submenu ) {
			ret = search_VMenuItem(itm->submenu,id);
			if ( ret )
				return ret;
		}
	}
	return 0;
}


void
VMenuItem::set_submenu(VMenuItem *menu)
{
	if ( submenu )
		delete submenu;
	submenu = menu;
}

void
VMenuItem::append(VMenuItem *menu, int where)
{
	VMenuItem *prev = 0;
	int cnt = 1;
	if ( where != 1 && submenu ) {
		for ( prev = submenu ; prev->next ; prev = prev->next ) {
			if ( ++cnt == where )
				break;
		}
		menu->next = prev->next;
		prev->next = menu;
	}
	else {
		menu->next = submenu;
		submenu = menu;
	}
}

void
VMenuItem::append_to_list(VMenuItem *menu)
{
	VMenuItem *item;
	for ( item = this ; item->next ; item = item->next ) {}
	item->next = menu;
	menu->next = 0;
}

void
VMenuItem::merge(VMenuItem *from)
{
	int name_match;
	VMenuItem *m;
	append(new VMenuItem(VMT_SEPARATOR,0,0,0,0,0,0,0,0));
	for ( from = from->submenu ; from ; from = from->next ) {
		if ( from->type != VMT_SEPARATOR ) {
			for ( m = submenu ; m ; m = m->next ) {
				if ( m->type == VMT_SEPARATOR )
					continue;
				name_match = from->name && m->name && l_strcmp(from->name, m->name)==0;
				if ( name_match || m->id == from->id ) {
					if ( from->submenu ) {
						if ( m->submenu )
							m->merge(from);
						else
							m->submenu = new VMenuItem(*from->submenu, from->menu_bar);
					}
					if ( ! name_match ) {
						d_f_ree(m->name);
						m->name = ll_copy_str(from->name);
					}
					m->flag = from->flag;
					m->modifier = from->modifier;
					m->shortcut_key = from->shortcut_key;
					m->access_key = from->access_key;
					m->func = from->func;
					m->user_work = from->user_work;
					break;
				}
			}
		}
		if ( m == 0 ) {
			append(new VMenuItem(*from, from->menu_bar));
		}
	}
}

void
VMenuItem::remove(VMenuItem *menu)
{
	VMenuItem *prev = 0, *m;
	for ( m = submenu ; m && m != menu ; prev = m, m = m->next ) {}
	if ( m ) {
		if ( prev )
			prev->next = m->next;
		else
			submenu = m->next;
		m->next = 0;
	}
}

void
VMenuItem::remove_from_list(VMenuItem *menu, VMenuItem **from_list)
{
	VMenuItem *prev = 0, *m;
	for ( m = *from_list ; m && m != menu ; prev = m, m = m->next ) {}
	if ( m ) {
		if ( prev )
			prev->next = m->next;
		else
			*from_list = m->next;
	}
	m->next = 0;
}

int
VMenuItem::get_user_work()
{
	return user_work;
}

void
VMenuItem::refrect_information(VCustomizedMenuBar * cm,VCustomizedMenuBar * cm_org)
{
VMenuItem * itm,* org;
	for ( itm = this ; itm ; itm = itm->next ) {
		if ( itm->submenu )
			itm->submenu->refrect_information(cm,cm_org);
		org = cm_org->search(itm->id);
		if ( org == 0 )
			continue;
		cm->set_menu_flag(itm->id,org->flag);
		if ( itm->func == 0 )
			cm->set_menu_func(itm->id,org->func,org->user_work);
	}
}

VMenuBar*	VMenuBar::v_menu_bars = 0;

VMenuBar::VMenuBar(VMenuItem *items, int category, bool base)
	: items(items), category(category), base(base)
{
	next = v_menu_bars;
	v_menu_bars = this;
/*
ss_printf("IN MENU-BAR\n");
items->debug_print(1);
ss_printf("IN MENU-BAR-END\n");
*/
	if ( category == 0 )
		init();
}

VMenuBar::~VMenuBar()
{
	VMenuBar *m, *prev = 0;
	delete items;
	for ( m = v_menu_bars ; m && m != this ; prev = m, m = m->next ) {}
	if ( m == 0 )
		return;	// sub class is not in the list
	if ( prev )
		prev->next = next;
	else
		v_menu_bars = next;
}

void
VMenuBar::debug_print(int indent)
{
	if ( items == 0 )
		return;
	items->debug_print(indent);
}


VMenuBar *
VMenuBar::get_menu_bar(int category)
{
	for ( VMenuBar *m = v_menu_bars ; m ; m = m->next )
		if ( m->category == category )
			return m;
	return 0;
}

VMenuItem*
VMenuBar::search_VMenuItem(short id)
{
	return items->search_VMenuItem(items,id);
}

VMenuItem *
VMenuBar::modify_VMenuItem(short * type_list,int cmd,VMenuItem * itm)
{
VMenuItem * ret;
	switch ( cmd ) {
	case VMI_MOD_SEARCH:
	case VMI_MOD_INSERT_AFTER:
	case VMI_MOD_DEL_AFTERALL:
		if ( items == 0 )
			return 0;
		ret = items->modify_VMenuItem(type_list,cmd,itm);
		break;
	case VMI_MOD_INSERT_BEFORE:
	case VMI_MOD_DELETE:
		if ( items == 0 )
			return 0;
		ret = items->modify_VMenuItem(type_list,cmd,itm,&items);
		break;
	default:
		er_panic("modify_VMenuItem");
	}
	if ( cmd != VMI_MOD_SEARCH )
		VMenuBar::refresh_menu_bar(category);
	return ret;
}

V_CALLBACK_D(VMenuBar::refresh_menu_bar)
{
int category;
	if ( window_list == 0 )
		return;
	VCustomizedMenuBar::menu_lock((char*)__FILE__,__LINE__);
	category = (int)user_arg;
	window_list->refresh_menu_bar(category);
	VCustomizedMenuBar::menu_unlock((char*)__FILE__,__LINE__);
}

void
VMenuBar::refresh_menu_bar(int category)
{
	vq_insert_callback_machine(0,refresh_menu_bar,(void*)category,0,0,0,0);
}

VCustomizedMenuBar *
VCustomizedMenuBar::create(int category, VWindow *window)
{
	VMenuBar *bar = VMenuBar::get_menu_bar(category);
	if ( bar )
		return new VCustomizedMenuBar(bar, window);
	return 0;
}

VCustomizedMenuBar::VCustomizedMenuBar(VMenuBar *bar, VWindow *window)
	: window(window)
{
	this->category = bar->get_category();
	base = bar->is_base();
	make_customized_menu(bar);
	hash = new VMenuItemHash(this);

}

void
VCustomizedMenuBar::update(VMenuItem *menus)
{
	if ( menus == 0 )
		menus = items;
	VEditable *focused = VEditable::get_focused_object();
	for ( ; menus ; menus = menus->next ) {
		short flag = menus->flag;
		if ( focused && 
				menus->type >= VMT_EDIT_START  && menus->type <= VMT_EDIT_END ) {
			if ( focused->command_status(menus->type) )
				flag |= VMF_ENABLED;
			else
				flag &= ~VMF_ENABLED;
		}
//		char *debug = n_string(std_cm, menus->name);
		set_menu_flag_do(menus, flag);
		if ( menus->submenu )
			update(menus->submenu);
	}
}

bool
VCustomizedMenuBar::set_menu_func(int id, V_CALLBACK(func),int data)
{
	bool ret = false;
	VMenuItem *item = hash->search(id);
	if ( item ) {
		item->func = func;
		item->user_work = data;
		ret = true;
	}
	return ret;
}

bool
VCustomizedMenuBar::get_menu_name(int id, const L_CHAR **name)
{
	bool ret = false;
	VMenuItem *item = hash->search(id);
	if ( item ) {
		*name = item->name;
		ret = true;
	}
	return ret;
}

bool
VCustomizedMenuBar::set_menu_name(int id, const L_CHAR *name)
{
	bool ret = false;
	VMenuItem *item = hash->search(id);
	if ( item ) {
		if ( item->name )
			d_f_ree(item->name);
		item->name = ll_copy_str(const_cast<L_CHAR*>(name));
		set_menu_name_do(item, name);
		ret = true;
	}
	return ret;
}

bool
VCustomizedMenuBar::get_menu_flag(int id, short *flag)
{
	bool ret = false;
	VMenuItem *item = hash->search(id);
	if ( item ) {
		*flag = item->flag;
		ret = true;
	}
	return ret;
}

bool
VCustomizedMenuBar::set_menu_flag(int id, short flag)
{
	bool ret = false;
	VMenuItem *item = hash->search(id);
	if ( item ) {
		item->flag = flag;
		set_menu_flag_do(item, flag);
		ret = true;
	}
	return ret;
}


V_CALLBACK_D(VCustomizedMenuBar::set_menu_flag_que)
{
SET_MENU_T * sm;
VCustomizedMenuBar * mb;
	sm = (SET_MENU_T*)user_arg;
	menu_lock((char*)__FILE__,__LINE__);
	mb = sm->win->get_menu_bar();
	if ( mb )
		mb->set_menu_flag(sm->id,sm->flag);
	menu_unlock((char*)__FILE__,__LINE__);
	d_f_ree(sm);
}

void
VCustomizedMenuBar::set_menu_flag_que(VWindow * win,int id, short flag)
{
SET_MENU_T * sm;
	sm = (SET_MENU_T*)d_alloc(sizeof(*sm));
	sm->id = id;
	sm->flag = flag;
	sm->win = win;
	vq_insert_callback_machine(0,set_menu_flag_que,sm,0,0,0,0);
}

V_CALLBACK_D(VCustomizedMenuBar::set_menu_func_que)
{
SET_MENU_T * sm;
VCustomizedMenuBar * mb;
	sm = (SET_MENU_T*)user_arg;
	menu_lock((char*)__FILE__,__LINE__);
	mb = sm->win->get_menu_bar();
	if ( mb )
		mb->set_menu_func(sm->id,sm->func,sm->data);
	menu_unlock((char*)__FILE__,__LINE__);
	d_f_ree(sm);
}

void
VCustomizedMenuBar::set_menu_func_que(VWindow * win,int id, V_CALLBACK(func),int data)
{
SET_MENU_T * sm;
	sm = (SET_MENU_T*)d_alloc(sizeof(*sm));
	sm->id = id;
	sm->func = func;
	sm->data = data;
	sm->win = win;
	vq_insert_callback_machine(0,set_menu_func_que,sm,0,0,0,0);
}

V_CALLBACK_D(VCustomizedMenuBar::set_menu_name_que)
{
SET_MENU_T * sm;
VCustomizedMenuBar * mb;
	sm = (SET_MENU_T*)user_arg;
	menu_lock((char*)__FILE__,__LINE__);
	mb = sm->win->get_menu_bar();
	if ( mb )
		mb->set_menu_name(sm->id,sm->name);
	menu_unlock((char*)__FILE__,__LINE__);
	d_f_ree(sm->name);
	d_f_ree(sm);
}

void
VCustomizedMenuBar::set_menu_name_que(VWindow * win,int id, L_CHAR * name)
{
SET_MENU_T * sm;
	sm = (SET_MENU_T*)d_alloc(sizeof(*sm));
	sm->id = id;
	sm->name = name;
	sm->win = win;
	vq_insert_callback_machine(0,set_menu_name_que,sm,0,0,0,0);
}


bool
VCustomizedMenuBar::menu_choosed(VMenuItem *item)
{
	VEditable *focused = VEditable::get_focused_object();
	if ( item == 0 )
		return false;
	if ( focused && item->type != VMT_OTHER && item->type != VMT_SEPARATOR && item->type >= 0 )
		if ( focused->obey_command(item->type) )
			return true;
	
	if ( item && item->func ) {
#ifdef MENU_ITEM_INHERIT
		VCustomizedMenuBar::menu_lock((char*)__FILE__,__LINE__);
		item->i_tid = VCustomizedMenuBar::menu_lock_inheritance_from();
		vq_insert_callback(window, item->func, item, 0, 0,0);
#else
printf("FUNC = %p\n",item->func);
		vq_insert_callback_machine(window, item->func, item, 0, 0,0 ,&item->i_tid);
#endif
		return true;
	}
	return false;
}

void
VCustomizedMenuBar::add_flag_hierarchic(VMenuItem *items, short flag)
{
	for ( ; items ; items = items->next ) {
		items->flag |= flag;
		
		if ( items->submenu )
			add_flag_hierarchic(items->submenu, flag);
	}
}

void
VCustomizedMenuBar::init_menu_lock()
{
	_menu_lock = new_lock(LL_MENU);
}


void 
VCustomizedMenuBar::menu_lock(char * file,int line) {
int tid;
	lock_task(_menu_lock);
	for ( ; inheritance_mode ; ) {
		sleep_task((int)&inheritance_mode,_menu_lock);
		lock_task(_menu_lock);
	}
	if ( ms_lock_func ) {
		unlock_task(_menu_lock,"menu_lock");
		(*ms_lock_func)(file,line);
	}
	else {
		tid = get_tid();
		if ( menu_lock_tid && menu_lock_tid != tid ) {
			for ( ; menu_lock_cnt != 0 ; ) {
				sleep_task((int)&_menu_lock,_menu_lock);
				lock_task(_menu_lock);
			}
		}
		menu_lock_cnt ++;
		menu_lock_tid = tid;
		menu_lock_file = file;
		menu_lock_line = line;
		unlock_task(_menu_lock,"menu_lock");
	}
/*
printf("menu_lock %s %i\n",file,line);
*/
}

void 
VCustomizedMenuBar::menu_unlock(char * file,int line) {
int tid;
	lock_task(_menu_lock);
	if ( ms_unlock_func ) {
		unlock_task(_menu_lock,"menu_unlock");
		(*ms_unlock_func)();
	}
	else {
		tid = get_tid();
		if  ( menu_lock_tid != tid )
			er_panic("menu_unlock(1)");
		menu_lock_cnt --;
		if ( menu_lock_cnt == 0 ) {
			wakeup_task((int)&_menu_lock);
			menu_lock_tid = 0;
		}
		if ( inheritance_mode && menu_lock_cnt == 1 )
			wakeup_task((int)&inheritance_mode);
		menu_unlock_file = file;
		menu_unlock_line = line;
		unlock_task(_menu_lock,"menu_unlock");
	}
/*
printf("menu_unlock %s %i\n",file,line);
*/
}

int
VCustomizedMenuBar::menu_lock_inheritance_from()
{
int ret;
	lock_task(_menu_lock);
	if ( inheritance_mode )
		er_panic("menu_lock_inheritance_from");
	if ( inheritance_id <= 0 )
		inheritance_id = 1;
	else	inheritance_id ++;
	ret = inheritance_mode = inheritance_id;
	unlock_task(_menu_lock,"menu_lock_inheritance_from");
	return ret;
}

void
VCustomizedMenuBar::menu_lock_inheritance(int itid,char * file,int line)
{
int tid;
	lock_task(_menu_lock);
	if ( inheritance_mode == 0 )
		er_panic("menu_lock_inheritance");
	if ( itid != inheritance_mode )
		er_panic("menu_lock_inheritance(2)");
	for ( ; menu_lock_cnt > 1 ; ) {
		sleep_task((int)&inheritance_mode,_menu_lock);
		lock_task(_menu_lock);
	}
	inheritance_mode = 0;
	if ( ms_unlock_func ) {
		(*ms_inheritance_func)(itid,file,line);
	}
	else {
		tid = get_tid();
		if ( menu_lock_tid == 0 )
			er_panic("menu_lock_inheritance(3)");
		menu_lock_tid = tid;
	}
	wakeup_task((int)&inheritance_mode);
	unlock_task(_menu_lock,"menu_unlock");
}

void
VMenuItemHash::add_menu_items(VMenuItem *menu)
{
	VMenuList *list;
	for ( ; menu ; menu = menu->next ) {
		int key = (unsigned)menu->id % v_menu_item_hash_size;
		list = new VMenuList;
		list->item = menu;
		list->next = hash[key];
		hash[key] = list;
		if ( menu->submenu )
			add_menu_items(menu->submenu);
	}
}

VMenuItemHash::VMenuItemHash(VMenuBar *bar)
{
	for ( int i = 0 ; i < v_menu_item_hash_size ; i++ )
		hash[i] = 0;
	add_menu_items(bar->get_items());
}

VMenuItem *
VMenuItemHash::search(int id) const
{
	int key = (unsigned)id % v_menu_item_hash_size;
	for ( VMenuHashNode node = hash[key] ; node ; node = node->next )
		if ( node->item->id == id )
			return node->item;
	return 0;
}

VMenuItemHash::~VMenuItemHash()
{
	VMenuHashNode node, next;
	for ( int i = 0 ; i < v_menu_item_hash_size ; i++ ) {
		for ( node = hash[i] ; node ; node = next ) {
			next = node->next;
			delete node;
		}
	}
}


void
VMenuItem::debug_print(int indent) {
	for ( int i = 0 ; i < indent ; i++ )
		putchar(' ');
	printf("[%x]", flag);
	const char *cname = name ? n_string(std_cm, name) : "-";
	puts(cname);
	if ( submenu )
		submenu->debug_print(indent+strlen(cname));
	if ( next )
		next->debug_print(indent);
}


V_CALLBACK_D(window_switch_callback)
{
VCustomizedMenuBar * bar;
	bar = static_cast<VCustomizedMenuBar*>(user_arg);
	bar->reset_menu_flags_do(-1);
}



