/**********************************************************************
 
	Copyright (C) 2003-2004
	Hirohisa MORI <joshua@nichibun.ac.jp>
	Tomoki SEKIYAMA <sekiyama@yahoo.co.jp>
 
	This program is free software; you can redistribute it 
	and/or modify it under the terms of the GLOBALBASE 
	Library General Public License (G-LGPL) as published by 

	http://www.globalbase.org/
 
	This program is distributed in the hope that it will be 
	useful, but WITHOUT ANY WARRANTY; without even the 
	implied warranty of MERCHANTABILITY or FITNESS FOR A 
	PARTICULAR PURPOSE.

**********************************************************************/



#include <stdlib.h>

#include "v/VTabView.h"
#include "v/vobj_utils.h"

extern "C" {
#include "xl.h"
#include "xlerror.h"

XL_SEXP *
vobj_VTabView(XLISP_ENV *env, XL_SEXP *arg, XLISP_ENV *a, XL_SYM_FIELD *sf);

XL_SEXP *
vobj_VTabView(XLISP_ENV *env, XL_SEXP *arg, XLISP_ENV *a, XL_SYM_FIELD *sf)
{
	XL_SEXP *ret = 0, *s;
	const L_CHAR **labels;
	const L_CHAR l_null[] = {0};
	int n_pages;
	int i;
	VTabView *obj;
	XL_SEXP * xl_er;

	XL_SEXP * _ref;

	VObjectStatus sts;
//	VObject::FreeList *free_list;
//	int flags = get_sts_from_sf(&sts,0, sf, &free_list);
//	VExError err;

/*	
	XL_SEXP *p = eval(env, n_get_symbol("__parent"));
	if ( get_type(p) == XLT_ERROR )
		return p;
	if ( get_type(p) != XLT_INTEGER )
		return vobj_get_error(initial_VExError(V_ER_PARENT,0,0), arg);
	VObject *parent = VObject::get_object_by_id(p->integer.data);
	
	sts.parent = parent;
	flags |= VSF_PARENT;
*/
	
	n_pages = 0;
	for ( s = cdr(arg) ; get_type(s) == XLT_PAIR ; s = cdr(s) ) {
		XL_SEXP *pg = car(s);
		if ( get_type(pg) != XLT_PAIR )
			goto type_missmatch;
		XL_SEXP *pg_s = car(pg);
		if ( get_type(pg_s) != XLT_SYMBOL
				|| l_strcmp(pg_s->symbol.data, l_string(std_cm, "VTabPage")) != 0 )
			return get_error(
				arg->h.file,
				arg->h.line,
				XLE_PROTO_INV_PARAM,
				l_string(std_cm,"VTabView"),
				n_get_string("VTabPage is expected"));
		n_pages++;
	}
	if ( get_type(s) )
		goto type_missmatch;
	
	i = 0;
	labels = new const L_CHAR*[n_pages];
	xl_er = 0;
	for ( s = cdr(arg) ; get_type(s) == XLT_PAIR ; s = cdr(s) ) {
		labels[i] = eval_carret(
				&xl_er,
				env,
				get_symbol_field(car(car(s)), l_string(std_cm, "label")),
				car(car(s)));
		if ( get_type(xl_er) == XLT_ERROR )
			break;
		if ( labels[i] == 0 )
			labels[i] = l_null;
		i++;
	}
	if ( get_type(xl_er) ) {
		delete labels;
		return xl_er;
	}

	_ref = get_refered_object_int_lc_list<VTabView>
			(&obj,env,arg,sf,VO_TABV,"VTabView",n_pages,labels);
	if ( get_type(_ref) == XLT_ERROR )
		return _ref;

/*
	obj = VTabView::create(&sts, flags, n_pages, labels, &err);
	delete labels;
	if ( err.code != V_ER_NO_ERR )
		return vobj_get_error(err, arg);
	obj->free_on_release_list(free_list);
*/	
	i = 0;
	for ( s = cdr(arg) ; get_type(s) == XLT_PAIR ; s = cdr(s) ) {
	VTabPage * tp;
		tp = obj->get_page(i);
		if ( tp == 0 )
			continue;
		tp->get_status(&sts, VSF_ID);
		XL_SEXP *res = vobj_eval_child(sts.id, env, car(s));
		if ( get_type(res) == XLT_ERROR )
			return res;
		ret = append(ret, res);
		i++;
	}

	switch ( get_type(_ref) ) {
	case XLT_INTEGER:
		return vobj_get_id_list(_ref->integer.data,ret,sf,0);
	case XLT_ERROR:
		return _ref;
	default:
		return 0;
	}
//	return vobj_get_id_list(sts.id, ret, sf,0);

type_missmatch:
	return get_error(
		arg->h.file,
		arg->h.line,
		XLE_SEMANTICS_TYPE_MISSMATCH,
		l_string(std_cm, "VTabView"),
		n_get_string("type missmatch"));
}

void
init_VTabView(XLISP_ENV *env)
{
	set_env(env,l_string(std_cm,"VTabView"),
		get_func_prim((XL_SEXP*(*)())vobj_VTabView,FO_NORMAL,0,2,-1));
}


} // extern "C"
