/**********************************************************************
 
	Copyright (C) 2003 Hirohisa MORI <joshua@nichibun.ac.jp>
 
	This program is free software; you can redistribute it 
	and/or modify it under the terms of the GLOBALBASE 
	Library General Public License (G-LGPL) as published by 

	http://www.globalbase.org/
 
	This program is distributed in the hope that it will be 
	useful, but WITHOUT ANY WARRANTY; without even the 
	implied warranty of MERCHANTABILITY or FITNESS FOR A 
	PARTICULAR PURPOSE.

**********************************************************************/


#include	"xlerror.h"
#include	"xl.h"

XL_SEXP * xl_IgnoreDelay();


void
init_IgnoreDelay(XLISP_ENV * env)
{
	set_env(env,l_string(std_cm,"IgnoreDelay"),
		get_func_prim(xl_IgnoreDelay,FO_NORMAL,0,2,3));
}

XL_SEXP *
xl_IgnoreDelay(XLISP_ENV * env,XL_SEXP * s)
{
XL_SEXP * ig, * next;

	if ( list_length(s) == 2 ) {
		ig = eval(env,get_el(s,1));
		if ( ig == 0 )
			return 0;
		if ( ig->h.type == XLT_ERROR )
			return ig;
		return 0;
	}
	else {
		ig = eval(env,get_el(s,1));
		if ( ig == 0 )
			return 0;
		if ( ig->h.type == XLT_ERROR )
			return ig;
		next = eval(env,get_el(s,2));
		if ( get_type(next) == XLT_ERROR )
			return next;
		return cons(ig,next);
	}
}


