/**********************************************************************
 
	Copyright (C) 2003 Hirohisa MORI <joshua@nichibun.ac.jp>
 
	This program is free software; you can redistribute it 
	and/or modify it under the terms of the GLOBALBASE 
	Library General Public License (G-LGPL) as published by 

	http://www.globalbase.org/
 
	This program is distributed in the hope that it will be 
	useful, but WITHOUT ANY WARRANTY; without even the 
	implied warranty of MERCHANTABILITY or FITNESS FOR A 
	PARTICULAR PURPOSE.

**********************************************************************/


#include	"xlerror.h"
#include	"xl.h"

XL_SEXP * xl_WaitInterpreter();


void
init_WaitInterpreter(XLISP_ENV * env)
{
	set_env(env,l_string(std_cm,"WaitInterpreter"),
		get_func_prim(xl_WaitInterpreter,FO_APPLICATIVE,0,2,2));
}

XL_SEXP *
xl_WaitInterpreter(XLISP_ENV * env,XL_SEXP * s)
{
XL_SEXP * arg;
int _arg;
	arg = get_el(s,1);
	switch ( get_type(arg) ) {
	case XLT_ERROR:
		return arg;
	case XLT_INTEGER:
		_arg = arg->integer.data;
		break;
	case XLT_FLOAT:
		_arg = arg->floating.data;
		break;
	default:
		goto type_missmatch;
	}
	if ( _arg < 0 )
		goto param_error;
	wait_stop_interpreter(_arg);
	return 0;
type_missmatch:
	return get_error(
		s->h.file,
		s->h.line,
		XLE_SEMANTICS_TYPE_MISSMATCH,
		l_string(std_cm,"WaitInterpreter"),
		0);
param_error:
	return get_error(
		s->h.file,
		s->h.line,
		XLE_PROTO_INV_PARAM,
		l_string(std_cm,"WaitInterpreter"),
		0);
}


