/**********************************************************************
 
	Copyright (C) 2003 Hirohisa MORI <joshua@nichibun.ac.jp>
 
	This program is free software; you can redistribute it 
	and/or modify it under the terms of the GLOBALBASE 
	Library General Public License (G-LGPL) as published by 

	http://www.globalbase.org/
 
	This program is distributed in the hope that it will be 
	useful, but WITHOUT ANY WARRANTY; without even the 
	implied warranty of MERCHANTABILITY or FITNESS FOR A 
	PARTICULAR PURPOSE.

**********************************************************************/



#include	"xlerror.h"
#include	"xl.h"
#include	"xl_server.h"

XL_SEXP * xl_Account();

void
init_Account(XLISP_ENV * env)
{
	set_env(env,l_string(std_cm,"Account"),
		get_func_prim(xl_Account,FO_APPLICATIVE,0,5,5));
}



XL_SEXP *
xl_Account(XLISP_ENV * env,XL_SEXP * s)
{
XL_SEXP * group,* ltype;
XL_SEXP * user, * passwd;
	group = get_el(s,1);
	ltype = get_el(s,2);
	user = get_el(s,3);
	passwd = get_el(s,4);
	switch ( get_type(group) ) {
	case XLT_ERROR:
		return group;
	case XLT_STRING:
		break;
	default:
		goto type_missmatch;
	}
	switch ( get_type(ltype) ) {
	case XLT_ERROR:
		return ltype;
	case XLT_STRING:
		break;
	default:
		goto type_missmatch;
	}
	switch ( get_type(user) ) {
	case XLT_ERROR:
		return user;
	case XLT_STRING:
		break;
	default:
		goto type_missmatch;
	}
	switch ( get_type(passwd) ) {
	case XLT_ERROR:
		return passwd;
	case XLT_STRING:
		break;
	default:
		goto type_missmatch;
	}
	insert_account(
		group->string.data,
		ltype->string.data,
		user->string.data,
		passwd->string.data);
	return 0;
type_missmatch:
	return get_error(
		s->h.file,
		s->h.line,
		XLE_SEMANTICS_TYPE_MISSMATCH,
		l_string(std_cm,"Account"),
		0);
}

