/**********************************************************************
 
	Copyright (C) 2003-2004
	Hirohisa MORI <joshua@nichibun.ac.jp>
	Tomoki SEKIYAMA <sekiyama@yahoo.co.jp>
 
	This program is free software; you can redistribute it 
	and/or modify it under the terms of the GLOBALBASE 
	Library General Public License (G-LGPL) as published by 

	http://www.globalbase.org/
 
	This program is distributed in the hope that it will be 
	useful, but WITHOUT ANY WARRANTY; without even the 
	implied warranty of MERCHANTABILITY or FITNESS FOR A 
	PARTICULAR PURPOSE.

**********************************************************************/



#include "PP_Prefix.h"
#include "LView.h"

#include "machine/v_types.h"
#include "v/VFocusView.h"
#include  "CClickCheckAttachment.h"


const short RingWidth = 4;

class CFocusView : public LView, public LCommander
{
public:
	CFocusView(const SPaneInfo &pi, const SViewInfo &vi, VFocusView* fv, LCommander *super)
		: LView(pi,vi), LCommander(super), mVFocusView(fv)
	{
	}
	
	typedef struct SwitchTarget_t {
		CFocusView *		cfv;
	} SwitchTarget_T;
	
	void SwitchTarget_dispatch_()
	{
		SwitchTarget(this);
	}

	//static V_CALLBACK_D(SwitchTarget_dispatch)
	static void SwitchTarget_dispatch(void * sys_arg)
	{
	SwitchTarget_T * stt;
		stt = (SwitchTarget_T*)sys_arg;
		stt->cfv->SwitchTarget_dispatch_();
	}

	virtual void		ClickSelf( const SMouseDownEvent& md ) { SwitchTarget(this); }

	virtual void		DrawSelf() {
		if ( IsTarget() ) {
			Rect r;
			CalcLocalFrameRect(r);
			r.left += RingWidth;
			r.top += RingWidth;
			r.right -= RingWidth;
			r.bottom -= RingWidth;
			::DrawThemeFocusRect(&r, true);
		}
	}

	virtual void		FindCommandStatus(
								CommandT			inCommand,
								Boolean&			outEnabled,
								Boolean&			outUsesMark,
								UInt16&				outMark,
								Str255				outName);

	virtual Boolean			ObeyCommand(
								CommandT			inCommand,
								void*				ioParam = nil);	
	void					Click(
								SMouseDownEvent		&inMouseDown) {
		LView::Click(inMouseDown);

		if ( !CClickCheckAttachment::sClickHandled ) {
//			SwitchTarget(this);
			SwitchTarget_T stt;
			stt.cfv = this;
//			vq_insert/_callback_machine(0,SwitchTarget_dispatch,0,&stt,sizeof(stt),0,0);
			lthread_do(SwitchTarget_dispatch,&stt,1,1,0);
		}
		CClickCheckAttachment::sClickHandled = 1;
	}

protected:
	virtual void		BeTarget()		{ Refresh(); mVFocusView->focus_event(true);
											mVFocusView->check_menu_status();  }
	virtual void		DontBeTarget()	{ Refresh(); mVFocusView->focus_event(false); }

	VFocusView *		mVFocusView;
};

void
CFocusView::FindCommandStatus(
	CommandT	inCommand,
	Boolean&	outEnabled,
	Boolean&	outUsesMark,
	UInt16&		outMark,
	Str255		outName)
{
	int type = VMenuBar::edit_id_2_item_type(inCommand);
	if ( type && mVFocusView->command_status(type) ) {
		outEnabled = true;
		return;
	}

	LCommander::FindCommandStatus(inCommand, outEnabled,
									outUsesMark, outMark, outName);
}


Boolean
CFocusView::ObeyCommand(
	CommandT	inCommand,
	void*		ioParam)
{
	int type = VMenuBar::edit_id_2_item_type(inCommand);
	if ( type && mVFocusView->command_status(type) ) {
		return mVFocusView->obey_command(type);
	}
	
	return LCommander::ObeyCommand(inCommand, ioParam);
}


VExError
VFocusView::create_do(const VObjectStatus* s, int flags,VObject * nmp, void * arg)
{
	command_status_handler = 0;
	obey_command_handler = 0;
	menu_dirty = 1;

	SPaneInfo paneInfo;
	paneInfo.superView = dynamic_cast<LView*>(nmp->get_info_this());
	if ( paneInfo.superView == 0 )
		er_panic("non-LView object cannot be parent");
	paneInfo.paneID = sts.id;
	paneInfo.width = 0;
	paneInfo.height = 0;
	paneInfo.visible = true;
	paneInfo.enabled = true;
	paneInfo.left = 0;
	paneInfo.top = 0;
	paneInfo.bindings = (SBooleanRect){false,false,false,false};
	paneInfo.userCon = (long)this;
	SViewInfo viewInfo = { (SDimension32){0,0}, {0,0}, {1,1}, false };

	int al_stk = get_app_lock();
	CFocusView *v = new CFocusView(paneInfo,  viewInfo, this,
				GetTabGroupForWindow(TGT_INSERT,paneInfo.superView,0));
	v->AddAttachment(new CClickCheckAttachment);
	v->FinishCreate();
	info = v;
	release_app_lock(al_stk);
	return nmp->add_child_do(this);
}

void
VFocusView::destroy_do(VObject * nmp)
{
	nmp->remove_child_do(this);
	int al_stk = get_app_lock();
	delete info;
	release_app_lock(al_stk);
	nmp->redraw();
}

VFocusView::~VFocusView()
{
}


VExError
VFocusView::get_status(VObjectStatus *s, int flags) const
{
	V_OP_START_EX
	VExError err = v_get_status_standard(s, &flags, info);
	VExError err2 = VObject::get_status(s,flags);
	if ( err2.code )
		err = merge_VExError_vstatus_type(err,err2);
	V_OP_END
	return err;
};

VExError
VFocusView::set_status(const VObjectStatus *s, int flags)
{
	V_OP_START_EX
	VExError err = v_set_status_standard(s, flags&~VSF_ENABLED, &sts, info);
	VExError err2 = VObject::set_status(s,flags&~VSF_MIN_SIZE);
	if ( err2.code )
		err = merge_VExError_vstatus_type(err,err2);

	if ( flags & VSF_CALC_MIN ) {
		for ( VObjectList *list = sts.children ; list ; list = list->next )
			list->object->set_status(0, VSF_CALC_MIN);
		VLayout layout;
		layout.layout_in_align_view(this, true, true);
		sts.min_size = layout.parent_min_size();
		err.subcode1 &= ~VSF_CALC_MIN;
	}
	if ( flags & VSF_LAYOUT ) {
		VLayout layout;
		layout.layout_in_align_view(this, true);
		layout.do_layout(this);
		err.subcode1 &= ~VSF_LAYOUT;
	}

	V_OP_END

	if ( flags & (VSF_ALIGN | VSF_PADDING | VSF_VISIBLE) )
		VLayout::mark(this);
	return err;
}

VExError
VFocusView::add_child_do(VObject*child)
{
	return initial_VExError(V_ER_NO_ERR,0,0);
}

void
VFocusView::remove_child_do(VObject* child)
{
	// do nothing
}

void
VFocusView::child_status_changed(VObject* child, VInfo* info)
{
	// do nothing - object is marked when status is changed
}

void
VFocusView::redraw(VRect* rect) const
{
	_V_OP_START()
	int al_stk = get_app_lock();
	if ( rect )
		info->RefreshRect((Rect){rect->t, rect->l, rect->b, rect->r});
	else
		info->Refresh();
	release_app_lock(al_stk);
	V_OP_END
}



void
VFocusView::focus()
{
	int al_stk = get_app_lock();
	LCommander::SwitchTarget((CFocusView*)info);
	release_app_lock(al_stk);
	set_menu_dirty(1);
}

void
VFocusView::set_menu_dirty(int d)
{
	int al_stk = get_app_lock();
	menu_dirty = d;
	if ( menu_dirty )
		LCommander::SetUpdateCommandStatus(true);
	release_app_lock(al_stk);
}

V_CALLBACK_D(VFocusView::call_obey_command_handler)
{
	VFocusView *fv = static_cast<VFocusView*>(object);
	fv->obey_command_handler(object, user_arg, sys_arg);
	fv->set_menu_dirty(1);
}
