/**********************************************************************
 
	Copyright (C) 2003-2004
	Hirohisa MORI <joshua@nichibun.ac.jp>
	Tomoki SEKIYAMA <sekiyama@yahoo.co.jp>
 
	This program is free software; you can redistribute it 
	and/or modify it under the terms of the GLOBALBASE 
	Library General Public License (G-LGPL) as published by 

	http://www.globalbase.org/
 
	This program is distributed in the hope that it will be 
	useful, but WITHOUT ANY WARRANTY; without even the 
	implied warranty of MERCHANTABILITY or FITNESS FOR A 
	PARTICULAR PURPOSE.

**********************************************************************/


#include "machine/v_types2.h"
#include "v/VStaticText.h"
#include "LView.h"
#include "LStaticText.h"
#include "LControlImp.h"
#include "machine/v_types.h"
#include "v/v_errors.h"

/*
class CBorderAttachment : public LBorderAttachment
{
	virtual void ExecuteSelf(
								MessageT	inMessage,
								void*		ioParam) {
			LPane* p = dynamic_cast<LPane*>(mOwnerHost);
			if ( p )
				p->DrawSelf();
			LBorderAttachment::ExecuteSelf(inMessage, ioParam);
			mExecuteHost = false;
		}
};
*/

VExError
VStaticText::create_do(const VObjectStatus* s, int flags,VObject * nmp, void * arg)
{
	SPaneInfo paneInfo;
	paneInfo.superView = dynamic_cast<LView*>(nmp->get_info_this());
	if ( paneInfo.superView == 0 )
		er_panic("non-LView object cannot be parent");
	paneInfo.paneID = sts.id;
	paneInfo.width = 0;
	paneInfo.height = 0;
	paneInfo.visible = true;
	paneInfo.enabled = true;
	paneInfo.left = 0;
	paneInfo.top = 0;
	paneInfo.bindings = (SBooleanRect){false,false,false,false};
	paneInfo.userCon = (long)this;
	int al_stk = get_app_lock();
	LStaticText *v = new LStaticText(paneInfo, "\p");
//v->AddAttachment(new CBorderAttachment);
	v->FinishCreate();
	release_app_lock(al_stk);
	info = v;
	return nmp->add_child_do(this);
}

void
VStaticText::destroy_do(VObject * nmp)
{
	nmp->remove_child_do(this);
	int al_stk = get_app_lock();
	delete info;
	release_app_lock(al_stk);
	nmp->redraw();
}

VStaticText::~VStaticText()
{
}


VExError
VStaticText::get_status(VObjectStatus *s, int flags) const
{
	V_OP_START_EX
	
	if ( flags & VSF_SIZE ) {
		s->size = sts.size;
		flags &= ~VSF_SIZE;
	}
	if ( flags & VSF_POSITION ) {
		s->position = sts.position;
		flags &= ~VSF_POSITION;
	}

	VExError err = v_get_status_standard(s, &flags, info);
	VExError err2 = VObject::get_status(s,flags);
	if ( err2.code )
		err = merge_VExError_vstatus_type(err,err2);
	V_OP_END
	return err;
};

VExError
VStaticText::set_status(const VObjectStatus *s, int flags)
{
	V_OP_START_EX
	VExError err = v_set_status_standard(s, flags & ~(VSF_SIZE|VSF_POSITION), &sts, info);

	if ( flags & VSF_SIZE ) {
		// height is fixed to min_size
		if ( (s->size.w != sts.size.w) || (s->size.h != sts.size.h) ) {
			int al_stk = get_app_lock();
			info->ResizeFrameTo(s->size.w, sts.min_size.h, true);
			release_app_lock(al_stk);
		}
		sts.size = s->size;	// used in VSF_POSITION
	}
	if ( flags & VSF_POSITION ) {
		// static text is displayed in the center of its height
		short pos_h = s->position.y + (sts.size.h - sts.min_size.h)/2;
		if ( s->position.x != sts.position.x || s->position.y != sts.position.y ) {
			int al_stk = get_app_lock();
			info->PlaceInSuperImageAt(s->position.x, pos_h, true);
			release_app_lock(al_stk);
		}
	}

	VExError err2 = VObject::set_status(s,flags);
	if ( err2.code )
		err = merge_VExError_vstatus_type(err,err2);
	
	if ( flags & VSF_CALC_MIN ) {
		// min is calculated when desc is set
		err.subcode1 &= ~VSF_CALC_MIN;
	}
	
	if ( flags & (VSF_WS | VSF_FSIZE | VSF_DESC | VSF_VERTD) ) {
		v_set_descriptor(info, sts.descriptor, sts.ws, sts.fsize, sts.vert_desc, &sts.min_size);
		int al_stk = get_app_lock();
		info->ResizeFrameTo(sts.min_size.w, sts.min_size.h, false);

		Rect rect = {0,0,0,0};
		SInt16 baseLine;
		::GetBestControlRect(((LControlPane*)info)->GetControlImp()->GetMacControl(), &rect, &baseLine);
		release_app_lock(al_stk);
		sts.min_size = (VSize){rect.right-rect.left, rect.bottom-rect.top};
		err.subcode1 &= ~(VSF_WS | VSF_FSIZE | VSF_DESC | VSF_VERTD);
	}
	
	if ( flags & VSF_ATTR ) {
		ControlFontStyleRec	styleRec;
		unsigned char a;
		GET_RGB8_32(s->attr, styleRec.foreColor.red, styleRec.foreColor.green, styleRec.foreColor.blue, a);
		styleRec.foreColor.red <<= 8;
		styleRec.foreColor.green <<= 8;
		styleRec.foreColor.blue <<= 8;
		styleRec.flags = kControlUseForeColorMask;
		int al_stk = get_app_lock();
		((LControlPane*)info)->SetFontStyle(styleRec);
		release_app_lock(al_stk);
	}

	V_OP_END

	if ( flags & (VSF_ALIGN | VSF_PADDING | VSF_DESC | VSF_VERTD | VSF_VISIBLE) )
		VLayout::mark(this);
	return err;
}

void
VStaticText::redraw(VRect* rect) const
{
ss_printf("StaticText\n");
	_V_OP_START()
	int al_stk = get_app_lock();
	if ( rect )
		info->RefreshRect((Rect){rect->t, rect->l, rect->b, rect->r});
	else
		info->Refresh();
	release_app_lock(al_stk);
	V_OP_END
}
