/**********************************************************************
 
	Copyright (C) 2003 Hirohisa MORI <joshua@nichibun.ac.jp>
 
	This program is free software; you can redistribute it 
	and/or modify it under the terms of the GLOBALBASE 
	Library General Public License (G-LGPL) as published by 

	http://www.globalbase.org/
 
	This program is distributed in the hope that it will be 
	useful, but WITHOUT ANY WARRANTY; without even the 
	implied warranty of MERCHANTABILITY or FITNESS FOR A 
	PARTICULAR PURPOSE.

**********************************************************************/

#include	<pthread.h>
#include	"machine/include.h"
#include	"init.h"
#include	"task.h"
#include	"utils.h"

void sigalarm_handler();
void sigpipe_handler();
void sigint_handler(); 


/* Set the mutex kind attribute in *ATTR to KIND (either PTHREAD_MUTEX_NORMAL,                                  
   PTHREAD_MUTEX_RECURSIVE, PTHREAD_MUTEX_ERRORCHECK, or                                                        
   PTHREAD_MUTEX_DEFAULT).  */
extern int pthread_mutexattr_settype (pthread_mutexattr_t *__attr, int __kind)
     __THROW;

/* Return in *KIND the mutex kind attribute in *ATTR.  */
extern int pthread_mutexattr_gettype (__const pthread_mutexattr_t *__restrict
                                      __attr, int *__restrict __kind) __THROW;



extern int task_flags;
/*
int pri_table[PRI_MAX] = {1,20,39,58,77,96};
*/
int pri_table[PRI_MAX] = {0,0,0,0,0,0};


D_SEM
xx_new_lock(int level,char * file,int line)
{
D_SEM s;
pthread_mutexattr_t attr;
	s = new_block();
	pthread_mutexattr_init(&attr);
	pthread_mutexattr_settype(&attr,PTHREAD_MUTEX_ERRORCHECK_NP);
	pthread_mutex_init(&s->mx,&attr);
	pthread_mutexattr_destroy(&attr);
	return s;
}


void
_lock_task(D_SEM s,char * file,int line)
{
int er;
	switch ( er=pthread_mutex_lock(&s->mx) ) {
	case 0:
		break;
	case EINVAL:
		er_panic("invalid semaphore (MUTEX)");
	case EDEADLK:
		er_panic("dead lock");
	default:
		printf("ER = %i\n",er);
		er_panic("unknown return");
	}

	s->lock_file = file;
	s->lock_line = line;


}

void
_unlock_task(D_SEM s,char *str,char * file,int line)
{
int er;

	s->unlock_file = file;
	s->unlock_line = line;
	
	switch ( pthread_mutex_unlock(&s->mx) ) {
	case 0:
		break;
	case EINVAL:
		er_panic("invalid semaphore (MUTEX)");
	case EPERM:
		er_panic("nlock non locked lock");
	default:
		printf("ER = %i\n",er);
		er_panic("unknown return");
	}
}

void xx_close_lock(D_SEM s)
{
	pthread_mutex_destroy(&s->mx);
	free_block(s);
}


int
_sem_getvalue(D_SEM s,int * value)
{
int er;
	switch ( er=pthread_mutex_trylock(&s->mx) ) {
	case 0:
		*value = 0;
	case EINVAL:
		er_panic("invalid semaphore (MUTEX)");
	case EPERM:
		*value = 1;
		break;
	default:
		printf("ER = %i\n",er);
		er_panic("unknown return");
	}
	return 0;
}


int
ss_do(void (*func)(void*),void * arg)
{
	(*func)(arg);
	return 0;
}
