/**********************************************************************
 
	Copyright (C) 2003 Hirohisa MORI <joshua@nichibun.ac.jp>
 
	This program is free software; you can redistribute it 
	and/or modify it under the terms of the GLOBALBASE 
	Library General Public License (G-LGPL) as published by 

	http://www.globalbase.org/
 
	This program is distributed in the hope that it will be 
	useful, but WITHOUT ANY WARRANTY; without even the 
	implied warranty of MERCHANTABILITY or FITNESS FOR A 
	PARTICULAR PURPOSE.

**********************************************************************/

#include "machine/gb_windows.h"
#include	<winsock2.h>
#include	"memory_debug.h"
#include	"netutils.h"
#include "task.h"

extern SEM netutils_lock;

int
get_localhostip()
{
static long localip=0;
char hostname[256];
struct hostent *he;
int ret;

	if(localip != 0){
		return localip;
	}

	lock_task(netutils_lock);
	
	get_localhostname(hostname);
	he = gethostbyname(hostname);
	if(he){
		ret = ntohl(*(int*)he->h_addr_list[0]);
	}
	else{
		ret = 0x7f000001;
	}
	unlock_task(netutils_lock, "gethostbyname");
	
	localip = ret;
	return ret;
}
