/**********************************************************************
 
	Copyright (C) 2005- Hirohisa MORI <joshua@nichibun.ac.jp>
 
	This program is free software; you can redistribute it 
	and/or modify it under the terms of the GLOBALBASE 
	Library General Public License (G-LGPL) as published by 

	http://www.globalbase.org/
 
	This program is distributed in the hope that it will be 
	useful, but WITHOUT ANY WARRANTY; without even the 
	implied warranty of MERCHANTABILITY or FITNESS FOR A 
	PARTICULAR PURPOSE.

**********************************************************************/

#include	"memory_debug.h"
#include	"utils.h"
#include	"xlerror.h"
#include	"xl.h"
#include	"mx_format.h"
#include	"pg_vector.h"
#include	"xl_zlib.h"


XL_SEXP *
gb_gmxPgDisplay(XLISP_ENV * env,XL_SEXP * s,XLISP_ENV * a,XL_SYM_FIELD * sf);

void
init_gmxPgDisplay(XLISP_ENV * env0,XLISP_ENV * env1)
{
	set_env(env0,l_string(std_cm,"gmxPgDisplay"),
		get_func_prim(gb_gmxPgDisplay,FO_APPLICATIVE,0,2,2));
}

XL_SEXP *
ip2sexp_c(MATRIX * m,INTERNAL_PLOT * pt)
{
XL_SEXP * ret;
int i;
	ret = 0;
	for ( i = 0 ; i < m->p.dim ; i ++ )
		ret = cons(get_integer(pt->c[i],0),ret);
	return cons(n_get_symbol("c"),reverse(ret));
}

XL_SEXP *
ip2sexp_base(MATRIX * m,INTERNAL_PLOT * pt)
{
XL_SEXP * ret;
int i;
	if ( pt->base == 0 )
		return 0;
	ret = 0;
	for ( i = 0 ; i < m->p.dim ; i ++ )
		ret = cons(get_integer(pt->base[i],0),ret);
	return cons(n_get_symbol("base"),reverse(ret));
}

XL_SEXP*
ip2sexp_fields(INTERNAL_PLOT * pt)
{
XL_SEXP * ret;
int i;
	if ( pt->fields == 0 )
		return 0;
	ret = 0;
	for ( i = 0 ; i < pt->fields[0].len ; i ++ ) {
		switch ( (pt->fields[i].type & CH_TYPE_MASK) ) {
		case CH_TYPE_NONE:
			ret = cons(List(n_get_symbol("NONE"),
					get_integer(pt->fields[i].type,0),
					-1),ret);
			break;
		case CH_TYPE_STRING:
			ret = cons(List(n_get_symbol("STRING"),
					get_integer(pt->fields[i].type,0),
					get_string(l_string(&utf8_cm,pt->fields[i].d.str)),
					-1),ret);
			break;
		case CH_TYPE_INT:
			if ( pt->fields[i].type == CH_INT_AVG )
				ret = cons(List(n_get_symbol("INT"),
						get_integer(pt->fields[i].type,0),
						get_integer(pt->fields[i].d.i[0],0),
						get_integer(pt->fields[i].d.i[1],0),
						-1),ret);
			else	ret = cons(List(n_get_symbol("INT"),
						get_integer(pt->fields[i].type,0),
						get_integer(pt->fields[i].d.i[0],0),
						-1),ret);
			break;
		case CH_TYPE_RGBA:
			ret = cons(List(n_get_symbol("INT"),
					get_integer(pt->fields[i].type,0),
					get_integer(pt->fields[i].d.i[0],0),
					get_integer(pt->fields[i].d.i[1],0),
					-1),ret);
			break;
		default:
			ret = cons(List(n_get_symbol("DEFAULT"),
					get_integer(pt->fields[i].type,0),
					-1),ret);
			break;
		}
	}
	return cons(n_get_symbol("fields"),reverse(ret));
}


XL_SEXP *
ip2sexp(MATRIX * m,INTERNAL_PLOT * pt)
{
XL_SEXP * p;
XL_SEXP * ret;
	ret = 0;
	for ( ; pt ; pt = pt->next ) {
		p = List(
			n_get_symbol("point"),
			get_integer(pt->flags,0),
			ip2sexp_c(m,pt),ip2sexp_base(m,pt),ip2sexp_fields(pt),-1);
		ret = cons(p,ret);
	}
	return cons(n_get_symbol("ip"),reverse(ret));
}

XL_SEXP *
gb_gmxPgDisplay(XLISP_ENV * env,XL_SEXP * s,XLISP_ENV * a,XL_SYM_FIELD * sf)
{
XL_SEXP * d;
INTERNAL_PLOT * pt,*pt2;
L_CHAR * compress;
char * ptr1,*ptr2;
int size;
L_CHAR * id;
MX_ENTRY * e;
MATRIX * m;
XL_SEXP * sym,*ret;
int pt_cnt;

	compress = get_sf_attribute(sf,l_string(std_cm,"compress"));

	d = get_el(s,1);
	if ( list_length(d) != 3 )
		goto type_missmatch;
	id = get_sf_attribute(sf,l_string(std_cm,"id"));
	if ( id == 0 ) {
		sym = car(d);
		if ( get_type(sym) != XLT_SYMBOL )
			goto type_missmatch;
		id = get_sf_attribute(sym->symbol.field,l_string(std_cm,"id"));
		if ( id == 0 )
			goto inv_param;
	}
	e = search_mx_entry_by_id(atoi(n_string(std_cm,id)));
	if ( e == 0 )
		goto inv_param;
	m = e->c.m;
	
	d = get_el(d,2);

	if ( compress && l_strcmp(compress,l_string(std_cm,"on")) == 0 ) {
		ptr1 = ptr2 = zlib_uncompress(&size,d->raw.data,d->raw.size);
		ptr1 ++;
		pt = code2internal(m,(PRIMITIVE_PLOT*)ptr1,d->raw.size-1,0);
		d_f_ree(ptr2);
	}
	else {
		pt = code2internal(m,(PRIMITIVE_PLOT*)d->raw.data,d->raw.size,0);
		size = d->raw.size;
	}
	pt_cnt = 0;
	for (pt2 = pt ; pt2 ; pt2 = pt2->next , pt_cnt ++ );
	
	ret = List(n_get_symbol("pg"),
			get_integer(size,0),
			get_integer(d->raw.size,0),
			get_integer(pt_cnt,0),
			ip2sexp(m,pt),
			-1);
	free_internal_plot(pt);
	return ret;
/*
open_err:
	return get_error(
		s->h.file,
		s->h.line,
		XLE_PROTO_OPEN_FILE,
		l_string(std_cm,"gmxPgDisplay"),
		0);
*/
type_missmatch:
	return get_error(
		s->h.file,
		s->h.line,
		XLE_SEMANTICS_TYPE_MISSMATCH,
		l_string(std_cm,"gmxPgDisplay"),
		0);
inv_param:
	return get_error(
		s->h.file,
		s->h.line,
		XLE_PROTO_INV_PARAM,
		l_string(std_cm,"gmxPgDisplay"),
		n_get_string("attribute:path-type"));
/*
permission_error:
	return get_error(
		s->h.file,
		s->h.line,
		XLE_PROTO_PERMISSION_DENIED,
		l_string(std_cm,"gmxPgDisplay"),
		n_get_string("file path"));
*/
}

