/**********************************************************************
 
	Copyright (C) 2003 Hirohisa MORI <joshua@nichibun.ac.jp>
 
	This program is free software; you can redistribute it 
	and/or modify it under the terms of the GLOBALBASE 
	Library General Public License (G-LGPL) as published by 

	http://www.globalbase.org/
 
	This program is distributed in the hope that it will be 
	useful, but WITHOUT ANY WARRANTY; without even the 
	implied warranty of MERCHANTABILITY or FITNESS FOR A 
	PARTICULAR PURPOSE.

**********************************************************************/



#include	"resource.h"
#include	"xl.h"
#include	"memory_routine.h"	
#include	"memory_debug.h"
#include	"rs_cache.h"
#include	"rcache.h"
#include	"queue.h"
#include	"pri_level.h"

typedef struct lm_t {
	Q_HEADER		h;
	L_CHAR *		target;
	XL_SEXP *		ret;
	char *			mode;
	int			cache_flag;
	void (*func)(XL_SEXP *,L_CHAR *,void*);
	void *			user_arg;
} LM_T;

SYS_QUEUE lm_queue1,lm_queue2;
void lm_task1(TKEY d);
void lm_task2(TKEY d);
void lm_gc_func(LM_T * n);
void lm_gc_get(LM_T * n);


void
init_load_meta()
{

	memset(&lm_queue1,0,sizeof(SYS_QUEUE));
	lm_queue1.flags = QF_FIFO;
	lm_queue1.key_func = lm_task1;
	lm_queue1.gc_func = (void (*)())lm_gc_func;
	lm_queue1.gc_get =  (void (*)())lm_gc_get;
	lm_queue1.pri = PRI_FETCH;
	setup_queue(&lm_queue1);

	memset(&lm_queue2,0,sizeof(SYS_QUEUE));
	lm_queue2.flags = QF_FIFO;
	lm_queue2.key_func = lm_task2;
	lm_queue2.gc_func = (void (*)())lm_gc_func;
	lm_queue2.gc_get =  (void (*)())lm_gc_get;
	lm_queue2.pri = PRI_FETCH;
	setup_queue(&lm_queue2);

}

XL_SEXP * 
load_meta(int ses,char * mode,L_CHAR * target)
{
XL_SEXP * ret;
XL_SEXP * gt;
L_CHAR * f;
URL uu;
void gc_gb_sexp();
RS_BUF b;
int flags;

	gc_push(0,0,"remote_fetch");

	if ( strcmp(mode,"data") == 0 ||
			strcmp(mode,"meta") == 0 ) {
		ret = get_meta_cache_str(target,mode);
		if ( ret ) {
			gc_pop(ret,gc_gb_sexp);
			return ret;
		}
		memset(&b,0,sizeof(b));
		if ( strcmp(mode,"data") == 0 )
			flags = RSQ_DATA;
		else if ( strcmp(mode,"meta") == 0 )
			flags = RSQ_META;
		else	flags = RSQ_LUMP;
		if ( get_rs_resource_cache(&b,target,flags) == 0 ) {

			if ( b.meta )
				ret = b.meta;
			else if ( b.data )
				ret = b.data;
			else	ret = b.lump;

			if ( get_type(ret) != XLT_ERROR && ret ) {


				get_url2(&uu,target);
				new_meta_cache(&uu,ret,mode[0]);
				free_url(&uu);

				gc_pop(ret,gc_gb_sexp);
				return ret;
			}
		}
	}

	get_url2(&uu,target);

	gt = get_symbol(l_string(std_cm,"Get"));
	set_attribute(gt,
		l_string(std_cm,"mode"),
		l_string(std_cm,mode));

	f = get_url_filepath(&uu);

	ret = remote_session(
		gblisp_top_env0,
		ses,
		&uu,
		0,
		l_string(std_cm,"user"),
		l_string(std_cm,"Get"),
		List(List(gt,
			get_string(f),
			-1),
			-1),
		0,0,0,0);
	d_f_ree(f);

if ( get_type(ret) == XLT_ERROR ){
log_printf(LOG_ERROR,LOG_LAYER_GB,0,"loadmeta(%i)(%s) %ls = ",get_tid(),mode,get_url_str2(&uu));
log_print_sexp(LOG_ERROR,LOG_LAYER_GB,0,"loadmeta",ret,0);
}

	if ( get_type(ret) != XLT_ERROR &&
			(strcmp(mode,"meta") == 0 || strcmp(mode,"data") == 0) ) {



		memset(&b,0,sizeof(b));
		if ( strcmp(mode,"meta") == 0 )
			b.meta = ret;
		else if ( strcmp(mode,"data") == 0 )
			b.data = ret;
		else	b.lump = ret;
		b.url = target;
		set_rs_resource_cache(&b);

		new_meta_cache(&uu,ret,mode[0]);
	}

	free_url(&uu);

	gc_pop(ret,gc_gb_sexp);
	return ret;
}

void
load_meta_2(char * mode,L_CHAR * target,void (*func)(XL_SEXP *,L_CHAR *,void*),void * user_arg,int cache_flag)
{
XL_SEXP * ret;
URL uu;
void gc_gb_sexp();
RS_BUF b;
int flags;
LM_T * t;

	if ( cache_flag == 0 )
		goto next;

	gc_push(0,0,"remote_fetch");

	if ( strcmp(mode,"data") == 0 ||
			strcmp(mode,"meta") == 0 ) {
		ret = get_meta_cache_str(target,mode);
		if ( ret ) {
			gc_pop(ret,gc_gb_sexp);
			(*func)(ret,ll_copy_str(target),user_arg);
		}
		memset(&b,0,sizeof(b));
		if ( strcmp(mode,"data") == 0 )
			flags = RSQ_DATA;
		else if ( strcmp(mode,"meta") == 0 )
			flags = RSQ_META;
		else	flags = RSQ_LUMP;
		if ( get_rs_resource_cache(&b,target,flags) == 0 ) {

			if ( b.meta )
				ret = b.meta;
			else if ( b.data )
				ret = b.data;
			else	ret = b.lump;

			if ( get_type(ret) != XLT_ERROR && ret ) {


				get_url2(&uu,target);
				new_meta_cache(&uu,ret,mode[0]);
				free_url(&uu);

				gc_pop(ret,gc_gb_sexp);
				(*func)(ret,ll_copy_str(target),user_arg);
			}
		}
	}

next:
	get_url2(&uu,target);

	t = d_alloc(sizeof(*t));
	memset(t,0,sizeof(*t));
	t->target = ll_copy_str(target);
	t->func = func;
	t->user_arg = user_arg;
	t->mode = copy_str(mode);
	t->cache_flag = cache_flag;
	t->h.key = get_server_key(&uu,0);
	free_url(&uu);
	insert_queue(&lm_queue1,t,1);
}

void
lm_task1(TKEY d)
{
XL_INTERPRETER * xli;
L_CHAR * key;
SYS_QUEUE * que;
int ses;
LM_T * t;
URL uu;
L_CHAR * f;
XL_SEXP * gt;
REMOTE_SESSION_OPT opt;

	que = (SYS_QUEUE *)GET_TKEY(d);
	key = touch_qkey(que);
	if ( key == 0 )
		return;

	xli = new_xl_interpreter();
	xli->a_type = XLA_SELF;
	setup_i(xli);
	
	ses = open_session(SEST_OPTIMIZE);
	
	for ( ; ; ) {

		gc_push(0,0,"lm_task1");
		
		t = delete_queue(que,0,0,0);
		if ( t == 0 ) {
			gc_pop(0,0);
			break;
		}

		get_url2(&uu,t->target);
		
		gt = get_symbol(l_string(std_cm,"Get"));
		set_attribute(gt,
			l_string(std_cm,"mode"),
			l_string(std_cm,t->mode));

		f = get_url_filepath(&uu);

		setup_remote_session_opt(&opt);
		opt.return_format = RFT_BODY;
		t->ret = remote_session(
			gblisp_top_env0,
			ses,
			&uu,
			0,
			l_string(std_cm,"user"),
			l_string(std_cm,"Get"),
			List(List(gt,
				get_string(f),
				-1),
				-1),
			0,0,0,&opt);
		d_f_ree(f);
		free_url(&uu);
		
		insert_queue(&lm_queue2,t,1);
		
		gc_pop(0,0);
	}

	release_qkey(que,key);
	d_f_ree(key);

	close_session(ses);
	close_self_interpreter();
}


void
lm_task2(TKEY d)
{
XL_INTERPRETER * xli;
L_CHAR * key;
SYS_QUEUE * que;
int ses;
LM_T * t;
URL uu;
RS_BUF b;

	que = (SYS_QUEUE *)GET_TKEY(d);
	key = touch_qkey(que);
	if ( key == 0 )
		return;

	xli = new_xl_interpreter();
	xli->a_type = XLA_SELF;
	setup_i(xli);
	
	ses = open_session(SEST_OPTIMIZE);
	
	for ( ; ; ) {

		gc_push(0,0,"lm_task1");
		
		t = delete_queue(que,0,0,0);
		if ( t == 0 ) {
			gc_pop(0,0);
			break;
		}

		get_url2(&uu,t->target);
		

		if ( t->cache_flag && get_type(t->ret) != XLT_ERROR &&
				(strcmp(t->mode,"meta") == 0 || strcmp(t->mode,"data") == 0) ) {



			memset(&b,0,sizeof(b));
			if ( strcmp(t->mode,"meta") == 0 )
				b.meta = t->ret;
			else if ( strcmp(t->mode,"data") == 0 )
				b.data = t->ret;
			else	b.lump = t->ret;
			b.url = t->target;
			set_rs_resource_cache(&b);

			new_meta_cache(&uu,t->ret,t->mode[0]);
		}

		free_url(&uu);

		(*t->func)(t->ret,t->target,t->user_arg);
		d_f_ree(t->target);
		d_f_ree(t);

		gc_pop(0,0);

	}

	release_qkey(que,key);
	d_f_ree(key);

	close_session(ses);
	close_self_interpreter();
}



void
lm_gc_func(LM_T * n)
{
	gc_gb_sexp(n->ret);
}

void
lm_gc_get(LM_T * n)
{
	lock_mem();
	gc_set_nl(n->ret,(void (*)())gc_gb_sexp);
	unlock_mem();
}


