/**********************************************************************
 
	Copyright (C) 2003 Hirohisa MORI <joshua@nichibun.ac.jp>
 
	This program is free software; you can redistribute it 
	and/or modify it under the terms of the GLOBALBASE 
	Library General Public License (G-LGPL) as published by 

	http://www.globalbase.org/
 
	This program is distributed in the hope that it will be 
	useful, but WITHOUT ANY WARRANTY; without even the 
	implied warranty of MERCHANTABILITY or FITNESS FOR A 
	PARTICULAR PURPOSE.

**********************************************************************/

#ifndef ___CAL_H___
#define ___CAL_H___


#include	"stream.h"
#include	"long_char.h"
#include	"xl.h"

#define XL_CAL_BUFFER_SIZE	1000


typedef struct xl_cal_stack {
	struct xl_cal_stack *	next;
	XL_SEXP *		delay;
} XL_CAL_STACK;

typedef struct xl_cal {
	DELAY_FUNC		h;
	STREAM *		st;
	CODE_METHOD *		cm;
	void *			cm_work;
	char			buffer[XL_CAL_BUFFER_SIZE];
	int			buffer_len;
	int			bptr;
	
	L_CHAR			push_chr;
	int			push_chr_flag;

	XL_CAL_STACK *		stack;
} XL_CAL;

/* get_cal_line status */
#define CS_COMPONENT_BEGIN	1
#define CS_COMPONENT_END	2
#define CS_PROPERTY		3

XL_SEXP *
get_cal(STREAM * st,CODE_METHOD * cm);


#endif
