/**********************************************************************
 
	Copyright (C) 2003 Hirohisa MORI <joshua@nichibun.ac.jp>
 
	This program is free software; you can redistribute it 
	and/or modify it under the terms of the GLOBALBASE 
	Library General Public License (G-LGPL) as published by 

	http://www.globalbase.org/
 
	This program is distributed in the hope that it will be 
	useful, but WITHOUT ANY WARRANTY; without even the 
	implied warranty of MERCHANTABILITY or FITNESS FOR A 
	PARTICULAR PURPOSE.

**********************************************************************/

#include "machine/include.h"
#include "vpf_std.h"
#include "gm_svg_color.h"
#include "gm_svg_util.h"

// remove crlf
static void chop(char *sz){
	int nLen;
	char *p;
	if(!sz)
		return;
	nLen = strlen(sz);
	if(nLen == 0)
		return;
	p = &sz[nLen-1];
	while(*p == '\r' || *p == '\n'){
		*p = '\0';
		--p;
		if(--nLen<1)
			break;
	}
}



GM_SVG_COLOR_TABLE *gm_svg_color_table_new(FILE *fp)
{
	GM_SVG_COLOR_TABLE *table;
	char buff[4096];
	char *p,*p2;
	char name[64];
	char value[64];
	
	table = (GM_SVG_COLOR_TABLE *)calloc(sizeof(*table),1);

	while(fgets(buff, 4096, fp)){
		chop(buff);
		if(buff[0]=='#')
			continue;
		memset(name, 0, sizeof(name));
		memset(value, 0, sizeof(value));
		p = buff;
		while(isspace((int)*p)){
			++p;
		}
		if(!*p)
			continue;
		p2 = p+strcspn(p, " =\t\r\n");
		strncpy(name, p, p2-p);
		if(!*p2)
			continue;
		p = p2+strspn(p2, " \r\n\t=");
		if(!*p)
			continue;
		p2 = p+strcspn(p, " \r\n\t");
		strncpy(value, p, p2-p);
		
		if(strcmp(name, "line_road")==0){
			table->line_colors[GMTT_ROAD_LFT] = strdup(value);
		}
		if(strcmp(name, "line_railroad")==0){
			table->line_colors[GMTT_RAILROAD_LFT] = strdup(value);
		}
		else if(strcmp(name, "line_coast_line")==0){
			table->line_colors[GMTT_COAST_LINE_LFT] = strdup(value);
		}
		else if(strcmp(name, "line_political_boundary")==0){
			table->line_colors[GMTT_POLITICAL_BOUNDARY_AFT] = strdup(value);
		}
		else if(strcmp(name, "line_oceansea")==0){
			table->line_colors[GMTT_OCEANSEA_AFT] = strdup(value);
		}
		else if(strcmp(name, "line_water_course")==0){
			table->line_colors[GMTT_WATER_COURSE_LFT] = strdup(value);
		}
		else if(strcmp(name, "line_inland_water")==0){
			table->line_colors[GMTT_INLAND_WATER_AFT] = strdup(value);
		}
		else if(strcmp(name, "line_builtup_areaa")==0){
			table->line_colors[GMTT_BUILTUP_AREA_AFT] = strdup(value);
		}
		else if(strcmp(name, "line_builtup_areap")==0){
			table->line_colors[GMTT_BUILTUP_AREA_PFT] = strdup(value);
		}

		else if(strcmp(name, "fill_road")==0){
			table->fill_colors[GMTT_ROAD_LFT] = strdup(value);
		}
		else if(strcmp(name, "fill_railroad")==0){
			table->fill_colors[GMTT_RAILROAD_LFT] = strdup(value);
		}
		else if(strcmp(name, "fill_coast_line")==0){
			table->fill_colors[GMTT_COAST_LINE_LFT] = strdup(value);
		}
		else if(strcmp(name, "fill_political_boundary")==0){
			table->fill_colors[GMTT_POLITICAL_BOUNDARY_AFT] = strdup(value);
		}
		else if(strcmp(name, "fill_oceansea")==0){
			table->fill_colors[GMTT_OCEANSEA_AFT] = strdup(value);
		}
		else if(strcmp(name, "fill_water_course")==0){
			table->fill_colors[GMTT_WATER_COURSE_LFT] = strdup(value);
		}
		else if(strcmp(name, "fill_inland_water")==0){
			table->fill_colors[GMTT_INLAND_WATER_AFT] = strdup(value);
		}
		else if(strcmp(name, "fill_builtup_areaa")==0){
			table->fill_colors[GMTT_BUILTUP_AREA_AFT] = strdup(value);
		}
		else if(strcmp(name, "fill_builtup_areap")==0){
			table->fill_colors[GMTT_BUILTUP_AREA_PFT] = strdup(value);
		}
	}

	return table;
}

void gm_svg_color_table_delete(GM_SVG_COLOR_TABLE *table)
{
	int i;
	for(i=0; i<sizeof(table->line_colors)/sizeof(table->line_colors[0]); ++i){
		if(table->line_colors[i]){
			free(table->line_colors[i]);
		}
	}
	
	for(i=0; i<sizeof(table->fill_colors)/sizeof(table->line_colors[0]); ++i){
		if(table->fill_colors[i]){
			free(table->fill_colors[i]);
		}
	}
	
	free(table);
}
