/**********************************************************************
 
	Copyright (C) 2003 Hirohisa MORI <joshua@nichibun.ac.jp>
 
	This program is free software; you can redistribute it 
	and/or modify it under the terms of the GLOBALBASE 
	Library General Public License (G-LGPL) as published by 

	http://www.globalbase.org/
 
	This program is distributed in the hope that it will be 
	useful, but WITHOUT ANY WARRANTY; without even the 
	implied warranty of MERCHANTABILITY or FITNESS FOR A 
	PARTICULAR PURPOSE.

**********************************************************************/


#ifndef ___XL2PDB_H___
#define ___XL2PDB_H___

#include	"gbgraph.h"
#include	"pdb.h"
#include	"xl.h"

typedef struct pdb_pd_point {
	struct pdb_pd_point *	next;
  	int			no;
	int			lod_min;
	int			lod_max;
		/* now both of lod_min and lod_max are 0 */
	GB_POINT_F		p;
	double			reso;
	struct pdb_pd_point *	line_prev;
	struct pdb_pd_point *	line_next;
	unsigned int		fofs;
	int			sg_size;
	PN_POLY_POINT *		short_sg;
	PN_LNO_POLY_POINT *	long_sg;
} PDB_PD_POINT;

typedef struct point_matrix {
	PDB_PD_POINT *		head;
	PDB_PD_POINT *		tail;
	float			rate;
} POINT_MATRIX;

typedef struct pdb_polygon2d {
	struct pdb_polygon2d *	next;
	struct pdb_polygon2d *  prev;
	struct pdb_pd_point * tail_point;
	struct pdb_pd_point * tail2_point;
	struct pdb_polygon2d *	seq_next;
	unsigned int		seq;
	unsigned int		code;
	struct pdb_polygon2d *	samename;
	L_CHAR *		name;
	L_CHAR *		subname;
	int			depth;
	int			type;
#define PDT_CLOSE		1
#define PDT_OPEN		2
	GB_COLOR		padding;
	/* the structure member "t" in the type GB_COLOR
	   (which is defined in the gbgraph.h) means alpha channel
	   (t = 0 is transparent)
	   (and 0 <= r,g,b <= 1)
	*/
	GB_COLOR		line;
	PDB_PD_POINT *		point;

	XL_SEXP *		info;
	unsigned int		info_ofs;

	GB_RECT_F		minrect;
	short			lod_max;
	short			lod_min;
	unsigned int		fofs;
	int			start_sg_size;
	int			subname_sg_size;
	int			end_sg_size;
	PN_POLYGON2D *		start_sg;
	PN_POLY_END *		end_sg;
} PDB_POLYGON2D;

typedef struct pdb_next {
	int		type;
#define PTT_POLYGON2D	1
#define PTT_PT		2
	union {
		struct pdb_pt *	pt;
		PDB_POLYGON2D *	poly;
	} ptr;
} PDB_NEXT;

typedef struct pdb_pt {
	GB_RECT_F	r;
	short		lod_min;
	short		lod_max;
	int		same_index;
	PDB_NEXT	next[PTR_MAX];
	unsigned int	fofs;
	int		sg_size;
	PN_TREE_NODE *	sg;
} PDB_PT;

typedef struct pdb_lod_pt {
	int		max;
	PDB_NEXT	next[32];
	int		sg_size;
	unsigned int	fofs;
	PN_LOD_LIST *	sg;
} PDB_LOD_PT;

PDB_POLYGON2D *
get_polygon(XL_SEXP **,XL_SYM_FIELD *,XL_FILE *,int);

PDB_POLYGON2D *search_sn_avt(L_CHAR * name);


typedef struct load_svg_param{
	int argc;
	char **argv;
	int finished;
}LOAD_SVG_PARAM;
void load_svg_task(void *pParam);
/*
int load_svg(int argc, char *argv[]);
void init_load_svg_lock();
void load_svg_lock();
void load_svg_unlock();
*/
void gc_load_svg_info_exp();


//define for debug
#define VERIFY(IsOk) if(!IsOk) printf("%s",(char*)-1);

#define VERIFY_PT_IS_NOT_ZERO(pt) \
if(-0.0001 < pt.x && pt.x < 0.0001 && \
   -0.0001 < pt.y && pt.y < 0.0001)   \
   VERIFY(0)

#define DEBUG_PRINT printf
#endif
