/**********************************************************************
 
	Copyright (C) 2003 Hirohisa MORI <joshua@nichibun.ac.jp>
 
	This program is free software; you can redistribute it 
	and/or modify it under the terms of the GLOBALBASE 
	Library General Public License (G-LGPL) as published by 

	http://www.globalbase.org/
 
	This program is distributed in the hope that it will be 
	useful, but WITHOUT ANY WARRANTY; without even the 
	implied warranty of MERCHANTABILITY or FITNESS FOR A 
	PARTICULAR PURPOSE.

**********************************************************************/



#include	"machine/include.h"
#include	"memory_debug.h"
#include	"task.h"
#include	"utils.h"
#include	"server.h"

/*
#define DEBUG
*/

extern SEM netutils_lock;

void
init_access_permission(ACCESS_PERMISSION * ap)
{
	ap->head = ap->tail = 0;
}


void
copy_host_addr_ext(HOST_ADDR_EXT * d,HOST_ADDR_EXT * s)
{
	memcpy(d,s,sizeof(*d));
	if ( s->type == HAT_XLPROX_DOMAIN )
		d->domain.name = copy_str(s->domain.name);
}

void
free_host_addr_ext(HOST_ADDR_EXT * d)
{
	if ( d->type == HAT_XLPROX_DOMAIN )
		d_f_ree(d->domain.name);
}


void
free_access_list(ACCESS_PERMISSION * ap)
{
ACCESS_LIST * al;
	for ( ; ap->head ; ) {
		al = ap->head;
		ap->head = al->next;

		free_host_addr_ext(&al->src);
		free_host_addr_ext(&al->dest);
		if ( al->info )
			(*al->info->free_func)(al->info);
		d_f_ree(al);
	}
}

void
set_host_addr_size(HOST_ADDR* a)
{

	switch ( a->type ) {
	case HAT_NONE:
		a->size = 0;
		break;
	case HAT_V4:
		a->size = sizeof(a->d.v4);
		break;
	case HAT_V6:
		a->size = sizeof(a->d.v6);
		break;
	case HAT_XLPROX_V4:
		a->size = sizeof(a->d.xp_v4);
		break;
	case HAT_XLPROX_V6:
		a->size = sizeof(a->d.xp_v6);
		break;
	default:
		er_panic("set_host_addr_size");
	}
}



void
insert_access_list(
	ACCESS_PERMISSION * ap,
	HOST_ADDR_EXT *		src,
	HOST_ADDR_EXT *		dest,
	int			type,
	AL_INFO_HEADER *	info)
{
ACCESS_LIST * al;
	al = d_alloc(sizeof(*al));
	memset(al,0,sizeof(*al));

	copy_host_addr_ext(&al->src,src);
	copy_host_addr_ext(&al->dest,dest);
#ifdef DEBUG
ss_printf("ACCESS %s -> %s\n",get_string_inet_addr(src),get_string_inet_addr(dest));
#endif
	al->type = type;
	al->info = info;

	al->next = 0;
	if ( ap->head ) {
		ap->tail->next = al;
		ap->tail = al;
	}
	else {
		ap->head = ap->tail = al;
	}
}


int
cmp_host_port_id(int p1,int id1,int p2,int id2)
{
	if ( p1 >= 0 ) {
		if ( p1 != p2 )
			return -1;
	}
	if ( id1 >= 0 ) {
		if ( id1 != id2 )
			return -1;
	}
	return 0;
}


int
cmp_host_addr(HOST_ADDR_EXT * a1,HOST_ADDR_EXT * a2,HOST_ADDR_EXT * a2_tmp)
{
HOST_ENTRY * hp;
int len1;
int len2;
char ** q;
int i,j;

	if ( a1->type == HAT_ALL )
		return 0;
	switch ( a2->type ) {
	case HAT_ME:
		if ( a1->type == HAT_ME )
			return 0;
		else	return -1;
	case HAT_NONE:
		if ( a1->type == HAT_NONE )
			return 0;
		else	return -1;
	case HAT_XLPROX_V4:
		switch ( a1->type ) {
		case HAT_ME:
			return -1;
		case HAT_NONE:
			return 0;
		case HAT_XLPROX_V4:
			if ( (a1->am.addr.d.xp_v4.v4 & a1->am.mask.d.xp_v4.v4)
					== (a2->am.addr.d.xp_v4.v4 & a1->am.mask.d.xp_v4.v4) )
				return cmp_host_port_id(a1->am.addr.port,a1->am.addr.d.xp_v4.id,
							a2->am.addr.port,a2->am.addr.d.xp_v4.id);
			else	return -1;
		case HAT_XLPROX_V6:
			return -1;
		case HAT_XLPROX_DOMAIN:
			switch ( a2_tmp->type ) {
			case HAT_NONE:
			addr_resolve:
				set_host_addr_size(&a2->am.addr);
				hp = r_gethostbyaddr(a2->am.addr);
				if ( hp == 0 ) {
					a2_tmp->type = HAT_ERROR;
					return -1;
				}
				else {
					a2_tmp->he.size = 0;
					a2_tmp->he.port = a2->domain.port;
					a2_tmp->he.id = a2->domain.id;
					a2_tmp->he.he = hp;
					goto he_do;
				}
			case HAT_XLPROX_HOST_ENTRY:
			he_do:
				len1 = strlen(a1->domain.name);
				q = a2_tmp->he.he->names;
				for ( ; *q ; q ++ ) {
					len2 = strlen(*q);
					if ( len2 < len1 )
						return -1;
					if ( strcmp(&(*q)[len2-len1],a1->domain.name)
							== 0 ) {
						if ( len2 == len1 ) {
							return cmp_host_port_id(a1->domain.port,a1->domain.id,
										a2_tmp->he.port,a2_tmp->he.id);
						}
						if ( (*q)[len2-len1-1] == '.' ) {
							return cmp_host_port_id(a1->domain.port,a1->domain.id,
										a2_tmp->he.port,a2_tmp->he.id);
						}
					}
				}
				return -1;
			default:
				return -1;
			}
			break;
		default:
			er_panic("cmp_host_addr");
		}
		break;
	case HAT_XLPROX_V6:
		switch ( a1->type ) {
		case HAT_ME:
			return -1;
		case HAT_NONE:
			return 0;
		case HAT_XLPROX_V4:
			return -1;
		case HAT_XLPROX_V6:
			for ( i = 0 ; i < 4 ; i ++ ) {
				if ( (a1->am.addr.d.xp_v6.v6[i] & a1->am.mask.d.xp_v6.v6[i])
						!= (a2->am.addr.d.xp_v6.v6[i] & a1->am.mask.d.xp_v6.v6[i]) )
					return -1;
			}
			return cmp_host_port_id(a1->am.addr.port,a1->am.addr.d.xp_v6.id,
						a2->am.addr.port,a2->am.addr.d.xp_v6.id);
		case HAT_XLPROX_DOMAIN:
			switch ( a2_tmp->type ) {
			case HAT_NONE:
				goto addr_resolve;
			case HAT_XLPROX_HOST_ENTRY:
				goto he_do;
			default:
				return -1;
			}
			break;
		default:
			er_panic("cmp_host_addr");
		}
		break;
	case HAT_XLPROX_DOMAIN:
		switch ( a1->type ) {
		case HAT_ME:
			return -1;
		case HAT_NONE:
			return 0;
		case HAT_XLPROX_V6:
			switch ( a2_tmp->type ) {
			case HAT_NONE:
				hp = r_gethostbyname(a2->domain.name);
				if ( hp == 0 ) {
					a2_tmp->type = HAT_ERROR;
					return -1;
				}
				else {
					a2_tmp->he.size = 0;
					a2_tmp->he.port = a2->am.addr.port;
					a2_tmp->he.id = a2->am.addr.d.xp_v4.id;
					a2_tmp->he.he = hp;
					goto he_do2;
				}
			case HAT_ERROR:
				return -1;
			case HAT_XLPROX_HOST_ENTRY:
			he_do2:
				for ( i = 0 ; i < a2_tmp->he.he->ips_length ; i ++ ) {
					for ( j = 0 ; j < 4 ; j ++ ) {
						if ( (a1->am.addr.d.xp_v6.v6[j] & a1->am.mask.d.xp_v6.v6[j])
								!= (a2->he.he->ips[i].d.v6[j] & a1->am.mask.d.v6[j]) )
							goto next;
					}
					return cmp_host_port_id(a1->am.addr.port,a1->am.addr.d.xp_v6.id,
								a2_tmp->he.port,a2_tmp->he.id);
				next:	;
				}
				return -1;
			default:
				return -1;
			}
		case HAT_XLPROX_V4:
			switch ( a2_tmp->type ) {
			case HAT_NONE:
				hp = r_gethostbyname(a2->domain.name);
				if ( hp == 0 ) {
					a2_tmp->type = HAT_ERROR;
					return -1;
				}
				else {
					a2_tmp->he.size = 0;
					a2_tmp->he.port = a2->am.addr.port;
					a2_tmp->he.id = a2->am.addr.d.xp_v4.id;
					a2_tmp->he.he = hp;
					goto he_do3;
				}
			case HAT_ERROR:
				return -1;
			case HAT_XLPROX_HOST_ENTRY:
			he_do3:
				for ( i = 0 ; i < a2_tmp->he.he->ips_length ; i ++ ) {
					if ( (a1->am.addr.d.xp_v4.v4 & a1->am.mask.d.xp_v4.v4)
							== (a2_tmp->he.he->ips[i].d.v4 & a1->am.mask.d.xp_v4.v4) )
						return cmp_host_port_id(a1->am.addr.port,a1->am.addr.d.xp_v4.id,
									a2_tmp->he.port,a2_tmp->he.id);
				}
				return -1;
			default:
				return -1;
			}
		case HAT_XLPROX_DOMAIN:
			len1 = strlen(a1->domain.name);
			len2 = strlen(a2->domain.name);
			if ( len2 < len1 )
				return -1;
			if ( strcmp(&a2->domain.name[len2-len1],a1->domain.name)
					== 0 ) {
				if ( len2 == len1 ) {
					return cmp_host_port_id(a1->domain.port,a1->domain.id,
								a2->domain.port,a2->domain.id);
				}
				if ( a2->domain.name[len2-len1-1] == '.' ) {
					return 0;
				}
			}
			return -1;
		default:
			er_panic("cmp_host_addr");
		}
	default:
		er_panic("cmp_host_addr");
	}
	er_panic("cmp_host_addr");
	return 0;
}



ACCESS_LIST *
check_permission(ACCESS_PERMISSION * ap,HOST_ADDR_EXT * src,HOST_ADDR_EXT * dest)
{
ACCESS_LIST * al;
HOST_ADDR_EXT src_tmp,dest_tmp;
	src_tmp.type = HAT_NONE;
	dest_tmp.type = HAT_NONE;

#ifdef DEBUG
if ( src )
ss_printf("CP %s -> %s\n",get_string_inet_addr(src),get_string_inet_addr(dest));
else 
ss_printf("CP ME -> %s\n",get_string_inet_addr(dest));
#endif


	for ( al = ap->head ; al ; al = al->next ) {
#ifdef DEBUG
if ( src )
ss_printf("CP %s -> %s (%s -> %s) %s\n",get_string_inet_addr(src),get_string_inet_addr(dest),get_string_inet_addr(&al->src),get_string_inet_addr(&al->dest),get_string_inet_addr(&src_tmp));
else 
ss_printf("CP ME -> %s (%s -> %s) %s\n",get_string_inet_addr(dest),get_string_inet_addr(&al->src),get_string_inet_addr(&al->dest),get_string_inet_addr(&src_tmp));
#endif
		if ( src == 0 ) {
			if ( al->src.type != HAT_NONE && al->src.type != HAT_ME )
				continue;
		}
		else {
			if ( cmp_host_addr(&al->src,src,&src_tmp) )
				continue;
		}
		if ( dest == 0 ) {
			if ( al->dest.type != HAT_NONE )
				continue;
		}
		else {
			if ( cmp_host_addr(&al->dest,dest,&dest_tmp) )
				continue;
		}
#ifdef DEBUG
ss_printf("OK\n");
#endif
		return al;
	
	}
/*
ss_printf("DENY\n");
*/
	return 0;
}

int
inet_addr_xl(char * str)
{
char buf[20];
char * p;
char * a[4];
int b[4];
	b[0] = b[1] = b[2] = b[3] = 0;
	strcpy(buf,str);
	a[0] = &buf[0];
	for ( p = &buf[0] ; *p && *p != '.' ; p ++ );
	if ( *p == 0 )
		goto end;
	*p = 0;
	p++;
	b[0] = atoi(a[0]);
	a[1] = p;
	for ( ; *p && *p != '.' ; p ++ );
	if ( *p == 0 )
		goto end;
	*p = 0;
	p++;
	b[1] = atoi(a[1]);
	a[2] = p;
	for ( ; *p && *p != '.' ; p ++ );
	if ( *p == 0 )
		goto end;
	*p = 0;
	p++;
	b[2] = atoi(a[2]);
	a[3] = p;

	b[3] = atoi(a[3]);
end:
	return (b[0]<<24)+(b[1]<<16)+(b[2]<<8)+(b[3]);
}


int
get_inet_addr(HOST_ADDR_EXT * ha,char * str)
{
char * _str,*p;
char * addr;
char * port;
char * mask;
char * accept_id;
	_str = copy_str(str);

	addr = _str;
	for ( p = _str ; *p && *p != ':' ; p ++ );
	if ( *p == 0 ) {
		port = "-1";
		accept_id = "-1";
		goto next1;
	}
	*p = 0;
	p ++;
	port = p;
	for ( ; *p && *p != ':' ; p ++ );
	if ( *p == 0 ) {
		accept_id = "-1";
		goto next1;
	}
	*p = 0;
	p ++;
	accept_id = p;
next1:
	if ( port[0] == 0 )
		port = "-1";
	if ( accept_id[0] == 0 )
		accept_id = "-1";
	for ( p = _str ; *p && *p != '/' ; p ++ );
	if ( *p == 0 ) {
		mask = "32";
	}
	else {
		*p = 0;
		mask = p + 1;
	}
	
	if ( strcmp(addr,"me") == 0 ) {
		ha->type = HAT_ME;
	}
	else if ( strcmp(addr,"all") == 0 ) {
		ha->type = HAT_ALL;
	}
	else {
		for ( p = addr ; *p && ((*p >= '0' && *p <= '9') || *p == '.') ; p ++ );
		if ( *p != 0 ) {

			ha->type = HAT_XLPROX_DOMAIN;
			ha->domain.name = copy_str(addr);
			ha->domain.port = atoi(port);
			ha->domain.id = atoi(accept_id);
			ha->domain.size = strlen(ha->domain.name);
		}
		else {
			ha->am.addr.d.xp_v4.v4 = inet_addr_xl(addr);
			ha->am.addr.port = atoi(port);
			ha->am.addr.size = 4;
			if ( atoi(mask) )
				ha->am.mask.d.xp_v4.v4 = -(1<<(32-atoi(mask)));
			else	ha->am.mask.d.xp_v4.v4 = 0;
			ha->am.mask.type = HAT_XLPROX_V4;
			ha->am.addr.d.xp_v4.id = atoi(accept_id);
			ha->type = HAT_XLPROX_V4;
		}
	}
	
	
	d_f_ree(_str);
	return 0;
}

char * 
get_string_inet_addr(HOST_ADDR_EXT * addr)
{
char * ret,*p;
unsigned int i;
unsigned int v4;
	switch ( addr->type ) {
	case HAT_XLPROX_V4:
		ret = d_alloc(1000);
		v4 = addr->am.addr.d.xp_v4.v4;
		sprintf(ret,"%i.%i.%i.%i",(v4>>24)&0xff,(v4>>16)&0xff,(v4>>8)&0xff,(v4)&0xff);
		p = ret+strlen(ret);
		if ( addr->am.mask.d.xp_v4.v4 != 0xffffffff ) {
			for ( i = 0 ; i < 32 ; i ++ )
				if ( addr->am.mask.d.xp_v4.v4 & (1<<i) )
					break;
			sprintf(p,"/%i",32-i);
		}
		p = p+strlen(p);
		if ( addr->am.addr.port >= 0 )
			sprintf(p,":%i",addr->am.addr.port);
		else	sprintf(p,":");
		p = p+strlen(p);
		if ( addr->am.addr.d.xp_v4.id >= 0 )
			sprintf(p,":%i",addr->am.addr.d.xp_v4.id);
		else	sprintf(p,":");
		break;
	case HAT_XLPROX_DOMAIN:
		ret = d_alloc(1000);
		sprintf(ret,"%s",addr->domain.name);
		p = ret+strlen(ret);
		if ( addr->domain.port >= 0 )
			sprintf(p,":%i",addr->domain.port);
		else	sprintf(p,":");
		p = p+strlen(p);
		if ( addr->domain.id >= 0 )
			sprintf(p,":%i",addr->domain.id);
		else	sprintf(p,":");
		break;
	case HAT_ME:
		ret = copy_str("me");
		break;
	case HAT_ALL:
		ret = copy_str("all");
		break;
	case HAT_NONE:
		ret = copy_str("none");
	default:
		ret = copy_str("unrecognized");
	}
	set_buffer(ret);
	return ret;
}


