/**********************************************************************
 
	Copyright (C) 2003-2004
	Hirohisa MORI <joshua@nichibun.ac.jp>
	Tomoki SEKIYAMA <sekiyama@yahoo.co.jp>
 
	This program is free software; you can redistribute it 
	and/or modify it under the terms of the GLOBALBASE 
	Library General Public License (G-LGPL) as published by 

	http://www.globalbase.org/
 
	This program is distributed in the hope that it will be 
	useful, but WITHOUT ANY WARRANTY; without even the 
	implied warranty of MERCHANTABILITY or FITNESS FOR A 
	PARTICULAR PURPOSE.

**********************************************************************/



#include "v/VSemaphore.h"

extern "C" {
#include "lock_level.h"
#include "pri_level.h"
#include "utils.h"
#include "task.h"

int get_tid();
  //void er_panic(const char * str);
}

int lock_count;
SEM vsem_lock;

VSemaphore::VSemaphore()
{
	if ( vsem_lock.so == 0 )
		vsem_lock = new_lock(LL_VOBJECT);
	lock_cnt = 0;
	locking_tid = 0;
lock_count ++;
}

VSemaphore::~VSemaphore()
{
	if ( locking_tid != 0 )
		er_panic("~VSemaphore");
lock_count --;
}

void
VSemaphore::lock(char * __f,int __l)
{
int pri;
	int tid = get_tid();
	
	lock_task(vsem_lock);
	if ( locking_tid && locking_tid == tid ) // already locked
		lock_cnt++;
	else {
		pri = push_pri(PRI_TOOLKIT);
		for ( ; locking_tid ; ) {
			sleep_task((int)this,vsem_lock);
			lock_task(vsem_lock);
		}
		locking_tid = tid;
		lock_pri = pri;
		lock_cnt = 1;
		
		__file = __f;
		__line = __l;
	}
	unlock_task(vsem_lock,"VSemqphore");
}


void
VSemaphore::unlock()
{
int pri;
int tid;
	tid = get_tid();
	
	
	lock_task(vsem_lock);
	if ( lock_cnt == 0 || locking_tid != tid )
		er_panic("unlock unlock lock");
	lock_cnt --;
	if ( lock_cnt == 0 ) {
		wakeup_task((int)this);
		locking_tid = 0;
		pri = lock_pri;
		__file = 0;
		__line = 0;
		change_pri(0,pri);
	}
	unlock_task(vsem_lock,"VSemqphore::unlock");
}

int
VSemaphore::is_locked()
{
int ret;
	lock_task(vsem_lock);
	if ( locking_tid == get_tid() )
		ret = 1;	// this thread locked this
	else if ( locking_tid )
		ret = -1;	// another thread locked this
	else	ret = 0;		// is not locked
	unlock_task(vsem_lock,"ls_locked");
	return ret;
}
