/**********************************************************************
 
	Copyright (C) 2003-2004
	Hirohisa MORI <joshua@nichibun.ac.jp>
	Tomoki SEKIYAMA <sekiyama@yahoo.co.jp>
 
	This program is free software; you can redistribute it 
	and/or modify it under the terms of the GLOBALBASE 
	Library General Public License (G-LGPL) as published by 

	http://www.globalbase.org/
 
	This program is distributed in the hope that it will be 
	useful, but WITHOUT ANY WARRANTY; without even the 
	implied warranty of MERCHANTABILITY or FITNESS FOR A 
	PARTICULAR PURPOSE.

**********************************************************************/



#include "v/VGroupBox.h"
#include "v/vobj_utils.h"

extern "C" {
#include "xl.h"
#include "xlerror.h"

XL_SEXP *
vobj_VGroupBox(XLISP_ENV *env, XL_SEXP *arg, XLISP_ENV *a, XL_SYM_FIELD *sf);


XL_SEXP *
vobj_VGroupBox(XLISP_ENV *env, XL_SEXP *arg, XLISP_ENV *a, XL_SYM_FIELD *sf)
{
/*
	VObjectStatus sts;
	VObject::FreeList *free_list;

	int flags = get_sts_from_sf(env,&sts,0, sf, &free_list);
	VExError err;
	
	XL_SEXP *p = eval(env, n_get_symbol("__parent"));
	if ( get_type(p) == XLT_ERROR )
		return p;
	if ( get_type(p) != XLT_INTEGER )
		return vobj_get_error(initial_VExError(V_ER_PARENT,0,0), arg,0);
	VObject *parent = VObject::get_object_by_id(p->integer.data);

*/

	XL_SEXP * _ref;
	VObjectStatus _sts;
	VGroupBox * obj;
	int flags = 0;

	_ref = get_refered_object<VGroupBox>
			(&obj,env,arg,sf,VO_GBOX,"VGroupBox",&_sts,0,0);
	if  ( get_type(_ref) == XLT_ERROR )
		return _ref;

	L_CHAR *attr;
	if ( ( attr = get_sf_attribute(sf, l_string(std_cm, "attr")) ) ) {
		flags |= VSF_ATTR;
		if ( l_strcmp(attr, l_string(std_cm, "secondary")) == 0 )
			_sts.attr = VGroupBox::secondary;
		else
			_sts.attr = 0;
	}


	if ( flags )
		obj->set_status(&_sts,flags);
	obj->get_status(&_sts, VSF_ID);
	XL_SEXP *ret = vobj_eval_child(_sts.id, env, arg);
	if ( get_type(ret) == XLT_ERROR )
		return ret;
	switch ( get_type(_ref) ) {
	case XLT_INTEGER:
		return vobj_get_id_list(_ref->integer.data,ret,sf,0);
	case XLT_ERROR:
		return _ref;
	}
	return vobj_get_id_list(_sts.id, ret, sf,0);
/*	
	sts.parent = parent;
	flags |= VSF_PARENT;
	VGroupBox *obj = VGroupBox::create(&sts, flags, &err);
	if ( err.code != V_ER_NO_ERR )
		return vobj_get_error(err, arg,0);
	obj->free_on_release_list(free_list);
	obj->get_status(&sts, VSF_ID);
	XL_SEXP *ret = vobj_eval_child(sts.id, env, arg);
	if ( get_type(ret) == XLT_ERROR )
		return ret;
	return vobj_get_id_list(sts.id, ret, sf,0);
*/
}

void
init_VGroupBox(XLISP_ENV *env)
{
	set_env(env,l_string(std_cm,"VGroupBox"),
		get_func_prim((XL_SEXP*(*)())vobj_VGroupBox,FO_NORMAL,0,1,2));
}


} // extern "C"
