/**********************************************************************
 
	Copyright (C) 2003-2004
	Hirohisa MORI <joshua@nichibun.ac.jp>
	Tomoki SEKIYAMA <sekiyama@yahoo.co.jp>
 
	This program is free software; you can redistribute it 
	and/or modify it under the terms of the GLOBALBASE 
	Library General Public License (G-LGPL) as published by 

	http://www.globalbase.org/
 
	This program is distributed in the hope that it will be 
	useful, but WITHOUT ANY WARRANTY; without even the 
	implied warranty of MERCHANTABILITY or FITNESS FOR A 
	PARTICULAR PURPOSE.

**********************************************************************/



#include "v/VWindow.h"
#include "VApplication.h"

#include "v/VLayout.h"
#include "v/VChooseFile.h"

extern "C" {
#include	"utils.h"
#include	"pri_level.h"
#include	"memory_debug.h"
}

#include "v/vobj_utils.h"
#include "LString.h"
#include "PP_KeyCodes.h"
#include "LWindow.h"
#include "LUndoer.h"
#include "LWindowHeader.h"
#include "LPushButton.h"
#include "UKeyFilters.h"

void AddDefaultButton(LPane *pane, LPushButton *button);
void RemoveDefaultButton(LPane *pane, LPushButton *button);
void AddCancelButton(LPane *pane, LPushButton *button);
void RemoveCancelButton(LPane *pane, LPushButton *button);
int finish_by_close_last_window;

extern VCustomizedMenuBar *	menu_no_window;

const SInt16	length_Big		= 16000;

class CWindow : public LWindow
{
public:
	CWindow(
			ResIDT				inWINDid,
			UInt32				inAttributes,
			LCommander*			inSuperCommander,
			int					category,
			VCustomizedMenuBar*	menu,
			VWindow*			vwin)
		: LWindow(inWINDid, inAttributes, inSuperCommander), 
		  mCategory(category), mMenuBar(menu), mVWindow(vwin),
		  mDefaultButtons(0), mCancelButtons(0)
		{
		}
	//static V_CALLBACK_D(_ResizeFrameBy)
	static void _ResizeFrameBy(void * sys_arg)
	{
		VObject* object = (VObject*)sys_arg;
		VLayout::mark(object);
	}
	
	virtual void	ResizeFrameBy(
				SInt16		inWidthDelta,
				SInt16		inHeightDelta,
				Boolean		inRefresh)
		{
			LWindow::ResizeFrameBy(inWidthDelta, inHeightDelta, inRefresh);
			if (mUserCon && (inWidthDelta !=0 || inHeightDelta != 0) ) {
//				VLayout::mark(mVWindow);
//				vq_insert_callback_machine(mVWindow,_ResizeFrameBy,0,0,0,0,0);
				lthread_do(_ResizeFrameBy,mVWindow,1,1,0);
			}
		}

	virtual void		AttemptClose()
		{
			if ((mSuperCommander == nil) || mSuperCommander->AllowSubRemoval(this)) {
				if ( mVWindow->attempt_close() ) {
					SendSelfAE(kAECoreSuite, kAEClose, ExecuteAE_No);
					Hide();
					vq_insert_callback_machine(mVWindow,v_object_destroyer,0,0,0,0,0);
				}
			}
		}

	virtual void		DoClose()
		{
			if ((mSuperCommander == nil) || mSuperCommander->AllowSubRemoval(this)) {
				if ( mVWindow->attempt_close() ) {
					SendSelfAE(kAECoreSuite, kAEClose, ExecuteAE_No);
					Hide();
					vq_insert_callback_machine(mVWindow,v_object_destroyer,0,0,0,0,0);
				}
			}
		}
	virtual void		ActivateSelf() 
		{
			VCustomizedMenuBar::menu_lock(1,__FILE__,__LINE__);
			if ( (mAttributes & windAttr_Floating) == 0 )
				VCustomizedMenuBarImp::switch_to_menu(mMenuBar, !(mAttributes & windAttr_Modal));
			LWindow::ActivateSelf();
			if ( (mAttributes & windAttr_Modal) ) {
				if ( mMenuBar )
					mMenuBar->reset_menu_flags_do(0);
				else if ( menu_no_window )
					menu_no_window->reset_menu_flags_do(0);
			}
			VCustomizedMenuBar::menu_unlock(__FILE__,__LINE__);
		}
	virtual void		DeactivateSelf()
		{ 
			if ( (mAttributes & windAttr_Floating) == 0 )
				VCustomizedMenuBarImp::switch_to_menu(menu_no_window, true); 
			LWindow::DeactivateSelf();
		}
	
	virtual void		FindCommandStatus(
								CommandT			inCommand,
								Boolean&			outEnabled,
								Boolean&			outUsesMark,
								UInt16&				outMark,
								Str255				outName)
		{
//ss_printf("{%i,%i,%i,%i,%i},\n",inCommand,outEnabled,outUsesMark,outMark,outName);
			short flag;
			if ( mMenuBar && inCommand < 0 && mMenuBar->get_menu_flag(inCommand, &flag) ) {
				outEnabled = flag & VMF_ENABLED;
				outUsesMark = flag & VMF_CHECKED;
				if ( outUsesMark )
					outMark = checkMark;
			}
			else if ( inCommand == cmd_Preferences || inCommand == cmd_Quit ) {
				outEnabled = (mAttributes & windAttr_Modal) ? false : true;
			}
			else {
				LWindow::FindCommandStatus(inCommand, outEnabled,
										outUsesMark, outMark, outName);
			}
		}
	virtual Boolean			ObeyCommand(
								CommandT			inCommand,
								void*				ioParam = nil)
		{
/*
			if ( mMenuBar && inCommand < 0 && mMenuBar->menu_choosed(inCommand) )
				return true;
*/
			if ( mMenuBar ) {
			short menu_id;
			short where;
			int cmd;
			VMenuItem * itm;
				if ( inCommand < 0 ) {
					if ( mMenuBar->menu_choosed(inCommand) )
						return true;
				}
				else {
					cmd = -inCommand;
					menu_id = (cmd>>16)&0xffff;
					where = (cmd)&0xffff;
					itm = mMenuBar->search(menu_id);
					if ( itm == 0 )
						goto next;
					itm = itm->get_submenu_in_where(where);
					if ( mMenuBar->menu_choosed(itm) )
						return true;
				}
			}
		next:
			return LWindow::ObeyCommand(inCommand, ioParam);
		}

	virtual Boolean		HandleKeyPress( const EventRecord& inKeyEvent )
		{
			ButtonList *list;
			if ( inKeyEvent.modifiers == 0 &&
					( (inKeyEvent.message & charCodeMask ) == char_Return ||
					  (inKeyEvent.message & charCodeMask ) == char_Enter ) ) {
				for ( list = mDefaultButtons ; list ; list = list->next ) {
					if ( list->btn->IsActive() ) {
						list->btn->BroadcastMessage(msg_ValueChanged, 0);
						return TRUE;
					}
				}
			}
			else if ( UKeyFilters::IsEscapeKey(inKeyEvent) ||
						UKeyFilters::IsCmdPeriod(inKeyEvent) ) {
				for ( list = mCancelButtons ; list ; list = list->next ) {
					if ( list->btn->IsActive() ) {
						list->btn->BroadcastMessage(msg_ValueChanged, 0);
						return TRUE;
					}
				}
			}
			return FALSE;
		}
	void				AddDefaultButton( LPushButton*	button )
		{
			AddToButtonList(button, &mDefaultButtons);
		}
	void				RemoveDefaultButton( LPushButton*	button )
		{
			RemoveFromButtonList(button, &mDefaultButtons);
		}
	void				AddCancelButton( LPushButton*	button )
		{
			AddToButtonList(button, &mCancelButtons);
		}
	void				RemoveCancelButton( LPushButton*	button )
		{
			RemoveFromButtonList(button, &mCancelButtons);
		}

	void				set_menu_bar(VCustomizedMenuBar * menu)
	{
//		delete mMenuBar;
		mMenuBar = menu;
	}
	VCustomizedMenuBar *		get_menu_bar()
	{
		return mMenuBar;
	}
	virtual void push_port(VWINDOW_OSDEP * dp)
	{
		int al_stk = get_app_lock();
		if ( in_redraw == 0 ) {
			dp->originalPort = UQDGlobals::GetCurrentPort();

			::SetPortWindowPort(mMacWindowP);
			::SetOrigin(0,0);
			OutOfFocus(nil);

//			::BeginUpdate(mMacWindowP);
			dp->push = 1;
		}
		else	dp->push = 0;
		release_app_lock(al_stk);
	}
	virtual void pop_port(VWINDOW_OSDEP * dp)
	{
		int al_stk = get_app_lock();
		if ( dp->push == 1 ) {
//			::EndUpdate(mMacWindowP);

			::MacSetPort(dp->originalPort);
			OutOfFocus(nil);
		}
		release_app_lock(al_stk);
	}

  protected:
	VCustomizedMenuBar*	mMenuBar;
	int					mCategory;
	VWindow *			mVWindow;
	struct ButtonList {
		LPushButton *	btn;
		ButtonList *	next;
	} *mDefaultButtons, *mCancelButtons;

	void				AddToButtonList( LPushButton*	button, ButtonList **list )
		{
			ButtonList *newList = new ButtonList;
			newList->btn = button;
			newList->next = *list;
			*list = newList;
		}
	void				RemoveFromButtonList( LPushButton*	button, ButtonList **list )
		{
			ButtonList *prev = 0, *target;
			for ( target = *list ; target ; prev = target, target = target->next ) {
				if ( target->btn == button ) {
					if ( prev )
						prev->next = target->next;
					else
						*list = target->next;
					delete target;
					return;
				}
			}
		}
};

void
AddDefaultButton(LPane *pane, LPushButton *button)
{
	((CWindow*)pane)->AddDefaultButton(button);
}
void
RemoveDefaultButton(LPane *pane, LPushButton *button)
{
	((CWindow*)pane)->RemoveDefaultButton(button);
}
void
AddCancelButton(LPane *pane, LPushButton *button)
{
	((CWindow*)pane)->AddCancelButton(button);
}
void
RemoveCancelButton(LPane *pane, LPushButton *button)
{
	((CWindow*)pane)->RemoveCancelButton(button);
}


VExError
VWindow::create_do(const VObjectStatus *s, int flags,VObject * nmp, void * arg)
{
	window_close_handler = 0;
	sts.min_size = (VSize){V_WINDOW_MIN_WIDTH, V_WINDOW_MIN_HEIGHT};
	VCustomizedMenuBar * mbar;

	category = *(int*)arg;

	VCustomizedMenuBar::menu_lock(1,__FILE__,__LINE__);
	mbar = VCustomizedMenuBar::create(category, this);
	VCustomizedMenuBar::menu_unlock(__FILE__,__LINE__);

	if ( flags & VSF_ATTR )
		sts.attr = s->attr;
	else
		sts.attr = 0;
	
	UInt32 attributes;
	attributes = (sts.attr & floating) ? (windAttr_Floating | windAttr_HideOnSuspend) :
				( sts.attr & modal ) ? 	windAttr_Modal : windAttr_Regular;
	attributes |= windAttr_TitleBar | windAttr_Enabled | windAttr_Targetable;
	if ( ! (sts.attr & modal) )
		attributes |= windAttr_CloseBox;
	if ( sts.attr & resizable )
		attributes |= windAttr_Resizable | windAttr_SizeBox | windAttr_Zoomable;
	int al_stk = get_app_lock();
	CWindow* win = new CWindow((sts.attr & floating) ? WIND_V_FLOATING_RES : WIND_V_DEFAULT_RES,
			attributes, theApp, category, mbar, this);
	win->AddAttachment(new LUndoer);
	win->SetMinMaxSize((Rect){V_WINDOW_MIN_WIDTH,V_WINDOW_MIN_HEIGHT,length_Big,length_Big});
	win->SetStandardSize((SDimension16){V_WINDOW_MIN_WIDTH,V_WINDOW_MIN_HEIGHT});
	win->ResizeWindowTo(V_WINDOW_MIN_WIDTH,V_WINDOW_MIN_HEIGHT);
	win->SetUserCon((long)this);

	SDimension16 size;
	win->GetFrameSize(size);

	SPaneInfo paneInfo = { sts.id, size.width, size.height, true, true, 
			(SBooleanRect){true,true,true,true}, 0, 0, (long)this, win };
	SViewInfo viewInfo = { (SDimension32){size.width, size.height}, {0,0}, {1,1}, false };
	LWindowHeader *pla = new LWindowHeader(paneInfo, viewInfo);
	pla->FinishCreate();
	info = pla;
	
	win->FinishCreate();
	release_app_lock(al_stk);

	{
		VLayout layout;	// calc min size
		layout.layout_in_frame(this, true);
	}
	insert_window_list();
	return nmp->add_child_do(this);
}

void
VWindow::destroy_do(VObject * nmp)
{
VWindow ** wp;
VCustomizedMenuBar * mb;
	nmp->remove_child_do(this);
	VCustomizedMenuBar::menu_lock(1,__FILE__,__LINE__);
	CWindow *win = (CWindow*)((LWindowHeader *)info)->GetSuperView();
	mb = win->get_menu_bar();
	win->set_menu_bar(0);
	VCustomizedMenuBarImp::switch_to_menu(0, !((LWindow*)info)->HasAttribute(windAttr_Modal));
	if ( mb )
{ss_printf("delete menuBar\n");
		delete mb;
}
	VCustomizedMenuBar::menu_unlock(__FILE__,__LINE__);
	if ( info ) { // info can be set NULL on close
//		((LWindowHeader*)info)->GetSuperView()->Hide();
		VLayout::unmark(this);
		int al_stk = get_app_lock();
		delete ((LWindowHeader*)info)->GetSuperView();
		release_app_lock(al_stk);
	}
	delete_window_list();
}

VWindow::~VWindow()
{
}

VCustomizedMenuBar *
VWindow::get_menu_bar()
{
	CWindow *win = (CWindow*)((LWindowHeader *)info)->GetSuperView();
	if ( win == 0 )
		return 0;
	return win->get_menu_bar();
}

VExError
VWindow::get_status(VObjectStatus *s, int flags) const
{
	V_OP_START_EX
	VExError err = initial_VExError(V_ER_NO_ERR,flags,0);
	int al_stk = get_app_lock();
	CWindow *win = (CWindow*)((LWindowHeader *)info)->GetSuperView();
	if ( flags & VSF_ATTR ) {
		s->attr = sts.attr;
		if ( win->HasAttribute(windAttr_Resizable) )
			s->attr |= resizable;
		else
			s->attr &= ~resizable;
		if ( win->HasAttribute(windAttr_Modal) )
			s->attr |= modal;
		else
			s->attr &= ~modal;
		if ( win->HasAttribute(windAttr_Floating) )
			s->attr |= floating;
		else
			s->attr &= ~floating;
		flags &= ~VSF_ATTR;
	}
	if ( flags & VSF_ENABLED ) {
		s->enabled = win->IsEnabled();
		flags &= ~VSF_ENABLED;
	}
	Rect rect;
	if ( flags & (VSF_POSITION | VSF_SIZE) ) {
		win->GetGlobalBounds(rect);
	}
	if ( flags & VSF_SIZE ) {
		s->size.w = rect.right - rect.left;
		s->size.h = rect.bottom - rect.top;
		flags &= ~VSF_SIZE;
	}
	if ( flags & VSF_POSITION ) {
		s->position.x = rect.left;
		s->position.y = rect.top;
		flags &= ~VSF_POSITION;
	}
	release_app_lock(al_stk);
	err.subcode1 = flags;
	VExError err2 = VObject::get_status(s,flags);
	if ( err2.code )
		err = merge_VExError_vstatus_type(err,err2);
	
	V_OP_END
	return err;
}

VExError
VWindow::set_status(const VObjectStatus *s, int flags)
{
	if ( flags & VSF_OSDEP ) {
	VWINDOW_OSDEP * dp;
	CWindow *win = (CWindow*)((LWindowHeader *)info)->GetSuperView();
		dp = (VWINDOW_OSDEP*)s->osdep;
		switch ( dp->type ) {
		case OSDEP_VWINDOW_PUSH_PORT:
			win->push_port(dp);
			break;
		case OSDEP_VWINDOW_POP_PORT:
			win->pop_port(dp);
			break;
		default:
			er_panic("VSF_OSDEP");
		}
		return initial_VExError(V_ER_NO_ERR,flags,0);
	}
	V_OP_START_EX
	VExError err = initial_VExError(V_ER_NO_ERR,flags,0);
	CWindow *win = (CWindow*)((LWindowHeader *)info)->GetSuperView();
	if ( flags & VSF_ATTR ) {
		int al_stk = get_app_lock();
		if ( s->attr & resizable )
			win->SetAttribute(windAttr_Resizable | windAttr_SizeBox | windAttr_Zoomable);
		else
			win->ClearAttribute(windAttr_Resizable | windAttr_SizeBox | windAttr_Zoomable);
		if ( s->attr & modal )
			win->SetAttribute(windAttr_Modal);
		else
			win->ClearAttribute(windAttr_Modal);
		if ( s->attr & floating )
			win->SetAttribute(windAttr_Floating);
		else
			win->ClearAttribute(windAttr_Floating);
		if ( ! (s->attr & modal) && ! (s->attr & floating) )
			win->SetAttribute(windAttr_Regular);
		else
			win->ClearAttribute(windAttr_Regular);
		err.subcode1 &= ~VSF_ATTR;
		release_app_lock(al_stk);
	}
	if ( flags & VSF_DESC ) {
		if ( s->descriptor ) {
/*
			LStr255 str(n_string(std_cm, const_cast<L_CHAR*>(s->descriptor)));
*/
			LStr255 str;
			c2pstrcpy(str, s->descriptor ? get_mac_string((L_CHAR*)s->descriptor) : "");

			int al_stk = get_app_lock();
			win->SetDescriptor(str);
			release_app_lock(al_stk);
		}
		else {
			int al_stk = get_app_lock();
			win->SetDescriptor("\p");
			release_app_lock(al_stk);
		}
		int al_stk = get_app_lock();
		VCustomizedMenuBarImp::update_window_menu();
		LCommander::SetUpdateCommandStatus(true);
		release_app_lock(al_stk);
		err.subcode1 &= ~VSF_DESC;
	}
	if ( flags & VSF_VERTD ) {
		err.subcode1 &= ~VSF_VERTD;
	}
	if ( flags & VSF_ENABLED ) {
		int al_stk = get_app_lock();
		if ( s->enabled )
			win->Enable();
		else
			win->Disable();
		release_app_lock(al_stk);
		err.subcode1 &= ~VSF_ENABLED;
	}
	if ( flags & VSF_MIN_SIZE ) {
		short w = V_WINDOW_MIN_WIDTH, h = V_WINDOW_MIN_HEIGHT;
		if ( s->min_size.w != V_DEFAULT_SIZE )
			w = s->min_size.w;
		if ( s->min_size.h != V_DEFAULT_SIZE )
			h = s->min_size.h;
		if ( w < V_WINDOW_MIN_WIDTH )
			w = V_WINDOW_MIN_WIDTH;
		if ( h < V_WINDOW_MIN_HEIGHT )
			h = V_WINDOW_MIN_HEIGHT;
		int al_stk = get_app_lock();
		win->SetMinMaxSize((Rect){h, w, length_Big, length_Big});
		win->SetStandardSize((SDimension16){w, h});
		release_app_lock(al_stk);
		err.subcode1 &= ~VSF_MIN_SIZE;
	}
	if ( flags & VSF_SIZE ) {
		SDimension16 frame, new_frame;
		win->GetFrameSize(frame);
		if ( s->size.w == V_DEFAULT_SIZE && s->size.h == V_DEFAULT_SIZE ) {
			new_frame.width = sts.min_size.w;
			new_frame.height = sts.min_size.h;
		}
		else {
			new_frame.width = s->size.w;
			new_frame.height = s->size.h;
		}
		int al_stk = get_app_lock();
		if ( frame.width != new_frame.width || frame.height != new_frame.height )
			win->ResizeWindowTo(new_frame.width, new_frame.height);
		release_app_lock(al_stk);
		err.subcode1 &= ~VSF_SIZE;
	}
	if ( flags & VSF_POSITION ) {
		int al_stk = get_app_lock();
		win->MoveWindowTo(s->position.x, s->position.y);
		release_app_lock(al_stk);
		err.subcode1 &= ~VSF_POSITION;
	}

	VExError err2 = VObject::set_status(s,flags);
	if ( err2.code )
		err = merge_VExError_vstatus_type(err,err2);

	if ( flags & VSF_CALC_MIN ) {
		if ( sts.children )
			sts.children->object->set_status(0, VSF_CALC_MIN);
		VLayout layout;
		layout.layout_in_frame(this, true);
		sts.min_size = layout.parent_min_size();
		int al_stk = get_app_lock();
		if ( ! (sts.attr & resizable) )
			win->ResizeWindowTo(sts.min_size.w, sts.min_size.h);
		release_app_lock(al_stk);
		err.subcode1 &= ~VSF_CALC_MIN;
	}
	if ( flags & VSF_LAYOUT ) {
		VLayout layout;
		layout.layout_in_frame(this);
		layout.do_layout(this);
		err.subcode1 &= ~VSF_LAYOUT;
	}

	if ( flags & VSF_VISIBLE ) {
		if ( s->visible ) {
			sts.visible = true;
			VLayout::mark(this);
			VLayout::layout_marked_window();
			int al_stk = get_app_lock();
			win->Show();
			release_app_lock(al_stk);
		}
		else {
			int al_stk = get_app_lock();
			win->Hide();
			release_app_lock(al_stk);
		}
		err.subcode1 &= ~VSF_VISIBLE;
	}
	V_OP_END

	if ( flags & ( VSF_PADDING | VSF_ALIGN ) ) {
		VLayout::mark(this);
		err.subcode1 &= ~( VSF_PADDING | VSF_ALIGN );
	}
	return err;
}

bool
VWindow::attempt_close()
{
	if ( window_close_handler == 0 ) {
		return true;
	}	
	vq_insert_callback_machine(this,window_close_handler,user_arg,0,0,0,0);
	return false;
}


void
VWindow::redraw(VRect* rect) const
{
	if ( ! info )
		return;
	_V_OP_START()
	int al_stk = get_app_lock();
	if ( rect )
		info->RefreshRect((Rect){rect->t, rect->l, rect->b, rect->r});
	else
		info->Refresh();
	release_app_lock(al_stk);
	V_OP_END
}


VExError
VWindow::add_child_do(VObject* child)
{
	VLayout layout;	// calc min size
	layout.layout_in_frame(this, true);
	return initial_VExError(V_ER_NO_ERR,0,0);
}

void
VWindow::remove_child_do(VObject* child)
{
	// do nothing
}

void
VWindow::child_status_changed(VObject* child, VInfo* info)
{
	// do nothing - object is marked when status is changed
}

void
VWindow::_refresh_menu_bar()
{
VCustomizedMenuBar * m,*m2;

//	VCustomizedMenuBarImp::switch_to_menu(menu_no_window, true);
	CWindow *win = (CWindow*)((LWindowHeader *)info)->GetSuperView();
	if ( win == 0 )
		return;

	VCustomizedMenuBar::menu_lock(1,__FILE__,__LINE__);
	m = win->get_menu_bar();
	win->set_menu_bar(0);
	m2 = VCustomizedMenuBar::create(category, this);
	if ( m )
		m2->refrect_information(m);
	win->set_menu_bar(m2);
	VCustomizedMenuBarImp::switch_to_menu(m2, !((LWindow*)info)->HasAttribute(windAttr_Modal));

	if ( m )
{ss_printf("delete menu bar 2\n");
		delete m;
}
	VCustomizedMenuBar::menu_unlock(__FILE__,__LINE__);

}

void
VWindow::refresh_menu_bar(int c)
{
VWindow * win;
	lock_task(v_zonbie_lock);
	for ( win = window_list ; ; ) {
		if ( win->category != c )
			goto next;
		win->_refresh_menu_bar();
	next:
		win = win->wlist_next;
		if ( win == window_list )
			break;
	}
	unlock_task(v_zonbie_lock, "v_zonbie_insert");
}


void 
VWindow::insert_window_list() {
	lock_task(v_zonbie_lock);
	if ( window_list == 0 ) {
		wlist_next = wlist_prev = this;
		window_list = this;
	}
	else {
		wlist_next = window_list;
		wlist_prev = window_list->wlist_prev;
		wlist_next->wlist_prev = this;
		wlist_prev->wlist_next = this;
	}
	unlock_task(v_zonbie_lock, "v_zonbie_insert");
}
void 
VWindow::delete_window_list() {
	lock_task(v_zonbie_lock);
	if ( window_list == this ) {
		window_list = window_list->wlist_next;
		if ( window_list == this ) {
			window_list = 0;
			unlock_task(v_zonbie_lock, "v_zonbie_insert");
			return;
		}
	}
	wlist_next->wlist_prev = wlist_prev;
	wlist_prev->wlist_next = wlist_next;
	unlock_task(v_zonbie_lock, "v_zonbie_insert");
}

typedef struct __win_dialog_save1_t {
	NavDialogRef	outDialog;
	OSStatus	st;
} __WIN_DIALOG_SAVE1_T;

void
_v_win_dialog_save1(void * arg)
{
__WIN_DIALOG_SAVE1_T * d;
	d = (__WIN_DIALOG_SAVE1_T*)arg;
	d->st = NavDialogRun(d->outDialog);
}

void
VWindow::win_dialog(DIALOG_IO * io)
{

	if ( strcmp(io->type,"modal-select-save-file") == 0 ) {
	OSStatus st;
	NavDialogCreationOptions inOptions;
	OSType inFileType,inFileCreator;
	NavEventUPP inEventProc;
	void * inClientData;
	NavDialogRef outDialog = 0;
	NavReplyRecord outReply;
	int length,i;
	UniChar uchar;
	char * ret;
	FSRef parentDirectory;
	L_CHAR * path,* filename;
	int path_len,filename_len;
	int al_stk;
	
		memset(&inOptions,0,sizeof(inOptions));
		inOptions.version = kNavDialogCreationOptionsVersion;
		inOptions.optionFlags = kNavDefaultNavDlogOptions;
		inOptions.location.h = 100;
		inOptions.location.v = 100;
	/*
		c2pstrcpy(inOptions.clientName,"TEST");
		c2pstrcpy(inOptions.windowTitle,"TEST-SAVE");
		c2pstrcpy(inOptions.actionButtonLabel,"Action");
		c2pstrcpy(inOptions.cancelButtonLabel,"Cancel");
	*/
		inOptions.modality = kWindowModalityAppModal;
		
		al_stk = get_app_lock();
		st = NavCreatePutFileDialog (
				&inOptions,
				'TEXT',
				'APPL',
				0,
				0,
				&outDialog
			);
		release_app_lock(al_stk);
/*
		st = NavDialogRun (outDialog);
*/
		__WIN_DIALOG_SAVE1_T nav;
		nav.outDialog = outDialog;
		nav.st = 0;
		lthread_do(_v_win_dialog_save1,(void*)&nav,1,0,1);
		
		memset(&outReply,0,sizeof(outReply));
		
		al_stk = get_app_lock();
		st = NavDialogGetReply(outDialog,&outReply);
		release_app_lock(al_stk);
	
		if ( outReply.validRecord ) {
			int al_stk = get_app_lock();
			io->ret = DIO_OK;
			length = CFStringGetLength(outReply.saveFileName);
			filename = (L_CHAR*)d_alloc(sizeof(L_CHAR)*(length+1));
			for (i=0; i < length; i++) {
				uchar = CFStringGetCharacterAtIndex(outReply.saveFileName, i);
				filename[i] = ((L_CHAR)uchar)&0x0ffff;
			}
			filename[length] = 0;

			AEGetNthPtr(&(outReply.selection), 1, typeFSRef, NULL, NULL, &parentDirectory, sizeof(FSRef), NULL);
			ret = (char*)d_alloc(1024);
			FSRefMakePath(&parentDirectory, (UInt8*)ret, 1024);
			path = nl_copy_str(&utf8_cm,ret);
			path_len = l_strlen(path);
			filename_len = l_strlen(filename);
			path = (L_CHAR*)d_re_alloc(path,sizeof(L_CHAR)*(path_len+filename_len+2));
			path[path_len] = '/';
			l_strcpy(&path[path_len+1],filename);
			d_f_ree(filename);
			io->ret_msg[0] = path;
			release_app_lock(al_stk);
		}
		else {
			io->ret = DIO_ERR;
		}

		al_stk = get_app_lock();
		NavDisposeReply(&outReply);
		NavDialogDispose(outDialog);
		release_app_lock(al_stk);
		return;
	}
	else if ( strcmp(io->type,"modal-select-open-file") == 0 ) {
	char * filename;
		if ( io->msg[1] == 0 )
			filename = v_choose_file(io->msg[0],0);
		else	filename = v_choose_file(io->msg[0],mac_string(0,io->msg[1]));
		if ( filename == 0 )
			io->ret = DIO_ERR;
		else {
			io->ret = DIO_OK;
			io->ret_msg[0] = nl_copy_str(&utf8_cm,filename);
			d_f_ree(filename);
		}
		return;
	}
	else	v_modal_dialog(io);
}


