/**********************************************************************
 
	Copyright (C) 2003-2004
	Hirohisa MORI <joshua@nichibun.ac.jp>
	Tomoki SEKIYAMA <sekiyama@yahoo.co.jp>
 
	This program is free software; you can redistribute it 
	and/or modify it under the terms of the GLOBALBASE 
	Library General Public License (G-LGPL) as published by 

	http://www.globalbase.org/
 
	This program is distributed in the hope that it will be 
	useful, but WITHOUT ANY WARRANTY; without even the 
	implied warranty of MERCHANTABILITY or FITNESS FOR A 
	PARTICULAR PURPOSE.

**********************************************************************/


#include "PP_Prefix.h"
#include "VApplication.h"
VApplication *theApp = nil;

#include "VMouseTracker.h"
#include "VLayoutAttachment.h"
#include "CWindowMenuAttachment.h"
#include "CClickCheckAttachment.h"

#include "v/VDisplay.h"
#include "v/VWindow.h"
#include "v/VChooseFile.h"
#include "v/VMenu.h"

#include <PP_DebugMacros.h>

#include <LGrowZone.h>
#include <URegistrar.h>
#include <UEnvironment.h>
#include <LMenuBar.h>
#include <LMenu.h>
#include <LClipboard.h>

#include <UAttachments.h>

#include <UStandardDialogs.h>
#if PP_StdDialogs_Option == PP_StdDialogs_Conditional
	#include <UConditionalDialogs.h>
#endif

#include <UControlRegistry.h>

#include <LDebugStream.h>

#include <LWindow.h>
#include <LDialogBox.h>
#include <LTabGroup.h>

#include <Appearance.h>

#include <UThread.h>
#include <LCleanupTask.h>

#include "CColorView.h"
#include "CColorViewImp.h"

#include "CDataBrowser.h"
#include "CDataBrowserImp.h"

extern "C" {
#include "init.h"
#include "long_char.h"
#include "stream.h"
#include "task.h"
#include "utils.h"
#include "machine/v_types.h"
#include "memory_debug.h"
#include "lock_level.h"
#include "pri_level.h"

void SetSleepTime(UInt32 inSleepTime);
void DisplayAlert(char *msg);
void QuitApplication();
void call__main();
}

#include "CYieldRepeater.h"

CYieldRepeater *sCYieldRepeater = nil;
UInt32 CYieldRepeater::curTick;
bool CYieldRepeatersExitLoop = false;
bool *CYieldRepeater::sExitLoop = &CYieldRepeatersExitLoop;
int CYieldRepeater::sGetMouseEvent = 0;
LThread *CYieldRepeater::sGoBack = 0;
long free_mem_size;

bool CClickCheckAttachment::sClickHandled = 0;

void(*v_open_file_callback)(const char*) = NULL;
int intermediate_run_thread_standby;
int lthread_main_wait;
HTID lthread_agent_htid;
extern int lthread_agent_tid;
extern int intermediate_thread_id;

// ===========================================================================
//		 Utility Routine
// ===========================================================================

extern "C" {

void
SetSleepTime(UInt32 inSleepTime)
{
	theApp->SetSleepTime(inSleepTime==0 ? 0 : appBusyLv ? 2 : 12);
}

void
DisplayAlert(char *msg)
{
	Str255 pmsg;
	c2pstrcpy(pmsg, msg);
	::ParamText(pmsg,"\p","\p","\p");
	::StopAlert(ALRT_Msg, nil);
}

/*
void DeleteAllServerMaster();
*/

Boolean atQuitApp_flag = 0;

void
QuitApplication()
{
	if ( atQuitApp_flag )
		return;
	printf("QuitApplication...\n");
	if ( theApp->GetState() != programState_Quitting )
		theApp->DoQuit();
	if ( LThread::GetCurrentThread() != LThread::GetMainThread() )
			// switch to main thread (main thread will dispose every thread)
		LThread::Yield(LThread::GetMainThread());	
	else {
			// clean up every thing here (i.e. main thread) and continue exit
/*
		DeleteAllServerMaster();
*/
		LCleanupTask::CleanUpAtExit();
	}
}


} // extern "C"

// ===========================================================================
//	 main
// ===========================================================================

int main_thread_id;

int
main()
{
#if __MACH__
	int fd = open("/tmp/COSMOS.log", O_CREAT | O_WRONLY, 0666);
	ftruncate(fd, 0);
	dup2(fd, 1);
	dup2(fd, 2);
	close(fd);
#endif
	main_thread_id = (int)pthread_self();
	UDebugging::SetDebugThrow(debugAction_Nothing);
	UDebugging::SetDebugSignal(debugAction_Nothing);

		// Normal initializations
	InitializeHeap(5);
	UQDGlobals::InitializeToolbox();
	UEnvironment::InitEnvironment();
	
	LThread::Initialize();

		// Install a GrowZone to catch low-memory situations	
	LGrowZone* theGZ = new LGrowZone(20000);

	atexit(QuitApplication);

    if ( UEnvironment::IsRunningOSX() ) {
            Gestalt(gestaltPhysicalRAMSize, &free_mem_size);
            free_mem_size -= (512<<20)*(1.0-exp(-free_mem_size/float(784<<20)));
    } else {
            free_mem_size = FreeMem()-(10<<20);
    }
	theApp = new VApplication;
	theApp->Run();
	
		// Make sure async tasks get cleaned up. This call is VERY IMPORTANT.
	atQuitApp_flag = 1;
/*
	DeleteAllServerMaster();
*/
	LCleanupTask::CleanUpAtExit();
	
	return 0;
}



// ---------------------------------------------------------------------------
//	 VApplication									[public]
// ---------------------------------------------------------------------------
//	Application object constructor


SEM app_lock;
extern void (*thread_init_func)(int);

void VApplication::_thread_init()
{
int	pos;
unsigned int pos_addr;
	pos_addr = (unsigned int)&pos;
	if ( bottom_of_main < pos_addr )
		bottom_of_main = pos_addr;
}

extern "C"
void thread_of_init(int d)
{
	if ( theApp == 0 )
		return;
	theApp->_thread_init();
}

int VApplication::_inMain()
{
int pos;
unsigned int pos_addr;
	pos_addr = (unsigned int)&pos;
	if ( bottom_of_main < pos_addr &&
			pos_addr < top_of_main )
		return 1;
	return 0;
}

extern "C"
int inMain()
{
	if ( main_thread_id == (int)pthread_self() )
		return 1;
	return 0;
	return theApp->_inMain();
}

extern "C" 
int lock_check(SEM s,int panic_flag)
{
HTID tid;
	if ( inMain() )
		return 0;
	tid = _get_tid();
	if ( (cmp_htid(s.so->d_sem->tid,tid) && cmp_htid(lthread_agent_htid,tid)) || s.so->d_sem->value ) {
		if ( panic_flag )
			er_panic("application lock_check");
		return -1;
	}
	return 0;
}

extern "C"
int get_app_lock()
{
int ret;
	ret = lock_check(app_lock,0);
	if ( ret < 0 )
		lock_task(app_lock);
	return ret;
}

extern "C"
void release_app_lock(int stk)
{
	if ( stk < 0 )
		unlock_task(app_lock,"");
}

extern "C" void
xx_vq_insert_callback_mac(
		VObject *object,
		V_CALLBACK(handler),
		void *usr_arg,
		void *sys_arg,
		int sys_arg_size,
		char * skey,
		int * inherit,
		char *f,int l)
{
	if ( theApp == 0 )
		return;
	if ( inMain() )
		theApp->xx_vq_insert_callback_inner(
			object,
			handler,
			usr_arg,
			sys_arg,
			sys_arg_size,
			skey,
			inherit,
			f,l);
	else
		xx_vq_insert_callback(
			object,
			handler,
			usr_arg,
			sys_arg,
			sys_arg_size,
			skey,
			f,l);
	return;
}

void
VApplication::xx_vq_insert_callback_inner(
		VObject *object,
		V_CALLBACK(handler),
		void *usr_arg,
		void *sys_arg,
		int sys_arg_size,
		char * sequence_key,
		int * inherit,
		char * __f,
		int __l)
{
VQueEventHandler * arg;
char buf[20];
L_CHAR * p;
int len;
int i;
	arg = (VQueEventHandler*)malloc(sizeof(*arg));
	memset(&arg->h,0,sizeof(arg->h));

	arg->object = object;
	arg->handler = handler;
	arg->usr_arg = usr_arg;
	arg->sys_arg_size = sys_arg_size;
	if ( sys_arg_size ) {
		arg->sys_arg = malloc(sys_arg_size);
		memcpy(arg->sys_arg,sys_arg,sys_arg_size);
	}
	else {
		arg->sys_arg = 0;
	}
	
	arg->__file = __f;
	arg->__line = __l;
/*
if ( object )
ss_printf(">>>> %s %i (%i)\n",__f,__l,object->get_type());
else
ss_printf(">>>> %s %i (0)\n",__f,__l);
*/
	if ( sequence_key ) {
		len = strlen(sequence_key);
		arg->h.key = (L_CHAR*)malloc(len+1);
		strcpy((char*)arg->h.key,sequence_key);
	}
	else {
		sprintf(buf,"key%p",object);
		len = strlen(buf);
		arg->h.key = (L_CHAR*)malloc(len+1);
		strcpy((char*)arg->h.key,buf);
	}
	arg->h.next = 0;
	if ( inherit ) {
		if ( vq_inherit )
			er_panic("xx_vq_insert_queue_inner");
		vq_inherit = arg;
		vq_inherit_point = inherit;
	}
	else if ( vq_head ) {
		vq_tail->h.next = (Q_HEADER*)arg;
		vq_tail = arg;
	}
	else {
		vq_tail = vq_head = arg;
	}
}

VQueEventHandler *
VApplication::vq_delete_callback_inner()
{
VQueEventHandler * ret;
	if ( vq_head ) {
		ret = vq_head;
		vq_head = (VQueEventHandler*)ret->h.next;
		if ( vq_head == 0 )
			vq_tail = 0;
	}
	else {
		ret = 0;
	}
	return ret;
}

void
VApplication::free_VQueEventHandler(VQueEventHandler* arg)
{
	if ( arg->sys_arg )
		free(arg->sys_arg);
	if ( arg->h.key )
		free(arg->h.key);
	free(arg);
}

void
VApplication::relay_que()
{
VQueEventHandler* arg;

	for ( ; ; ) {
		arg = vq_delete_callback_inner();
		if ( arg == 0 )
			break;
		xx_vq_insert_callback(
			arg->object,
			arg->handler,
			arg->usr_arg,
			arg->sys_arg,
			arg->sys_arg_size,
			(char*)arg->h.key,
			arg->__file,
			arg->__line);
		free_VQueEventHandler(arg);
	}
}

void
VApplication::relay_que_inherit()
{
VQueEventHandler * arg;
int * inherit_point;
	inherit_point = vq_inherit_point;
	arg = vq_inherit;
	vq_inherit = 0;
	vq_inherit_point = 0;
	if ( arg == 0 )
		return;
	VCustomizedMenuBar::menu_lock(1,__FILE__,__LINE__);
	*inherit_point = VCustomizedMenuBar::menu_lock_inheritance_from();
	xx_vq_insert_callback(
		arg->object,
		arg->handler,
		arg->usr_arg,
		arg->sys_arg,
		arg->sys_arg_size,
		(char*)arg->h.key,
		arg->__file,
		arg->__line);
	free_VQueEventHandler(arg);
}



void
VApplication::lthread_grue(LThread &thread,void * data)
{
LTHREAD_DATA * ld;

	ld = (LTHREAD_DATA*)data;

	(ld->func)(ld->arg);
	if ( ld->wait_flag ) {
		ld->end_flag = 1;
	}
	else {
		free(ld);
	}

}

void
VApplication::lthread_grue_pthread(TKEY d)
{
LTHREAD_DATA * ld;


	ld = (LTHREAD_DATA*)GET_TKEY(d);
	
	if ( ld->lthread == 0 ) {
		lthread_agent_htid = _get_tid();
		lthread_agent_tid = get_tid();
	}
	(ld->func)(ld->arg);
	if ( ld->wait_flag ) {
		ld->end_flag = 1;
	}
	else {
		free(ld);
	}
	
	if ( ld->lthread == 0 ) {
		lthread_agent_htid = invalid_htid();
		lthread_agent_tid = 0;
	}
}

extern "C" void lthread_do(void (*func)(void*),void * arg,int wait_flag,int insert_flag,int lthread_flag)
{
LTHREAD_DATA ld;
LTHREAD_DATA * ld2;
LThread * t;

	ld.arg = arg;
	ld.func = func;
	ld.arg = arg;
	ld.end_flag = 0;
	ld.lthread = lthread_flag;
	if ( inMain() == 1 ) {
		if ( wait_flag ) {
			ld.wait_flag = 1;
			lthread_main_wait = 1;
			theApp->insert_lthread(&ld,0);
			for ( ; ld.end_flag == 0 ; )
				LThread::Yield();
			lthread_main_wait = 0;
		}
		else {
			ld.wait_flag = 0;
			ld2 = (LTHREAD_DATA*)malloc(sizeof(*ld2));
			*ld2 = ld;
			theApp->insert_lthread(ld2,insert_flag);
		}
	}
	else if ( lthread_flag == 0 ) {
		(*func)(arg);
	}
	else if ( wait_flag ) {
		ld.wait_flag = 1;
		int al_stk = get_app_lock();
		theApp->insert_lthread(&ld,insert_flag);
		if ( insert_flag == 0 ) {
			release_app_lock(al_stk);
			for ( ; ld.end_flag == 0 ; )
				usleep(10000);
		}
		else {
			for( ; ld.end_flag == 0 ; ) {
				sleep_task((int)&ld,app_lock);
				int al_stk = get_app_lock();
			}
			release_app_lock(al_stk);
		}
	}
	else {
		ld.wait_flag = 0;
		ld2 = (LTHREAD_DATA*)malloc(sizeof(*ld2));
		*ld2 = ld;
		int al_stk = get_app_lock();
		theApp->insert_lthread(ld2,insert_flag);
		release_app_lock(al_stk);
	}
}


char lthread_routine_wait;

void
VApplication::insert_lthread(LTHREAD_DATA * ld,int insert_flag)
{
	if ( insert_flag == 0 ) {
		ld->next = 0;
		if ( ld_head == 0 )
			ld_head = ld_tail = ld;
		else {
			ld_tail->next = ld;
			ld_tail = ld;
		}
	}
	else {
		ld->next = 0;
		if ( ldr_head == 0 )
			ldr_head = ldr_tail = ld;
		else {
			ldr_tail->next = ld;
			ldr_tail = ld;
		}
		wakeup_task((int)&lthread_routine_wait);
	}
}


void
VApplication::lthread_run()
{
LTHREAD_DATA * ld;
LThread * t;
	if ( ld_head == 0 )
		return;
	ld = ld_head;
	ld_head = ld->next;
	if ( ld_head == 0 )
		ld_tail = 0;
	if ( ld->lthread ) {
		t = new LSimpleThread(VApplication::lthread_grue, (void *)ld);
		t->SetPriority(5);
		t->Resume();
	}
	else {
		create_task(lthread_grue_pthread,(int)ld,PRI_FETCH);
	}
}

void
VApplication::intermediate_run_thread(LThread &,void*d)
{
	theApp->_intermediate_run_thread();
}

void
VApplication::tick_loop()
{
	for ( ; ; ) {
		usleep(10000);
		int al_stk = get_app_lock();
		lthread_routine_wait = 1;
		wakeup_task((int)&lthread_routine_wait);
		release_app_lock(al_stk);
	}
}

void
VApplication::lthread_routine()
{
LTHREAD_DATA * ld;
	for ( ; ldr_head ; ) {
		ld = ldr_head;
		ldr_head = ld->next;
		if ( ldr_head == 0 )
			ldr_tail = 0;
		unlock_task(app_lock,"");
		(ld->func)(ld->arg);
		lock_task(app_lock);
		if ( ld->wait_flag ) {
			ld->end_flag = 1;
			wakeup_task((int)ld);
		}
		else {
			free(ld);
		}
	}
}

void
VApplication::_intermediate_run_thread()
{
extern SEM _menu_lock;
	StartUp2();
	
	app_lock = new_lock(LL_APP);
	set_trace_bit(app_lock);
	intermediate_thread_id = get_tid();

	call__main();
	
	for ( ; ; ) {
		if ( _menu_lock.so == 0 )
			goto loop;
		break;
	loop:
		usleep(10000);
	}

	thread_of_init(0);
	create_task((void(*)(TKEY))tick_loop,5,0);
	intermediate_run_thread_standby = 1;
	for ( ; ; ) {
		if ( VCustomizedMenuBar::menu_lock(0,__FILE__,__LINE__) < 0 ) {
			lock_task(app_lock);
			if ( mState != programState_ProcessingEvents )
				break;
			lthread_run();

			if ( mState != programState_ProcessingEvents )
				break;

			unlock_task(app_lock,"");
		}
		else {
			lock_task(app_lock);
			if ( mState != programState_ProcessingEvents )
				break;
		retry2:
			lthread_run();

			LThread::Yield();

			if ( lthread_main_wait == 1 )
				goto retry2;

			if ( mState != programState_ProcessingEvents )
				break;

			unlock_task(app_lock,"");
			
			relay_que_inherit();
			VCustomizedMenuBar::menu_unlock(__FILE__,__LINE__);
		}
		relay_que();
/*
		usleep(10000);
*/
		lock_task(app_lock);
		
		if ( ldr_head ) {
		retry:
			lthread_routine();
		}
		sleep_task((int)&lthread_routine_wait,app_lock);
		lock_task(app_lock);
		if ( lthread_routine_wait == 0 ) {
			if ( ldr_head )
				goto retry;
		}
		lthread_routine_wait = 0;
		unlock_task(app_lock,"");
	}
	unlock_task(app_lock,"");
	VCustomizedMenuBar::menu_unlock(__FILE__,__LINE__);
}


VApplication::VApplication()
{
int pos;
unsigned int pos_addr;
	vq_head = vq_tail = 0;
	vq_inherit = 0;
	vq_inherit_point = 0;
	
	pos_addr = (unsigned int)&pos;
	top_of_main = pos_addr;
	bottom_of_main = 0;
	thread_init_func = thread_of_init;
	
	ld_head = ld_tail = 0;
	ldr_head = ldr_tail = 0;

		// Register ourselves with the Appearance Manager
	if (UEnvironment::HasFeature(env_HasAppearance)) {
		::RegisterAppearanceClient();
	}

	RegisterClasses();
	
		// Preload facilities for the Standard Dialogs
	PP_StandardDialogs::Load();
	
		// Require at least Navigation Services 1.1. See comments
		// above SetTryNavServices in UConditionalDialogs.cp for why
		// you might wish to do this.
#if PP_StdDialogs_Option == PP_StdDialogs_Conditional
	UConditionalDialogs::SetTryNavServices(0x01108000);
#endif

	AddAttachment(new LClipboard);
	AddAttachment(new VLayoutAttachment);
	AddAttachment(new CWindowMenuAttachment);
	AddAttachment(new CClickCheckAttachment);
	
	sCYieldRepeater = new CYieldRepeater(thTicksYield);
	VMouseTracker* mt = new VMouseTracker;
	mt->StartRepeating();
}


// ---------------------------------------------------------------------------
//	 ~VApplication									[public, virtual]
// ---------------------------------------------------------------------------
//	Application object destructor

VApplication::~VApplication()
{
	VDisplay::get_main_display()->destroy();

		// Clean up after Standard Dialogs
	PP_StandardDialogs::Unload();
}


// ---------------------------------------------------------------------------
//	 StartUp										[protected, virtual]
// ---------------------------------------------------------------------------
//	Perform an action in response to the Open Application AppleEvent.
//	Here, issue the New command to open a window.

extern "C" {
void check_endian();
void init_msequence();
void check_endian();
void init_longchar();
void init_utils();
void init_netutils();
void init_event();
void init_resolve();
void init_wct();
void init_blacklist();
int _main(int,char**);
char *get_path_from_mac_fs_alloc(FSSpec inMacFSSpec, Boolean isFolder);
bool v_startup_flag = false;
}




V_CALLBACK_D(DoPreferences_handler)
{
	void v_setup_menu_choosed();
	v_setup_menu_choosed();
}


void
VApplication::DoPreferences()
{

	void v_setup_menu_choosed();
	v_setup_menu_choosed();

//	vq_insert_/callback_machine(0,DoPreferences_handler,0,0,0,0,0);
}

void
VApplication::StartUp()
{
LThread * t;
	t = new LSimpleThread(VApplication::intermediate_run_thread, (void *)0);
	t->SetPriority(5);
	t->Resume();
/*
	semlock_mode = SLM_NORMAL;
	v_startup_flag = true;
	check_endian();
	init_task(INI_DONTWAITCHI);
	init_msequence();
	check_endian();
	init_tick();
	init_d_alloc();
	init_longchar();
	init_wct();
	init_stream();
	init_utils();
	init_netutils();
	init_resolve();
	call__main();
*/
}


void
VApplication::StartUp2()
{
	semlock_mode = SLM_NORMAL;
	v_startup_flag = true;
	check_endian();
	init_task(INI_DONTWAITCHI);
	init_msequence();
	check_endian();
	init_tick();
	init_d_alloc();
	init_longchar();
	init_wct();
	init_stream();
	init_utils();
	init_netutils();
	init_resolve();
/*
	call__main();
*/
}



// ---------------------------------------------------------------------------
//	 DoReopenApp									[protected, virtual]
// ---------------------------------------------------------------------------
//	Support the Finder's "re-open application" ('rapp') Apple Event. From
//	Apple TechNote 1102 (on Mac OS 8):
//
//		The Finder now sends a 're-open application' Apple event ('rapp') to
//		applications when the application is already running and it is opened
//		from one of the Finder's windows (either by a double click or by
//		selecting the application and choosing the Open command). Applications
//		receiving a 'rapp' event (when they do not have any windows open) should
//		open a new untitled document just as they would when processing an 'oapp'
//		event.

void
VApplication::DoReopenApp()
{
	
}


// ---------------------------------------------------------------------------
//	 ObeyCommand									[public, virtual]
// ---------------------------------------------------------------------------
//	Respond to Commands. Returns true if the Command was handled, false if not.

Boolean
VApplication::ObeyCommand(
	CommandT	inCommand,
	void*		ioParam)
{
	Boolean		cmdHandled = true;	// Assume we'll handle the command
	extern VCustomizedMenuBar *menu_no_window;

	switch (inCommand) {
	  case cmd_About:
		void v_about_menu_choosed();
		v_about_menu_choosed();
		break;
	
	  default:
		if ( menu_no_window && inCommand < 0 && 
				menu_no_window->menu_choosed(inCommand) )
			cmdHandled = true;
		else
			cmdHandled = LApplication::ObeyCommand(inCommand, ioParam);
		break;
	}
	
	return cmdHandled;
}





// ---------------------------------------------------------------------------
//	 FindCommandStatus								[public, virtual]
// ---------------------------------------------------------------------------
//	Determine the status of a Command for the purposes of menu updating.

void
VApplication::FindCommandStatus(
	CommandT	inCommand,
	Boolean&	outEnabled,
	Boolean&	outUsesMark,
	UInt16&		outMark,
	Str255		outName)
{
	extern bool MenuFlag_about;
	extern bool MenuFlag_setup;
	extern VCustomizedMenuBar *menu_no_window;
	
	switch (inCommand) {
	  case cmd_About:
		outEnabled = MenuFlag_about;
		break;

	  case cmd_Preferences:
		outEnabled = MenuFlag_setup;
		break;

	  default:
		short flag;
		if ( menu_no_window && inCommand < 0 &&
				menu_no_window->get_menu_flag(inCommand, &flag) ) {
			outEnabled = flag & VMF_ENABLED;
			outUsesMark = flag & VMF_CHECKED;
			if ( outUsesMark )
				outMark = checkMark;
		}
		else
			LApplication::FindCommandStatus(inCommand, outEnabled,
											outUsesMark, outMark, outName);
		break;
	}

}


// ---------------------------------------------------------------------------
//	 AttemptQuitSelf
// ---------------------------------------------------------------------------

extern "C" int vobject_quit();

Boolean
VApplication::AttemptQuitSelf(
	SInt32	/* inSaveOption */)
{

	if ( mState != programState_Quitting )
		return vobject_quit();
	return true;
}


// ---------------------------------------------------------------------------
//	 RegisterClasses								[protected]
// ---------------------------------------------------------------------------
//	To reduce clutter within the Application object's constructor, class
//	registrations appear here in this seperate function for ease of use.

void
VApplication::RegisterClasses()
{

		// Register core PowerPlant classes.
	RegisterClass_(LWindow);

	RegisterClassID_( CColorViewImp,	CColorView::imp_class_ID );
	RegisterClassID_( CDataBrowserImp,	CDataBrowser::imp_class_ID );

		// Register the Appearance Manager/GA classes. You may want
		// to remove this use of UControlRegistry and instead perform
		// a "manual" registration of the classes. This cuts down on
		// extra code being linked in and streamlines your app and
		// project. However, use UControlRegistry as a reference/index
		// for your work, and ensure to check UControlRegistry against
		// your registrations each PowerPlant release in case
		// any mappings might have changed.
		
	UControlRegistry::RegisterClasses();

}


// ---------------------------------------------------------------------------
//	 OpenDocument								  [public]
// ---------------------------------------------------------------------------
//	Open a Document specified by an FSSpec

extern bool v_startup_flag;
extern "C" void call_ipc_system(const char *path);


void
VApplication::OpenDocument(
	FSSpec*	inMacFSSpec)
{

	if ( v_startup_flag == false )
		VApplication::StartUp();
	char * path = get_path_from_mac_fs_alloc(*inMacFSSpec,false);
	call_ipc_system(path);
	free(path);
}


// ---------------------------------------------------------------------------
//	 ChooseDocument								[protected, virtual]
// ---------------------------------------------------------------------------
void
VApplication::ChooseDocument()
{
	PP_StandardDialogs::LFileChooser	chooser;
	
		// Open any/all TEXT files
	
	NavDialogOptions*	options = chooser.GetDialogOptions();
	if (options != nil) {
		options->dialogOptionFlags =	kNavDefaultNavDlogOptions
										+ kNavSelectAllReadableItem;
	}

	if (chooser.AskOpenFile(LFileTypeList(ResType_Text))) {
		AEDescList		docList;
		chooser.GetFileDescList(docList);
		SendAEOpenDocList(docList);
	}
}
