/**********************************************************************
 
	Copyright (C) 2003 Hirohisa MORI <joshua@nichibun.ac.jp>
		Atsushi MURAMATSU <muramatsu@s-cradle.com>
 
	This program is free software; you can redistribute it 
	and/or modify it under the terms of the GLOBALBASE 
	Library General Public License (G-LGPL) as published by 

	http://www.globalbase.org/
 
	This program is distributed in the hope that it will be 
	useful, but WITHOUT ANY WARRANTY; without even the 
	implied warranty of MERCHANTABILITY or FITNESS FOR A 
	PARTICULAR PURPOSE.

**********************************************************************/


#include	<stdlib.h>
#include	<errno.h>
#include	"memory_debug.h"
#include	"task.h"
#include	"lock_level.h"
#include	"utils.h"
#include	"pri_level.h"


#define SW_HASH_SIZE	99

D_SEM sw_lock;


SW_HASH * hash[SW_HASH_SIZE];


void
sw_init()
{
	sw_lock = xx_new_lock(LL_SLEEP_WAKEUP,__FILE__,__LINE__);
}

void
t_sleep_task(unsigned int key,D_SEM s,int pri_flag)
{
unsigned int kk;
SW_HASH * h;
int pri;
	kk = key%SW_HASH_SIZE;
	if ( pri_flag && (semlock_mode == SLM_REALTIME)  )
		pri = push_pri(PRI_SLEEP_WAIT);
	_lock_task(sw_lock,__FILE__,__LINE__);
	for ( h = hash[kk]; h ; h = h->next )
		if ( h->key == key ) {
			h->cnt ++;
			_unlock_task(sw_lock,"sleep_task(1)",__FILE__,__LINE__);
			goto last;
		}

	h = new_block();
	h->key = key;
	h->cnt = 1;
	sem_init(&h->sem,0,1);
	sem_trywait(&h->sem);

	h->next = hash[kk];
	hash[kk] = h;
	_unlock_task(sw_lock,"sleep_task(3)",__FILE__,__LINE__);
last:
	if ( s )
		_unlock_task(s,"sleep_task(4)",__FILE__,__LINE__);
retry1:
	errno = 0;
	if ( sem_wait(&h->sem) ) {
		switch ( errno ) {
		case EINTR:
			goto retry1;
		case EAGAIN:
			sleep_sec(1);
			goto retry1;
		default:
			er_panic("sem_wait");
		}
	}
	_lock_task(sw_lock,__FILE__,__LINE__);
	h->cnt --;
	if ( h->cnt == 0 ) {
		sem_destroy(&h->sem);
		free_block(h);
	}
	_unlock_task(sw_lock,"sleep_task(5)",__FILE__,__LINE__);
	if ( pri_flag && (semlock_mode == SLM_REALTIME)  )
		change_pri(0,pri);
	return;
}


void
t_wakeup_task(unsigned int key,int pri_flag)
{
unsigned int kk;
int i;
SW_HASH * h, ** hp;
int pri;
	kk = key%SW_HASH_SIZE;
	if ( pri_flag && (semlock_mode == SLM_REALTIME)  )
		pri = push_pri(PRI_SLEEP_WAIT);
	_lock_task(sw_lock,__FILE__,__LINE__);
	for ( hp = &hash[kk] ; *hp ; hp = &(*hp)->next )
		if ( (*hp)->key == key )
			goto next;
	_unlock_task(sw_lock,"wakeup_task(1)",__FILE__,__LINE__);
	return;
next:
	h = *hp;
	*hp = h->next;
	for ( i = h->cnt ; i ; i -- )
		for ( ; sem_post(&h->sem); );
	_unlock_task(sw_lock,"wakeup_task(2)",__FILE__,__LINE__);
	if ( pri_flag && (semlock_mode == SLM_REALTIME)  )
		change_pri(0,pri);
}

void
_sleep_task(unsigned int key,D_SEM s,char * file,int line)
{
	t_sleep_task(key,s,1);
}

void
_wakeup_task(unsigned int key,char * file,int line)
{
	t_wakeup_task(key,1);
}

void
send_sw_trigger(unsigned int key)
{
}
