/**********************************************************************
 
	Copyright (C) 2003 Hirohisa MORI <joshua@nichibun.ac.jp>
 
	This program is free software; you can redistribute it 
	and/or modify it under the terms of the GLOBALBASE 
	Library General Public License (G-LGPL) as published by 

	http://www.globalbase.org/
 
	This program is distributed in the hope that it will be 
	useful, but WITHOUT ANY WARRANTY; without even the 
	implied warranty of MERCHANTABILITY or FITNESS FOR A 
	PARTICULAR PURPOSE.

**********************************************************************/
#include "machine/gb_windows.h"

int for_each_file(char *path, int (*func)(char *)){
WIN32_FIND_DATA fd;
char pszFilter[MAX_PATH+1];
char pszFullPath[MAX_PATH+1];
HANDLE hFind;
int ret = 1;

	wsprintf(pszFilter, "%s*.*", path);
	hFind = FindFirstFile(pszFilter, &fd);
	if(!hFind)
		return 0;
	while(FindNextFile(hFind, &fd)){
		if(*(fd.cFileName) == '.'){
			continue;
		}
		wsprintf(pszFullPath, "%s%s", path, fd.cFileName);
		if(fd.dwFileAttributes & FILE_ATTRIBUTE_DIRECTORY){
			continue;
		}
		
		if(!func(pszFullPath))
			ret = 0;
	}
	FindClose(hFind);
	return ret;
}

