/**********************************************************************
 
	Copyright (C) 2007 Hirohisa MORI <joshua@globalbase.org>
 
	This program is free software; you can redistribute it 
	and/or modify it under the terms of the GLOBALBASE 
	Library General Public License (G-LGPL) as published by 

	http://www.globalbase.org/
 
	This program is distributed in the hope that it will be 
	useful, but WITHOUT ANY WARRANTY; without even the 
	implied warranty of MERCHANTABILITY or FITNESS FOR A 
	PARTICULAR PURPOSE.

**********************************************************************/

#include	"change_endian.h"
#include	"memory_debug.h"
#include	"recordlist64.h"
#include	"matrix.h"
#include	"pg_vector.h"
#include	"xlerror.h"
#include	"xl_zlib.h"
#include	"mx_format.h"
#include	"memory_routine.h"

/*
	(mxPgPlotField opt-list FieldData)
	FieldData:
		Depend to field type
	RETURN
		opt-list : ptr
*/



XL_SEXP*
gb_gmxPgPlotField(XLISP_ENV * env,XL_SEXP * s,XLISP_ENV* a,XL_SYM_FIELD * sf);

void
init_gmxPgPlotField(XLISP_ENV * env0,XLISP_ENV * env1)
{
	set_env(env1,l_string(std_cm,"gmxPgPlotField"),
		get_func_prim(gb_gmxPgPlotField,FO_APPLICATIVE,0,1,-1));
}


XL_SEXP*
gb_gmxPgPlotField(XLISP_ENV * env,XL_SEXP * s,XLISP_ENV* a,XL_SYM_FIELD * sf)
{
XL_SEXP * opt_list;
FD_OPT * opt,** op;
FD_OPT_PTR * ptr;
char * err_msg;
L_CHAR * id;
L_CHAR * dim;
L_CHAR * merge_type;
L_CHAR * csv_label;
L_CHAR * label;
int d;
L_CHAR * cp;
int _ret;
MX_ENTRY * e;
XL_SEXP * ret;
	if ( list_length(s) == 1 ) {
		ptr = mmalloc(sizeof(*ptr),gc_fd_opt_ptr);
		memset(ptr,0,sizeof(*ptr));
		id = get_sf_attribute(sf,l_string(std_cm,"id"));
		err_msg = "id required";
		if ( id == 0 )
			goto inv_param;
		e = search_mx_entry_by_id(atoi(n_string(std_cm,id)));
		err_msg = "invalid id";
		if ( e == 0 )
			goto inv_param;
		ptr->m = e->c.m;
		return get_ptr((void*)ptr,gc_fd_opt_ptr);
	}
	opt_list = get_el(s,1);
	switch ( get_type(opt_list) ) {
	case XLT_PTR:
		ptr = opt_list->ptr.ptr;
		break;
	default:
		err_msg = "opt_list";
		goto type_missmatch;
	}

	opt = mmalloc(sizeof(*opt),gc_fd_opt);
	memset(opt,0,sizeof(*opt));
	opt->h.dim = -1;
	opt->h.target_label = -1;
	dim = get_sf_attribute(sf,l_string(std_cm,"dim"));
	if ( dim )
		opt->h.dim = atoi(n_string(std_cm,dim));
	label = get_sf_attribute(sf,l_string(std_cm,"label"));
	if ( label )
		opt->h.target_label = atoi(n_string(std_cm,label));
	merge_type = get_sf_attribute(sf,l_string(std_cm,"merge-type"));
	if ( merge_type )
		opt->h.merge_type = atoi(n_string(std_cm,merge_type));
	csv_label = get_sf_attribute(sf,l_string(std_cm,"csv"));
	if ( csv_label == 0 )
		opt->h.csv_label = -1;
	else {
		d = 0;
		for ( cp = csv_label ; *cp ; cp++ ) {
			d *= 'Z'-'A';
			if ( 'A' <= *cp && *cp <= 'Z' )
				d += (*cp)-'A';
			else if ( 'a' <= *cp && *cp <= 'z' )
				d += (*cp)-'a';
			else {
				d = atoi(n_string(std_cm,csv_label));
				break;
			}
		}
		opt->h.csv_label = d;
	}
	_ret = (*field_type_tbl[opt->h.merge_type>>CH_TYPE_SHIFT].initial)
		(0,cdr(cdr(s)),opt,0);
	err_msg = "initialize";
	if ( _ret < 0 )
		goto inv_param_error;
	if ( list_length(s) == 3 ) {
		opt->h.init_sexp = get_el(s,2);
	}
	for ( op = &ptr->opt ; *op ; op = &(*op)->h.next )
		if ( opt->h.csv_label < (*op)->h.csv_label )
			break;
	opt->h.next = *op;
	*op = opt;
	if ( ptr->last_label < opt->h.target_label )
		ptr->last_label = opt->h.target_label;
	return get_ptr((void*)ptr,gc_fd_opt_ptr);
/*
error:
	ret = get_error(
		s->h.file,
		s->h.line,
		_ret,
		l_string(std_cm,"mxPgPlotSort"),
		List(n_get_string("type missmatch or others"),n_get_string(err_msg),-1));
	return ret;
*/
type_missmatch:
	ret = get_error(
		s->h.file,
		s->h.line,
		XLE_SEMANTICS_TYPE_MISSMATCH,
		l_string(std_cm,"gmxPgPlotField"),
		List(n_get_string("type missmatch"),n_get_string(err_msg),-1));
	return ret;
inv_param:
	ret = get_error(
		s->h.file,
		s->h.line,
		XLE_PROTO_INV_PARAM,
		l_string(std_cm,"gmxPgPlotField"),
		List(n_get_string("invalid parameter in gmxPgPlotField"),n_get_string(err_msg),-1));
	return ret;
inv_param_error:
	ret = get_error(
		s->h.file,
		s->h.line,
		XLE_PROTO_INV_PARAM,
		l_string(std_cm,"gmxPgPlotField"),
		List(n_get_string("invalid parameter in gmxPgPlotField"),n_get_string(err_msg),get_integer(_ret,0),-1));
	return ret;
}
