/**********************************************************************
 
	Copyright (C) 2003 Hirohisa MORI <joshua@nichibun.ac.jp>
 
	This program is free software; you can redistribute it 
	and/or modify it under the terms of the GLOBALBASE 
	Library General Public License (G-LGPL) as published by 

	http://www.globalbase.org/
 
	This program is distributed in the hope that it will be 
	useful, but WITHOUT ANY WARRANTY; without even the 
	implied warranty of MERCHANTABILITY or FITNESS FOR A 
	PARTICULAR PURPOSE.

**********************************************************************/


#include	"fcntl.h"
#include	<stdlib.h>
#include	"gbview.h"
#include	"xlerror.h"
#include	"win_flame.h"


XL_SEXP *
gv_goto_point(XLISP_ENV * e,XL_SEXP * s,
	XLISP_ENV * a,XL_SYM_FIELD * sf)
{
XL_SEXP * url;
XL_SEXP * ptr;
XL_SEXP * reso;
XL_SEXP * rotate;
GB_POINT pp;
REAL1 res,rot;
int er;
GBVIEW_FLAME * gf;
L_CHAR * gf_id;

printf("** get_goto_point **\n");
	gf_id = get_sf_attribute(sf,l_string(std_cm,"flame-id"));
	if ( gf_id ) {
		gf = wf_get_gf_from_id(atoi(n_string(std_cm,gf_id)));
	}
	else 	gf = 0;
	if ( gf == 0 )
		gf = wf_next_gf(0,GVFM_LIVE);
	url = eval(e,get_el(s,1));
	switch ( get_type(url) ) {
	case XLT_ERROR:
		return url;
	case XLT_STRING:
		break;
	default:
		goto typemissmatch;
	}
	ptr = eval(e,get_el(s,2));
	switch ( get_type(ptr) ) {
	case XLT_ERROR:
		return ptr;
	case XLT_PAIR:
		if ( list_length(ptr) != 2 )
			goto typemissmatch;
		if ( get_gbpoint(0,&pp,ptr) < 0 )
			goto typemissmatch;
		break;
	default:
		goto typemissmatch;
	}
	rotate = eval(e,get_el(s,3));
	switch ( get_type(rotate) ) {
	case XLT_ERROR:
		return ptr;
	case XLT_INTEGER:
		rot = rotate->integer.data;
		break;
	case XLT_FLOAT:
		rot = rotate->floating.data;
		break;
	default:
		goto typemissmatch;
	}
	reso = eval(e,get_el(s,4));
	switch ( get_type(reso) ) {
	case XLT_ERROR:
		return ptr;
	case XLT_INTEGER:
		res = conv_unit(
			&er,
			get_uenv(e),
			reso->integer.data,
			reso->integer.unit,
			l_string(std_cm,"dot/m"));
		break;
	case XLT_FLOAT:
		res = conv_unit(
			&er,
			get_uenv(e),
			reso->floating.data,
			reso->floating.unit,
			l_string(std_cm,"dot/m"));
		break;
	default:
		goto typemissmatch;
	}
	wf_goto_point(	
		gf,
		url->string.data,
		pp,
		rot,
		res,
		0);
	return 0;
typemissmatch:
	return get_error(
		s->h.file,
		s->h.line,
		XLE_SEMANTICS_TYPE_MISSMATCH,
		l_string(std_cm,"goto-point"),
		list(	n_get_string(
		"type missmatch"),
			0));
}

void
init_gv_goto_point(XLISP_ENV * env)
{
	set_env(env,
		l_string(std_cm,"gv-goto-point"),
		get_func_prim(gv_goto_point,FO_NORMAL,0,5,5));
}
