/**********************************************************************
 
	Copyright (C) 2007 Hirohisa MORI <joshua@globalbase.org>
 
	This program is free software; you can redistribute it 
	and/or modify it under the terms of the GLOBALBASE 
	Library General Public License (G-LGPL) as published by 

	http://www.globalbase.org/
 
	This program is distributed in the hope that it will be 
	useful, but WITHOUT ANY WARRANTY; without even the 
	implied warranty of MERCHANTABILITY or FITNESS FOR A 
	PARTICULAR PURPOSE.

**********************************************************************/

#include	<stdlib.h>
#include	"memory_debug.h"
#include	"memory_routine.h"
#include	"xlerror.h"
#include	"xl.h"
#include	"utils.h"
#include	"gbview.h"
#include	"win_flame.h"
#include	"lock_level.h"

#include	"mx_format.h"
#include	"pg_vector.h"

/*
#define PGV_DEBUG
*/


#define PDB_RESO	1
#define POINT_MIN_DIRECTION_STEP	4
#define ARG_CACHE_LIST_LEN		1000
#define STRING_RECT_OFFSET		1
#define STRING_ALL_PRINT		5

int
setup_view_methods(RESOURCE * res,MATRIX_NODE * n,VIEW_METHOD_TBL ** vmt,VIEW_METHOD ** vm);

/*********************************************************
	PLOT DRAW
**********************************************************/

extern SEM res_lock;

int
vmt_create_plot(VIEW_METHOD*,MATRIX_NODE*);
void
vmt_draw_plot(VIEW_METHOD*,GBVIEW_FLAME*,RESOURCE *,DRAW_WORK*);

static int div_list[] = {-2,-2};

VIEW_METHOD_TBL vm_plot_tbl = {
	MDT_BLOCK,
	2,div_list,&blk_pp_tbl,
	vmt_create_plot,
	0,
	vmt_draw_plot,
	0
};


typedef struct vm_default_values {
	L_CHAR *		logo;
	int			align;
	I_POINT			offset;
	int			t_color;
	
	int			logo_field;
	int			halign_field;
	int			valign_field;
	int			t_color_field;

} VM_DEFAULT_VALUES;


typedef struct vm_arg_cache {
	struct vm_arg_cache *	next;
	struct vm_arg_cache *	prev;
	AVT_NODE *		me;
	INTEGER64		obj_id;
	MATRIX_SEXP *		onmap;
	MATRIX_SEXP *		card;
} VM_ARG_CACHE;

typedef struct vm_plot {
	VM_WORK_HEADER		h;
	int			default_color;
	L_CHAR *		default_anchor;

	VM_DEFAULT_VALUES *	default_logo;
	int			default_logo_len;

	int			color_field;
	int			anchor_field;

	INFO_SCHEME *		ischeme;
	MATRIX_SEXP *		ind_convert;
	
	int *			arg_cache;
	int			arg_cache_len;
	int			arg_cache_max;
	AVT_NODE *		arg_cache_tree;
	int			arg_cache_tree_cnt;
	
	VM_ARG_CACHE *		arg_cache_list_head;
	int			arg_cache_cnt;
	
	int			direct_onmap_field;
	int			direct_onmap_ref_field;
	L_CHAR *		direct_onmap_ref_field_str;
	int			direct_onmap_fontcolor;
} VM_PLOT;

typedef struct vm_pg_data {
	VM_PLOT *		vmp;
	IP_FIELD *		fd;
} VM_PG_DATA;

extern SEM luster_lock,tc_lock;
XL_SEXP *
xl_pg_vector_mark(XLISP_ENV * env,XL_SEXP * s,XLISP_ENV * a,XL_SYM_FIELD * sf);
XL_SEXP *
xl_pg_vector_information(XLISP_ENV * env,XL_SEXP * s,XLISP_ENV * a,XL_SYM_FIELD * sf);
XL_SEXP *
xl_pg_vector_format(XLISP_ENV * env,XL_SEXP * s,XLISP_ENV * a,XL_SYM_FIELD * sf);
XL_SEXP *
xl_pg_cache(XLISP_ENV * env,XL_SEXP * s,XLISP_ENV * a,XL_SYM_FIELD * sf);
XL_SEXP *
xl_pg_Arg(XLISP_ENV * env,XL_SEXP * s,XLISP_ENV * a,XL_SYM_FIELD * sf);
XL_SEXP *
xl_pg_information(XLISP_ENV * env,XL_SEXP * s,XLISP_ENV * a,XL_SYM_FIELD * sf);
XL_SEXP *
xl_set_scheme(XLISP_ENV * env,XL_SEXP * s,
	XLISP_ENV * a,XL_SYM_FIELD * sf);
XLISP_ENV * pgv_runtime_env;

void
init_pg_vector(XLISP_ENV * env)
{
XLISP_ENV * pgv_env;
XLISP_ENV * run_env;

	pgv_env = new_env(env);
	root_tag(env,l_string(std_cm,"pg-vector"),pgv_env);
	set_env(pgv_env,l_string(std_cm,"mark"),
		get_func_prim(xl_pg_vector_mark,
			FO_APPLICATIVE,0,1,1));
	set_env(pgv_env,l_string(std_cm,"format"),
		get_func_prim(xl_pg_vector_format,
			FO_NORMAL,0,2,2));
	set_env(pgv_env,l_string(std_cm,"cache"),
		get_func_prim(xl_pg_cache,
			FO_APPLICATIVE,0,1,1));
	set_env(pgv_env,l_string(std_cm,"set-scheme"),
		get_func_prim(xl_set_scheme,
			FO_APPLICATIVE,0,1,1));
	pgv_runtime_env = run_env = new_env(pgv_env);
	set_env(pgv_env,l_string(std_cm,".run"),get_env(run_env));
	set_env(run_env,l_string(std_cm,"Arg"),
		get_func_prim(xl_pg_Arg,
			FO_APPLICATIVE,0,2,3));
	set_env(run_env,l_string(std_cm,"information"),
		get_func_prim(xl_pg_information,
			FO_NORMAL,0,2,-1));


}

void
vmp_initialize(VM_PLOT * vmp)
{
//VM_PLOT * vmp;
//	vmp = (VM_PLOT*)get_vm_work_header(r,&vm_plot_tbl,sizeof(*vmp));
	if ( vmp->h.flags & VMWF_NOT_INITIALIZE ) {
		vmp->color_field = -1;
		vmp->default_color = 0xffffff00;
		vmp->direct_onmap_field = -1;
		vmp->direct_onmap_ref_field = -1;
		vmp->direct_onmap_ref_field_str = 0;
		vmp->direct_onmap_fontcolor = 0;
		vmp->h.flags &= ~VMWF_NOT_INITIALIZE;
	}
}


XL_SEXP *
xl_pg_Arg(XLISP_ENV * env,XL_SEXP * s,XLISP_ENV * a,XL_SYM_FIELD * sf)
{
IP_FIELD * fd,*fdp;
int _id;
XL_SEXP * id;
FIELD_RGBA_T * rgba;
unsigned int d;
int i;
VM_PG_DATA * dd;
char * e_msg;
XL_SEXP * e_sexp;
	e_msg = "";
	e_sexp = 0;
	dd = get_env_work(env);
	if ( dd == 0 ) {
		return get_error(
			s->h.file,
			s->h.line,
			XLE_SEMANTICS_TYPE_MISSMATCH,
			l_string(std_cm,"pg-vector/Arg"),
			List(n_get_string("fd env work"),
				-1));
	}
	fd = dd->fd;
	id = get_el(s,1);
	e_sexp = id;
	e_msg = "Arg-id";
	if ( get_type(id) != XLT_INTEGER )
		goto type_missmatch;
	_id = id->integer.data;
	e_sexp = id;
	e_msg = "id field type";
	if ( _id < 0 )
		goto nothing;
	if ( _id >= fd[0].len )
		goto nothing;
	fdp = &fd[_id];
	switch ( fdp->type ) {
	case CH_STRING:
		return get_string(l_string(&utf8_cm,fdp->d.str));
	case CH_STRING_ERASE:
		return get_string(l_string(std_cm,""));
	case CH_INT_ADD:
	case CH_INT_AVG:
	case CH_INT_MAX:
	case CH_INT_MIN:
		return get_integer(fdp->d.i[0],0);
	case CH_RGBA:
		rgba = fdp->d.rgba;
		d = 0;
		for ( i = 0 ; i < 4 ; i ++ ) {
			d = d<<8;
			d += rgba->rgba[i];
		}
		return get_integer(d,0);
	default:
		e_msg = "field type";
		e_sexp = get_integer(fdp->type,0);
	nothing:
		if ( list_length(s) == 2 )
			goto type_missmatch;
		return get_el(s,2);
	}
	return 0;
/*
inv_param:
	return get_error(
		s->h.file,
		s->h.line,
		XLE_PROTO_INV_PARAM,
		l_string(std_cm,"pg-vector/Arg"),
		List(n_get_string("invalid parameter"),
			-1));
*/
type_missmatch:
	return get_error(
		s->h.file,
		s->h.line,
		XLE_SEMANTICS_TYPE_MISSMATCH,
		l_string(std_cm,"pg-vector/Arg"),
		List(n_get_string("type missmatch"),
			n_get_string(e_msg),
			e_sexp,
			-1));
}


XL_SEXP *
xl_pg_information(XLISP_ENV * env,XL_SEXP * s,XLISP_ENV * a,XL_SYM_FIELD * sf)
{
L_CHAR * type;
	type = get_sf_attribute(sf,l_string(std_cm,"type"));
	return gb_quote_trace(env,s,type);
}



XL_SEXP *
xl_pg_cache(XLISP_ENV * env,XL_SEXP * s,XLISP_ENV * a,XL_SYM_FIELD * sf)
{
L_CHAR * field;
int _field;
RESOURCE *r;
XL_SEXP * ret;
VM_PLOT * vmp;
	r = get_resource_ptr(&ret,env,s->h.file,s->h.line);
	if ( r == 0 )
		return ret;
	vmp = (VM_PLOT*)get_vm_work_header(r,&vm_plot_tbl,sizeof(*vmp));
	vmp_initialize(vmp);

	field = get_sf_attribute(sf,l_string(std_cm,"field"));
	if ( field == 0 )
		return 0;
	_field = atoi(n_string(std_cm,field));
	vmp->arg_cache = d_re_alloc(vmp->arg_cache,sizeof(int)*(vmp->arg_cache_len+1));
	vmp->arg_cache[vmp->arg_cache_len] = _field;
	vmp->arg_cache_len ++;
	if ( vmp->arg_cache_max < _field )
		vmp->arg_cache_max = _field;
	return 0;
}

XL_SEXP *
xl_pg_vector_mark(XLISP_ENV * env,XL_SEXP * s,XLISP_ENV * a,XL_SYM_FIELD * sf)
{
RESOURCE * r;
XL_SEXP * ret;
VM_PLOT * vmp;
L_CHAR * color;
L_CHAR * level;
int _level;
L_CHAR *img;
int _img;
L_CHAR * anchor;
L_CHAR * valign;
int _valign,__valign;
L_CHAR * halign;
int _halign,__halign;
L_CHAR * transparent;
int _transparent,__transparent;
int _align;
VM_DEFAULT_VALUES * vp;

char * e_param;
	r = get_resource_ptr(&ret,env,s->h.file,s->h.line);
	if ( r == 0 )
		return ret;
	vmp = (VM_PLOT*)get_vm_work_header(r,&vm_plot_tbl,sizeof(*vmp));
	vmp_initialize(vmp);

	color = get_sf_attribute(sf,l_string(std_cm,"color"));
	if ( color )
		sscanf(n_string(std_cm,color),"%i",&vmp->default_color);
	level = get_sf_attribute(sf,l_string(std_cm,"level"));
	if ( level ) {
		_level = atoi(n_string(std_cm,level));

		img  = get_sf_attribute(sf,l_string(std_cm,"img"));
		e_param = "attribute img is required";
		if ( img == 0 )
			goto inv_param;
		if ( img[0] == '#' )
			_img = atoi(n_string(std_cm,&img[1]));
		else	_img = -1;

		__valign = __halign = __transparent = _align = 0;

		valign  = get_sf_attribute(sf,l_string(std_cm,"valign"));
		if ( valign == 0 ) {
			_valign = -1;
			__valign = 0;
			_align |= AG_TB_CENTER;
		}
		else if ( valign[0] == '#' )
			_valign = atoi(n_string(std_cm,&valign[1]));
		else if ( l_strcmp(valign,l_string(std_cm,"top")) == 0 ) {
			_valign = -1;
			__valign = 0;
			_align |= AG_TB_TOP;
		}
		else if ( l_strcmp(valign,l_string(std_cm,"center")) == 0 ) {
			_valign = -1;
			__valign = 0;
			_align |= AG_TB_CENTER;
		}
		else if ( l_strcmp(valign,l_string(std_cm,"bottom")) == 0 ) {
			_valign = -1;
			__valign = 0;
			_align |= AG_TB_BOTTOM;
		}
		else {
			_valign = -1;
			__valign = atoi(n_string(std_cm,valign));
			_align |= AG_LR_VALUE;
		}
		
		halign  = get_sf_attribute(sf,l_string(std_cm,"halign"));
		if ( halign == 0 ) {
			_halign = -1;
			__halign = 0;
			_align |= AG_LR_CENTER;
		}
		else if ( halign[0] == '#' )
			_halign = atoi(n_string(std_cm,&halign[1]));
		else if ( l_strcmp(halign,l_string(std_cm,"left")) == 0 ) {
			_halign = -1;
			__halign = 0;
			_align |= AG_LR_LEFT;
		}
		else if ( l_strcmp(halign,l_string(std_cm,"center")) == 0 ) {
			_halign = -1;
			__halign = 0;
			_align |= AG_LR_CENTER;
		}
		else if ( l_strcmp(halign,l_string(std_cm,"right")) == 0 ) {
			_halign = -1;
			__halign = 0;
			_align |= AG_LR_RIGHT;
		}
		else {
			_halign = -1;
			__halign = atoi(n_string(std_cm,halign));
			_align |= AG_LR_VALUE;
		}

		transparent  = get_sf_attribute(sf,l_string(std_cm,"transparent"));
		if ( transparent == 0 ) {
			_transparent = -1;
			__transparent = -1;
		}
		else if ( transparent[0] == '#' )
			_transparent = atoi(n_string(std_cm,&transparent[1]));
		else {
			_transparent = -1;
			sscanf(n_string(std_cm,transparent),"%i",&__transparent);
		}
		
		if ( vmp->default_logo_len <= _level ) {
			vmp->default_logo = d_re_alloc(vmp->default_logo,
				(_level+1)*sizeof(VM_DEFAULT_VALUES));
			vmp->default_logo_len = _level+1;
		}
		vp = &vmp->default_logo[_level];
		if ( vp->logo )
			d_f_ree(vp->logo);
		vp->logo_field = _img;
		vp->logo = ll_copy_str(img);

		vp->align = _align;
		vp->offset.x = __halign;
		vp->offset.y = __valign;
		vp->valign_field = _valign;
		vp->halign_field = _halign;
		
		vp->t_color = _transparent;
		vp->t_color_field = __transparent;
	}
	anchor = get_sf_attribute(sf,l_string(std_cm,"anchor"));
	if ( anchor ) {
		if ( vmp->default_anchor )
			d_f_ree(vmp->default_anchor);
		vmp->default_anchor = 0;
		if ( anchor[0] == '#' )
			vmp->anchor_field = atoi(n_string(std_cm,&anchor[1]));
		else {
			vmp->anchor_field = -1;
			vmp->default_anchor = ll_copy_str(anchor);
		}
	}
	
	return 0;
inv_param:
	return get_error(
		s->h.file,
		s->h.line,
		XLE_PROTO_INV_PARAM,
		l_string(std_cm,"pg-vector/mark"),
		List(n_get_string("invalid parameter"),
			n_get_string(e_param),
			-1));
}

XL_SEXP *
xl_pg_vector_format(XLISP_ENV * env,XL_SEXP * s,XLISP_ENV * a,XL_SYM_FIELD * sf)
{
VM_PLOT * vmp;
RESOURCE * r;
XL_SEXP * ret;
L_CHAR * direct;

	r = get_resource_ptr(&ret,env,s->h.file,s->h.line);
	if ( r == 0 )
		return ret;
	vmp = (VM_PLOT*)get_vm_work_header(r,&vm_plot_tbl,sizeof(*vmp));
	vmp_initialize(vmp);
	direct = get_sf_attribute(sf,l_string(std_cm,"direct-onmap-field"));
	if ( direct )
		vmp->direct_onmap_field = atoi(n_string(std_cm,direct));
	direct = get_sf_attribute(sf,l_string(std_cm,"direct-onmap-ref"));
	if ( direct ) {
		if ( '0' <= direct[0] && direct[0] <= '9' )
			vmp->direct_onmap_ref_field = atoi(n_string(std_cm,direct));
		else {
			vmp->direct_onmap_ref_field_str = ll_copy_str(direct);
		}
	}
	direct = get_sf_attribute(sf,l_string(std_cm,"direct-onmap-fontcolor"));
	if ( direct ) {
		sscanf(n_string(std_cm,&direct[1]),"%x",&vmp->direct_onmap_fontcolor);
	}
	vmp->ind_convert = new_matrix_sexp(get_el(s,1));
	return 0;
}




XL_SEXP *
xl_set_scheme(XLISP_ENV * env,XL_SEXP * s,
	XLISP_ENV * a,XL_SYM_FIELD * sf)
{
L_CHAR * card, * onmap;
L_CHAR * scheme;
char * e_param;
int card_type,onmap_type;
RESOURCE * r;
XL_SEXP * ret;
L_CHAR * entry;
VM_PLOT * vmp;
	r = get_resource_ptr(&ret,env,s->h.file,s->h.line);
	if ( r == 0 )
		return ret;
	vmp = (VM_PLOT*)get_vm_work_header(r,&vm_plot_tbl,sizeof(*vmp));
	vmp_initialize(vmp);
	scheme = 0;
	card = 0;
	onmap = 0;
	card_type = SFT_XL;
	onmap_type = SFT_XL;
	for ( ; sf ; sf = sf->next ) {
		if ( l_strcmp(sf->name,l_string(std_cm,"scheme")) == 0 )
			scheme = sf->data;
		else if ( l_strcmp(sf->name,l_string(std_cm,"card")) == 0 )
			card = sf->data;
		else if ( l_strcmp(sf->name,l_string(std_cm,"onmap")) == 0 )
			onmap = sf->data;
		else if ( l_strcmp(sf->name,l_string(std_cm,"card.type"))
				== 0 ) {
			e_param = "card.type";
			if ( l_strcmp(sf->data,
				l_string(std_cm,"text/xl")) == 0 )
				card_type = SFT_XL;
			else if ( l_strcmp(sf->data,
				l_string(std_cm,"text/xsl")) == 0 )
				card_type = SFT_XSL;
			else goto type_missmatch;
		}
		else if ( l_strcmp(sf->name,l_string(std_cm,"onmap.type"))
				== 0 ) {
			e_param = "onmap.type";
			if ( l_strcmp(sf->data,
				l_string(std_cm,"text/xl")) == 0 )
				onmap_type = SFT_XL;
			else if ( l_strcmp(sf->data,
				l_string(std_cm,"text/xsl")) == 0 )
				onmap_type = SFT_XSL;
			else goto type_missmatch;
		}
	}
	if ( scheme == 0 ) {
		e_param = "scheme";
		goto attr_required;
	}
	if ( card == 0 ) {
		e_param = "card";
		goto attr_required;
	}
	if ( onmap == 0 ) {
		e_param = "onmap";
		goto attr_required;
	}
	entry = get_url_str2(&r->h.entry);
	card = compose_url(entry,card);
	onmap = compose_url(entry,onmap);
	if ( onmap == 0 ) {
		e_param = "onmap2";
		goto attr_required;
	}
	if ( card == 0 ) {
		e_param = "card2";
		goto attr_required;
	}
	insert_scheme(&vmp->ischeme,scheme,
		card_type,onmap_type,
		card,onmap);
	d_f_ree(onmap);
	d_f_ree(card);
	return 0;
attr_required:
	return get_error(
		s->h.file,
		s->h.line,
		XLE_PROTO_INV_PARAM,
		l_string(std_cm,"pg-vector/set-scheme"),
		List(n_get_string("attribute"),
			n_get_string(e_param),
			n_get_string("is required"),
			-1));
type_missmatch:
	return get_error(
		s->h.file,
		s->h.line,
		XLE_SEMANTICS_TYPE_MISSMATCH,
		l_string(std_cm,"pg-vector/set-scheme"),
		List(n_get_string("attribute"),
			n_get_string(e_param),
			n_get_string("type missmatch"),
			-1));
}

int
cmp_arg_cache(VM_ARG_CACHE * a1,VM_ARG_CACHE * a2)
{
	if ( a1->obj_id < a2->obj_id )
		return -1;
	if ( a1->obj_id > a2->obj_id )
		return 1;
	return 0;
}

void
delete_arg_cache(VM_PLOT * vmp,VM_ARG_CACHE * ac)
{
	if ( vmp->arg_cache_list_head == ac ) {
		vmp->arg_cache_list_head = ac->next;
		if ( vmp->arg_cache_list_head == ac ) {
			vmp->arg_cache_list_head = 0;
			goto end;
		}
	}
	ac->prev->next = ac->next;
	ac->next->prev = ac->prev;
end:
	vmp->arg_cache_cnt --;
}

void
insert_arg_cache(VM_PLOT * vmp,VM_ARG_CACHE * ac)
{
	if ( vmp->arg_cache_list_head == 0 ) {
		ac->next = ac->prev = ac;
		vmp->arg_cache_list_head = ac;
		vmp->arg_cache_cnt = 1;
	}
	else {
		ac->next = vmp->arg_cache_list_head;
		ac->prev = vmp->arg_cache_list_head->prev;
		ac->next->prev = ac;
		ac->prev->next = ac;
		vmp->arg_cache_list_head = ac;
		vmp->arg_cache_cnt ++;
	}
}


VM_ARG_CACHE *
get_arg_cache(VM_PLOT * vmp,INTERNAL_PLOT * pt)
{
AVT_NODE * at,*at2;
VM_ARG_CACHE * ac;
	ac = d_alloc(sizeof(*ac));
	memset(ac,0,sizeof(*ac));
	ac->obj_id = pt->id;
	at = d_alloc(sizeof(*at));
	ac->me = at;
	at->data = ac;
	at2 = avt_insert(&vmp->arg_cache_tree,at,cmp_arg_cache);
	if ( at2 != at ) {
		d_f_ree(ac);
		d_f_ree(at);
		delete_arg_cache(vmp,at2->data);
		insert_arg_cache(vmp,at2->data);
		return at2->data;
	}
	else {
		ac->onmap = 0;
		ac->card = 0;
		insert_arg_cache(vmp,ac);
		for ( ; vmp->arg_cache_cnt > ARG_CACHE_LIST_LEN ; ) {
			ac = vmp->arg_cache_list_head->prev;
			delete_arg_cache(vmp,ac);
			at2 = avt_delete(&vmp->arg_cache_tree,ac,cmp_arg_cache);
			if ( at2 != ac->me )
				er_panic("get_arg_cache");
			if ( ac->onmap )
				ac->onmap->del = 1;
			if ( ac->card )
				ac->card->del = 1;
			d_f_ree(ac->me);
			d_f_ree(ac);
		}
		return at->data;
	}
}

int
vmt_create_plot(VIEW_METHOD* vm,MATRIX_NODE* n)
{
VM_PLOT * vmp;
	vmp = (VM_PLOT*)_get_vm_work_header(vm->r,vm->tbl,sizeof(*vmp));
	vm->work = vmp;

	vmp_initialize(vmp);
	return 0;
}

void
set_search_parameter(MATRIX * m,INTEGER64 * start,INTEGER64 * end,INTEGER64 * inc,GB_RECT rct,int lev,int dim)
{
int i;
INTEGER64 mask;
	if ( rct.tl.x < 0 )
		rct.tl.x = 0;
	if ( rct.tl.y < 0 )
		rct.tl.y = 0;
	if ( rct.br.x >= m->pixel_size[0] )
		rct.br.x = m->pixel_size[0];
	if ( rct.br.y >= m->pixel_size[1] )
		rct.br.y = m->pixel_size[1];
	start[1] = rct.tl.x;
	if ( dim == 2 )
		start[2] = rct.tl.y;
	end[1] = ceil(rct.br.x);
	if ( dim == 2 )
		end[2] = ceil(rct.br.y);
	start[0] = end[0] = inc[0] = lev;
	for ( i = 3 ; i <= m->p.dim ; i ++ ) {
		start[i] = 0;
		end[i] = 0;
	}
	for ( i = 0 ; i < m->p.dim; i ++ ) {
		mask = (((INTEGER64)1)<<(m->dim_divide[i]*lev+m->block_size[i]));
		start[i+1] &= -mask;
		if ( i < 2 )
			inc[i+1] = mask;
		else	inc[i+1] = 0;
		end[i+1] = (end[i+1] & (-mask)) + mask;
	}
}

void
get_target_plot(
	INTERNAL_PLOT ***ip_list,
	GB_POINT **ip_pt_list,
	REAL1 ** ip_reso_list,
	char ** ip_flags_list,
	int *b_size,
	int *size,
	MATRIX_NODE * n,
	INTERNAL_PLOT *ip,
	GB_RECT rct,
	REAL1 dpm)
{
int i;
INTERNAL_PLOT * p1;
INTEGER64 * crd;
GB_POINT ptr;
	for (i = 0 , p1 = ip; p1 ; p1 = p1->next , i ++ );
	if ( *b_size < i ) {
		*ip_list = d_re_alloc(*ip_list,i*sizeof(INTERNAL_PLOT*));
		*ip_pt_list = d_re_alloc(*ip_pt_list,i*sizeof(GB_POINT));
		*ip_reso_list = d_re_alloc(*ip_reso_list,i*sizeof(REAL1));
		*ip_flags_list = d_re_alloc(*ip_flags_list,i);
		*b_size = i;
	}
//ss_printf("GTP %i %p\n",i,ip);
	i = 0;
	crd = d_alloc(sizeof(INTEGER64)*(n->matrix->p.dim+1));
	for ( p1 = ip ; p1 ; p1 = p1->next ) {
		get_plot_crd(crd,n->matrix,p1,n->dim_code[0]);
		ptr.x = (crd[1] + n->dim_code[1]);
		ptr.y = (crd[2] + n->dim_code[2]);
/*
ss_printf("GTP (%f %f)(%f %f) - (%f %f) - %i\n",
rct.tl.x,rct.tl.y,
rct.br.x,rct.br.y,
ptr.x,ptr.y,inside_rect(&rct,ptr));
*/
		if ( inside_rect(&rct,ptr) == 0 )
			continue;
		ptr.x /= dpm;
		ptr.y /= dpm;
		(*ip_list)[i] = p1;
		(*ip_pt_list)[i] = ptr;
		(*ip_reso_list)[i] = 1;
		i++;
	}
	*size = i;
}


int
get_logo_info(VM_PLOT * vmp,INTERNAL_PLOT * pt,int logo,L_CHAR ** url,int * align,I_POINT * ofs,int * t_color,L_CHAR ** anchor)
{
VM_DEFAULT_VALUES * vp;
FIELD_RGBA_T * rgba;
	if ( pt->fields == 0 )
		return -1;
	if ( vmp->default_logo_len <= logo )
		logo = vmp->default_logo_len - 1;
	for ( ; logo > 0 ; logo -- ) {
		if ( vmp->default_logo[logo].logo )
			break;
		if ( vmp->default_logo[logo].logo_field >= 0 )
			break;
	}
	if ( logo <= 0 )
		return -1;
	vp = &vmp->default_logo[logo];
	if ( vp->logo_field >= 0 ) {
		if ( pt->fields[0].len <= vp->logo_field )
			return -1;
		if ( pt->fields[vp->logo_field].type != CH_STRING )
			return -1;
		*url = nl_copy_str(&utf8_cm,pt->fields[vp->logo_field].d.str);
	}
	else {
		*url = ll_copy_str(vp->logo);
	}

	if ( vmp->anchor_field >= 0 ) {
		if ( pt->fields[0].len <= vmp->anchor_field )
			return -1;
		switch ( pt->fields[vmp->anchor_field].type ) {
		case CH_STRING:
			*anchor = nl_copy_str(&utf8_cm,pt->fields[vmp->anchor_field].d.str);
			if ( (*anchor)[0] == 0 ) {
				d_f_ree(*anchor);
				*anchor = 0;
			}
			break;
		case CH_NONE:
		case CH_STRING_ERASE:
			*anchor = 0;
			break;
		default:
			return -1;
		}
	}
	else if ( vmp->default_anchor ) {
		*anchor = ll_copy_str(vmp->default_anchor);
	}
	else {
		*anchor = 0;
	}

	*align = 0;
	if ( vp->halign_field >= 0 ) {
		if ( pt->fields[0].len <= vp->halign_field )
			return -1;
		switch ( pt->fields[vp->halign_field].type ) {
		case CH_STRING:
			if ( strcmp(pt->fields[vp->halign_field].d.str,"left") == 0 )
				*align |= AG_LR_LEFT;
			else if ( strcmp(pt->fields[vp->halign_field].d.str,"center") == 0 )
				*align |= AG_LR_CENTER;
			else if ( strcmp(pt->fields[vp->halign_field].d.str,"right") == 0 )
				*align |= AG_LR_RIGHT;
			else	return -1;
			ofs->x = -1;
			break;
		case CH_INT_ADD:
		case CH_INT_AVG:
		case CH_INT_MAX:
		case CH_INT_MIN:
			ofs->x = pt->fields[vp->halign_field].d.i[0];
			*align |= AG_LR_VALUE;
			break;
		default:
			return -1;
		}
	}
	else {
		*align |= vp->align &AG_LR_MASK;
		ofs->x = vp->offset.x;
	}
	if ( vp->valign_field >= 0 ) {
		if ( pt->fields[0].len <= vp->valign_field )
			return -1;
		switch ( pt->fields[vp->valign_field].type ) {
		case CH_STRING:
			if ( strcmp(pt->fields[vp->valign_field].d.str,"top") == 0 )
				*align |= AG_TB_TOP;
			else if ( strcmp(pt->fields[vp->halign_field].d.str,"center") == 0 )
				*align |= AG_TB_CENTER;
			else if ( strcmp(pt->fields[vp->halign_field].d.str,"bottom") == 0 )
				*align |= AG_TB_BOTTOM;
			else	return -1;
			ofs->y = -1;
			break;
		case CH_INT_ADD:
		case CH_INT_AVG:
		case CH_INT_MAX:
		case CH_INT_MIN:
			ofs->y = pt->fields[vp->valign_field].d.i[0];
			*align |= AG_TB_VALUE;
			break;
		default:
			return -1;
		}
	}
	else {
		*align |= vp->align &AG_TB_MASK;
		ofs->y = vp->offset.y;
	}
	if ( vp->t_color_field >= 0 ) {
		if ( pt->fields[0].len <= vp->t_color_field )
			return -1;
		if ( pt->fields[vp->valign_field].type != CH_RGBA )
			return -1;
		rgba = pt->fields[vp->t_color_field].d.rgba;
		if ( rgba->rgba[3] == 0xff )
			*t_color = -1;
		else	*t_color = (rgba->rgba[0]<<16)+(rgba->rgba[1]<<8)+rgba->rgba[2];
	}
	else {
		*t_color = vp->t_color;
	}
	return 0;
}


void
set_dont_print_flag(MATRIX * m,INTERNAL_PLOT ** ip_list,GB_POINT * pt_list,char * fp,int sz,GB_RECT r,GB_POINT ptr)
{
INTERNAL_PLOT * ip1;
//int max;
//GB_POINT pt;
int w,h,ofs;
//int len;

GB_POINT m_br,m_tl;

	m_br = p_add(ptr,p_sub(ptr,r.br));
	m_tl = p_add(ptr,p_sub(ptr,r.tl));
/*
ss_printf("RECT (%f %f) (%f %f) (%f %f) - (%f %f) ** (%f %f)\n",
m_br.x,m_br.y,
m_tl.x,m_tl.y,
r.tl.x,r.tl.y,
r.br.x,r.br.y,
ptr.x,ptr.y);
*/
	if ( m_tl.x > r.br.x )
		r.br.x = m_tl.x;
	if ( m_tl.y > r.br.y )
		r.br.y = m_tl.y;
	if ( m_br.x < r.tl.x )
		r.tl.x = m_br.x;
	if ( m_br.y < r.tl.y )
		r.tl.y = m_br.y;

	w = r.br.x - r.tl.x;
	h = r.br.y - r.tl.y;
	if ( w > h )
		ofs = h;
	else	ofs = w;

	r.br.x += ofs*STRING_RECT_OFFSET;
	r.br.y += ofs*STRING_RECT_OFFSET;
	r.tl.x -= ofs*STRING_RECT_OFFSET;
	r.tl.y -= ofs*STRING_RECT_OFFSET;
/*
ss_printf("RECT-2 (%f %f) - (%f %f) %p %i\n",
r.tl.x,r.tl.y,
r.br.x,r.br.y,
fp,sz);
*/
//ss_printf("set_dont_print_flag-1\n");
	ip1 = *ip_list;
	ip_list ++;
	fp ++;
	pt_list ++;
	sz --;
	for ( ; sz ; fp ++ , ip_list ++ , pt_list ++ , sz --) {
/*
		if ( (len=get_estimate_distance(m,ip1,*ip_list)) > 50 )
			break;
*/
//ss_printf("set_dont_print_flag-2\n");
		if ( inside_rect(&r,*pt_list) )
			*fp = 1;
	}
//ss_printf("set_dont_print_flag-3 %i\n",len);
}

void
vmt_draw_plot(VIEW_METHOD* vm,GBVIEW_FLAME* gf,RESOURCE * r,DRAW_WORK* dw)
{
GB_RECT rct;
GB_RECT * rp;
int rp_len;
int rr;
double reso,reso2;
int lev;

MATRIX * mtx;
MATRIX_NODE * n;
int div;
int i;
INTEGER64 * start,*end,*inc,*ix;
void *d;
INTERNAL_PLOT * ip;
INTERNAL_PLOT ** ip_list;
GB_POINT* ip_pt_list;
REAL1 * ip_reso_list;
char * ip_flags_list;
int b_size;
int size;
int err;

INTERNAL_PLOT ** ip_p;
GB_POINT * ptr_p;
REAL1 * reso_p;
char * flags_p;
int index;
unsigned int rgba;
FIELD_RGBA_T * rgba_p;
VM_PLOT * vmp;
int j;
int logo;
L_CHAR * logo_url;
int * data;
int w,h;
I_POINT logo_offset;
int logo_align;
int logo_t_color;
unsigned int * dt;
GB_RECT rect;
int x,y;

int width,height;
int _width,_height;
PIC pic;
PIC_ELEMENT * pe;
int sub;
GB_POINT ind_ptr;
L_CHAR * logo_anchor;
XL_SEXP * s;
VM_ARG_CACHE * ac;
XLISP_ENV * env;
REAL1 style_reso;
VM_PG_DATA dd;
int dsize;
int er_code;

	if ( dw->method == 0 )
		return; 
	if ( get_mov_flag(gf,dw->wfid) != 0 )
		return;
	dw->flags |= WFF_PLOT; 
	vmp = vm->work;
	mtx = r->h.mtx;
	if ( mtx == 0 ) {
		gv_new_luster_option(r,0);
		if ( r->h.mtx == 0 )
			return;
		mtx = r->h.mtx;
	}
	if ( mtx->flags & MXF_ERR_DETECTED ) {
			r->h.mtx = 0;
		close_matrix(mtx);
		gv_new_luster_option(r,0);
		if ( r->h.mtx == 0 )
			return;
	}
	div = ((int)1)<<mtx->dim_divide[0];
	
	ip_list = 0;
	ip_pt_list = 0;
	ip_reso_list = 0;
	b_size = 0;
	size = 0;

	start = d_alloc(sizeof(INTEGER64)*(r->h.mtx->p.dim+1));
	end = d_alloc(sizeof(INTEGER64)*(r->h.mtx->p.dim+1));
	inc = d_alloc(sizeof(INTEGER64)*(r->h.mtx->p.dim+1));
	ix = d_alloc(sizeof(INTEGER64)*(r->h.mtx->p.dim+1));

	ip_list = 0;
	ip_pt_list = 0;
	ip_reso_list = 0;
	ip_flags_list = 0;
	
	width = (dw->rectondisp->br.x - dw->rectondisp->tl.x);
	height = (dw->rectondisp->br.y - dw->rectondisp->tl.y);
	dsize = width * height;
	for ( i = 0 ; i < dsize ; i ++ )
		dw->pixels[i] = C_TRANSPARENT;

#ifdef PGV_DEBUG
ss_printf("=================== PG VECTOR\n");
#endif

	rp = get_surp_rect_rate(&rp_len,&dw->surp,0.1,0);
	for ( rr = 0 ; rr < rp_len ; rr ++ )  {
		if ( wf_active_check_2(gf,dw->wfid) < 0 )
{ss_printf("FREE=RETURN-DRAW\n");
			break;
}
		rct = rp[rr];

		dw->draw_rect = rct;
		dw->draw_lod = 0;

		dw->limit_reso = r->pr64.dpm;
		dw->limit_ptr = dw->pt_list[dw->size/2];
		r->h.loop_no ++;

		if ( dw->limit_reso != 0 &&
			r->h.limit_resolution != 0 &&
			dw->limit_reso > r->h.limit_resolution )
			dw->limit_reso = r->h.limit_resolution;
		dw->limit_ptr = p_add(rct.tl,rct.br);
		dw->limit_ptr.x /= 2;
		dw->limit_ptr.y /= 2;

		lev = 0;
		reso2 = r->pr64.dpm;
		reso = get_surp_reso(&dw->surp);

		if ( reso > reso2*LIMIT_RESOLUTION_RATE )
			goto end;

		for ( lev = 0; lev < mtx->total_levels ; lev ++, reso2 = reso2/div )
			if ( reso > reso2*PDB_RESO )
				break;
		if ( lev >= r->h.mtx->total_levels )
			goto end;
		r->h.loop_no ++;


		rct.tl.x *= r->pr64.dpm;
		rct.tl.y *= r->pr64.dpm;
		rct.br.x *= r->pr64.dpm;
		rct.br.y *= r->pr64.dpm;
		set_search_parameter(r->h.mtx,start,end,inc,rct,lev,r->h.mtx->p.dim);
		
		for ( i = 0 ; i <= r->h.mtx->p.dim ; i ++ )
			ix[i] = start[i];
		for ( ; ; ) {
			n = 0;
			if ( r->h.mtx->p.flags & MPF_NODE_DIPENDENT ) {
				d = get_matrix_node_channel
						(&err,&n,r->h.mtx,
						&ix[0],vm->view_channel[0],
						GN_TREE,GN_NODE_CREATE,0,r->h.loop_no);
			}
			else {
				d = get_matrix_node_channel
						(&err,&n,r->h.mtx,
						&ix[0],vm->view_channel[0],
						GN_TREE,GN_STEP_NODE_CREATE,0,r->h.loop_no);
			}
#ifdef PGV_DEBUG
ss_printf("PG PLOT CH %i = %p %p - LEVEL = %i\n",vm->view_channel[0],d,n,lev);
#endif
			if ( n == 0 ) 
				goto last;
			if ( d == 0 )
				goto next;
			(*n->channel[vm->view_channel[0]].sb->tbl->operation)(PPC_GET,
				n->channel[vm->view_channel[0]].sb,&ip);

#ifdef PGV_DEBUG
ss_printf("PG PLOT IP = %p\n",ip);
#endif

			get_target_plot(&ip_list,&ip_pt_list,&ip_reso_list,&ip_flags_list,&b_size,&size,n,ip,rct,r->pr64.dpm);
			map_conv_forward(dw->map->map_file,ip_pt_list,ip_reso_list,size);
			map_from_resource(dw->mh,ip_pt_list,ip_reso_list,size);
			
#ifdef PGV_DEBUG
ss_printf("PG PLOT size = %p\n",size);
#endif
			ip_p = ip_list;
			ptr_p = ip_pt_list;
			reso_p = ip_reso_list;
			flags_p = ip_flags_list;
			memset(flags_p,0,size);
			for ( i = 0 ; i < size ; i ++, ip_p ++, ptr_p ++,reso_p++ , flags_p ++ ) {
#ifdef PGV_DEBUG
ss_printf("PG PLOT DIST %i\n",(*ip_p)->min_direction);
#endif
				if ( (*ip_p)->min_direction < POINT_MIN_DIRECTION_STEP ) {
				plot_color:
#ifdef PGV_DEBUG
ss_printf("PG PLOT COLOR-1\n");
#endif
					dw->flags |= WFF_POLY; 
					if ( dw->pixels == 0 )
						continue;
					if ( inside_rect(dw->rectondisp,*ptr_p) == 0 )
						continue;
					index = ((int)(ptr_p->x - dw->rectondisp->tl.x)) +
							((int)(ptr_p->y - dw->rectondisp->tl.y)) *
							width;
#ifdef PGV_DEBUG
ss_printf("PG PLOT COLOR-2 %i %i - %i %x\n",(*ip_p)->c[0],(*ip_p)->c[1],vmp->color_field,vmp->default_color);
#endif
					if ( vmp->color_field >= 0 ) {
						if ( vmp->color_field >= (*ip_p)->fields[0].len )
							continue;
						if ( (*ip_p)->fields[vmp->color_field].type != CH_RGBA )
							continue;
						rgba = 0;
						rgba_p = (*ip_p)->fields[vmp->color_field].d.rgba;
						for ( j = 0 ; j < 4 ; j ++ )
							rgba = (rgba<<8)+(rgba_p->rgba[j]);
						dw->pixels[index] = convert_rgba_to_cc((unsigned int)rgba);
					}
					else	dw->pixels[index] = convert_rgba_to_cc(vmp->default_color);
				}
				else {
#ifdef PGV_DEBUG
ss_printf("PG PLOT LOGO-1\n");
#endif
					logo = (*ip_p)->min_direction / POINT_MIN_DIRECTION_STEP;
					if ( get_logo_info(vmp,*ip_p,logo,&logo_url,&logo_align,&logo_offset,&logo_t_color,
							&logo_anchor) < 0 )
						goto plot_color;
					
					data = get_ri(&w,&h,gf,dw->wfid,logo_url);
					if ( data == 0 )
						goto plot_color;
					switch ( logo_align & AG_LR_MASK ) {
					case AG_LR_LEFT:
						x = ptr_p->x;
						break;
					case AG_LR_CENTER:
						x = ptr_p->x - w/2;
						break;
					case AG_LR_RIGHT:
						x = ptr_p->x - w;
						break;
					case AG_LR_VALUE:
						x = ptr_p->x - logo_offset.x;
						break;
					}
					switch ( logo_align & AG_TB_MASK ) {
					case AG_TB_TOP:
						y = ptr_p->y;
						break;
					case AG_TB_CENTER:
						y = ptr_p->y - h/2;
						break;
					case AG_TB_BOTTOM:
						y = ptr_p->y - h;
						break;
					case AG_TB_VALUE:
						y = ptr_p->y - logo_offset.y;
						break;
					}
					dt = d_alloc(w*h*sizeof(int));
					memcpy(dt,data,w*h*sizeof(int));
					for ( i = 0 ; i < w*h ; i ++ )
						if ( dt[i] == logo_t_color )
							dt[i] = C_TRANSPARENT;

					rect.tl.x = x;
					rect.tl.y = y;
					rect.br.x = x + w;
					rect.br.y = y + h;

					if ( logo_anchor )
						wf_insert_si(
							gf,
							ISI_INSERT,
							dw->wfid,
							dw->resource->h.no,
							(*ip_p)->id,
							0,
							&rect,
							dt,
							0,
							SIF_ANCOR,
							logo_anchor);
					else	wf_insert_si(
							gf,
							ISI_INSERT,
							dw->wfid,
							dw->resource->h.no,
							(*ip_p)->id,
							0,
							&rect,
							dt,
							0,
							SIF_ANCOR,
							0);
					d_f_ree(logo_url);
					if ( logo_anchor )
						d_f_ree(logo_anchor);
				}

				if ( /* size > STRING_ALL_PRINT &&*/ (*flags_p) )
{
#ifdef PGV_DEBUG
ss_printf("PG PLOT ONMAP-0\n");
#endif
					continue;
}
				if ( (*ip_p)->flags & PP_MERGED_FIELDS )
{
#ifdef PGV_DEBUG
ss_printf("PG PLOT ONMAP-MERGE %p\n",(*ip_p)->base);
#endif
					continue;
}
				if ( (*ip_p)->onmap == 0 ) {
#ifdef PGV_DEBUG
ss_printf("PG PLOT ONMAP-1\n");
#endif

					ac = get_arg_cache(vmp,*ip_p);
					if ( ac->onmap == 0  ) {
						if ( vmp->direct_onmap_field >= 0 ) {
						IP_FIELD * fd;
						XL_SEXP * data;
						XL_SEXP * sym;
						int list_f;
#ifdef PGV_DEBUG
ss_printf("PG PLOT ONMAP-2 %i\n",vmp->direct_onmap_field);
#endif
							list_f = 0;
							gc_push(0,0,"onmap");
							if ( vmp->direct_onmap_field >= 
									(*ip_p)->fields[0].len )
								goto ac_error;
							fd = &(*ip_p)->fields[vmp->direct_onmap_field];
#ifdef PGV_DEBUG
ss_printf("PG PLOT ONMAP-3 %x %x\n",fd->type,CH_STRING);
#endif
							switch ( fd->type ) {
							case CH_STRING:
								data = get_string(
									l_string(&utf8_cm,fd->d.str));
#ifdef PGV_DEBUG
ss_printf("DATA %x %x :: %x\n",fd->d.str[0],fd->d.str[1],data->string.data[0]);
#endif
								break;
							case CH_INT_ADD:
							case CH_INT_AVG:
							case CH_INT_MAX:
							case CH_INT_MIN:
								data = get_integer(fd->d.i[0],0);
								break;
							default:
								goto ac_error;
							}
							if ( vmp->direct_onmap_ref_field < 0 ||
								vmp->direct_onmap_ref_field >= 
									(*ip_p)->fields[0].len ) {
								if ( vmp->direct_onmap_ref_field_str == 0 )
									goto ref_next;
								sym = n_get_symbol("A");
								set_attribute(sym,l_string(std_cm,"HREF"),
									vmp->direct_onmap_ref_field_str);
								data = List(sym,data,-1);
								list_f = 0;
								goto ref_next;
							}
							fd = &(*ip_p)->fields[vmp->direct_onmap_ref_field];
							if ( fd->type == CH_STRING ) {
								sym = n_get_symbol("A");
								set_attribute(sym,l_string(std_cm,"HREF"),
									l_string(&utf8_cm,fd->d.str));
								data = List(sym,data,-1);
								list_f = 0;
							}
						ref_next:
							if ( vmp->direct_onmap_fontcolor ) {
							char bf[20];
								sprintf(bf,"#%x",vmp->direct_onmap_fontcolor);
								sym = n_get_symbol("FONT");
								set_attribute(sym,l_string(std_cm,"COLOR"),
									l_string(std_cm,bf));
								if ( list_f ) {
									data = cons(List(sym,-1),data);
								}
								else {
									data = List(List(sym,-1),data,-1);
									list_f = 1;
								}
							}
							ac->onmap = new_matrix_sexp(data);
							(*ip_p)->onmap = new_matrix_sexp(data);
							gc_pop(0,0);
						}
						else {
							dd.fd = (*ip_p)->fields;
							dd.vmp = vmp;
							gc_push(0,0,"onmap");
							env = new_env(pgv_runtime_env);
							set_env_work(env,&dd);
							s = eval(env,(XL_SEXP*)vmp->ind_convert->data);
							er_code = 1;
							if ( get_type(s) != XLT_ERROR ) {
#ifdef PGV_DEBUG
ss_printf("PG PLOT ONMAP-2-1\n");
#endif
								er_code = 2;
								s = get_onmap_info(r,vmp->ischeme,s,&style_reso);
								if ( get_type(s) != XLT_ERROR ) {
									(*ip_p)->onmap = new_matrix_sexp(s);
									ac->onmap = new_matrix_sexp(s);
								}
								else	goto ac_error;
							}
							else {
							ac_error:
								if ( ac->onmap )
									ac->onmap->del = 1;
								if ( ac->card )
									ac->card->del = 1;
								ac->onmap = 0;
								ac->card = 0;
							}
							gc_pop(0,0);
						}

/*
						gc_push(0,0,"card");
						env = new_env(pgv_runtime_env);
						set_env_work(env,&dd);
						s = eval(env,(XL_SEXP*)vmp->ind_convert->data);
						er_code = 3;
						if ( get_type(s) != XLT_ERROR ) {
							s = get_card_info(r,vmp->ischeme,s);
							er_code = 4;
							if ( get_type(s) != XLT_ERROR ) {
								(*ip_p)->card = new_matrix_sexp(s);
								ac->card = new_matrix_sexp(s);
							}
							else	goto ac_error;
						}
						else {
						}
						gc_pop(0,0);
*/
					}
					else {
#ifdef PGV_DEBUG
ss_printf("PG PLOT ONMAP-3\n");
#endif
						if ( ac->onmap )
							(*ip_p)->onmap = new_matrix_sexp(ac->onmap->data);
/*
						if ( ac->card )
							(*ip_p)->card = new_matrix_sexp(ac->card->data);
*/
					}
				}
				if ( (*ip_p)->id == 0 ) {
					er_panic("obj*id");
				}
#ifdef PGV_DEBUG
ss_printf("PG PLOT ONMAP-5 %p %p\n",(*ip_p)->onmap,(*ip_p)->card);
#endif
				if ( (*ip_p)->onmap == 0 )
					continue;
#ifdef PGV_DEBUG
ss_printf("PG PLOT ONMAP-5-1\n");
#endif
				if ( (*ip_p)->onmap->data == 0 )
					continue;
#ifdef PGV_DEBUG
ss_printf("PG PLOT ONMAP-6\n");
print_sexp(s_stdout,(*ip_p)->onmap->data,0);
ss_printf("\n");
#endif
				pic = get_onmap_string_pic(gf,(*ip_p)->onmap->data);
				if ( pic.list == 0 ){
					free_pic(pic);
					continue;
				}
				ind_ptr.x = (int)ptr_p->x;
				ind_ptr.y = (int)ptr_p->y;
				rect.tl.x = ind_ptr.x + pic.rect.tl.x;
				rect.tl.y = ind_ptr.y + pic.rect.tl.y;
				rect.br.x = ind_ptr.x + pic.rect.br.x;
				rect.br.y = ind_ptr.y + pic.rect.br.y;
				_width = pic.rect.br.x - pic.rect.tl.x;
				_height = pic.rect.br.y - pic.rect.tl.y;
				goto ok;
				
				if ( wf_space_check_si(
						gf,
						dw->wfid,r->h.no,((*ip_p)->id&MAIN_CODE)|INFO_SUBCODE,
							0,&rect,10) == 0 )
					goto ok;
				rect.tl.y -= _height;
				rect.br.y -= _height;
				ind_ptr.y -= _height;
				if ( wf_space_check_si(
						gf,
						dw->wfid,r->h.no,((*ip_p)->id&MAIN_CODE)|INFO_SUBCODE,
							0,&rect,10) == 0 )
					goto ok;
				rect.tl.y += 2*_height;
				rect.br.y += 2*_height;
				ind_ptr.y += 2*_height;
				if ( wf_space_check_si(
						gf,
						dw->wfid,r->h.no,((*ip_p)->id&MAIN_CODE)|INFO_SUBCODE,
							0,&rect,10) == 0 )
					goto ok;
				free_pic(pic);
				continue;
			ok:
				sub = 0;
				for ( pe = pic.list ; pe ; pe = pe->next ) {
				int flags;
					rect.tl.x = pe->p.r.tl.x + ind_ptr.x;
					rect.br.x = pe->p.r.br.x + ind_ptr.x;
					rect.tl.y = pe->p.r.tl.y + ind_ptr.y;
					rect.br.y = pe->p.r.br.y + ind_ptr.y;
					if ( pe->flags & PLF_ANCOR )
						flags = SIF_ANCOR;
					else	flags = 0;

#ifdef PGV_DEBUG
ss_printf("PG PLOT ONMAP-7 REF=%p %x\n",pe->ref,flags);
#endif
					wf_insert_si(
						gf,
						ISI_INSERT,
						dw->wfid,
						r->h.no,
						((*ip_p)->id&MAIN_CODE)|INFO_SUBCODE,
						sub++,
						&rect,
						pe->data,
						pe->alpha,
						flags,
						pe->ref);
					pe->data = 0;
					pe->alpha = 0;
					set_dont_print_flag(mtx,ip_p,ptr_p,flags_p,size-i,rect,ind_ptr);
				}
				free_pic(pic);
			}
		next:
			matrix_node_channel_unlock(n,0);
			unlock_node(n,0);
		last:
			if ( inc_dim_code_ix(ix,start,inc,end,r->h.mtx->p.dim) )
				break;
		}
		
	end:
		;
	}
	d_f_ree(rp);
	
	d_f_ree(start);
	d_f_ree(end);
	d_f_ree(inc);
	d_f_ree(ix);

	if ( ip_list )
		d_f_ree(ip_list);
	if ( ip_pt_list )
		d_f_ree(ip_pt_list);
	if ( ip_reso_list )
		d_f_ree(ip_reso_list);
}




void
vmt_dummy(VIEW_METHOD* _vm,GBVIEW_FLAME* gf,RESOURCE * r,DRAW_WORK* dw)
{
GB_RECT rct;
GB_RECT * rp;
int rp_len;
int rr;
double reso,reso2;
int lev;

MATRIX * mtx;
MATRIX_NODE * n;
int div;
int i;
INTEGER64 * start,*end,*inc,*ix;
int err;
int err_flag;

	if ( dw->method == 0 )
		return; 
	if ( get_mov_flag(gf,dw->wfid) != 0 )
		return;
	mtx = r->h.mtx;
	dw->flags |= WFF_LUSTER;
	if ( mtx == 0 ) {
		gv_new_luster_option(r,0);
		if ( r->h.mtx == 0 )
			return;
		mtx = r->h.mtx;
	}
	if ( mtx->flags & MXF_ERR_DETECTED ) {
		r->h.mtx = 0;
		close_matrix(mtx);
		gv_new_luster_option(r,0);
		if ( r->h.mtx == 0 )
			return;
		mtx = r->h.mtx;
	}
ss_printf("DUMMY MATRIX OK\n");
	div = ((int)1)<<mtx->dim_divide[0];
	start = d_alloc(sizeof(INTEGER64)*(r->h.mtx->p.dim+1));
	end = d_alloc(sizeof(INTEGER64)*(r->h.mtx->p.dim+1));
	inc = d_alloc(sizeof(INTEGER64)*(r->h.mtx->p.dim+1));
	ix = d_alloc(sizeof(INTEGER64)*(r->h.mtx->p.dim+1));

	rp = get_surp_rect_rate(&rp_len,&dw->surp,0.1,0);
	for ( rr = 0 ; rr < rp_len ; rr ++ )  {
		if ( wf_active_check_2(gf,dw->wfid) < 0 )
{ss_printf("FREE=RETURN-DRAW\n");
			break;
}
		rct = rp[rr];

		dw->draw_rect = rct;
		dw->draw_lod = 0;

		dw->limit_reso = r->pr64.dpm;
		dw->limit_ptr = dw->pt_list[dw->size/2];
		r->h.loop_no ++;

		if ( dw->limit_reso != 0 &&
			r->h.limit_resolution != 0 &&
			dw->limit_reso > r->h.limit_resolution )
			dw->limit_reso = r->h.limit_resolution;
		dw->limit_ptr = p_add(rct.tl,rct.br);
		dw->limit_ptr.x /= 2;
		dw->limit_ptr.y /= 2;

		lev = 0;
		reso2 = r->pr64.dpm;
		reso = get_surp_reso(&dw->surp);

		if ( reso > reso2*LIMIT_RESOLUTION_RATE )
			goto end;

		for ( lev = 0; lev < mtx->total_levels ; lev ++, reso2 = reso2/div )
			if ( reso > reso2*PDB_RESO )
				break;
		if ( lev == r->h.mtx->total_levels )
			goto end;
		r->h.loop_no ++;


		rct.tl.x *= r->pr64.dpm;
		rct.tl.y *= r->pr64.dpm;
		rct.br.x *= r->pr64.dpm;
		rct.br.y *= r->pr64.dpm;
		set_search_parameter(r->h.mtx,start,end,inc,rct,lev,r->h.mtx->p.dim);
		
		for ( i = 0 ; i <= r->h.mtx->p.dim ; i ++ )
			ix[i] = start[i];
		err_flag = 0;
		for ( ; ; ) {
			err = 0;
			if ( r->h.mtx->p.flags & MPF_NODE_DIPENDENT ) {
				n = get_matrix_tree(&err,r->h.mtx,ix,GN_NODE_CREATE,r->h.loop_no);
			}
			else {
				n = get_matrix_tree(&err,r->h.mtx,ix,GN_STEP_NODE_CREATE,r->h.loop_no);
			}
			if ( n )
				unlock_node(n,0);
			if ( err )
				err_flag = 1;
			if ( inc_dim_code_ix(ix,start,inc,end,r->h.mtx->p.dim) )
				break;
		}
		if ( err_flag == 0 ) {
			lock_task(res_lock);
			r->h.non_setup_vm = setup_view_methods(r,0,vm_tbl[r->h.type],&r->h.vm);
			unlock_task(res_lock,"insert_resource_matrix");
		}
		
	end:
		;
	}
	d_f_ree(rp);
	
	d_f_ree(start);
	d_f_ree(end);
	d_f_ree(inc);
	d_f_ree(ix);

}


