/**********************************************************************
 
	Copyright (C) 2003 Hirohisa MORI <joshua@nichibun.ac.jp>
 
	This program is free software; you can redistribute it 
	and/or modify it under the terms of the GLOBALBASE 
	Library General Public License (G-LGPL) as published by 

	http://www.globalbase.org/
 
	This program is distributed in the hope that it will be 
	useful, but WITHOUT ANY WARRANTY; without even the 
	implied warranty of MERCHANTABILITY or FITNESS FOR A 
	PARTICULAR PURPOSE.

**********************************************************************/



#include	<stdlib.h>
#include	"machine/u_math.h"
#include	"machine/include.h"
#include	"memory_debug.h"
#include	"gbview.h"
#include	"gbparam.h"
#include	"gbgraph.h"
#include	"lock_level.h"
#include	"routing.h"
#include	"win_flame.h"
#include	"viewindex.h"
#include	"pri_level.h"
#include	"utils.h"
#include	"save_global.h"
#include	"xl.h"
#include	"radar.h"
#include	"h_layering.h"
#include	"xlerror.h"
#include	"heuristics_win_frame.h"

#define CURRENT_SWITCH_TIMERAG	2
#define ZONBIE_TIMEOUT	120
#define MOVE_TIMER_LIMIT	30

void ov_default();

void _wakeup_win_manage(void *);
void wakeup_win_manage(void *);
void _wakeup_loading_task(void);
void wakeup_loading_task(void *);
void min_route_task(void *);
void _wakeup_min_route_task(void *);
void wakeup_min_route_task(void *);
void _indicate_tr_lock(int * ind);


int system_wfid;
int system_gfid;
int gf_zonbie_count;

void check_flame_task();

GBVIEW_FLAME * gbview_flame_list;
SEM gbview_flame_lock;
SEM irq_lock,in_lock,iom_lock;
extern void (*draw_gb_indicate_task)(TKEY);
void indicate_info_task(TKEY);
#define wf_indicate_lock(gf)	xx_wf_indicate_lock(gf,__FILE__,__LINE__)
void change_task();
void _indicate_flame_lock(int*);
void _call_flame_change_base_event(GBVIEW_FLAME * gf);
GBVIEW_PLOT_ELEMENT *  _wf_plot_element(GBVIEW_FLAME * gf,WF_ID id);

void
init_win_flame()
{

	init_h_layering();
	init_hwf();

	gbview_flame_lock = new_lock(LL_WF);
/* init GBVIEW_FLAME
	gf->seq = 1;
*/
	irq_lock = new_lock(LL_IRQ);
	in_lock = new_lock(LL_INDICATE);
	iom_lock = new_lock(LL_ONMAP);
	draw_gb_indicate_task = indicate_info_task;

	create_task((void(*)(TKEY))change_task,0,PRI_DRAW_EXIT);
	
	upper_layer_lock_tracer = _indicate_flame_lock;


}

void
see_lock_d(char * msg,GBVIEW_FLAME * gf,LOCK_D * d,int * ind)
{
	if ( d->_file == 0 )
		return;
	if ( debug_th_timeout_check(d->time) < 0 )
		return;
	if ( *ind == 0 )
		printf("LOCK INFO ====\n");
	*ind = 1;
	printf("LOCK_D (%s %x) %isec :: %s %i == %i\n",
		msg,(int)gf,
		get_xltime() - d->time,
		d->_file,
		d->_line,
		d->lock_cnt);	
}

void
_indicate_flame_lock(int * ind)
{
GBVIEW_FLAME * gf;
void _indicate_draw_gb_lock(int*);
	for ( gf = gbview_flame_list ; gf ; gf = gf->next ) {
		see_lock_d("gf ls_lock",gf,&gf->_ls_lock,ind);
		see_lock_d("gf wf_lock",gf,&gf->_wf_lock,ind);
		see_lock_d("gf indicate_lock",gf,&gf->indicate_lock,ind);
	}
	_indicate_draw_gb_lock(ind);
	_indicate_tr_lock(ind);
}


int
_get_new_gfid()
{
GBVIEW_FLAME * gf;
retry:
	system_gfid ++;
	if ( system_gfid <= 0 )
		system_gfid = 1;
	for ( gf = gbview_flame_list ; gf ; gf = gf->next ) {
		if ( gf->id == system_gfid )
			goto retry;
	}
	return system_gfid;
}

void
move_timer_tick(int _gf)
{
INTEGER64 tim;
GBVIEW_FLAME * gf;
RADAR_CACHE * rc;
	gf = (GBVIEW_FLAME*)_gf;
	tim = get_xltime();
	if ( gf->move_timer == 0 )
		return;
	if ( (tim - gf->move_timer) < MOVE_TIMER_LIMIT ) {
		change_tick(MOVE_TIMER_LIMIT- (tim - gf->move_timer));
		return;
	}

ss_printf("move_time_tick=====\n");
	rc = (RADAR_CACHE*)gf->radar_ptr;
	rc->last_loading_time = 0;
	wakeup_loading_task(rc);
	gf->move_timer = 0;
	change_tick(-1);
}

void
_set_move_timer(GBVIEW_FLAME* gf)
{
/* INVALID
	if ( gf->move_timer == 0 ) {
		gf->move_timer = get_xltime();
		new_tick(move_timer_tick,MOVE_TIMER_LIMIT,(int)gf);
	}
	else {
		gf->move_timer = get_xltime();
	}
*/
}

GBVIEW_FLAME *
_wf_new_gf()
{
GBVIEW_FLAME * ret;

	ret = d_alloc(sizeof(*ret));
	memset(ret,0,sizeof(*ret));
	ret->seq = 1;
/*
	ret->win_height = 400;
	ret->win_width = 600;
	ret->redraw = d_alloc(ret->win_height*ret->win_width);
	for ( i = 0 ; i < ret->win_height*ret->win_width ; i ++ )
		env.redraw[i] = RP_REDRAW;
	ret->redraw_plane 
		= d_alloc(ret->win_height*ret->win_width*sizeof(long));
*/
	gf_init_indicate(ret);

	ret->id = _get_new_gfid();

	ret->status = GVFS_IDLE;
	ret->move_timer = 0;

	ret->next = gbview_flame_list;
	gbview_flame_list = ret;

	return ret;
}

GBVIEW_FLAME *
wf_new_gf()
{
GBVIEW_FLAME * ret;
	lock_task(gbview_flame_lock);
	ret = _wf_new_gf();
	unlock_task(gbview_flame_lock,"wf_new_gf");
	return ret;
}

GBVIEW_FLAME *
wf_open()
{
GBVIEW_FLAME * ret;
GBVIEW_STATUS sts;
	ret = wf_new_gf();
	wf_init_status(&sts);
	sts.flags = SF_RADAR|SF_STATUS;
	sts.status = GVFS_ACTIVE;
	wf_set_status(ret,&sts);
	return ret;
}

void
wf_close(GBVIEW_FLAME * gf)
{
GBVIEW_STATUS sts;
	if ( gf == 0 )
		return;
	wf_init_status(&sts);
	sts.flags = SF_STATUS;
	sts.status = GVFS_ZONBIE;
	wf_set_status(gf,&sts);
}

void
ch_lock_init(LOCK_D * d)
{
	memset(d,0,sizeof(*d));
}

void
_ch_lock(LOCK_D *lock_bit,char * file,int line)
{
HTID tid;
	tid = _get_tid();
	if ( tid.valid == lock_bit->tid.valid && tid.tid == lock_bit->tid.tid ) {
		lock_bit->lock_cnt ++;
		return;
	}
	for ( ; lock_bit->_file ; ) {
		_i_sleep_task((int)lock_bit,gbview_flame_lock,file,line);
		lock_task(gbview_flame_lock);
	}
	if ( file == 0 )
		er_panic("_ch_lock");
	lock_bit->_file = file;
	lock_bit->_line = line;
	lock_bit->tid = tid;
	lock_bit->time = get_xltime();
	lock_bit->lock_cnt = 1;
}

void
ch_lock(LOCK_D *lock_bit,char * file,int line)
{
int pri;
	pri = push_pri(PRI_USER_INTERFACE);
	lock_task(gbview_flame_lock);
	_ch_lock(lock_bit,file,line);
	unlock_task(gbview_flame_lock,"wf_lock");
	lock_bit->pri = pri;
}


void
_ch_unlock(LOCK_D * lock_bit)
{
	if ( lock_bit->_file == 0 )
		er_panic("wf_unlock");
	lock_bit->lock_cnt --;
	if ( lock_bit->lock_cnt < 0 )
		er_panic("wf_unlock(2)");
	if ( lock_bit->lock_cnt )
		return;
	lock_bit->_file = 0;
	lock_bit->_line = 0;
	lock_bit->tid = invalid_htid();
	wakeup_task((int)lock_bit);
}


void
ch_unlock(LOCK_D * lock_bit,void (*f)(),void * wk)
{
int pri;
	lock_task(gbview_flame_lock);
	_ch_unlock(lock_bit);
	pri = lock_bit->pri;
	if ( f )
		(*f)(wk);
	unlock_task(gbview_flame_lock,"wf_lock");
	change_pri(0,pri);
}


int
_ch_locked(LOCK_D * d)
{
	if ( d->_file )
		return 1;
	return 0;
}

void
ch_sleep_task(int key,LOCK_D * lock_bit,void (*f)(),void * wk)
{
	lock_task(gbview_flame_lock);
	if ( lock_bit->_file == 0 )
		er_panic("ch_sleep_task");
	lock_bit->_file = 0;
	lock_bit->_line = 0;
	lock_bit->tid = invalid_htid();
	lock_bit->lock_cnt = 0;
	wakeup_task((int)lock_bit);
	if ( f )
		(*f)(wk);
	sleep_task(key,gbview_flame_lock);
}

void
xx_wf_lock(GBVIEW_FLAME * gf,char * file,int line)
{
	ch_lock(&gf->_wf_lock,file,line);
}


void
wf_unlock(GBVIEW_FLAME * gf)
{
	ch_unlock(&gf->_wf_lock,_free_to_outlist,gf);
}

void
wf_sleep_task(GBVIEW_FLAME * gf,int key)
{
	ch_sleep_task(key,&gf->_wf_lock,_free_to_outlist,gf);
}


void
wf_apply_all_gf(int (*func)(),void * work,int status,int lock_flag)
{
GBVIEW_FLAME * gf;
int pri;
	pri = push_pri(PRI_DRAW);
	lock_task(gbview_flame_lock);
	for ( gf = gbview_flame_list ; gf ; gf = gf->next ) {
		if ( gf->status & status ) {
			if ( lock_flag == 0 )
				unlock_task(gbview_flame_lock,"wf_apply_all_gf");
			if ( (*func)(gf,work) < 0 ) {
				if ( lock_flag == 0 )
					lock_task(gbview_flame_lock);
				break;
			}
			if ( lock_flag == 0 )
				lock_task(gbview_flame_lock);
		}
	}
	unlock_task(gbview_flame_lock,"wf_apply_all_gf");
	change_pri(0,pri);
}

typedef struct f2outlist {
	GBVIEW_FLAME *	gf;
	WIN_FLAME *	wf;
} F2OUTLIST;

void
__free_to_outlist(int d)
{
F2OUTLIST * f;
XL_INTERPRETER * xli;
	if ( get_my_xli() == 0 ) {
		xli = new_xl_interpreter();
		xli->a_type = XLA_SELF;
		setup_i(xli);
	}

	f = (F2OUTLIST*)d;

	log_printf(LOG_MESSAGE,LOG_LAYER_GB,0,
		"EXIT-1 %ls\n",
		get_url_str2(&f->wf->draw->h.entry));

	exit_win_flame(f->gf,f->wf);
	d_f_ree(f);
}

void
_free_to_outlist(GBVIEW_FLAME * gf)
{
WIN_FLAME * wf, ** wfp;
int f;
F2OUTLIST * fo;
	if ( _ch_locked(&gf->_ls_lock) )
		return;
	if ( _ch_locked(&gf->_wf_lock) )
		return;
	if ( _ch_locked(&gf->indicate_lock) )
		return;
	f = 0;
	for ( wfp = &gf->flame ; *wfp ; ) {
		wf = *wfp;
		if ( wf == gf->flame_base ) {
			wfp = &wf->next;
			continue;
		}
		if ( !(wf->flags & WFF_FREE) ) {
			wfp = &wf->next;
			continue;
		}
		if ( wf->flags & WFF_FREE_OUTLIST )
			er_panic("_free_to_outlist");

//		exit_lock_resource(wf->draw,1);
		*wfp = wf->next;
		wf->next = 0;
		wf->flags |= WFF_FREE_OUTLIST;
		f = 1;
		wakeup_task((int)gf);
		if ( wf->lock == 0 && wf->browse == 0 ) {
//			exit_lock_resource(wf->draw,0);
//			exit_win_flame(gf,wf);
			fo = d_alloc(sizeof(*fo));
			fo->gf = gf;
			fo->wf = wf;
			new_tick(__free_to_outlist,0,(int)fo);
		}
	}
	if ( f )
		wakeup_task((int)gf);
}

typedef struct _wf_get_gf_from_id_t {
	int		id;
	GBVIEW_FLAME * 	ret;
} _WF_GET_GF_FROM_ID_T;

int _wf_get_gf_from_id(GBVIEW_FLAME * gf,_WF_GET_GF_FROM_ID_T * w);

int
_wf_get_gf_from_id(GBVIEW_FLAME * gf,_WF_GET_GF_FROM_ID_T * w)
{
	if ( gf->id == w->id ) {
		w->ret = gf;
		return -1;
	}
	return 0;
}

GBVIEW_FLAME *
wf_get_gf_from_id(int id)
{
_WF_GET_GF_FROM_ID_T w;

	w.ret = 0;
	w.id = id;
	wf_apply_all_gf(_wf_get_gf_from_id,&w,GVFM_LIVE,1);
	return w.ret;
}

GBVIEW_FLAME *
wf_next_gf(GBVIEW_FLAME * gf,int status)
{
	lock_task(gbview_flame_lock);
	if ( gf == 0 )
		gf = gbview_flame_list;
	else gf = gf->next;
	for ( ; gf ; gf = gf->next )
		if ( gf->status & status )
			break;
	unlock_task(gbview_flame_lock,"wf_next_gf");
	return gf;
}



void
check_flame_task(GBVIEW_FLAME * gf)
{
WIN_FLAME * wf;
	for ( ; ; ) {
		sleep_sec(1);
		wf_lock(gf);
		ss_printf("CWF\n");
		for ( wf = gf->flame ; wf ; wf = wf->next ) {
			if ( wf->mh == 0 )
				ss_printf(">> * ");
			else	ss_printf(">>   ");
			ss_printf("%ls ",
				get_url_str2(&wf->draw->h.entry));
			ss_printf("%i %x %i\n",wf->lock,wf->flags,wf->pri_adj);
		}
		wf_unlock(gf);
		gv_cpu_direct();
	}
}

int
_get_env_seq(GBVIEW_FLAME * gf)
{
int ret;
	ret = gf->seq ++;
	if ( gf->seq < 1 )
		gf->seq = 1;
	return ret;
}

void
wf_free_si(WIN_FLAME * wf)
{
SYMBOL_INDICATE * si;


	for ( ; wf->sym_i ; ) {
		si = wf->sym_i;
		wf->sym_i = si->next;
		if ( si->data )
			d_f_ree(si->data);
		if ( si->alpha )
			d_f_ree(si->alpha);
		if ( si->ref )
			d_f_ree(si->ref);
		if ( si->rect.tl.x == si->rect.br.x )
			delete_irq(si->rno,si->code);
		d_f_ree(si);
	}
}

int
_win_lock(GBVIEW_FLAME * gf,WIN_FLAME * wf)
{
int id;
WF_LOCK_LIST * wfl;

retry:
	if ( wf->flags & WFF_FREE )
		return -1;
	if ( wf->aboat_count )
		return -1;
	if ( wf->lock >= 0 ) {
		wf->lock ++;

		wfl = d_alloc(sizeof(*wfl));
		wfl->next = wf->lock_list;
		wfl->tid = get_tid();
		wf->lock_list  = wfl;
	}
	else {
		id = wf->id;
		wf_sleep_task(gf,(int)wf);
		wf_lock(gf);
		if ( _get_wf_ptr(gf,id) == 0 )
			return -1;
		if ( wf->flags & (WFF_FREE|WFF_FREE_OUTLIST) )
			return -1;
		goto retry;
	}
	_wakeup_at_redraw_wp(gf);
	return 0;
}

int
_win_wlock(GBVIEW_FLAME * gf,WIN_FLAME * wf)
{
int id;
WF_LOCK_LIST * wfl;
	for ( ; wf->lock ; ) {
		id = wf->id;
		wf_sleep_task(gf,(int)wf);
		wf_lock(gf);
		if ( _get_wf_ptr(gf,id) == 0 )
			return -1;
		if ( wf->flags & (WFF_FREE|WFF_FREE_OUTLIST) )
			return -1;
	}
	wf->lock = -1;

	wfl = d_alloc(sizeof(*wfl));
	wfl->next = wf->lock_list;
	wfl->tid = get_tid();
	wf->lock_list  = wfl;

	_wakeup_at_redraw_wp(gf);
	return 0;
}

void
_win_unlock(GBVIEW_FLAME * gf,WIN_FLAME * wf)
{
WF_LOCK_LIST ** wflp, * wfl;
int tid;

	tid = get_tid();
	for ( wflp = &wf->lock_list ; *wflp ; wflp = &(*wflp)->next ) {
		if ( (*wflp)->tid != tid )
			continue;
		wfl = *wflp;
		*wflp = wfl->next;
		d_f_ree(wfl);
		goto ok;
	}
	return;
ok:
	if ( wf->lock == 0 )
		er_panic("_win_unlock");
	if ( wf->lock > 0 )
		wf->lock --;
	else 	wf->lock = 0;
	if ( wf->lock == 0 ) {
		wakeup_task((int)wf);
		_wakeup_at_redraw_wp(gf);
		if ( wf->browse == 0 ) {
			if ( wf->flags & WFF_FREE_OUTLIST ) {
//				exit_lock_resource(wf->draw,0);

			log_printf(LOG_MESSAGE,LOG_LAYER_GB,0,
				"EXIT-2 %ls\n",
				get_url_str2(&wf->draw->h.entry));

				exit_win_flame(gf,wf);
			}
		}
	}
}

void
wf_free_lock_list(WIN_FLAME * wf)
{
WF_LOCK_LIST * wfl;
	for ( ; wf->lock_list ; ) {
		wfl = wf->lock_list;
		wf->lock_list = wfl->next;
		d_f_ree(wfl);
	}
}


int
win_lock(GBVIEW_FLAME * gf,WIN_FLAME * wf)
{
int ret;
	wf_lock(gf);
	ret = _win_lock(gf,wf);
	wf_unlock(gf);
	return ret;
}

int
win_wlock(GBVIEW_FLAME * gf,WIN_FLAME * wf)
{
int ret;
	wf_lock(gf);
	ret = _win_wlock(gf,wf);
	wf_unlock(gf);
	return ret;
}

void
win_unlock(GBVIEW_FLAME * gf,WIN_FLAME * wf)
{
	wf_lock(gf);
	_win_unlock(gf,wf);
	wf_unlock(gf);
}

void
_ex_lock(GBVIEW_FLAME * gf)
{

	for ( ; gf->ex_lock ; ) {
		wf_sleep_task(gf,(int)&gf->ex_lock);
		wf_lock(gf);
	}
	gf->ex_lock = 1;
}

void
_ex_unlock(GBVIEW_FLAME * gf)
{
	gf->ex_lock = 0;
	wakeup_task((int)&gf->ex_lock);
}

void
ex_lock(GBVIEW_FLAME * gf)
{
	wf_lock(gf);
	_ex_lock(gf);
	wf_unlock(gf);
}

void
ex_unlock(GBVIEW_FLAME * gf)
{
	wf_lock(gf);
	_ex_unlock(gf);
	wf_unlock(gf);
}

/*
int
_check_exit_flame(GBVIEW_FLAME * gf)
{
WIN_FLAME * wf;
int ret;
	ret = 0;
	for ( wf = gf->flame ; wf ; wf = wf->next )
		if ( wf->flags & WFF_FREE )
			ret ++;
	return ret;
}
*/

void
_xx_wakeup_wf(GBVIEW_FLAME * gf,WIN_FLAME * wf,char * __f,int __l)
{
/*
ss_printf("_xx_wakeup_wf %s::%i %i %i\n",__f,__l,gf->run_req_task_nos,gf->load_task_max);
*/
	wf->flags |= WFF_DRAW_REQUEST;
	gf->req_task_nos ++;
	if ( gf->load_task_max <= 0 )
		gf->load_task_max ++;
	wakeup_task((int)gf);
	if ( gf->run_req_task_nos <= gf->load_task_max ) {
		gf->run_req_task_nos ++;
		create_task(load_task,(int)gf,PRI_START_DRAW);
	}
}

void
_reset_task_nos(GBVIEW_FLAME * gf)
{
	gf->req_task_nos --;
	if ( gf->req_task_nos < 0 )
		gf->req_task_nos = 0;
}

/*
void
reset_task_nos()
{
	wf_lock(gf);
	_reset_task_nos();
	wf_unlock(gf);"reset_task_nos");
}
*/

int
_get_new_wfid(GBVIEW_FLAME * gf)
{
WIN_FLAME * wf;
retry:
	system_wfid ++;
	if ( system_wfid <= 0 )
		system_wfid = 1;
	for ( wf = gf->flame ; wf ; wf = wf->next ) {
		if ( wf->id == system_wfid )
			goto retry;
	}
	return  system_wfid;
}

int
_get_next_wfid(GBVIEW_FLAME * gf,int id)
{
WIN_FLAME * wf;
int ret;
	ret = 0;
	for ( wf = gf->flame ; wf ; wf = wf->next ) {
		if ( wf->flags & WFF_FREE )
			continue;
		if ( id >= wf->id )
			continue;
		if ( ret == 0 || ret > wf->id )
			ret = wf->id;
	}
	return ret;
}

int
get_next_wfid(GBVIEW_FLAME * gf,int id)
{
int ret;
	wf_lock(gf);
	ret = _get_next_wfid(gf,id);
	wf_unlock(gf);
	return ret;
}

WIN_FLAME * 
_get_wf_ptr(GBVIEW_FLAME * gf,WF_ID id)
{
WIN_FLAME * wf;
	for ( wf = gf->flame ; wf ; wf = wf->next )
		if ( wf->id == id )
			return wf;
	return 0;
}

int
_wf_active_check(WIN_FLAME * wf)
{
	if ( wf->flags & (WFF_FREE|WFF_FREE_OUTLIST) )
		return -1;
	return 0;
}

int
wf_active_check_1(GBVIEW_FLAME * gf,WIN_FLAME * wf)
{
int ret;
	if ( wf == 0 )
		return 1;
/*
	wf_lock(gf);
	ZONBIE_CHECK(gf,wf_unlock(gf),-1);
*/
	ret = _wf_active_check(wf);
//	wf_unlock(gf);
	return ret;
}

int
wf_active_check_2(GBVIEW_FLAME * gf,WF_ID id)
{
WIN_FLAME * wf;
int ret;

	wf_lock(gf);
	ZONBIE_CHECK(gf,wf_unlock(gf),-1);

	wf = _get_wf_ptr(gf,id);
	if ( wf == 0 )
		ret = 1;
	else	ret = _wf_active_check(wf);
	wf_unlock(gf);
	return ret;
}


int
wf_check_last(GBVIEW_FLAME * gf,WF_ID id)
{
int ret;
WIN_FLAME * wf, * wf_id;
int cnt;
	wf_lock(gf);
	ZONBIE_CHECK(gf,wf_unlock(gf),1)

	if ( id == 0 ) {
		if ( gf->flame == 0 || gf->flame->next == 0 )
			ret = 1;
		else {
			cnt = 0;
			for ( wf = gf->flame; wf ; wf = wf->next )
				if ( !(wf->flags & WFF_FREE) )
					cnt ++;
			if ( cnt == 0 )
				ret = 1;
			else	ret = 0;
		}
	}
	else {
		if ( gf->flame == 0 )
			ret = 1;
		else  {
			wf_id = 0;
			cnt = 0;
			for ( wf = gf->flame; wf ; wf = wf->next ) {
				if ( !(wf->flags & WFF_FREE) ) {
					cnt ++;
					wf_id = wf;
				}
			}
			if ( wf_id->id == id && cnt == 1 )
				ret = 1;
			else	ret = 0;
		}
	}
	wf_unlock(gf);
	return ret;
}


WF_ID
wf_get(GBVIEW_FLAME * gf,int no)
{
WF_ID ret;
WIN_FLAME * wf;
	wf_lock(gf);
	ZONBIE_CHECK(gf,wf_unlock(gf),0);


	for ( wf = gf->flame ; wf && no > 0 ; wf = wf->next , no -- );
	if ( wf == 0 )
		ret = 0;
	else	ret = wf->id;
	wf_unlock(gf);
	return ret;
}

GV_RESOURCE_LIST *
_search_resource_list(GBVIEW_FLAME * gf,RESOURCE *r,L_CHAR * target,int create_flag)
{
GV_RESOURCE_LIST * ret,** rp;
	for ( rp = &gf->resource_list ; *rp ; rp = &(*rp)->next ) {
		ret = *rp;
		if ( r ) {
			if ( ret->draw == 0 ) {
				if ( l_strcmp(ret->entry,get_url_str2(&r->h.entry)) == 0 ) {
					ret->draw = r;
					goto ok;
				}
			}
			else if ( ret->draw == r )
				goto ok;
		}
		else {
			if ( ret->draw == 0 ) {
				if ( l_strcmp(ret->entry,target) == 0 )
					goto ok;
			}
			else if ( l_strcmp(get_url_str2(&ret->draw->h.entry),target) == 0 )
				goto ok;
		}
	}
	if ( create_flag ) {
		ret = d_alloc(sizeof(*ret));
		memset(ret,0,sizeof(*ret));
		ret->draw = r;
		ret->entry = ll_copy_str(target);
		ret->next = gf->resource_list;
		gf->resource_list = ret;
		return ret;
	}
	return 0;
ok:
		*rp = ret->next;
		ret->next = gf->resource_list;
		gf->resource_list = ret;
		return ret;
}

GV_RESOURCE_LIST *
search_resource_list(GBVIEW_FLAME * gf,RESOURCE *r,L_CHAR * target,int create_flag)
{
GV_RESOURCE_LIST * ret;
	wf_lock(gf);
	ZONBIE_CHECK(gf,wf_unlock(gf),0);
	ret = _search_resource_list(gf,r,target,create_flag);
	wf_unlock(gf);
	return ret;
}

void
_setup_wf_flags(GBVIEW_FLAME * gf,WIN_FLAME * wf)
{
GV_RESOURCE_LIST * rl;
	rl = _search_resource_list(gf,wf->draw,0,0);
	if ( rl == 0 )
		return;
	wf->flags &= ~WFF_COPY_FLAGS;
	wf->flags |= (WFF_COPY_FLAGS & rl->flags);
}

void
_backup_wf_flags(GBVIEW_FLAME * gf,WIN_FLAME * wf)
{
GV_RESOURCE_LIST * rl;

	rl = _search_resource_list(gf,wf->draw,0,1);
	if ( rl == 0 )
		return;
	rl->flags &= ~WFF_COPY_FLAGS;
	rl->flags |= (wf->flags & WFF_COPY_FLAGS);
}

void
_free_wf_flags(GBVIEW_FLAME * gf)
{
GV_RESOURCE_LIST * rl;
	for ( ; gf->resource_list ; ) {
		rl = gf->resource_list;
		gf->resource_list = rl->next;
		if ( rl->entry )
			d_f_ree(rl->entry);
		d_f_ree(rl);
	}
}

typedef struct re_data {
	GBVIEW_FLAME * 	gf;
	void	(*event_func)(struct gbview_flame*,int,void*,void*);
	int		type;
	void *		sys;
	void *		usr;
} RE_DATA;

void
__call_radar_event_func(RE_DATA * d);

void
__call_radar_event_func(RE_DATA * d)
{
	(*d->event_func)(d->gf,d->type,d->sys,d->usr);
	d_f_ree(d);
}

void
_call_re_base_lock(GBVIEW_FLAME * gf,int type)
{
RE_DATA * dp;
	dp = d_alloc(sizeof(*dp));
	dp->gf = gf;
	dp->type = ET_LOCK_BASE;
	dp->sys = 0;
	dp->usr = gf->radar_event_user_arg;
	dp->event_func = gf->radar_event;
	if ( dp->event_func )
		new_tick((void(*)(int))__call_radar_event_func,0,(int)dp);
	else d_f_ree(dp);
}


typedef struct cb_arg {
	int	d_type;
	void	(*d_event)(struct gbview_flame*,int,void*,void*);
	void *	d_arg;
	GBVIEW_FLAME * gf;
} CB_ARG;

void __call_flame_event(CB_ARG * a);

void
__call_flame_event(CB_ARG * a)
{
//	wf_unlock(a->gf);
	(*a->d_event)(a->gf,a->d_type,0,a->d_arg);
//	wf_lock(a->gf);
	d_f_ree(a);
}

void
_call_flame_change_base_event(GBVIEW_FLAME * gf)
{
CB_ARG * a;
	a = d_alloc(sizeof(*a));
	a->gf = gf;
	a->d_event = gf->event;
	a->d_arg = gf->event_user_arg;
	a->d_type = ET_CHANGE_BASE;
	if ( a->d_event ) {
		new_tick((void(*)(int))__call_flame_event,0,(int)a);
	}
	else {
		d_f_ree(a);
	}
}


void
call_flame_change_base_event(GBVIEW_FLAME * gf)
{
	wf_lock(gf);
	_call_flame_change_base_event(gf);
	wf_unlock(gf);
}

void
_call_flame_insert_event(GBVIEW_FLAME * gf)
{
/*
void	(*d_event)(struct gbview_flame*,int,void*,void*);
void *	d_arg;

	d_event = gf->event;
	d_arg = gf->event_user_arg;
	wf_unlock(gf);
	if ( d_event )
		(*d_event)(gf,ET_INSERT,0,d_arg);
	wf_lock(gf);
*/

CB_ARG * a;
	a = d_alloc(sizeof(*a));
	a->gf = gf;
	a->d_event = gf->event;
	a->d_arg = gf->event_user_arg;
	a->d_type = ET_INSERT;
	if ( a->d_event ) {
		new_tick((void(*)(int))__call_flame_event,0,(int)a);
	}
	else {
		d_f_ree(a);
	}
}

void
call_flame_insert_event(GBVIEW_FLAME * gf)
{
	wf_lock(gf);
	_call_flame_insert_event(gf);
	wf_unlock(gf);
}

void
call_flame_status_event(GBVIEW_FLAME * gf)
{
void (*event)(struct gbview_flame*,int,void*,void*);
void *arg;
	wf_lock(gf);
	event = gf->event;
	arg = gf->event_user_arg;
	wf_unlock(gf);
	if ( event )
		(*event)(gf,ET_STATUS,0,arg);
}

void
insert_redraw_r(GBVIEW_FLAME * gf,VRECT * r)
{


	if ( gf->redraw_r.tl.x >= gf->redraw_r.br.x ||
			gf->redraw_r.tl.y >= gf->redraw_r.br.y ) {
		gf->redraw_r = *r;
		return;
	}
	if ( gf->redraw_r.tl.x > r->tl.x )
		gf->redraw_r.tl.x = r->tl.x;
	if ( gf->redraw_r.tl.y > r->tl.y )
		gf->redraw_r.tl.y = r->tl.y;
	if ( gf->redraw_r.br.x < r->br.x )
		gf->redraw_r.br.x = r->br.x;
	if ( gf->redraw_r.br.y < r->br.y )
		gf->redraw_r.br.y = r->br.y;
	if ( gf->redraw_r.tl.x < 0 )
		gf->redraw_r.tl.x = 0;
	if ( gf->redraw_r.tl.y < 0 )
		gf->redraw_r.tl.y = 0;
	if ( gf->redraw_r.br.x >= gf->win_width )
		gf->redraw_r.br.x = gf->win_width;
	if ( gf->redraw_r.br.y >= gf->win_height )
		gf->redraw_r.br.y = gf->win_height;
/*
ss_printf("IRR %i %i %i %i\n",
gf->redraw_r.tl.x,
gf->redraw_r.tl.y,
gf->redraw_r.br.x,
gf->redraw_r.br.y);
*/
}

void
insert_redraw_gbr(GBVIEW_FLAME * gf,GB_RECT * r)
{
I_RECT rr;
	rr.tl.x = r->tl.x;
	rr.tl.y = r->tl.y;
	rr.br.x = r->br.x;
	rr.br.y = r->br.y;
	insert_redraw_r(gf,&rr);
}


void
insert_vrect(I_RECT * v,int x,int y)
{
	if ( v->tl.x >= v->br.x ) {
		v->tl.x = x;
		v->br.x = x+1;
		v->tl.y = y;
		v->br.y = y+1;
		return;
	}
	if ( v->tl.x > x )
		v->tl.x = x;
	if ( v->br.x <= x )
		v->br.x = x+1;
	if ( v->tl.y > y )
		v->tl.y = y;
	if ( v->br.y <= y )
		v->br.y = y+1;
}

void
xx_set_redraw_rect(GBVIEW_FLAME * gf,GB_RECT *r,char * __f,int __l)
{
int xx,yy;
int xmax,ymax;
int xmin,ymin;
I_RECT rr;

	if ( r->tl.x >= gf->win_width )
		return;
	if ( r->tl.y >= gf->win_height )
		return;

//ss_printf("SR %s::%i\n",__f,__l);

	if ( r->tl.x < 0 )
		xmin = 0;
	else	xmin = r->tl.x;
	if ( r->tl.y < 0 )
		ymin = 0;
	else	ymin = r->tl.y;
	if ( r->br.x >= gf->win_width )
		xmax = gf->win_width;
	else	xmax = r->br.x;
	if ( r->br.y >= gf->win_height )
		ymax = gf->win_height;
	else	ymax = r->br.y;

	rr.tl.x = xmin;
	rr.tl.y = ymin;
	rr.br.x = xmax;
	rr.br.y = ymax;
	insert_redraw_r(gf,&rr);
	for ( xx = xmin ; xx < xmax ; xx ++ )
		for ( yy = ymin ; yy < ymax ; yy ++ )
			gf->redraw[xx + gf->win_width*yy] = RP_REDRAW;
//	_wf_set_delay_redraw(gf);
	new_tick((void(*)(int))_wf_set_redraw,0,(int)gf);
}

int
get_mov_flag(GBVIEW_FLAME * gf,WF_ID wfid)
{
WIN_FLAME * wf;
int ret;
	wf_lock(gf);
	wf = _get_wf_ptr(gf,wfid);
	if ( wf == 0 ) {
		ret = -1;
	}
	else if ( wf->mov_flag ) {
		ret = 1;
	}
	else	ret = 0;
	wf_unlock(gf);
	return ret;
}


int
wf_insert_si(
	GBVIEW_FLAME * gf,
	int		cmd,
	WF_ID		wfid,
	int 		rno,
	int		code,
	int		sub,
	GB_RECT * 	rect,
	unsigned int *	data,
	unsigned char *	alpha,
	int		flags,
	L_CHAR * 	ref)
{
SYMBOL_INDICATE * si;
int ret;
WIN_FLAME * wf;
int df;

	if ( wfid == 0 )
		return 0;
	wf_lock(gf);


	wf = _get_wf_ptr(gf,wfid);
	if ( wf == 0 ) {
		wf_unlock(gf);
		return 0;
	}
	for ( si = wf->sym_i ; si ; si = si->next ) {
		if ( si->rno != rno || si->code != code ||
			si->sub != sub )
			continue;
		ret = 1;
		if ( cmd == ISI_INFO )
			goto end;
		df = 0;
		if ( rect ) {
			if ( si->rect.tl.x != rect->tl.x )
				df = 1;
			if ( si->rect.tl.y != rect->tl.y )
				df = 1;
			if ( si->rect.br.x != rect->br.x )
				df = 1;
			if ( si->rect.br.y != rect->br.y )
				df = 1;
			si->rect = *rect;
		}
		if ( df )
			set_redraw_rect(gf,&si->rect);
		if ( data ) {
			if ( si->data )
				d_f_ree(si->data);
			si->data = data;
		}
		if ( alpha ) {
			if ( si->alpha )
				d_f_ree(si->alpha);
			si->alpha = alpha;
		}
		si->flags |= SIF_DRAW|SIF_NEW|flags;
		goto end;
	}
	ret = 0;
	if ( cmd == ISI_INFO )
		goto end2;
	si = d_alloc(sizeof(*si));
	si->rno = rno;
	si->code = code;
	si->sub = sub;
	si->flags = SIF_DRAW|SIF_NEW|flags;
	si->rect = *rect;
	si->data = data;
	si->alpha = alpha;
	if ( ref )
		si->ref = ll_copy_str(ref);
	else	si->ref = 0;
	si->next = wf->sym_i;
	wf->sym_i = si;
	set_redraw_rect(gf,&si->rect);

end:
	switch ( cmd ) {
	case ISI_INSERT:
		break;
	case ISI_INFO:
		if ( rect )
			*rect = si->rect;
		break;
	}
end2:

	wf_unlock(gf);
	return ret;
}

int
wf_space_check_si(
	GBVIEW_FLAME * 	gf,
	WF_ID		wfid,
	int 		rno,
	int		code,
	int		sub,
	GB_RECT * 	rect,
	int		percent)
{
SYMBOL_INDICATE * si;
int ret;
REAL1 surf1,surf2;
REAL1 x,y,x_max,y_max,xx,yy;
WIN_FLAME * wf;

	x_max = rect->br.x - rect->tl.x;
	y_max = rect->br.y - rect->tl.y;
	surf1 = x_max*y_max;

	wf_lock(gf);


	wf = _get_wf_ptr(gf,wfid);
	if ( wf == 0 ) {
		ret = -1;
		goto end;
	}
	ret = -1;
	for ( si = wf->sym_i ; si ; si = si->next ) {
		if ( si->rno == rno && si->code == code &&
			si->sub == sub )
			continue;
		if ( cross_rect_rect(rect,&si->rect) == 0 )
			continue;
		x = x_max;
		xx = rect->br.x - si->rect.tl.x;
		if ( xx < x )
			x = xx;
		xx = si->rect.br.x - rect->tl.x;
		if ( xx < x )
			x = xx;
		y = y_max;
		yy = rect->br.y - si->rect.tl.y;
		if ( yy < y )
			y = yy;
		yy = si->rect.br.y - rect->tl.y;
		if ( yy < y )
			y = yy;
		if ( x*y*100 >= percent*surf1 )
			goto end;
		surf2 = (si->rect.br.x - si->rect.tl.x)*
			(si->rect.br.y - si->rect.tl.y);
		if ( x*y*100 >= percent*surf2 )
			goto end;
	}
	ret = 0;
end:
	wf_unlock(gf);
	return ret;
}

void
regulate_si(WIN_FLAME * wf)
{
SYMBOL_INDICATE * si;
	for ( si = wf->sym_i ; si ; si = si->next ) {
		if ( !(si->flags & SIF_NEW) )
			continue;
		si->flags &= ~SIF_NEW;
		si->rect.tl.x += wf->mov_x;
		si->rect.tl.y += wf->mov_y;
		si->rect.br.x += wf->mov_x;
		si->rect.br.y += wf->mov_y;
	}
}


void
_wf_redraw_si(
	GBVIEW_FLAME * gf,
	WIN_FLAME * wf,int ow,int oh,
	int tl_x,int tl_y,int br_x,int br_y)
{
SYMBOL_INDICATE * si;
int x,y,i;
unsigned int cc,cc1,cc2,cc3,cc4,cc5;
int j;
unsigned char alpha;

#define SET_ALPHA(label) \
if ( si->alpha ) {			\
	alpha = si->alpha[i];		\
	switch ( alpha ) {		\
	case 255:			\
		continue;		\
	case 0:				\
		goto label;		\
	}				\
	cc1 = gf->redraw_plane[y*ow+x];			\
	if ( cc1 == C_TRANSPARENT )			\
		cc1 = C_COLOR;				\
	cc5 = 0;						\
	for ( j = 0 ; j < 3 ; j ++ ) {				\
		cc2 = (cc>>(COL_BIT*j))&COL_MASK;		\
		cc3 = (cc1>>(COL_BIT*j))&COL_MASK;		\
		cc4 = (cc2*(256-alpha) + cc3*(alpha))>>8;	\
		cc5 |= cc4<<(COL_BIT*j);			\
	}							\
	cc = cc5;						\
}

	for ( si = wf->sym_i ; si ; si = si->next ) {
		if ( si->data == 0 || si->rect.tl.x == si->rect.br.x ||
					si->rect.tl.y == si->rect.br.y )
				continue;
/*
		if ( (si->flags & SIF_DRAW) ) {
			si->flags &= ~SIF_DRAW;
			i = 0;

			for ( y = si->rect.tl.y ; y < si->rect.br.y ; y ++ )
				for ( x = si->rect.tl.x ; x < si->rect.br.x ; 
						i ++ , x ++ ) {
					if ( x < 0 )
						continue;
					if ( y < 0 )
						continue;
					if ( x >= ow )
						continue;
					if ( y >= oh )
						continue;
					cc = si->data[i];
					if ( cc == C_TRANSPARENT )
						continue;
					if ( (gf->redraw[y*ow+x]&
						(RP_REDRAW|RP_DIRTY))
						== 0  )
						continue;
					SET_ALPHA(next1);
				next1:
					gf->redraw_plane[y*ow+x] = cc;
				}
			continue;
		}
*/
		if ( si->rect.tl.x >= br_x )
			continue;
		if ( si->rect.tl.y >= br_y )
			continue;
		if ( si->rect.br.x < tl_x )
			continue;
		if ( si->rect.br.y < tl_y )
			continue;
		si->flags &= ~SIF_DRAW;
		i = 0;
		for ( y = si->rect.tl.y ; y < si->rect.br.y ; y ++ )
			for ( x = si->rect.tl.x ; x < si->rect.br.x ; 
					i ++ , x ++ ) {
				if ( x < tl_x )
					continue;
				if ( y < tl_y )
					continue;
				if ( x >= br_x )
					continue;
				if ( y >= br_y )
					continue;
				cc = si->data[i];
				if ( cc == C_TRANSPARENT )
					continue;
				if ( (gf->redraw[y*ow+x] &
					(RP_REDRAW|RP_DIRTY)) == 0 )
					continue;
				SET_ALPHA(next2);
			next2:
				gf->redraw_plane[y*ow+x] = cc;
			}
	}
}

void
wf_redraw_si(GBVIEW_FLAME * gf,int x,int y,int w,int h)
{
WIN_FLAME * wf;
int ow,oh;

	ow = gf->win_width;
	oh = gf->win_height;
	for ( wf = gf->flame ; wf ; wf = wf->next ) {
		if ( wf->flags & (WFF_FREE|WFF_HIDE) )
			continue;
		_wf_redraw_si(gf,wf,ow,oh,x,y,x+w,y+h);
	}
}


GBVIEW_PLOT_ELEMENT * 
_wf_plot_element(GBVIEW_FLAME * gf,WF_ID id)
{
GBVIEW_PLOT_ELEMENT * ret,* _ret;
WIN_FLAME * wf;
SYMBOL_INDICATE * si;
GB_RECT r;
	_ret = 0;
	for ( wf = gf->flame ; wf ; wf = wf->next ) {
		if( wf->flags & (WFF_FREE|WFF_HIDE) )
			continue;
		if ( id && wf->id != id )
			continue;
		for ( si = wf->sym_i ; si ; si = si->next ) {
			r = si->rect;
			if ( r.br.x <= 0 )
				continue;
			if ( r.br.y <= 0 )
				continue;
			if ( r.tl.x >= gf->win_width )
				continue;
			if ( r.tl.y >= gf->win_height )
				continue;
			if ( r.tl.x < 0 )
				r.tl.x = 0;
			if ( r.tl.y < 0 )
				r.tl.y = 0;
			if ( r.br.x > gf->win_width )
				r.br.x = gf->win_width;
			if ( r.br.y > gf->win_height )
				r.br.y = gf->win_height;

			if ( r.tl.x >= r.br.x )
				continue;
			if ( r.tl.y >= r.br.y )
				continue;

			ret = d_alloc(sizeof(*ret));
			ret->rect = r;
			if ( si->ref )
				ret->ref = ll_copy_str(si->ref);
			else	ret->ref = 0;
			ret->code = si->code;
			ret->sub = si->sub;
			ret->rno = si->rno;
			ret->next = _ret;
			_ret = ret;
		}
	}
	return _ret;
}

GBVIEW_PLOT_ELEMENT * 
wf_plot_element(GBVIEW_FLAME * gf,WF_ID id)
{
GBVIEW_PLOT_ELEMENT * ret;
	wf_lock(gf);
	ZONBIE_CHECK(gf,wf_unlock(gf),0)
	ret = _wf_plot_element(gf,id);
	wf_unlock(gf);
	return ret;
}

GBVIEW_PLOT_ELEMENT *
wf_all_plot_element(GBVIEW_FLAME * gf)
{
GBVIEW_PLOT_ELEMENT * ret, * _r,*_r2;
WIN_FLAME * wf;
	wf_lock(gf);
	ZONBIE_CHECK(gf,wf_unlock(gf),0)
	ret = 0;
	for ( wf = gf->flame ; wf ; wf = wf->next ) {
		if ( wf->flags & WFF_FREE )
			continue;
		_r = _wf_plot_element(gf,wf->id);
		if ( _r == 0 )
			continue;
		for ( _r2 = _r ; _r2->next ; _r2 = _r2->next );
		_r2->next = ret;
		ret = _r;
	}
	wf_unlock(gf);
	return ret;
}

void
_wf_wait_stable(int gf)
{
	wakeup_task((int)gf);
}

void
wf_wait_stable(GBVIEW_FLAME * gf)
{
WIN_FLAME * wf;
int pri;
	pri = push_pri(PRI_DRAW);
	for ( ; ; ) {
		wf_lock(gf);
		ZONBIE_CHECK_BREAK(gf,wf_unlock(gf));
		for ( wf = gf->flame ; wf ; wf = wf->next ) {
			if ( wf->flags & WFF_FREE )
				break;
		}
		wf_unlock(gf);
		if ( wf == 0 )
			break;
		new_tick(_wf_wait_stable,-1,(int)gf);
		sleep_task((int)gf,SEM_NULL);
	}
	change_pri(0,pri);
}

void
_xx_free_win_flame(GBVIEW_FLAME * gf,WIN_FLAME * wf,char * __file,int __line)
{

	_backup_wf_flags(gf,wf);
ss_printf("FREE %s(%i) %ls\n",__file,__line,get_url_str2(&wf->draw->h.entry));
	wf->flags |= WFF_FREE;
	wf_insert_action(gf,wf,WFF_HIDE);
	log_printf(LOG_MESSAGE,LOG_LAYER_GB,0,
		"FREE(%s:%i) %ls\n",
		__file,__line,
		get_url_str2(&wf->draw->h.entry));

//	_wakeup_at_exit_task_wp(gf);
	_wakeup_at_redraw_wp(gf);
	_call_flame_insert_event(gf);
	wakeup_hwf(gf,HWFF_TYPE_TO_FRAME);
}

void
wf_reset_active(GBVIEW_FLAME * gf)
{
WIN_FLAME * wf;
	wf_lock(gf);


	for ( wf = gf->flame ; wf ; wf = wf->next )
		wf->flags &= ~WFF_ACTIVE;
	wf_unlock(gf);
}

void
wf_free_nonactive(GBVIEW_FLAME * gf)
{
WIN_FLAME * wf;
	wf_lock(gf);


	for ( wf = gf->flame ; wf ; wf = wf->next ) {
		if ( !(wf->flags & WFF_ACTIVE) )
			_free_win_flame(gf,wf);
	}
	wf_unlock(gf);
}

void
xx_free_win_flame(GBVIEW_FLAME * gf,WF_ID wfid,char * __file,int __line)
{
WIN_FLAME * wf;
int pri;
	pri = push_pri(PRI_DRAW);
	wf_lock(gf);

	wf = _get_wf_ptr(gf,wfid);
	if ( wf == 0 ) {
		wf_unlock(gf);
		return;
	}
	_xx_free_win_flame(gf,wf,__file,__line);
	wf_unlock(gf);
	change_pri(0,pri);
}


void
_wf_auth_information(void * w)
{
void	(*d_event)(struct gbview_flame*,int,void*,void*);
void *	d_arg;
GV_AUTH_INFO * ai;
GBVIEW_FLAME * gf;

	ai = (GV_AUTH_INFO*)w;
	gf = ai->gf;
	wf_lock(gf);
	d_event = gf->event;
	d_arg = gf->event_user_arg;
	wf_unlock(gf);
	if ( d_event )
		(*d_event)(gf,ET_AUTH,ai,d_arg);
	d_f_ree(ai);
}

void
wf_auth_information(RESOURCE * r)
{
WFID_INCLUDE_RESOURCE * wir,* wirp;
GV_AUTH_INFO * ai;
	wir = wf_search_wfid_include_resource(r);
	for (wirp = wir ; wirp ; wirp = wirp->next ) {
		ai = d_alloc(sizeof(*ai));
		ai->id = wirp->id;
		ai->r = r;
		ai->gf = wirp->gf;
		new_tick((void(*)(int))_wf_auth_information,0,(int)ai);
	}
	free_wfid_include_resource(wir);
}

void
_wf_flame_redraw(GBVIEW_FLAME * gf)
{
int i;
I_RECT rr;
	rr.tl.x = rr.tl.y = 0;
	rr.br.x = gf->win_width;
	rr.br.y = gf->win_height;
	insert_redraw_r(gf,&rr);
	for ( i = 0 ; i < gf->win_height*gf->win_width ; i ++ )
		gf->redraw[i] = RP_REDRAW;
//	_wf_set_delay_redraw(gf);
	new_tick((void(*)(int))_wf_set_redraw,0,(int)gf);
}


void
_wf_set_redraw(GBVIEW_FLAME * gf)
{
void	(*d_event)(struct gbview_flame*,int,void*,void*);
void *	d_arg;

	wf_lock(gf);
	d_event = gf->event;
	d_arg = gf->event_user_arg;
	wf_unlock(gf);
	if ( d_event )
		(*d_event)(gf,ET_REDRAW,0,d_arg);
}

void
_wf_set_delay_redraw_flag(GBVIEW_FLAME * gf,int fg)
{
	gf->redraw_delay_flag = fg;
	_wf_set_delay_redraw_exec(gf);
}

void
wf_set_delay_redraw_flag(GBVIEW_FLAME * gf,int fg)
{
	wf_lock(gf);
	_wf_set_delay_redraw_flag(gf,fg);
	wf_unlock(gf);
}

void
_wf_set_delay_redraw(GBVIEW_FLAME * gf)
{
	if ( gf->redraw_delay_flag ) {
		gf->redraw_flag = 1;
	}
	else {
		new_tick((void(*)(int))_wf_set_redraw,0,(int)gf);
	}
}

void
wf_set_delay_redraw(GBVIEW_FLAME * gf)
{
	wf_lock(gf);
	_wf_set_delay_redraw(gf);
	wf_unlock(gf);
}

void
_wf_set_delay_redraw_exec(GBVIEW_FLAME * gf)
{
	if ( gf->redraw_flag ) {
		gf->redraw_flag = 0;
ss_printf("_wf_set_delay_redraw_exec\n");
		new_tick((void(*)(int))_wf_set_redraw,0,(int)gf);
	}
}


void
wf_set_delay_redraw_exec(GBVIEW_FLAME * gf)
{
	wf_lock(gf);
	_wf_set_delay_redraw_exec(gf);
	wf_unlock(gf);
}



WIN_FLAME *
_wf_get_current(GBVIEW_FLAME * gf)
{
	return gf->flame_base;
}

WF_ID
wf_get_current(GBVIEW_FLAME * gf)
{
WF_ID ret;
WIN_FLAME * wf;
int pri;
	pri = push_pri(PRI_DRAW);
	wf_lock(gf);
	ZONBIE_CHECK(gf,(wf_unlock(gf),change_pri(0,pri)),0)
	wf = _wf_get_current(gf);

	if ( wf )
		ret = wf->id;
	else	ret = 0;
	wf_unlock(gf);
	change_pri(0,pri);
	return ret;
}

void
adjust_point(GB_POINT *_pt)
{
GB_POINT pt;
	pt = *_pt;
	for ( ; pt.y > 3.0/2*M_PI ; pt.y -= 2*M_PI );
	for ( ; pt.y < -M_PI/2 ; pt.y += 2*M_PI );
	if ( pt.y > M_PI ) {
		pt.y = - pt.y + M_PI;
		pt.x += M_PI;
	}
	else if ( pt.y > M_PI/2 ) {
		pt.y = M_PI - pt.y;
		pt.x += M_PI;
	}
	*_pt = pt;
}

void
get_rr_param2(REAL1 * reso,REAL1 * rotate,GB_POINT center1,GB_POINT center2,REAL1 d,RESOURCE * r)
{
double d_cita,d_phi;
int er;
double b;
double _rotate;

double aa;

	center1.x = conv_unit(&er,r->h.cu.uenv,center1.x,r->h.cu.unit,l_string(std_cm,"rad"));
	center1.y = conv_unit(&er,r->h.cu.uenv,center1.y,r->h.cu.unit,l_string(std_cm,"rad"));
	center2.x = conv_unit(&er,r->h.cu.uenv,center2.x,r->h.cu.unit,l_string(std_cm,"rad"));
	center2.y = conv_unit(&er,r->h.cu.uenv,center2.y,r->h.cu.unit,l_string(std_cm,"rad"));

	adjust_point(&center1);
	adjust_point(&center2);

	d_cita = center2.x - center1.x;
	d_phi = center2.y - center1.y;

	aa = (cos(center1.y)*cos(center2.y)*cos(d_cita) + sin(center1.y)*sin(center2.y));
	if ( aa > 1 )
		b = 0;
	else if ( aa < -1 )
		b = M_PI;
	else	b = acos(aa);
	
	if ( b == 0 )
		_rotate = M_PI/2;
	else {
		_rotate = cos(center2.y)*sin(d_cita)/sin(b);
		if ( _rotate > 1 )
			_rotate = 0;
		else if ( _rotate < -1 )
			_rotate = M_PI;
		else	_rotate = acos(_rotate);
ss_printf("ROTATE %f - %f %f %f\n",_rotate,d_phi,d_cita,b);
		if ( d_phi < 0 )
			_rotate = - _rotate;
	}

	*rotate = _rotate;
	*reso = conv_unit(&er,r->h.cu.uenv,d/b,l_string(std_cm,"dot/rad"),reso_c_unit(&r->h.cu));

}


void
get_rr_param(REAL1 * reso,REAL1 * rotate,GB_POINT center1,GB_POINT center2,REAL1 d,RESOURCE * r)
{
double d_cita,d_phi,phi;
double param1,param2;
double a;
double sin_alpha,cos_alpha;
double pat1,pat2;
int er;
double rt;
	center1.x = conv_unit(&er,r->h.cu.uenv,center1.x,r->h.cu.unit,l_string(std_cm,"rad"));
	center1.y = conv_unit(&er,r->h.cu.uenv,center1.y,r->h.cu.unit,l_string(std_cm,"rad"));
	center2.x = conv_unit(&er,r->h.cu.uenv,center2.x,r->h.cu.unit,l_string(std_cm,"rad"));
	center2.y = conv_unit(&er,r->h.cu.uenv,center2.y,r->h.cu.unit,l_string(std_cm,"rad"));
	phi = center1.y;
	d_cita = center2.x - center1.x;
	d_phi = center2.y - center1.y;
	for ( ; d_cita > M_PI ; d_cita -= 2*M_PI );
	for ( ; d_cita < -M_PI ; d_cita += 2*M_PI );
	param1 = cos(phi) * d_cita;
	param2 = d_phi;
	
	if ( param1 == 0 && param2 == 0 ) {
		*reso = -1;
	}
	else if ( fabs(param1) < fabs(param2) ) {
		a = param1/param2;
		sin_alpha = 1/sqrt(1+a*a);
		pat1 = fabs(d*sin_alpha/param2);
		rt = atan(a);
		if ( rt < 0 )
			*rotate = - M_PI/2 - rt;
		else	*rotate = M_PI/2 - rt;

		*reso = conv_unit(&er,r->h.cu.uenv,pat1,l_string(std_cm,"dot/rad"),reso_c_unit(&r->h.cu));
	}
	else  {
		a = param2/param1;
		cos_alpha = 1/sqrt(1+a*a);
		pat2 = fabs(d*cos_alpha/param1);
		
		*rotate = atan(a);

		*reso = conv_unit(&er,r->h.cu.uenv,pat2,l_string(std_cm,"dot/rad"),reso_c_unit(&r->h.cu));
	}

}


int
_wf_set_current(GBVIEW_FLAME * gf,WIN_FLAME * now,WIN_FLAME * target)
{
WIN_FLAME * c, * wf, * before;
MAP_HISTORY * base, * mh;
GB_POINT center,_center[3];
REAL1 reso,_reso[3];
REAL1 rotate;
int i;
REAL1 d,dd;
GB_POINT pp1,pp2;
REAL1 s;
unsigned int now_t;
int r_f;
	if ( gf->flame == 0 )
		return 0;

	if ( now && gf->flame == now && now->next == 0 ) {
		return 0;
	}
	if ( target && target == gf->flame_base )
		return 1;
	c = 0;
	now_t = get_xltime();
	_calc_pitch(gf,0); 
	for ( wf = gf->flame ; wf ; wf = wf->next ) {
		if ( wf == gf->flame_base )
			continue;
		if ( wf == now )
			continue;
		if ( wf->flags & WFF_FREE )
			continue;
		if ( target && wf != target )
			continue;
		if ( target == 0 && now_t - wf->out_base_time <
					CURRENT_SWITCH_TIMERAG )
			continue;
			
		d = gf->win_width/2;
		r_f = 0;
	retry:
		_center[0].y = _center[1].y = _center[2].y
				= gf->win_height/2;
		_center[0].x = gf->win_width/2;
		_center[1].x = gf->win_width/2 + d;
		_center[2].x = gf->win_width/2 - d;
		_reso[0] = _reso[1] = _reso[2] = 1;
		map_from_flame(&gf->flame_base_display_map,_center,_reso,3);
		map_from_flame(wf->mh,_center,_reso,3);
		if ( _reso[0] < 0 )
			continue;
		if ( _reso[1] >= 0 ) {
			i = 1;
			if ( r_f == 0 && (wf->draw->c.geometory_type & GT_T_MASK) == GT_T_GLOBE_SUR ) {
				d = d/4;
				r_f = 1;
				goto retry;
			}
			pp1.x = d;
			pp1.y = 0;
		}
		else if ( _reso[2] >= 0 ) {
			i = 2;
			if ( r_f == 0 && (wf->draw->c.geometory_type & GT_T_MASK) == GT_T_GLOBE_SUR ) {
				d = d/4;
				r_f = 1;
				goto retry;
			}
			pp1.x = -d;
			pp1.y = 0;
		}
		else {
			d *= 0.5;
			goto retry;
		}
		c = wf;
		center = _center[0];
		if ( (wf->draw->c.geometory_type & GT_T_MASK) == GT_T_GLOBE_SUR ) {
			get_rr_param2(&reso,&rotate,_center[0],_center[i],d,wf->draw);
ss_printf("RESO %f %f\n",gf->flame_base_resolution,reso);
			if ( reso < 0 ) {
				reso = gf->flame_base_resolution;
				dd = distance(_center[i],_center[0]);
				if ( dd == 0 ) {
					d *= 1.2;
					goto retry;
				}
				pp2 = p_sub(_center[i],_center[0]);
				s = asin(pp2.y / dd);
				if ( pp2.x > 0 )
					rotate = -s;
				else if ( pp2.y > 0 )
					rotate = - M_PI + s;
				else	rotate = M_PI + s;
			}
			switch ( wf->draw->c.geometory_type & GT_A_MASK ) {
			case GT_A_X_FOR|GT_A_Y_FOR:
			case GT_A_X_REV|GT_A_Y_REV:
				break;
			default:
				rotate = - rotate;
			}
		}
		else {
			dd = distance(_center[i],_center[0]);
			if ( dd == 0 ) {
				d *= 1.2;
				goto retry;
			}
			pp2 = p_sub(_center[i],_center[0]);
			s = asin(pp2.y / dd);
			if ( pp2.x > 0 )
				rotate = -s;
			else if ( pp2.y > 0 )
				rotate = - M_PI + s;
			else	rotate = M_PI + s;
			switch ( wf->draw->c.geometory_type & GT_A_MASK ) {
			case GT_A_X_FOR|GT_A_Y_FOR:
			case GT_A_X_REV|GT_A_Y_REV:
				rotate = - rotate;
			}
			reso = d / dd;
		}
log_printf(LOG_MESSAGE,LOG_LAYER_GB,0,
"*********SET  %f %f %f %f %f\n",reso,center.x,center.y,gf->flame_base_rotate,rotate);
	}
	if ( c == 0 )
		return 0;
	if ( gf->flame_base == c )
		er_panic("wf_set_current");
	base = rev_mh(c->mh);
	for ( wf = gf->flame ; wf ; wf = wf->next ) {
		if ( wf == c ) {
			free_mh(c->mh);
			c->mh = 0;
			c->flags &= ~WFF_SHORT_MH;
		}
		else {
			mh = add_mh(base,wf->mh);
			mh = optimize_mh(mh);
			free_mh(wf->mh);
			wf->mh = mh;
			c->flags |= WFF_SHORT_MH;
		}
		_win_flame_dirty(gf,wf,0,WFF_DIRTY,0);
	}

	if ( gf->flame_base )
		gf->flame_base->out_base_time = now_t;
	before = gf->flame_base;
	gf->flame_base = c;
log_printf(LOG_MESSAGE,LOG_LAYER_GB,0,
"***********SET_CUR %ls\n",get_url_str2(&gf->flame_base->draw->h.entry));
	gf->flame_base_center = center;
	gf->flame_base_rotate = rotate;
	gf->flame_base_resolution = reso;
	c->in_base_time = now_t;
	_calc_pitch(gf,1);
	free_mh(base);
	if ( before != gf->flame_base )
		_call_flame_change_base_event(gf);
	return 1;
}

int
wf_set_current(GBVIEW_FLAME * gf)
{
int ret;

	wf_lock(gf);


	ret = _wf_set_current(gf,0,0);
	wf_unlock(gf);
	return ret;
}

int
wf_set_current_now(GBVIEW_FLAME * gf,WF_ID n)
{
int ret;
WIN_FLAME * now;
	wf_lock(gf);
	ZONBIE_CHECK(gf,wf_unlock(gf),0);
	now = _get_wf_ptr(gf,n);
	ret = _wf_set_current(gf,now,0);
	wf_unlock(gf);
	return ret;
}


int
wf_set_current_target(GBVIEW_FLAME * gf,WF_ID id)
{
int ret;
WIN_FLAME * wf;
	wf_lock(gf);
	ZONBIE_CHECK(gf,wf_unlock(gf),0);
	wf = _get_wf_ptr(gf,id);
	if ( wf )
		ret = _wf_set_current(gf,0,wf);
	else	ret = -1;
	wf_unlock(gf);
	return ret;
}


void
xx_wf_wakeup(GBVIEW_FLAME * gf,char * __f,int __l)
{
WIN_FLAME * wf;
	wf_lock(gf);
	ZONBIE_CHECK_VOID(gf,wf_unlock(gf))
	for ( wf = gf->flame ; wf ; wf = wf->next ) {
		_xx_wakeup_wf(gf,wf,__f,__l);
	}
	wf_unlock(gf);
}

int
wf_move(GBVIEW_FLAME * gf,VPOINT from,VPOINT to)
{
int ret;

	wf_lock(gf);
	ZONBIE_CHECK(gf,wf_unlock(gf),0)
/*
	switch ( gf->flame_base_display_map.type ) {
	case 0:
		ret = 0;
		break;
	case MHT_LINEAR:
		ret = wf_move_xy(gf,from,to);
		break;
	case MHT_PP:
		ret = wf_move_globe(gf,from,to);
		break;
	default:
		er_panic("wf_move");
	}
*/
	ret = (*wf_geo_type_list[gf->flame_base_geo_type][WFT_GEN]->f_move)(gf,0,from,to,0);

	if ( gf->history_enable )
		gf->history_flag = 1;
//	_wf_set_delay_redraw(gf);
	wf_unlock(gf);
	new_tick((void(*)(int))_wf_set_redraw,0,(int)gf);
	wakeup_hwf(gf,HWFF_TYPE_TO_FRAME);
	return ret;
}



void
wf_get_coordinate_info(GBVIEW_FLAME * gf,L_CHAR ** name,int * rid,GB_POINT * ptr,int ptr_len)
{
WIN_FLAME * wf;
REAL1 * reso;
int i;
MAP_HISTORY * mh;
	wf_lock(gf);
	ZONBIE_CHECK_VOID(gf,wf_unlock(gf))

	for ( wf = gf->flame ; wf ; wf = wf->next ) {
		if ( wf->next == 0 )
			break;
	}
	if ( wf == 0 ) {
		*rid = 0;
		wf_unlock(gf);
		return;
	}
	reso = d_alloc(sizeof(REAL1)*ptr_len);
	for ( i = 0 ; i < ptr_len ; i ++ )
		reso[i] = 1;
	mh = add_mh(&gf->flame_base_display_map,wf->mh);

	map_from_flame(mh,ptr,reso,ptr_len);
	*name = get_url_str2(&gf->flame_base->draw->h.entry);
	*rid = gf->flame_base->draw->h.no;
	free_mh(mh);

	wf_unlock(gf);
}


void
wf_im_zoom_proc(
	unsigned long *target,
	int w,int h,
	int *index_x,
	int *index_y)
{
unsigned long *buf;
int x,y,xx,yy,i;
	buf = d_alloc(sizeof(long)*w*h);
	i = 0;
	for ( y = 0 ; y < h ; y ++ )
		for ( x = 0 ; x < w ; x ++ ) {
			xx = index_x[x];
			yy = index_y[y];
			if ( xx < 0 || yy < 0 )
				buf[i] = C_TRANSPARENT;
			else	buf[i] = target[xx + yy*w];
			buf[i] |= C_DIRTY;
			i ++;
		}
	for ( i = 0 ; i < h*w ; i ++ )
		target[i] = buf[i];
	d_f_ree(buf);
}

int
wf_zoom(GBVIEW_FLAME * gf,GBVIEW_PLANE * p,REAL1 zoom)
{
WIN_FLAME * wf;
int i;
int ow,oh;
int * index_x, * index_y;
int len;
int ret;
VRECT rr;

	wf_lock(gf);
	ZONBIE_CHECK(gf,wf_unlock(gf),0);

	gf->flame_base_resolution *= zoom;

	ow = gf->win_width;
	oh = gf->win_height;
	index_x = d_alloc(sizeof(int)*ow);
	index_y = d_alloc(sizeof(int)*oh);
	wf_make_zoom_index(index_x,index_y,zoom,ow,oh);
	for ( wf = gf->flame ; wf ; wf = wf->next ) {
		if ( wf->flags & WFF_FREE )
			continue;
		win_flame_zoom(gf,wf,ow,oh,index_x,index_y);
		wf->mov_flag = 1;
		_wakeup_wf(gf,wf);
	}
/*
	wf_im_zoom_proc(gf->redraw_plane,ow,oh,index_x,index_y);
*/
	(*wf_geo_type_list[gf->flame_base_geo_type][WFT_GEN]->f_zoom)(gf,0,ow,oh,index_x,index_y);

	_calc_pitch(gf,0);

	len = gf->win_width*gf->win_height;
	for ( i = 0 ; i < len ; i ++ )
		gf->redraw[i] = RP_DIRTY|RP_REDRAW;
	rr.tl.x = rr.tl.y = 0;
	rr.br.x = gf->win_width;
	rr.br.y = gf->win_height;
	insert_redraw_r(gf,&rr);

	ret = _get_env_seq(gf);
	gf->move_flag = 1;
	if ( gf->history_enable )
		gf->history_flag = 1;
//	_wf_set_delay_redraw(gf);
	wf_unlock(gf);
	assert_ls(gf,LSF_ZOOM);
	_set_move_timer(gf);
	_wakeup_win_manage(gf->radar_ptr);

	if ( p ) {
		p->h.type = GPT_ZOOM;
		p->h.seq = ret;
		p->z.index_x = index_x;
		p->z.index_y = index_y;
	} else {
		d_f_ree(index_x);
		d_f_ree(index_y);
	}
	new_tick((void(*)(int))_wf_set_redraw,0,(int)gf);
	wakeup_hwf(gf,HWFF_TYPE_TO_FRAME);
	return ret;
}


unsigned long *
wf_get_resize_data(unsigned long * src,int old_w,int old_h,int w,int h,unsigned long dirty)
{
int y,x;
int xx;
int h_ofs,w_ofs;
int y_ofs;
unsigned long * pixels,*dest;


	h_ofs = (h - old_h)/2;
	w_ofs = (w - old_w)/2;
	pixels = d_alloc(w*h*sizeof(long));

	dest = pixels;
	if ( h_ofs + old_h < h ) {
		for ( y = 0 ; y < h_ofs ; y ++ )
			for ( x = 0 ; x < w ; x ++ )
				*dest++ = C_TRANSPARENT|dirty;
		for ( ; y < h_ofs + old_h ; y ++ ) {
			y_ofs = (y-h_ofs)*old_w;
			for ( x = 0 ; x < w ; x ++ , dest ++ ) {
				xx = x - w_ofs;
				if ( xx < 0 )
					*dest = C_TRANSPARENT|dirty;
				else if ( xx >= old_w )
					*dest = C_TRANSPARENT|dirty;
				else {
					*dest = src[y_ofs + xx];
				}
			}
		}
		for ( ; y < h ; y ++ )
			for ( x = 0 ; x < w ; x ++ )
				*dest ++ = C_TRANSPARENT|dirty;
	}
	else {
		for ( y = 0 ; y < h ; y ++ ) {
			y_ofs = (y-h_ofs)*old_w;
			for ( x = 0 ; x < w ; x ++ , dest ++ ) {
				xx = x - w_ofs;
				if ( xx < 0 )
					*dest = C_TRANSPARENT|dirty;
				else if ( xx >= old_w )
					*dest = C_TRANSPARENT|dirty;
				else {
					*dest = src[y_ofs + xx];
				}
			}
		}
	}
	return pixels;
}


void
_change_redraw(GBVIEW_FLAME * gf,int old_width,int old_height)
{
int w,h;
int i;
unsigned long * redraw_plane;
VRECT r;
	w = gf->win_width;
	h = gf->win_height;

	if ( gf->redraw_plane ) {
		redraw_plane = wf_get_resize_data(gf->redraw_plane,old_width,old_height,w,h,0);
		d_f_ree(gf->redraw_plane);
		gf->redraw_plane = redraw_plane;
	}
	else {
		gf->redraw_plane = d_alloc(sizeof(long)*w*h);
		for ( i = 0 ; i < w*h ; i ++ )
			gf->redraw_plane[i] = 0;
	}
	gf->redraw = d_re_alloc(gf->redraw,w*h);
	for ( i = 0 ; i < w*h ; i ++ )
		gf->redraw[i] = 0;
	r.tl.x = r.tl.y = 0;
	r.br.x = w;
	r.br.y = h;
	insert_redraw_r(gf,&r);
}

void
_wf_change_size(GBVIEW_FLAME * gf,int old_width,int old_height)
{
WIN_FLAME * wf;

	_ex_lock(gf);

	for ( wf = gf->flame ; wf ; wf = wf->next ) {
		win_flame_resize(gf,wf,old_width,old_height);
		wf->flags |= WFF_RESIZE;
		_wakeup_wf(gf,wf);
	}
	_calc_pitch(gf,1);
	_change_redraw(gf,old_width,old_height);

//	_wf_set_delay_redraw(gf);
	new_tick((void(*)(int))_wf_set_redraw,0,(int)gf);

	_ex_unlock(gf);
}


unsigned long
select_color(GBVIEW_FLAME * gf,unsigned long a,int x,int y)
{
SELECT_INDICATE * si;
unsigned long b,c1,c4;
int i;
	for ( si = gf->si ; si ; si = si->next ) {
		if ( x < si->x )
			continue;
		if ( y < si->y )
			continue;
		if ( x >= si->x + si->w )
			continue;
		if ( y >= si->y + si->h )
			continue;
		b = si->pixels[(y-si->y)*si->w + x-si->x];
		if ( b & C_TRANSPARENT )
			continue;
		if ( a & C_TRANSPARENT ) {
			a = b;
			continue;
		}
		if ( si->t == 1 ) {
			a = b;
			continue;
		}
		if ( si->t == 0 )
			continue;
		if ( a == b ) {
			c4 = 0;
			for ( i = 0 ; i < 3 ; i ++ ) {
				c1 = ((a>>(COL_BIT*i))&COL_MASK)/4
					+ 0x400*3/4;
				if ( c1 > 0x400 )
					c1 = 0x3ff;
				c4 |= (c1<<(COL_BIT*i))&
					(COL_MASK<<(COL_BIT*i));
			}
			a = c4;
		}
		else	a = b;
	}
	return a;
}


void
copy_plane(GBVIEW_FLAME * gf,GBVIEW_PLANE * p,unsigned long * plane)
{
unsigned long * sp, * dp;
int w,h;
int y_src,y_dest,y_max,x,x_ofs;

	w = p->r.r.br.x - p->r.r.tl.x;
	h = p->r.r.br.y - p->r.r.tl.y;

	p->r.plane = d_alloc(w*h*sizeof(unsigned long));

	y_max = p->r.r.br.y;
	y_dest = 0;
	x_ofs = p->r.r.tl.x;
	for ( y_src = p->r.r.tl.y ; y_src < y_max ; y_src ++ , y_dest ++ ) {
		sp = &plane[y_src*gf->win_width + x_ofs];
		dp = &p->r.plane[y_dest*w];
		for ( x = 0 ; x < w ; x ++ )
			*dp ++ = *sp ++;
	}
}


int
__wf_redraw(GBVIEW_FLAME * gf,GBVIEW_PLANE * p,int x,int y,int w,int h)
{
WIN_FLAME * wf;
int ow,oh;
int i,j;

I_RECT tar,rr;
int ix;
char * rp;
OV_ARG a;
int ret;

	p->r.plane = 0;
	p->r.r.tl.x = p->r.r.tl.y = 0;
	p->r.r.br.x = p->r.r.br.y = -1;

	ow = gf->win_width;
	oh = gf->win_height;

	if ( x < 0 ) {
		w = w + x;
		x = 0;
		if ( w <= 0 )
			return 0;
	}
	if ( x >= ow )
		return 0;
	if ( x + w >= ow )
		w = ow - x;

	if ( y < 0 ) {
		h = h + y;
		y = 0;
		if ( h <= 0 )
			return 0;
	}
	if ( y >= oh )
		return 0;
	if ( y + h >= oh )
		h = oh - y;

	tar = gf->redraw_r;
	if ( tar.tl.x < x )
		tar.tl.x = x;
	if ( tar.tl.y < y )
		tar.tl.y = y;
	if ( tar.br.x > x+w )
		tar.br.x = x+w;
	if ( tar.br.y > y+h )
		tar.br.y = y+h;
	x = tar.tl.x;
	y = tar.tl.y;
	w = tar.br.x - tar.tl.x;
	h = tar.br.y - tar.tl.y;

	p->h.type = GPT_REDRAW;
	p->h.seq = 0;
	if ( w <= 0 || h <= 0 ) {
		tar.tl.x = tar.br.x = 0;
		tar.tl.y = tar.br.y = 0;
		p->r.r = tar;
		p->r.plane = 0;
		return 0;
	}

	for ( i = 0 ; i < ow*oh ; i ++ ) {
		if ( gf->redraw[i] == 0 )
			continue;
		gf->redraw_plane[i] = C_TRANSPARENT;
	}

	a.redraw = gf->redraw;
	a.dest = gf->redraw_plane;
	a.d_h = oh;
	a.d_w = ow;
	a.d_x = x;
	a.d_y = y;
	a.d_x_w = w;
	a.d_y_h = h;


	for ( wf = gf->flame ; wf ; wf = wf->next ) {
		if ( wf->flags & (WFF_FREE|WFF_HIDE) )
			continue;
		win_flame_overlay(gf,wf,&a);

	}


	wf_redraw_si(gf,x,y,w,h);

	for ( i = y ; i < y+h ; i ++ ) {
		ix = i*ow+x;
		rp = &gf->redraw[ix];
		for ( j = 0 ; j < w ; j ++ )
			*rp ++ = 0;
	}

	rr = gf->redraw_r;
/*
ss_printf("RR %i %i %i %i = %i %i %i %i\n",
rr.tl.x,
rr.tl.y,
rr.br.x,
rr.br.y,
tar.tl.x,
tar.tl.y,
tar.br.x,
tar.br.y);
*/
	if ( tar.tl.x == rr.tl.x &&
			tar.tl.y == rr.tl.y &&
			tar.br.x == rr.br.x &&
			tar.br.y == rr.br.y ) {
		gf->redraw_r.tl.x = 0;
		gf->redraw_r.tl.y = 0;
		gf->redraw_r.br.x = gf->redraw_r.br.y = 0;
		goto last_handle;
	}
	if ( tar.tl.x == rr.tl.x && tar.tl.y == rr.tl.y &&
			tar.br.y == rr.br.y ) {
		gf->redraw_r.tl.x = tar.br.x;
		goto last_handle;
	}
	if ( tar.tl.y == rr.tl.y &&
			tar.br.x == rr.br.x &&
			tar.br.y == rr.br.y ) {
		gf->redraw_r.br.x = tar.tl.x;
		goto last_handle;
	}
	if ( tar.tl.x == rr.tl.x &&
			tar.tl.y == rr.tl.y &&
			tar.br.x == rr.br.x ) {
		gf->redraw_r.tl.y = tar.br.y;
		goto last_handle;
	}
	if ( tar.tl.x == rr.tl.x &&
			tar.br.x == rr.br.x &&
			tar.br.y == rr.br.y ) {
		gf->redraw_r.br.y = tar.tl.y;
		goto last_handle;
	}


last_handle:
	p->r.r = tar;
	if ( tar.tl.x == tar.br.x ||
			tar.tl.y == tar.br.y ) {
		p->r.plane = 0;
	}
	else {
		copy_plane(gf,p,gf->redraw_plane);
	}
	p->h.seq = ret = _get_env_seq(gf);
	return ret;
}

int
wf_redraw(GBVIEW_FLAME * gf,GBVIEW_PLANE * p,int x,int y,int w,int h)
{
int ret;

	wf_lock(gf);
	ZONBIE_CHECK(gf,wf_unlock(gf),0)

	_ex_lock(gf);

	ret = __wf_redraw(gf,p,x,y,w,h);
	_ex_unlock(gf);
	wf_unlock(gf);
	return ret;
}




WIN_FLAME *
touch_wf(GBVIEW_FLAME * gf)
{
WIN_FLAME * wf, * ret_wf;
/* retry: */
int flags;
	wf_lock(gf);
	ZONBIE_CHECK(gf,wf_unlock(gf),0)

retry2:
	_reset_task_nos(gf);
	ret_wf = 0;
	for ( wf = gf->flame ; wf ; wf = wf->next ) {
		if ( !(wf->flags & WFF_DRAW_REQUEST) )
			continue;
		if ( wf->flags & (WFF_FREE|WFF_HIDE) )
			continue;
		if ( wf->lock )
			continue;
		if ( ret_wf == 0 )
			ret_wf = wf;
		else if ( (ret_wf->flags & WFF_LS_DIRTY) == 0 ) {
			if ( wf->flags & WFF_LS_DIRTY )
				ret_wf = wf;
		}
	}
	ZONBIE_CHECK(gf,wf_unlock(gf),0)
	if ( ret_wf ) {
		flags = ret_wf->flags;
		ret_wf->flags &= ~WFF_LS_DIRTY;
		ret_wf->flags &= ~WFF_DRAW_REQUEST;
		if ( _win_lock(gf,ret_wf) < 0 )
			goto retry2;
		wf_unlock(gf);
		if ( (flags & WFF_LS_DIRTY) == 0 )
			change_pri(0,PRI_START_DRAW);
		return ret_wf;
	}
	flags = 0;
	if ( gf->req_task_nos )
		goto retry2;
	wf_unlock(gf);
	return 0;
}

typedef struct wf_search_t {
	RESOURCE * r;
	WF_ID		id;
	GBVIEW_FLAME * gf;
} WF_SEARCH_T;

int ___wf_search(GBVIEW_FLAME * gf,WF_SEARCH_T * w);

int
___wf_search(GBVIEW_FLAME * gf,WF_SEARCH_T * w)
{
WIN_FLAME * wf;

	wf_lock(gf);
	for ( wf = gf->flame ; wf ; wf = wf->next )
		if ( wf->draw == w->r ) {
			w->id = wf->id;
			w->gf = gf;
			wf_unlock(gf);
			return -1;
		}
	wf_unlock(gf);
	return 0;
}

GBVIEW_FLAME *
wf_search(WF_ID * ret_id,RESOURCE * r)
{
WF_SEARCH_T w;
	w.r = r;
	w.id = 0;
	w.gf = 0;
	wf_apply_all_gf(___wf_search,&w,GVFS_ACTIVE,0);
	if ( ret_id )
		*ret_id = w.id;
	return w.gf;
}


void
wf_indicate(GBVIEW_FLAME * gf,GBVIEW_STATUS * sts,int x,int y,int button)
{
WIN_FLAME * wf;
MAP_HISTORY * mh;
GB_POINT p[2],org;
REAL1 reso[2];
GET_POINT_WORK w;
int i,cnt;
SYMBOL_INDICATE * si;
RESOURCE * r;
OBJ * o;
int * no_list;
int no_cnt;
int sub,code;
int id;
void wf_init_status();

	if ( sts )
		wf_init_status(sts);

	wf_lock(gf);
	ZONBIE_CHECK_VOID(gf,wf_unlock(gf))

	wf_unlock(gf);
	clear_info(gf);
	w.indicate_list = 0;
	for ( cnt = 0 ; ; cnt ++ ) {


		wf_lock(gf);


		i = 0;
		for ( wf = gf->flame ; wf ; wf = wf->next , i ++ ) {
			if ( wf->flags & (WFF_FREE|WFF_HIDE) )
				continue;
			if ( i >= cnt )
				break;
		}
		if ( wf == 0 ) {
			wf_unlock(gf);
			break;
		}
		id = wf->id;
		no_cnt = 0;
		if ( button == GPB_PRESS ) {
			for ( si = wf->sym_i ; si ; si = si->next ) {
				if ( !(si->flags & SIF_ANCOR) )
					continue;
				p[0].x = x;
				p[0].y = y;
				if ( inside_rect(&si->rect,p[0]) == 0 )
					continue;
				if ( sts && si->ref ) {
log_printf(LOG_MESSAGE,LOG_LAYER_GB,0,"REFERENCE\n");
					sts->reference 
						= ll_copy_str(si->ref);
					sts->flags |= SF_REFERENCE;

					wf_unlock(gf);
					clear_info(gf);
					return;
				}
				no_cnt ++;
			}
			if ( no_cnt ) {
				no_list = d_alloc(no_cnt*2*sizeof(int));
				i = 0;
				for ( si = wf->sym_i ; si ; si = si->next ) {
					if ( !(si->flags & SIF_ANCOR) )
						continue;
					p[0].x = x;
					p[0].y = y;
					if ( inside_rect(&si->rect,p[0]) == 0 )
						continue;
					no_list[2*i] = si->rno;
					no_list[2*i+1] = si->code;
					i ++;
				}
			}
			else	no_list = 0;
		}
		else	no_list = 0;
		mh = add_mh(&gf->flame_base_display_map,
			wf->mh);
		p[0].x = x;
		p[0].y = y;
		p[1].x = x + 1;
		p[1].y = y;
		org = p[0];
		reso[0] = reso[1] = 1;

		map_from_flame(mh,p,reso,2);

		free_mh(mh);


		if ( reso[0] < 0 ) {
			wf_unlock(gf);
			continue;
		}
		if ( reso[1] < 0 )
			p[1] = p[0];
		memcpy(w.pt,p,sizeof(p));
		w.org = org;
		w.button = button;
		wf_unlock(gf);

		for ( i = 0 ; i < no_cnt ; i ++ ) {
			r = search_resource_by_no(no_list[2*i]);
			if ( r == 0 )
				continue;
			code = no_list[2*i+1]&MAIN_CODE;
			for ( sub = 0 ; sub < USER_SUBCODE ; sub ++ ) {
				o = search_obj(r,code|sub);
				if ( o )
					break;
			}
			if ( o == 0 )
				continue;
			indicate_info_card(gf,r,o);
		}
		if ( no_list )
			d_f_ree(no_list);
		wf_lock(gf);
		if ( _get_wf_ptr(gf,id) )
			r = wf->draw;
		else r = 0;
		wf_unlock(gf);
		if ( r ) {
			get_point_resource(gf,r,&w);
		}
	}
	lock_task(in_lock);
	free_indicate(gf->_indicate);
	gf->_indicate = w.indicate_list;
	unlock_task(in_lock,"ill");
}


void
wf_lock_test(GBVIEW_FLAME * gf,char * str)
{
	printf("%s...\n",str);
	wf_lock(gf);
	wf_unlock(gf);
	printf("%s...OK\n",str);
}


void
_all_dirty_out(GBVIEW_FLAME * gf)
{
WIN_FLAME * wf;
	for ( wf = gf->flame ; wf ; wf = wf->next ) {
		if ( wf->flags & WFF_FREE ) {
			continue;
		}
		wf->aboat_count ++;
		_wakeup_at_redraw_wp(gf);
//		_win_wlock(gf,wf):
		wf_free_si(wf);
		_win_flame_dirty(gf,wf,0,WFF_DIRTY,0);
//		_win_unlock(gf,wf);
		wf->aboat_count --;
		_wakeup_at_redraw_wp(gf);
	}
}

void
all_dirty_out(GBVIEW_FLAME * gf)
{
	wf_lock(gf);
	_all_dirty_out(gf);
	wf_unlock(gf);
}

/* mori
REAL1
get_rad(GB_POINT p)
{
double d;
	d = sqrt(p.x*p.x + p.y*p.y);
	if ( d == 0 )
		return 0;
	if ( p.x > 0 )
		return acos(-p.y/d);
	else	return -acos(-p.y/d);
}
*/

REAL1
get_rad(GB_POINT p)
{
double d;
	d = sqrt(p.x*p.x + p.y*p.y);
	if ( d == 0 )
		return 0;
	if ( p.x > 0 ) {
		return asin(p.y/d);
	}
	else {
		if  ( p.y > 0 ) {
			return M_PI - asin(p.y/d);
		}
		else {
			return - M_PI - asin(p.y/d);
		}
	}
}



int
wf_goto_point(
	GBVIEW_FLAME * gf,
	L_CHAR * url,
	GB_POINT ptr,
	REAL1 rotate,
	REAL1 reso,
	int flags)
{
URL u;
WIN_FLAME * wf;
RESOURCE * c;
WF_ID ret_wf;
int ses;

	get_url2(&u,url);
	if ( u.proto == 0 || u.db == 0 || u.server == 0 || u.resource == 0 )
		return 0;
	wf_lock(gf);
	ZONBIE_CHECK(gf,wf_unlock(gf),0);

	for ( wf = gf->flame ; wf ; wf = wf->next ) {
		if ( wf->flags & WFF_FREE )
			continue;
		if ( url_cmp_str(&wf->draw->h.entry,&u) == 0 )
			break;
	}
	if ( wf == 0 ) {
	wf_0:
		wf_unlock(gf);
		ses = open_session(SEST_OPTIMIZE);
		c = load_resource(ses,&u,Q_PRI_RADAR);
		close_session(ses);
		if ( c == 0 ) {
			fprintf(stderr,"cannot load resource \"%s\"\n",
				n_string(std_cm,url));
			goto end;
		}
		wf_lock(gf);
		for ( wf = gf->flame ; wf ; wf = wf->next )
			_free_win_flame(gf,wf);
		gf->flame_base = 0;
		wf_unlock(gf);
/*
		switch ( c->c.geometory_type & GT_T_MASK ) {
		case GT_T_2D:
			break;
		case GT_T_GLOBE_SUR:
			reso = conv_unit(&er,
					c->h.cu.uenv,
					reso,
					reso_c_unit(&c->h.cu),
					l_string(std_cm,"dot/rad"));
			break;
		default:
			er_panic("wf_goto_point");
		}
*/
		new_win_flame(&ret_wf,
			gf,
			c->h.visible_resolution,
			c,0,ptr,rotate,reso);

		wf_lock(gf);
		goto end1;
	}
/*
	switch ( wf->draw->c.geometory_type & GT_T_MASK ) {
	case GT_T_2D:
		break;
	case GT_T_GLOBE_SUR:
		reso = conv_unit(&er,
				wf->draw->h.cu.uenv,
				reso,
				reso_c_unit(&wf->draw->h.cu),
				l_string(std_cm,"dot/rad"));
		break;
	default:
		er_panic("wf_goto_point");
	}
*/
	if ( wf->flags & WFF_FREE ) {
		wf_unlock(gf);
		return 0;
	}
	if ( wf == gf->flame_base ) {
		if ( (flags & GP_IGN_RESO) == 0 )
			gf->flame_base_resolution = reso;
		if ( (flags & GP_IGN_ROTATE) == 0 )
			gf->flame_base_rotate = rotate;
		if ( (flags & GP_IGN_PTR) == 0 )
			gf->flame_base_center = ptr;
	}
	else {
	GB_POINT ptr_list[2];
	REAL1 reso_list[2];
//	GB_POINT a;
		if ( wf->flags & WFF_FREE ) {
			wf_unlock(gf);
			return 0;
		}
/* mori
		a.x = sin(rotate);
		a.y = - cos(rotate);
		ptr_list[0] = ptr;
		ptr_list[1] = p_add(ptr,a);
*/
		ptr_list[0] = ptr;
		ptr_list[1] = ptr;
		ptr_list[1].x += 1;
// *

		reso_list[0] = reso;
		reso_list[1] = reso;
		map_from_resource(wf->mh,ptr_list,reso_list,2);
		if ( reso_list[0] <= 0 )
			goto wf_0;
		if ( reso_list[1] <= 0 ) {
			if ( (flags & GP_IGN_RESO) == 0 )
				gf->flame_base_resolution = reso_list[0];
			if ( (flags & GP_IGN_PTR) == 0 )
				gf->flame_base_center = ptr_list[0];
			if ( (flags & GP_IGN_ROTATE) == 0 )
				gf->flame_base_rotate = rotate;
		}
		else {
			if ( (flags & GP_IGN_RESO) == 0 )
				gf->flame_base_resolution = reso_list[0];
			if ( (flags & GP_IGN_PTR) == 0 )
				gf->flame_base_center = ptr_list[0];
			if ( (flags & GP_IGN_ROTATE) == 0 )
				gf->flame_base_rotate = rotate - get_rad(
					p_sub(ptr_list[1],ptr_list[0]));
		}
	}
	_calc_pitch(gf,1);
	if ( gf->history_enable )
		gf->history_flag = 1;
	_all_dirty_out(gf);
end1:
	assert_ls(gf,LSF_ZOOM);
	gf->move_flag = 1;
	_set_move_timer(gf);
	_wakeup_win_manage(gf->radar_ptr);
	wf_unlock(gf);
end:
	return 0;
}


void
_wf_select(GBVIEW_FLAME * gf,GBVIEW_PLANE * p,OBJ * obj)
{
SELECT_WORK sw;
WIN_FLAME * wf;
SELECT_INDICATE * si;
int xx,yy,x1,y1;
int ow,oh;
unsigned long * buf;
unsigned int cc1;
I_RECT tar;


	tar.tl.x = 0;
	tar.tl.y = 0;
	tar.br.x = -1;
	tar.br.y = -1;
	ow = gf->win_width;
	oh = gf->win_height;
	buf = p->r.plane;

	for ( wf = gf->flame ; wf ; wf = wf->next ) {
		if ( wf->flags & (WFF_FREE|WFF_HIDE) )
			continue;
		sw.mh = add_mh(&gf->flame_base_display_map,wf->mh);
		sw.select_obj = obj;
		sw.map = 0;
		sw.color.c = 0x3ff;
		sw.color.t = 1;
		sw.color.rev_t = 0;
		sw.width = gf->win_width;
		sw.height = gf->win_height;
		si = d_alloc(sizeof(*si));
		sw.si = si;
		si->pixels = 0;
		select_resource(wf->draw,&sw);
		free_mh(sw.mh);
		if ( si->pixels ) {
			si->t = 0.4;
			si->rev_t = 1-si->t;
			si->next = gf->si;
			gf->si = si;

			y1 = 0;
			for ( yy = si->y ; ; yy ++ ) {
				if ( yy < 0 )
					continue;
				if ( yy >= si->y + si->h )
					break;
				if ( yy >= gf->win_height )
					break;
				x1 = 0;
				for ( xx = si->x ; ; xx ++ ) {
					if ( xx < 0 )
						continue;
					if ( xx >= si->x + si->w )
						break;
					if ( xx >= gf->win_width )
						break;
					if ( (xx&1) == (yy&1) ) {
						cc1 = select_color(
							gf,
							C_TRANSPARENT,
							xx,yy);
						buf[yy*ow + xx] = cc1;
						insert_vrect(&tar,
							xx,yy);
					}
					x1 ++;
				}
				y1 ++;
			}
			break;
		}
		else {
			d_f_ree(si);
		}
	}
	marge_vrect(&p->r.r,&tar);
	return;
}



int
_wf_purge_select(GBVIEW_FLAME * gf)
{
SELECT_INDICATE * si;
int xx,yy;
I_RECT rr;

	if ( gf->si == 0 )
		return -1;
	for ( ; gf->si ; ) {
		si = gf->si;
		gf->si = si->next;
		if ( si->x < 0 )
			xx = 0;
		else	xx = si->x;
		rr.tl.x = si->x;
		rr.tl.y = si->y;
		rr.br.x = si->x + si->w;
		rr.br.y = si->y + si->h;
		insert_redraw_r(gf,&rr);
		for ( ; ; xx ++ ) {
			if ( xx >= si->x + si->w )
				break;
			if ( xx >= gf->win_width )
				break;
			if ( si->y < 0 )
				yy = 0;
			else	yy = si->y;
			for ( ; ; yy ++ ) {
				if ( yy >= si->y + si->h )
					break;
				if ( yy >= gf->win_height )
					break;
				gf->redraw[yy*gf->win_width + xx]
					= RP_REDRAW;
			}
		}

		d_f_ree(si->pixels);
		d_f_ree(si);
	}
	return 0;
}

int
wf_purge_select(GBVIEW_FLAME * gf)
{
int ret;
	wf_lock(gf);
	ZONBIE_CHECK(gf,wf_unlock(gf),0);

	if ( _wf_purge_select(gf) < 0 )
		ret = 0;
	else	ret = _get_env_seq(gf);
	wf_unlock(gf);
	return ret;
}

void
_wf_check_resource_wf(GBVIEW_FLAME * gf,WIN_FLAME * wf)
{
CHECK_WORK c;
int i;

	if ( wf->flags & (WFF_FREE|WFF_HIDE) ) {
		wf->flags &= ~(WFF_LUSTER|WFF_POLY|WFF_PLOT);
		return;
	}
	for ( i = 0 ; i < RT_MAX ; i ++ ) {
		c.type[i] = 0;
		c.opt[i] = 0;
	}
	c.max_coord_level = 1;
	c.coord_level = 0;
	c.resource = 0;
	c.flags = 0;
	check_resource(wf->draw,&c);
	if ( c.type[RT_PIXEL_MAP_R64] )
		wf->flags |= WFF_LUSTER;
	else	wf->flags &= ~WFF_LUSTER;
	if ( c.opt[RT_DRAW_GB] & DGF_POLY )
		wf->flags |= WFF_POLY;
	if ( c.opt[RT_DRAW_GB] & (DGF_INFO|DGF_MARK) )
		wf->flags |= WFF_PLOT;
}

void
wf_check_small(GBVIEW_FLAME * gf,WIN_FLAME * wf)
{
SURP_SET surp;
MAP_HISTORY * mh;
GB_RECT * ret;
int n;
int i;
GB_RECT rct;
	set_surp(&surp,&wf->draw->h.minrect,1);
	mh = add_mh(&gf->flame_base_display_map,wf->mh);
	map_from_resource(mh,surp.ptr,surp.reso,SURP_NOS);
	ret = get_surp_rect(&n,&surp,0);
	free_mh(mh);
	if ( ret == 0 )
		return;
	rct.tl.x = rct.tl.y = 0;
	rct.br.x = rct.br.y = -1;
	for ( i = 0 ; i < n ; i ++ )
		add_rect(&rct,&ret[i]);
	d_f_ree(ret);

	if( gf->flame_base_display_map.type == MHT_PP )
		wf_setup_drawrect(gf,wf,rct,1.5);
	else	wf_setup_drawrect(gf,wf,rct,1.05);
}



void
wf_check_small_2(GBVIEW_LAYER_STATUS * ls,GBVIEW_FLAME * gf,WIN_FLAME * wf)
{
SURP_SET surp;
MAP_HISTORY * mh;
GB_RECT * ret;
int n;
int i;
GB_RECT rct;
GB_POINT ptr[2],center;
REAL1 reso[2];
REAL1 distance;
	set_surp(&surp,&wf->draw->h.minrect,1);
	mh = add_mh(&gf->flame_base_display_map,wf->mh);
	map_from_resource(mh,surp.ptr,surp.reso,SURP_NOS);
	ret = get_surp_rect(&n,&surp,0);
	if ( ret == 0 ) {
		free_mh(mh);
		return;
	}
	rct.tl.x = rct.tl.y = 0;
	rct.br.x = rct.br.y = -1;
	for ( i = 0 ; i < n ; i ++ )
		add_rect(&rct,&ret[i]);
	d_f_ree(ret);

	if( gf->flame_base_display_map.type == MHT_PP )
		ls->small_rect = get_drawrect(gf,rct,1.5);
	else	ls->small_rect = get_drawrect(gf,rct,1.05);
	
	center.x = ((REAL1)gf->win_width)/2;
	center.y = ((REAL1)gf->win_height)/2;

	distance = 10;
	for ( ; ; ) {
		ptr[0] = center;
		ptr[1] = center;
		ptr[1].y += distance;
		reso[0] = reso[1] = 1;
		map_from_flame(mh,ptr,reso,2);
		if ( reso[0] < 0 ) {
			ls->distance = -1;
			break;
		}
		if ( reso[1] < 0 ) {
			distance = distance / 2;
			continue;
		}
		ls->center[0] = ptr[0];
		ls->center[1] = ptr[1];
		ls->distance = distance;
		break;
	}
	free_mh(mh);
}

void
wf_check_resource(GBVIEW_FLAME * gf)
{
WIN_FLAME * wf;
CHECK_WORK c;
int i;

	wf_lock(gf);
	for ( wf = gf->flame ; wf ; wf = wf->next ) {
		if ( wf->flags & (WFF_FREE|WFF_HIDE) ) {
			wf->flags &= ~(WFF_LUSTER|WFF_POLY|WFF_PLOT);
			continue;
		}
		for ( i = 0 ; i < RT_MAX ; i ++ ) {
			c.type[i] = 0;
			c.opt[i] = 0;
		}
		c.max_coord_level = 1;
		c.coord_level = 0;
		c.resource = 0;
		c.flags = 0;
		check_resource(wf->draw,&c);
		if ( c.type[RT_PIXEL_MAP_R64] )
			wf->flags |= WFF_LUSTER;
		else	wf->flags &= ~WFF_LUSTER;
		if ( c.opt[RT_DRAW_GB] & DGF_POLY )
			wf->flags |= WFF_POLY;
		if ( c.opt[RT_DRAW_GB] & (DGF_INFO|DGF_MARK) )
			wf->flags |= WFF_PLOT;
	}
	wf_unlock(gf);
}

typedef struct wfs_wfid_ir {
	RESOURCE * r;
	WFID_INCLUDE_RESOURCE * ret;
} WFS_WFID_IR;

int _wf_search_wfid_include_resource(GBVIEW_FLAME * gf,WFS_WFID_IR * w);

int
_wf_search_wfid_include_resource(GBVIEW_FLAME * gf,WFS_WFID_IR * w)
{
WIN_FLAME * wf;
CHECK_WORK c;
int i;
RESOURCE * r;
WFID_INCLUDE_RESOURCE * ir;
int pri;
	r = w->r;

	pri = push_pri(PRI_NETWORK);
	wf_lock(gf);


	for ( wf = gf->flame ; wf ; wf = wf->next ) {
		if ( (wf->flags & (WFF_FREE|WFF_HIDE)) )
			continue;
		for ( i = 0 ; i < RT_MAX ; i ++ ) {
			c.type[i] = 0;
			c.opt[i] = 0;
		}
		c.max_coord_level = 1;
		c.coord_level = 0;
		c.resource = r;
		c.flags = 0;
		check_resource(wf->draw,&c);
		if ( c.flags & CWF_RESOURCE )
			break;
	}
	if ( wf ) {
		ir = d_alloc(sizeof(*ir));
		ir->id = wf->id;
		ir->gf = gf;
		ir->next = w->ret;
		w->ret = ir;
	}
	wf_unlock(gf);
	change_pri(0,pri);

	return 0;
}

WFID_INCLUDE_RESOURCE *
wf_search_wfid_include_resource(RESOURCE *r)
{
WFS_WFID_IR w;
	w.ret = 0;
	w.r = r;
	wf_apply_all_gf(_wf_search_wfid_include_resource,&w,GVFS_ACTIVE,0);
	return w.ret;
}

void
free_wfid_include_resource(WFID_INCLUDE_RESOURCE * wir)
{
WFID_INCLUDE_RESOURCE * wir2;
	for ( ; wir ; ) {
		wir2 = wir->next;
		d_f_ree(wir);
		wir = wir2;
	}
}



int
min_route_wf(GBVIEW_FLAME * gf,int ses)
{
int cnt,i;
WIN_FLAME * wf;
L_CHAR * target, * org;
MAP_HISTORY * mh;
MP_ROUTE * mpr;
URL u;
int ret;

	ret = 0;
	cnt = 0;
retry:
	wf_lock(gf);

	wf = _wf_get_current(gf);
	if ( wf == 0 ) {
		wf_unlock(gf);
		return ret;
	}
	org = ll_copy_str(get_url_str2(&wf->draw->h.entry));

	i = cnt;
	for ( wf = gf->flame ; wf && i ; wf = wf->next , i -- ) {
		if ( wf->mh == 0 )
			continue;
	}
	if ( wf == 0 ) {
		wf_unlock(gf);
		return ret;
	}
	target = ll_copy_str(get_url_str2(&wf->draw->h.entry));
	wf_unlock(gf);

	mpr = resolve_route(org,target,RR_WM_DIRECT_NO_WAIT);
	if ( mpr == 0 ) {
		goto flush_mpr2;
	}
	if ( mpr == MP_NO_ROUTE ) {
		ret = -1;
		goto flush_mpr2;
	}
	get_url2(&u,org);
	mh = get_mh_from_route(ses,&u,mpr);
	free_url(&u);
	if ( mh == MP_MH_NO_ROUTE ) {
		ret = -1;
		goto flush_mpr;
	}

	wf_lock(gf);


	wf = _wf_get_current(gf);
	if ( wf == 0 ) {
		free_mh(mh);
		wf_unlock(gf);
		goto flush_mpr;
	}
	for ( wf = gf->flame ; wf ; wf = wf->next ) {
		if ( wf->mh == 0 )
			continue;
		if ( l_strcmp(target,get_url_str2(&wf->draw->h.entry)) == 0 )
			break;
	}
	if ( wf == 0 ) {
		wf_unlock(gf);
		goto flush_mpr;
	}
	free_mh(wf->mh);
	wf->mh = optimize_mh(mh);
	wf_unlock(gf);

flush_mpr:
	flush_route(mpr);
flush_mpr2:
	d_f_ree(target);
	d_f_ree(org);

	cnt ++;
	goto retry;

}

RESOURCE *
wf_get_resource(GBVIEW_FLAME * gf,WF_ID id)
{
RESOURCE * ret;
WIN_FLAME * wf;
int pri;
	pri = push_pri(PRI_DRAW);
	wf_lock(gf);
	ZONBIE_CHECK(gf,(wf_unlock(gf),change_pri(0,pri)),0);


	wf = _get_wf_ptr(gf,id);
	if ( wf == 0 ) {
		wf_unlock(gf);
		return 0;
	}
	ret = wf->draw;
	wf_unlock(gf);
	change_pri(0,pri);
	return ret;
}


void
wakeup_wf(GBVIEW_FLAME * gf,WF_ID wfid)
{
WIN_FLAME * wf;
	wf_lock(gf);


	wf = _get_wf_ptr(gf,wfid);
	if ( wf == 0 )
		goto end;
	_wakeup_wf(gf,wf);
end:
	wf_unlock(gf);
}


REAL1
get_radian(
	GBVIEW_FLAME * gf,
	GB_POINT from,
	GB_POINT to)
{
REAL1 A,B;
double d,s,c;
GB_POINT center;
	center.x = gf->win_width/2;
	center.y = gf->win_height/2;
	from = p_sub(from,center);
	to = p_sub(to,center);
	d = sqrt(inner(from,from) * inner(to,to));
	A = inner(from,to)/d;
	B = (to.x * from.y - from.x * to.y)/d;
	if ( A > 1 )
		A = 1;
	else if ( A < -1 )
		A = -1;
	if ( B > 1 )
		B = 1;
	else if ( B < -1 )
		B = -1;
	c = acos(A);
	s = asin(B);
	if ( c < M_PI/2 )
		return s;
	if ( s < 0 )
		return -c;
	else	return c;
}



unsigned long *
_rotate_plane(
	GBVIEW_FLAME * gf,
	unsigned long * plane,
	I_POINT * index)
{
unsigned long * ret, * rp;
int x,y;
	ret = d_alloc(sizeof(long)*gf->win_width*gf->win_height);
	rp = ret;
	for ( y = 0 ; y < gf->win_height ; y ++ )
		for ( x = 0 ; x < gf->win_width ; x++ ) {
			if ( index->x < 0 )
				*rp++ = BACKGROUND_COLOR_MID;
			else	*rp++ = 
				plane[index->x + index->y * gf->win_width];
			index ++;
		}
	return ret;
}

int
wf_rotate(GBVIEW_FLAME * gf,GB_POINT from,GB_POINT to)
{
int ret;
I_POINT * index;
unsigned long * plane;
int i;
WIN_FLAME * wf;

	if ( from.x == to.x && from.y == to.y )
		return 0;
	wf_lock(gf);
	ZONBIE_CHECK(gf,wf_unlock(gf),0)
	
	index = d_alloc(sizeof(VPOINT)*gf->win_width*gf->win_height);
	wf_make_rotate_index(index,from,to,gf->win_width,gf->win_height);
	plane = _rotate_plane(gf,gf->redraw_plane,index);
	d_f_ree(gf->redraw_plane);
	gf->redraw_plane = plane;
	for ( i = 0 ; i < gf->win_width * gf->win_height ; i ++ )
		gf->redraw[i] = 0;
	for ( wf = gf->flame ; wf ; wf = wf->next ) {
		if ( wf->flags & (WFF_FREE|WFF_HIDE) )
			continue;
		win_flame_rotate(gf,wf,index);
		_wakeup_wf(gf,wf);
	}
	d_f_ree(index);
	_calc_pitch(gf,0);
	gf->flame_base_rotate -= get_radian(gf,from,to);
	_calc_pitch(gf,1);
	if ( gf->history_enable )
		gf->history_flag = 1;

	ret = _get_env_seq(gf);
//	_wf_set_delay_redraw(gf);
	wf_unlock(gf);
	new_tick((void(*)(int))_wf_set_redraw,0,(int)gf);
	return ret;
}



RESOURCE * 
_wf_get_mh(GBVIEW_FLAME * gf,WIN_FLAME * wf,MAP_HISTORY ** mhp)
{
	*mhp = add_mh(&gf->flame_base_display_map,wf->mh);
	return wf->draw;
}

RESOURCE *
wf_get_mh(GBVIEW_FLAME * gf,WF_ID id,MAP_HISTORY ** mhp)
{
RESOURCE * ret;
WIN_FLAME * wf;
	wf_lock(gf);
	wf = _get_wf_ptr(gf,id);
	if ( wf == 0 ) {
		wf_unlock(gf);
		return 0;
	}
	ret = _wf_get_mh(gf,wf,mhp);
	wf_unlock(gf);
	return ret;
}

int
wf_get_dirty_mask(int flags)
{
int mask;
	mask = 0;
	if ( flags & WFF_LUSTER )
		mask |= WFF_LUSTER_DIRTY;
	if ( flags & WFF_POLY )
		mask |= WFF_POLY_DIRTY;
	if ( flags & WFF_PLOT )
		mask |= WFF_PLOT_DIRTY;
	return mask;
}


void
wf_insert_dirty_rect(RESOURCE * r,GB_RECT * d_rect,
	int flags,
	int ofs_w,int ofs_h)
{
SURP_SET ss;
MAP_HISTORY * mh;
RESOURCE * draw;
GB_RECT rct,* _rct;
int nos;
RESOURCE * map;
WFID_INCLUDE_RESOURCE * wir,* p;
WIN_FLAME * wf;
int mask;
int i;
	mask = 0;
	wir = wf_search_wfid_include_resource(r);
	for ( p = wir ; p ; p = p->next ) {
		if ( p->id == 0 )
			continue;
		wf_lock(p->gf);
		wf = _get_wf_ptr(p->gf,p->id);
		if ( wf ) {
			mask = wf_get_dirty_mask(wf->flags);
		}
		wf_unlock(p->gf);
		if ( (flags & mask) == 0 )
			continue;

		set_surp(&ss,d_rect,1);
		draw = wf_get_mh(p->gf,p->id,&mh);
		if ( draw == 0 )
			goto next3;
		if ( draw == r )
			goto draw_point;
		map = get_map_between2(r,draw);
		if ( map == 0 )
			goto next2;
		map_conv_forward(map,ss.ptr,ss.reso,SURP_NOS);
		for ( i = 0 ; i < SURP_NOS ; i ++ )
			if ( ss.reso[i] < 0 ) {
				set_surp(&ss,&map->h.minrect,1);
				break;
			}
	draw_point:
		map_from_resource(mh,ss.ptr,ss.reso,SURP_NOS);
		memset(ss.group,0,sizeof(ss.group));
		_rct = get_surp_rect(&nos,&ss,0);
		if ( nos > 1 )
			er_panic("wf_insert_dirty_rect");
		if ( nos == 0 )
			goto next2;
		rct = *_rct;

		rct.tl.x -= ofs_w;
		rct.tl.y -= ofs_h;
		rct.br.x += ofs_w;
		rct.br.y += ofs_h;

		win_flame_dirty(p->gf,p->id,&rct,flags & mask,0);
//	next1:
		d_f_ree(_rct);
	next2:
		free_mh(mh);
	next3:
		;
	}
	free_wfid_include_resource(wir);
}


void
wf_insert_dirty_rect_1d(RESOURCE * r,GB_RECT * d_rect,
	int flags,
	int ofs_w,int ofs_h)
{
SURP_SET ss;
MAP_HISTORY * mh;
RESOURCE * draw;
GB_RECT rct,* _rct;
int nos;
RESOURCE * map;
WFID_INCLUDE_RESOURCE * wir,* p;
WIN_FLAME * wf;
int mask;
int i;
int y_top,y_bottom;
	mask = 0;
	wir = wf_search_wfid_include_resource(r);
	for ( p = wir ; p ; p = p->next ) {
		if ( p->id == 0 )
			continue;
		wf_lock(p->gf);
		wf = _get_wf_ptr(p->gf,p->id);
		if ( wf ) {
			mask = wf_get_dirty_mask(wf->flags);
		}
		y_top = p->gf->flame_base_y_offset + wf->e1d_y_top + wf->e1d_top_mergin;
		y_bottom = p->gf->flame_base_y_offset + wf->e1d_y_bottom + wf->e1d_bottom_mergin;
		wf_unlock(p->gf);
		if ( (flags & mask) == 0 )
			continue;

		set_surp(&ss,d_rect,1);
		draw = wf_get_mh(p->gf,p->id,&mh);
		if ( draw == 0 )
			goto next3;
		if ( draw == r )
			goto draw_point;
		map = get_map_between2(r,draw);
		if ( map == 0 )
			goto next2;
		map_conv_forward(map,ss.ptr,ss.reso,SURP_NOS);
		for ( i = 0 ; i < SURP_NOS ; i ++ )
			if ( ss.reso[i] < 0 ) {
				set_surp(&ss,&map->h.minrect,1);
				break;
			}
	draw_point:
		map_from_resource(mh,ss.ptr,ss.reso,SURP_NOS);
		memset(ss.group,0,sizeof(ss.group));
		_rct = get_surp_rect(&nos,&ss,0);
		if ( nos > 1 )
			er_panic("wf_insert_dirty_rect");
		if ( nos == 0 )
			goto next2;
		rct = *_rct;

		rct.tl.x -= ofs_w;
		rct.tl.y = y_top - ofs_h;
		rct.br.x += ofs_w;
		rct.br.y = y_bottom + ofs_h;

		win_flame_dirty(p->gf,p->id,&rct,flags & mask,0);
//	next1:
		d_f_ree(_rct);
	next2:
		free_mh(mh);
	next3:
		;
	}
	free_wfid_include_resource(wir);
}


int
_get_wf_pri(GBVIEW_FLAME * gf,WIN_FLAME * wf)
{
WIN_FLAME * w;
int ret;
	if ( wf->flags & WFF_LUSTER ) {
		ret = 0;
		for ( w = gf->flame ; 
			!(w->flags & WFF_FREE) &&
			w && w != wf ;
			w = w->next , ret -- );
		return ret + wf->pri_adj;
	}
	if ( wf->flags & WFF_POLY )
		return 1 + wf->pri_adj;
	return 2 + wf->pri_adj;
}

int
get_wf_priadj(GBVIEW_FLAME * gf,WF_ID id)
{
WIN_FLAME * wf;
int ret;
	wf_lock(gf);
	wf = _get_wf_ptr(gf,id);
	if ( wf == 0 ) {
		ret = -1;
		goto end;
	}
	ret = wf->pri_adj;
end:
	wf_unlock(gf);
	return ret;
}

void
_ind_pri(GBVIEW_FLAME * gf)
{
WIN_FLAME * wf;
int p;
	for ( wf = gf->flame ; wf ; wf = wf->next ) {
		p = _get_wf_pri(gf,wf);
		printf("(%x:%i:%i:%i)",wf->flags,p,wf->pri_adj,wf->lock);
	}
	printf("\n");
}


void
_set_pri_adj(GBVIEW_FLAME * gf,WIN_FLAME * wf,int adj)
{
	wf->pri_adj = adj;
	_wakeup_at_redraw_wp(gf);
}

void
set_pri_adj(GBVIEW_FLAME * gf,int wfid,int adj)
{
WIN_FLAME * wf;
	wf_lock(gf);
	wf = _get_wf_ptr(gf,wfid);
	if ( wf )
		_set_pri_adj(gf,wf,adj);
	wf_unlock(gf);
}


int
wf_button_action(GBVIEW_FLAME * gf,OBJ * o,char * type)
{
WIN_FLAME * wf;
RESOURCE ** rlist;
int rlist_len,i;
int ret;

	if ( o == 0 || o->h.name == 0 )
		return 0;
	wf_lock(gf);
	ZONBIE_CHECK(gf,wf_unlock(gf),0)
	rlist_len = 0;
	for ( wf = gf->flame ; wf ; wf = wf->next ) {
		if ( wf->flags & (WFF_FREE|WFF_HIDE) )
			continue;
		if ( wf->draw->c.button_action )
			rlist_len ++;
	}
	rlist = d_alloc(sizeof(RESOURCE*)*rlist_len);
	i = 0;
	for ( wf = gf->flame ; wf ; wf = wf->next ) {
		if ( wf->flags & (WFF_FREE|WFF_HIDE) )
			continue;
		if ( wf->draw->c.button_action )
			rlist[i++] = wf->draw;
	}
	wf_unlock(gf);

	ret = 0;
	for ( i = 0 ; i < rlist_len ; i ++ ) {
		if ( do_button_action(rlist[i],
				type,
				o->h.name) ) {
			ret = 1;
			goto end1;
		}
	}
end1:
	d_f_ree(rlist);
	return ret;
}

void
wf_status_flags(GBVIEW_FLAME * gf,GBVIEW_STATUS * e,int req_flags)
{
WIN_FLAME * wf;
int n;
RESOURCE * r;
int er;
GBVIEW_LAYER_STATUS * ls, ** lsp;
int pri;

	pri = push_pri(PRI_DRAW);
	wf_lock(gf);

	wf_init_status(e);
	ZONBIE_CHECK_VOID(gf,(wf_unlock(gf),change_pri(0,pri)))

	e->width = gf->win_width;
	e->height = gf->win_height;
	n = 0;
	for ( wf = gf->flame ; wf ; wf = wf->next , n ++ );
	e->layer_nos = n;
	e->event = gf->event;
	e->event_user_arg = gf->event_user_arg;

	e->default_ws = gf->default_ws;
	if ( gf->flame_base ) {
		e->current = gf->flame_base->id;
		e->current_ls = d_alloc(sizeof(GBVIEW_LAYER_STATUS));
		e->current_ls->id = gf->flame_base->id;
		e->current_ls->entry_url = ll_copy_str(get_url_str2(
					&gf->flame_base->draw->h.entry));
		e->current_ls->target_url = ll_copy_str(get_url_str2(
					&gf->flame_base->draw->h.target));
		e->current_ls->r = gf->flame_base->draw;
		e->current_ls->flags = (gf->flame_base->flags&(WFF_COPY_FLAGS|WFF_FREE))|
		  				WFF_BASE_CURRENT;
		e->current_ls->next = 0;
	}
	else	e->current = 0;

	if ( gf->req_task_nos || gf->req_task_nos2 )
		e->loading_status.draw = 1;
	if ( gf->exit_task_wp )
		e->loading_status.exit = 1;
	if ( (gf->ls_flags & LSF_ASSERT) || gf->load_structure_wp )
		e->loading_status.load_structure = 1;

	if ( gf->redraw_r.tl.x >= gf->redraw_r.br.x ||
			gf->redraw_r.tl.y >= gf->redraw_r.br.y )
		e->loading_status.dirty = 0;
	else	e->loading_status.dirty = 1;
	e->loading_status.data_request = 0;
	for ( wf = gf->flame ; wf ; wf = wf->next )
		e->loading_status.data_request += wf->data_request;
	wf_indicate_lock(gf);
	e->loading_status.indicate_request = gf->indicate_req;
	e->loading_status.indicate = gf->indicate_task_active;
	wf_indicate_unlock(gf);
	e->loading_status.raw_image_request = gf->raw_image_request;
	e->history_flag = gf->history_flag;
	e->history_enable = gf->history_enable;

	e->flags = SF_BASE;

	if ( gf->flame_base ) {
		r = gf->flame_base->draw;
		e->flame_base_resolution = gf->flame_base_resolution;
		e->flame_base_display_map_type
			= gf->flame_base_display_map.type;
		e->flame_base_unit = ll_copy_str(r->h.cu.unit);
		e->flame_base_center = gf->flame_base_center;
		e->flame_base_rotate = gf->flame_base_rotate;
		e->flame_base_geo_type = gf->flame_base_geo_type;

		e->flags |= SF_RESOLUTION|SF_MAP_TYPE|SF_UNIT|SF_CENTER|SF_ROTATE;

		if ( e->flame_base_display_map_type == MHT_PP ) {
			e->pp_radius = conv_unit(&er,
				r->h.cu.uenv,
				gf->flame_base_resolution,
				reso_c_unit(&r->h.cu),
				l_string(std_cm,"dot/rad"));

			e->flags |= SF_PP_RADIUS;
		}
	}
	if ( gf->flame ) {
		lsp = &e->layers;
		for ( wf = gf->flame ; wf ; wf = wf->next ) {
			if ( wf->flags & WFF_FREE )
				continue;
			ls = d_alloc(sizeof(*ls));
			ls->id = wf->id;
			ls->mh_length = map_history_length(wf->mh);
			ls->entry_url = ll_copy_str(
				get_url_str2(&wf->draw->h.entry));
			ls->target_url = ll_copy_str(
				get_url_str2(&wf->draw->h.target));
			ls->r = wf->draw;
			ls->flags = wf->flags&WFF_COPY_FLAGS&(~WFF_BASE_CURRENT);
			if ( gf->flame_base == wf )
				ls->flags |= WFF_BASE_CURRENT;
			ls->hide_time = wf->hide_time;
			if ( req_flags & SF_LAYER_DETAILS )
				wf_check_small_2(ls,gf,wf);
			ls->next = 0;
			*lsp = ls;
			lsp = &ls->next;
		}
	}
	if ( gf->radar_ptr )
		e->flags |= SF_RADAR;

	wf_unlock(gf);
	e->infolist = copy_infolist(gf);

	lock_task(in_lock);
	e->indicate = _copy_indicate(gf);
	unlock_task(in_lock,"wf_status");
	change_pri(0,pri);
}

void
wf_status(GBVIEW_FLAME * gf,GBVIEW_STATUS * e)
{
	wf_status_flags(gf,e,0);
}

int
change_status_rule(int * old_st,int new_st)
{
int ret;
	if ( *old_st != new_st )
		ret = 1;
	else	ret = 0;
	switch ( *old_st ) {
	case GVFS_IDLE:
	case GVFS_ACTIVE:
		switch ( new_st ) {
		case GVFS_ZONBIE_2:
			*old_st = GVFS_ZONBIE;
			break;
		default:
			*old_st = new_st;
			break;
		}
		return ret;
	case GVFS_ZONBIE:
	case GVFS_ZONBIE_2:
		return -1;
	default:
		er_panic("change_status_rule");
	}
	return 0;
}

void
gf_zonbie_tick()
{
GBVIEW_FLAME ** gfp,* gf;
WIN_FLAME * wf;
	lock_task(gbview_flame_lock);
	if ( gf_zonbie_count == 0 ) {
		del_tick((void(*)(int))gf_zonbie_tick);
		goto end;
	}
	for ( gfp = &gbview_flame_list ; *gfp ; ) {
		gf = *gfp;
		switch ( gf->status ) {
		case GVFS_ZONBIE:
			if ( _ch_locked(&gf->_wf_lock) )
				break;
			_ch_lock(&gf->_wf_lock,__FILE__,__LINE__);
			unlock_task(gbview_flame_lock,"gf_zonbie_tick");
			for ( wf = gf->flame ; wf ; wf = wf->next )
				_free_win_flame(gf,wf);
			lock_task(gbview_flame_lock);
			_wf_purge_select(gf);
			gf->event = 0;
			gf->event_user_arg = 0;
			_ch_unlock(&gf->_wf_lock);
			gf->status = GVFS_ZONBIE_2;
			gf->zonbie_timeout = get_xltime() + ZONBIE_TIMEOUT;
			gf->move_timer = 0;
			break;
		case GVFS_ZONBIE_2:
			if ( gf->zonbie_timeout < get_xltime() )
				gf->status = GVFS_ZONBIE_3;
		case GVFS_ZONBIE_3:
			if ( _ch_locked(&gf->_wf_lock) )
				break;
			if ( _ch_locked(&gf->_ls_lock) )
				break;
			if ( _ch_locked(&gf->indicate_lock) )
				break;
			if ( gf->ex_lock )
				break;
			if ( gf->run_req_task_nos )
				break;
			if ( gf->ls_task_cnt )
				break;
			if ( gf->exit_task_wp )
				break;
			if ( gf->redraw_wp )
				break;
			_free_wf_flags(gf);
			d_f_ree(gf->redraw);
			d_f_ree(gf->redraw_plane);
			free_indicate(gf->_indicate);
			free_infolist(gf->infolist);
			free_infolist(gf->click_op_list);
			*gfp = gf->next;
			d_f_ree(gf);
			gf_zonbie_count --;
			continue;
		default:
			break;
		}
		gfp = &(*gfp)->next;
	}
end:
	unlock_task(gbview_flame_lock,"gf_zonbie_tick");
}

void
_wf_st_change(GBVIEW_FLAME * gf,int old_status)
{
	switch ( gf->status ) {
	case GVFS_IDLE:
		break;
	case GVFS_ACTIVE:
		radar_status(gf->radar_ptr,gf->status);
		break;
	case GVFS_ZONBIE:
		detach_radar(gf->radar_ptr);
		lock_task(gbview_flame_lock);
		gf_zonbie_count ++;
		unlock_task(gbview_flame_lock,"_wf_st_change");
		new_tick((void(*)(int))gf_zonbie_tick,0,0);
		break;
	default:
		er_panic("_wf_st_change");
	}
}

int
wf_set_status(GBVIEW_FLAME * gf,GBVIEW_STATUS * e)
{
int ret;
int change,st_change;
int shift;
int old_width,old_height;
	wf_lock(gf);
	ZONBIE_CHECK(gf,wf_unlock(gf),0)
	change = 0;
	st_change = 0;
	if ( e->flags & SF_STATUS ) {
		shift = 1;
		for ( ; (e->status & shift) == 0 ; shift <<= 1 );
		if ( change_status_rule(&gf->status,shift) == 1 )
			st_change = gf->status;
		else	st_change = 0;
	}

	old_width = gf->win_width;
	old_height = gf->win_height;
	if ( e->flags & SF_WIDTH ) {
		if ( gf->win_width != e->width )
			change = 1;
		if ( e->width > 0 )
			gf->win_width = e->width;
	}
	if ( e->flags & SF_HEIGHT ) {
		if ( gf->win_height != e->height )
			change = 1;
		if ( e->height > 0 )
			gf->win_height = e->height;
	}
	if ( e->flags & SF_EVENT ) {
		gf->event = e->event;
		gf->event_user_arg = e->event_user_arg;
	}
	if ( e->flags & SF_DEFAULT_WS )
		gf->default_ws = e->default_ws;
	if ( e->flags & SF_HIS_ENABLE )
		gf->history_enable = e->history_enable;
	if ( e->flags & SF_HIS_FLAG )
		gf->history_flag = e->history_flag;

	if ( change )
		_wf_change_size(gf,old_width,old_height);
	if ( e->flags & SF_DONT_SEQ )
		ret = 0;
	else	ret = _get_env_seq(gf);
	wf_unlock(gf);

	if ( gf->radar_ptr == 0 && (e->flags & SF_RADAR) )
		attach_radar(gf);
	if ( st_change )
		_wf_st_change(gf,st_change);
	return ret;
}


int
_wf_click(GBVIEW_FLAME * gf,GBVIEW_PLANE * gbp,INFO_LIST * lst);

void
_wf_click_func(GBVIEW_FLAME * gf)
{
//GBVIEW_PLANE gbp;
INFO_LIST * info;
void	(*d_event)(struct gbview_flame*,int,void*,void*);
void *	d_arg;


return;
	wf_lock(gf);
	ZONBIE_CHECK_VOID(gf,wf_unlock(gf))
	info = gf->click_op_list;
	gf->click_op_list = 0;
	d_event = gf->event;
	d_arg = gf->event_user_arg;
	wf_unlock(gf);
//	_wf_click(gf,&gbp,info);
	if ( d_event )
		(*d_event)(gf,ET_CLICK,0,d_arg);
	free_infolist(info);
}

void
wf_click_func(GBVIEW_FLAME * gf)
{
	new_tick((void(*)(int))_wf_click_func,0,(int)gf);
}

int
_wf_click(GBVIEW_FLAME * gf,GBVIEW_PLANE * gbp,INFO_LIST * lst)
{
INFO_LIST * il, * il2;
GBVIEW_STATUS sts;
int seq;
int ow,oh;
unsigned long * buf;
int i;

	if ( gf->status & GVFM_ZONBIE )
		return 0;

	wf_status(gf,&sts);

	if ( lst )
		il2 = il = lst;
	else {
		il2 = il = sts.infolist;
		sts.infolist = 0;
	}

	for ( il = il2 ; il ; il = il->next ) {
		if ( wf_button_action(gf,il->obj,"click") )
			goto next;
	}

	if ( invoke_indicate(gf,wf_click_func,gf) ) {
		wf_lock(gf);
		if ( gf->click_op_list )
			free_infolist(gf->click_op_list);
		sts.infolist = 0;
		gf->click_op_list = il2;
		wf_unlock(gf);

		wf_free_status(&sts);
		return 0;
	}

next:

	wf_lock(gf);
	ow = gf->win_width;
	oh = gf->win_height;
	gbp->r.r.tl.x = gbp->r.r.br.x = 0;
	gbp->r.r.tl.y = gbp->r.r.br.y = -1;
	gbp->r.plane = buf = d_alloc(sizeof(unsigned long)*ow*oh);
	gbp->h.type = GPT_REDRAW;
	for ( i = 0 ; i < ow*oh ; i ++ , buf ++ )
		*buf = C_TRANSPARENT;
	for ( il = il2 ; il ; il = il->next )
		_wf_select(gf,gbp,il->obj);
	buf = gbp->r.plane;
	gbp->r.plane = 0;
/*
printf("CLICK TAR %i %i - %i %i\n",
gbp->r.r.tl.x,
gbp->r.r.tl.y,
gbp->r.r.br.x,
gbp->r.r.br.y);
*/
	if ( gbp->r.r.tl.x >= gbp->r.r.br.x ) {
		gbp->h.seq = seq = 0;
		gbp->h.type = 0;
		gbp->r.plane = 0;
		d_f_ree(buf);
	}
	else {
		copy_plane(gf,gbp,buf);
		d_f_ree(buf);
		gbp->h.seq = seq = _get_env_seq(gf);
	}

	wf_unlock(gf);

	return seq;
}


int
wf_click(GBVIEW_FLAME * gf,GBVIEW_STATUS * sts,GBVIEW_PLANE * p,int x,int y)
{

	wf_indicate(gf,sts,x,y,GPB_PRESS);
	if ( p == 0 ) {
		invoke_indicate(gf,0,gf);
		return 0;
	}
	return _wf_click(gf,p,0);
}

unsigned int
_wf_insert_time(WIN_FLAME * wf)
{
	return wf->insert_time;
}

unsigned int
wf_insert_time(GBVIEW_FLAME * gf,int wfid)
{
WIN_FLAME * wf;
unsigned int ret;
	wf_lock(gf);
	ZONBIE_CHECK(gf,wf_unlock(gf),0)
	wf = _get_wf_ptr(gf,wfid);
	if ( wf == 0 )
		ret = 0;
	else	ret = _wf_insert_time(wf);
	wf_unlock(gf);
	return ret;
}

void
dr_tick(int d)
{
GBVIEW_FLAME * gf;
	gf = (GBVIEW_FLAME*)d;
	wf_wakeup(gf);
}

void
wf_set_data_request(GBVIEW_FLAME * gf,WF_ID wfid,int r)
{
WIN_FLAME * wf;
	wf_lock(gf);
	wf = _get_wf_ptr(gf,wfid);
	if ( wf ) {
		if ( r ) {
			wf->dr_time = get_xltime() + wf->dr_interval;
			new_tick((void(*)(int))dr_tick,-wf->dr_interval-1,(int)gf);
			wf->dr_interval *= 2;
		}
		else {
			wf->dr_interval = DR_INTERVAL_MIN;
			wf->dr_time = 0;
		}
		wf->data_request = r;
	}
	wf_unlock(gf);
}

void
wf_insert_action(GBVIEW_FLAME * gf,WIN_FLAME * wf,int flags)
{
	if ( wf_geo_type_list[gf->flame_base_geo_type][WFT_GEN]->f_wf_insert_action == 0 )
		return;
	(*wf_geo_type_list[gf->flame_base_geo_type][WFT_GEN]->f_wf_insert_action)
			(gf,wf,flags,0,0);
}


int
wf_set_overlay(GBVIEW_FLAME* gf,L_CHAR * url,int flags,int mask)
{
URL u;
WIN_FLAME * wf, * wf2;
int ret;
int f;
GB_RECT rr;
GV_RESOURCE_LIST * ri;
int hwf_active = 0;

	ret = 0;
	wf_lock(gf);
	ZONBIE_CHECK(gf,wf_unlock(gf),-1);
	if ( url == 0 ) {
		if ( mask & WFF_BASE_LOCK ) {
			f = 0;
			for ( wf2 = gf->flame ; wf2 ; wf2 = wf2->next ) {
				if ( wf2->flags & WFF_BASE_LOCK )
					f = 1;
				wf2->flags &= ~WFF_BASE_LOCK;
			}
			_call_re_base_lock(gf,ET_LOCK_BASE);
			for ( ri = gf->resource_list ; ri ; ri = ri->next )
				ri->flags &= ~WFF_BASE_LOCK;
		}
		goto end2;
	}
	get_url2(&u,url);
	for ( wf = gf->flame ; wf ; wf = wf->next ) {
		if ( wf->flags & WFF_FREE )
			continue;
		if ( url_cmp(&wf->draw->h.entry,&u) )
			continue;
		goto ok;
	}
	if ( flags & WFF_BASE_LOCK ) {
		f = 0;
		for ( wf2 = gf->flame ; wf2 ; wf2 = wf2->next ) {
			if ( wf2->flags & WFF_BASE_LOCK )
				f = 1;
			wf2->flags &= ~WFF_BASE_LOCK;
		}
		_call_re_base_lock(gf,ET_LOCK_BASE);
		for ( ri = gf->resource_list ; ri ; ri = ri->next )
			ri->flags &= ~WFF_BASE_LOCK;
	}
	ri = _search_resource_list(gf,0,url,1);
	ret = -1;
	if ( ri == 0 )
		goto end;
	if ( (ri->flags & WFF_USER) && (flags & WFF_USER_NEGATE) )
		goto end;
	ri->flags &= ~(WFF_COPY_FLAGS&mask);
	ri->flags |= flags & WFF_COPY_FLAGS;
//ss_printf("RI COPY FLAGS %ls %x %x - %x\n",url,ri->flags,flags,mask);
	goto end;
ok:
//	flags &= mask;
	f = wf->flags;

	if ( (wf->flags & WFF_USER) && (flags & WFF_USER_NEGATE) )
		goto end;
	wf->flags &= ~(WFF_COPY_FLAGS&mask);
	wf->flags |= flags & WFF_COPY_FLAGS;
ss_printf("REAL COPY FLAGS %ls %x -> %x %x - %x\n",url,f,wf->flags,flags,mask);

	if ( (f & WFF_HIDE) != (wf->flags & WFF_HIDE) ) {
		rr.tl.x = rr.tl.y = 0;
		rr.br.x = gf->win_width;
		rr.br.y = gf->win_height;
		
		if ( (flags & WFF_HIDE_TIME_DISABLE) == 0 )
			wf->hide_time = get_xltime();
		if ( flags & WFF_HIDE ) {
			wf->flags |= WFF_HIDE;
			wf_insert_action(gf,wf,WFF_HIDE);
			set_redraw_rect(gf,&rr);
		}
		else {
			wf_insert_action(gf,wf,WFF_HIDE);
			wf_free_si(wf);
			_wf_check_resource_wf(gf,wf);
			_win_flame_dirty(gf,wf,&rr,WFF_DIRTY,0);
			force_change_task();
		}
ss_printf("CALL_FRAME_CHANGE\n");
		_call_flame_change_base_event(gf);
		hwf_active = 1;
	}
	if ( wf->flags & (WFF_BASE_LOCK) ) {
		for ( wf2 = gf->flame ; wf2 ; wf2 = wf2->next ) {
			if ( wf2 == wf )
				continue;
			wf2->flags &= ~(WFF_BASE_LOCK);
		}
		for ( ri = gf->resource_list ; ri ; ri = ri->next )
			ri->flags &= ~(WFF_BASE_LOCK);
	}
	if ( (wf->flags & WFF_BASE_LOCK) != (f & WFF_BASE_LOCK) ) {
		_call_re_base_lock(gf,ET_LOCK_BASE);
	}
end:
	free_url(&u);
end2:
	wf_unlock(gf);
	if ( hwf_active && (flags & WFF_USER) && (mask & WFF_USER) ) 
		wakeup_hwf(gf,HWFF_TYPE_TO_HWF);
	return ret;
}

int wf_get_flags(GBVIEW_FLAME * gf,WF_ID wfid)
{
int ret;
WIN_FLAME * wf;
	wf_lock(gf);
	ZONBIE_CHECK(gf,wf_unlock(gf),-1);
	wf = _get_wf_ptr(gf,wfid);
	if ( wf == 0 )
		ret = -1;
	else	ret = wf->flags;
	wf_unlock(gf);
	return ret;
}


void
insert_lw_service_code_flag_set(RESOURCE * r,XL_SEXP * s)
{
RESOURCE ** lst;
int i;
	lst = insert_lw_service_code_flag_set_get_parent(r,s);
	
	if ( get_type(s) == XLT_ERROR && s->err.code == XLE_PROTO_PERMISSION_DENIED )
		for ( i = 0 ; lst[i] ; i ++ ) 
			wf_auth_information(lst[i]);
	d_f_ree(lst);
}

WF_WORK_AREA *
wf_new_work_area(WF_WORK_AREA_SET * aset,WF_WORK_AREA_TBL * tbl,RESOURCE * r,int size)
{
WF_WORK_AREA * a;
	lock_task(gbview_flame_lock);
	for ( a = aset->wa_list ; a ; a = a->next )
		if ( a->r == r ) {
			a = 0;
			goto err;
		}
	a = d_alloc(size);
	a->tbl = tbl;
	a->r = r;
	a->checkout = 1;
	a->freeflag = 0;
	a->next = aset->wa_list;
	aset->wa_list = a;
err:
	unlock_task(gbview_flame_lock,"");
	return a;
}

WF_WORK_AREA *
wf_checkout_work_area(WF_WORK_AREA_SET * aset,RESOURCE * r)
{
WF_WORK_AREA * a;
	lock_task(gbview_flame_lock);
	for ( a = aset->wa_list ;a ;a = a->next )
		if ( a->r == r ) {
			a->checkout ++;
			break;
		}
	unlock_task(gbview_flame_lock,"");
	return a;
}

int
wf_checkin_work_area(WF_WORK_AREA * a)
{
	lock_task(gbview_flame_lock);
	a->checkout --;
	if ( a->checkout < 0 )
		er_panic("wf_checkin_work_area");
	if ( a == 0 && a->freeflag ) {
		(*a->tbl->close)(a);
	}
	unlock_task(gbview_flame_lock,"");
	return 0;
}


void
_wf_close_work_area_set(WF_WORK_AREA_SET * aset)
{
WF_WORK_AREA * a, * a2;
	for ( a = aset->wa_list ; a ; ) {
		if ( a->checkout ) {
			a->freeflag = 1;
			a = a->next;
		}
		else {
			a2 = a->next;
			(a->tbl->close)(a);
			a = a2;
		}
	}
	aset->wa_list = 0;
}

void
wf_close_work_area_set(WF_WORK_AREA_SET * aset)
{
	lock_task(gbview_flame_lock);
	if ( aset->checkout )
		aset->freeflag = 1;
	else	_wf_close_work_area_set(aset);
	unlock_task(gbview_flame_lock,"");
}

void
wf_work_area_move(WF_WORK_AREA_SET * aset,void (*move_func)(I_POINT * ptr,int len,void * work),void * work)
{
WF_WORK_AREA * a;
I_POINT * buffer;
int buffer_len;
int p;
int gsize;
	lock_task(gbview_flame_lock);
	buffer = d_alloc(sizeof(I_POINT)*10);
	buffer_len = 10;
	p = 0;
	for ( a = aset->wa_list ; a ; a = a->next ) {
		for ( ; ; ) {
			gsize = (*a->tbl->get_interrested_point)(a,&buffer[p],buffer_len-p);
			if ( gsize <= buffer_len-p )
				break;
			buffer_len += 10;
			buffer = d_re_alloc(buffer,sizeof(I_POINT)*buffer_len);
		}
		p += gsize;
	}
	buffer_len = p;
	(*move_func)(buffer,buffer_len,work);
	p = 0;
	for ( a = aset->wa_list ; a ; a = a->next ) {
		p += (*a->tbl->set_interrested_point)(a,&buffer[p]);
	}
	unlock_task(gbview_flame_lock,"");
}

void
wf_work_area_flush(WF_WORK_AREA_SET * aset)
{
WF_WORK_AREA * a;
	lock_task(gbview_flame_lock);
	for ( a = aset->wa_list ; a ; a = a->next )
		(*a->tbl->flush_area)(a);
	unlock_task(gbview_flame_lock,"");
}

WF_WORK_AREA_SET *
wf_new_work_area_set()
{
WF_WORK_AREA_SET * ret;
	ret = d_alloc(sizeof(*ret));
	ret->checkout = 0;
	ret->wa_list = 0;
	ret->freeflag = 0;
	return ret;
}

void
wf_checkout_work_area_set(WF_WORK_AREA_SET * aset)
{
	lock_task(gbview_flame_lock);
	aset->checkout ++;
	unlock_task(gbview_flame_lock,"");
	return;
}

void
wf_checkin_work_area_set(WF_WORK_AREA_SET * aset)
{
	lock_task(gbview_flame_lock);
	aset->checkout --;
	if ( aset->checkout < 0 )
		er_panic("wf_checkin_work_Area_set");
	if ( aset->checkout == 0 && aset->freeflag ) {
		_wf_close_work_area_set(aset);
		d_f_ree(aset);
	}
	unlock_task(gbview_flame_lock,"");
}


void
wf_mouse_mode(GBVIEW_FLAME * gf,int mode,I_POINT ptr,INTEGER64 tim)
{
RADAR_CACHE * rc;
	if ( gf == 0 )
		return;
	rc = (RADAR_CACHE*)gf->radar_ptr;
	rc_set_mouse_mode(rc,mode,ptr,tim);
}



