/**********************************************************************
 
	Copyright (C) 2008- Hirohisa MORI <joshua@globalbase.org>
 
	This program is free software; you can redistribute it 
	and/or modify it under the terms of the GLOBALBASE 
	Library General Public License (G-LGPL) as published by 

	http://www.globalbase.org/
 
	This program is distributed in the hope that it will be 
	useful, but WITHOUT ANY WARRANTY; without even the 
	implied warranty of MERCHANTABILITY or FITNESS FOR A 
	PARTICULAR PURPOSE.

**********************************************************************/


#include	"memory_debug.h"
#include	"xl.h"
#include	"xlerror.h"
#include	"utils.h"
#include	"spidering.h"

XL_SEXP * gb_SPls();

void
init_gb_SPls(XLISP_ENV * env1)
{
	set_env(env1,l_string(std_cm,"SPls"),
		get_func_prim(gb_SPls,FO_APPLICATIVE,0,1,2));
}

XL_SEXP *
gb_SPls(XLISP_ENV * env,XL_SEXP * s,
	XLISP_ENV * a,
	XL_SYM_FIELD * sf)
{
XL_SEXP * path;
XL_SEXP * pwd;
L_CHAR * target_path;
int len1,len2;
SP_READDIR_LIST * lst, * lst2;
XL_SEXP * ret;
	if ( list_length(s) == 1 ) {
		pwd = eval(env,n_get_symbol("___pwd"));
		if ( get_type(pwd) != XLT_STRING )
			target_path = nl_copy_str(std_cm,"root");
		else	target_path = ll_copy_str(pwd->string.data);
	}
	else {
		path = get_el(s,1);
		if ( memcmp(path->string.data,l_string(std_cm,"root"),sizeof(L_CHAR)*4) == 0 ) {
			target_path = ll_copy_str(path->string.data);
		}
		else if ( l_strcmp(path->string.data,l_string(std_cm,"-")) == 0 ) {
			target_path = 0;
		}
		else {
			pwd = eval(env,n_get_symbol("___pwd"));
			if ( get_type(pwd) != XLT_INTEGER )
				target_path = ll_copy_str(path->string.data);
			else {
				target_path = ll_copy_str(pwd->string.data);
				len1 = l_strlen(target_path);
				len2 = l_strlen(path->string.data);
				target_path = d_re_alloc(target_path,sizeof(L_CHAR)*(len1+len2+1));
				l_strcpy(&target_path[len1],path->string.data);
			}
		}
	}
	if ( target_path )
		lst = readdir_sp_list(wa_list,target_path);
	else	lst = readdir_sp_list_all(wa_list);
	ret = 0;
	for ( lst2 = lst ; lst2 ; lst2 = lst2->next ) {
		ret = cons(get_string(lst2->path),ret);
	}
	if ( target_path)
		d_f_ree(target_path);
	free_sp_readdir_list(lst);
	return reverse(ret);
/*
type_missmatch:
	return get_error(
		s->h.file,
		s->h.line,
		XLE_SEMANTICS_TYPE_MISSMATCH,
		l_string(std_cm,"SPls"),
		0);
invalid_param:
	return get_error(
		s->h.file,
		s->h.line,
		XLE_PROTO_INV_PARAM,
		l_string(std_cm,"SPls"),
		n_get_string("invlid path"));
*/
}

