/**********************************************************************
 
	Copyright (C) 2008 Hirohisa MORI <joshua@globalbase.org>
 
	This program is free software; you can redistribute it 
	and/or modify it under the terms of the GLOBALBASE 
	Library General Public License (G-LGPL) as published by 

	http://www.globalbase.org/
 
	This program is distributed in the hope that it will be 
	useful, but WITHOUT ANY WARRANTY; without even the 
	implied warranty of MERCHANTABILITY or FITNESS FOR A 
	PARTICULAR PURPOSE.

**********************************************************************/


#include	"resource.h"
#include	"routing.h"
#include	"memory_debug.h"
#include	"xlerror.h"

/*
	(gvGetWorldfile ".map URL of object" ".crd file of base coordinate")
	Return (filaname (pair list data of matrix of worldfile))
	option dir="forward/reverse" default=forward
		prefix=".tfw" default= non prefix
*/


XL_SEXP * gv_gvGetWorldfile();

void
init_gvGetWorldfile(XLISP_ENV * env0,XLISP_ENV * env1)
{
	set_env(env1,l_string(std_cm,"gvGetWorldfile"),
		get_func_prim(gv_gvGetWorldfile,FO_APPLICATIVE,0,3,3));
}

AFFEN2D
get_matrix_of_map(int * er,MAP_PARAMETER * mp)
{
AFFEN2D ret;
	*er = 0;
	switch ( mp->type ) {
	case MT_MOVE:
		ret.org = mp->opt.ptr;
		return ret;
	case MT_ROTATE:
	case MT_LINEAR:
		return mp->opt.affen;
	}
	*er = -1;
	memset(&ret,0,sizeof(ret));
	return ret;
}


XL_SEXP *
gv_gvGetWorldfile(XLISP_ENV * env,XL_SEXP * s,XLISP_ENV * a,XL_SYM_FIELD * sf)
{
XL_SEXP * _map,* _crd;
L_CHAR * map,* crd;
char * e_msg;
RESOURCE * map_r;
RESOURCE * lst_r;
int ses;
URL u;
XL_SEXP * ret;
MAP_HISTORY * mh,*mh2;
AFFEN2D a2d;
int _dir;
L_CHAR * dir;
int p;
L_CHAR * prefix;
int len,p_len;
L_CHAR * filename;
XL_SEXP * e_sub = 0;
	_map = get_el(s,1);
	e_msg = ".map file typemissmatch";
	if ( get_type(_map) != XLT_STRING )
		goto type_missmatch;
	map = _map->string.data;
	e_msg = ".crd file typemissmatch";
	_crd = get_el(s,2);
	if ( get_type(_crd) != XLT_STRING )
		goto type_missmatch;
	crd = _crd->string.data;
	get_url2(&u,map);
	ses = open_session(SEST_OPTIMIZE);
	map_r = load_resource(ses,&u,Q_PRI_OBJ);
	free_url(&u);
	
	e_msg = "cannot load map resource";
	if ( map_r == 0 ) {
		e_sub = get_string(map);
		goto inv_param;
	}
	lst_r = load_resource(ses,&map_r->map.src,Q_PRI_OBJ);
	e_msg = "cannot load lst resource of source of map";
	if ( lst_r == 0 ) {
		e_sub = get_string(get_url_str2(&map_r->map.src));
		goto inv_param;
	}
	e_msg = ".lst file dest not luster type";
	if ( lst_r->h.type != RT_LUSTER )
		goto inv_param;
	mh = resolve_mappath(ses,get_url_str2(&map_r->map.dest),crd,RR_WM_DIRECT);
	if ( mh == MP_MH_NO_ROUTE )
		goto no_route_error;
	if ( mh == 0 ) {
		a2d.org.x = a2d.org.y = 0;
		a2d.matrix[0][0] = a2d.matrix[1][1] = 1;
		a2d.matrix[0][1] = a2d.matrix[1][0] = 0;
	}
	else {
	int er;
		mh2 = optimize_mh(mh);
		free_mh(mh);
		mh = mh2;
		if ( mh && mh->next ) {
			e_msg = "cannot optimize map history to linear 1";
			goto inv_param_2;
		}
		switch ( mh->type ) {
		case MHT_MAP:
			if ( mh->dir == MHD_FORWARD )
				a2d = get_matrix_of_map(&er,&mh->d.map->map.param_forward);
			else	a2d = get_matrix_of_map(&er,&mh->d.map->map.param_reverse);
			if ( er == -1 ) {
				e_msg = "cannot optimize map history to linear 3";
				goto inv_param_2;
			}
			break;
		case MHT_LINEAR:
			if ( mh->dir == MHD_FORWARD )
				a2d = mh->d.ln.forward;
			else	a2d = mh->d.ln.reverse;
			break;
		default:
			e_msg = "cannot optimize map history to linear 2";
			goto inv_param_2;
		}
	}
	a2d.matrix[0][0] /= lst_r->pr64.dpm;
	a2d.matrix[0][1] /= lst_r->pr64.dpm;
	a2d.matrix[1][0] /= lst_r->pr64.dpm;
	a2d.matrix[1][1] /= lst_r->pr64.dpm;
	
	dir = get_sf_attribute(sf,l_string(std_cm,"dir"));
	e_msg = "invalid parameter of attribute dir";
	if ( dir == 0 )
		_dir = 1;
	else if ( l_strcmp(dir,l_string(std_cm,"forward")) == 0 )
		_dir = 1;
	else if ( l_strcmp(dir,l_string(std_cm,"reverse")) == 0 )
		_dir = 0;
	else	goto inv_param_2;
	
	if ( _dir == 0 ) {
	double tmp;
		tmp = a2d.matrix[0][0];
		a2d.matrix[0][0] = a2d.matrix[1][0];
		a2d.matrix[1][0] = tmp;

		tmp = a2d.matrix[0][1];
		a2d.matrix[0][1] = a2d.matrix[1][1];
		a2d.matrix[1][1] = tmp;

		tmp = a2d.org.x;
		a2d.org.x = a2d.org.y;
		a2d.org.y = tmp;
	}
	ret = List(
		get_floating(a2d.matrix[0][0],0),
		get_floating(a2d.matrix[0][1],0),
		get_floating(a2d.matrix[1][0],0),
		get_floating(a2d.matrix[1][1],0),
		get_floating(a2d.org.x,0),
		get_floating(a2d.org.y,0),
		-1);
	filename = ll_copy_str(map_r->map.src.resource);
	prefix = get_sf_attribute(sf,l_string(std_cm,"prefix"));
	if ( prefix ) {
		p_len = l_strlen(prefix);
		for ( p = (len = l_strlen(filename))-1 ; p >= 0 && filename[p] != '.' ; p -- );
		if ( p < 0 ) {
			filename = d_re_alloc(filename,(len+p_len+1)*sizeof(L_CHAR));
			memcpy(&filename[len],prefix,sizeof(L_CHAR)*(p_len+1));
		}
		else {
			filename = d_re_alloc(filename,(p+p_len+1)*sizeof(L_CHAR));
			memcpy(&filename[p],prefix,sizeof(L_CHAR)*(p_len+1));
		}
	}
	ret = List(get_string(filename),ret,-1);
	goto end_all;
no_route_error:
	ret = get_error(
		s->h.file,
		s->h.line,
		XLE_PROTO_NO_ROUTE,
		l_string(std_cm,"ResolveMappingPath"),
		n_get_string("there is no route of mapping path"));
	goto end1;
inv_param:
	ret = get_error(
		s->h.file,
		s->h.line,
		XLE_PROTO_INV_PARAM,
		l_string(std_cm,"gvGetWorldfile"),
		List(n_get_string("invalida parameter"),
			n_get_string(e_msg),
			e_sub,
			-1));
	goto end1;
inv_param_2:
	ret = get_error(
		s->h.file,
		s->h.line,
		XLE_PROTO_INV_PARAM,
		l_string(std_cm,"gvGetWorldfile"),
		List(n_get_string("invalida parameter"),
			n_get_string(e_msg),
			-1));
	goto end2;
type_missmatch:
	ret = get_error(
		s->h.file,
		s->h.line,
		XLE_SEMANTICS_TYPE_MISSMATCH,
		l_string(std_cm,"gvGetWorldfile"),
		List(n_get_string("type missmatch"),
			n_get_string(e_msg),
			-1));
	goto end0;
end_all:
	;
end2:
	free_mh(mh);
end1:
	close_session(ses);
end0:
	return ret;
}


