/**********************************************************************
 
	Copyright (C) 2003 Hirohisa MORI <joshua@nichibun.ac.jp>
 
	This program is free software; you can redistribute it 
	and/or modify it under the terms of the GLOBALBASE 
	Library General Public License (G-LGPL) as published by 

	http://www.globalbase.org/
 
	This program is distributed in the hope that it will be 
	useful, but WITHOUT ANY WARRANTY; without even the 
	implied warranty of MERCHANTABILITY or FITNESS FOR A 
	PARTICULAR PURPOSE.

**********************************************************************/



#ifndef ___GBVIEW_H___
#define ___GBVIEW_H___

#include	"task.h"
#include	"resource.h"
#include	"window.h"



typedef struct select_indicate {
	struct select_indicate *	next;
	int		x;
	int		y;
	int		w;
	int		h;
	unsigned long *	pixels;
	REAL1		t;
	REAL1		rev_t;
} SELECT_INDICATE;

typedef struct select_work {
	OBJ *			select_obj;
	MAP_HISTORY *		mh;
	MAP *			map;
	GB_COLOR_INT		color;
	SELECT_INDICATE *	si;
	int			width;
	int			height;
} SELECT_WORK;


typedef struct symbol_indicate {
	struct symbol_indicate * next;
	int			rno;
	int			code;
	int			sub;
	int			flags;
#define SIF_DRAW		0x00000001
#define SIF_NEW			0x00000002
#define SIF_ANCOR		0x00000004
	GB_RECT			rect;
	unsigned int *		data;
	unsigned char *		alpha;
	L_CHAR *		ref;
} SYMBOL_INDICATE;

/* cmd for wf_insert_si */
#define ISI_INSERT		1
#define ISI_INFO		2

typedef struct info_list {
	struct info_list *	next;
	RESOURCE * 		r;
	OBJ *			obj;
	int			code;
	int			flags;
	XL_SEXP *		info;
	void 			(*func)();
	void *			func_work;
} INFO_LIST;


typedef struct lock_d {
	char *		_file;
	int		_line;
	HTID		tid;
	int		pri;
	unsigned int	time;
	int		lock_cnt;
} LOCK_D;


typedef struct gv_resource_list {
	RESOURCE *			draw;
	L_CHAR *			entry;
	int				flags;
	REAL1				weight;
	struct gv_resource_list *	next;
} GV_RESOURCE_LIST;

typedef struct gv_auth_info {
	WF_ID				id;
	RESOURCE *			r;
	struct gbview_flame *		gf;
} GV_AUTH_INFO;


typedef struct gbview_flame {
	int		id;
	int		status;
#define GVFS_IDLE	1
#define GVFS_ACTIVE	2
#define GVFS_ZONBIE	4
#define GVFS_ZONBIE_2	8
#define GVFS_ZONBIE_3	0x10

#define GVFM_LIVE	(GVFS_IDLE|GVFS_ACTIVE)
#define GVFM_ZONBIE	(GVFS_ZONBIE|GVFS_ZONBIE_2|GVFS_ZONBIE_3)

#define ZONBIE_CHECK(gf,func,ret)	\
	if ( (gf)->status & GVFM_ZONBIE ) {	\
		(func);			\
		return (ret);			\
	}
#define ZONBIE_CHECK_VOID(gf,func)	\
	if ( (gf)->status & GVFM_ZONBIE ) {	\
		(func);				\
		return;				\
	}
#define ZONBIE_CHECK_BREAK(gf,func)	\
	if ( (gf)->status & GVFM_ZONBIE ) {	\
		(func);				\
		break;				\
	}

	int		seq;

	LC_WRITING_STYLE * default_ws;

	LOCK_D		_ls_lock;

	LOCK_D		_wf_lock;

	LOCK_D		indicate_lock;

	int		ex_lock;
	int		req_task_nos;
	int		req_task_nos2;
	int		run_req_task_nos;
	int		load_task_max;
	unsigned	load_task_max_tick:1;
	struct win_flame *	flame;
	struct win_flame *	flame_base;
	GB_POINT		flame_base_center;
	REAL1			flame_base_rotate;
	REAL1			flame_base_resolution;
	MAP_HISTORY		flame_base_display_map;
	int			flame_base_geo_type;
	
	int			flame_base_y_offset;
		/* for e1d :: y coordinate on the WIN of [top of first wf base] computer axis*/
	SELECT_INDICATE * si;
	char *		redraw;
#define RP_REDRAW		1
#define RP_DIRTY		2
	unsigned long *	redraw_plane;
	int		redraw_flag;
	I_RECT		redraw_r;


	int		ls_flags;
#define LSF_ZOOM	0x00000001
#define LSF_MOVE	0x00000002
#define LSF_CURRENT	0x00000004
#define LSF_BASE_FREE	0x00000008
#define LSF_ASSERT	0x0000000f
	int		ls_task_cnt;


	INDICATE *	_indicate;
	INFO_LIST *	infolist;

	int		win_width;
	int		win_height;

	INFO_LIST *	click_op_list;

	void		(*event)(struct gbview_flame*,int,void*,void*);
#define ET_REDRAW	1	/* no additional info */
#define ET_CLICK	2	/* GBVIEW_PLANE * */
#define ET_INFO		3	/* GBVIEW_STATUS */
#define ET_INSERT	4	/* 0 */
#define ET_CHANGE_BASE	5	/* 0 */
#define ET_LOCK_BASE	6	/* 0 */
#define ET_STATUS	7	/* 0 */
#define ET_AUTH		8	/* GV_AUTH_INFO * */

	void *		event_user_arg;

	void		(*radar_event)(struct gbview_flame*,int,void*,void*);
	void *		radar_event_user_arg;
	
	GV_RESOURCE_LIST * resource_list;

	void *		radar_ptr;
	
	unsigned	history_enable:1;
	unsigned	history_flag:1;

	char		exit_task_wp;
	char		redraw_wp;
	char		load_structure_wp;
	int		indicate_req;
	int		indicate_task_active;
	int		raw_image_request;
	
	INTEGER64	move_timer;

	int		zonbie_timeout;

	unsigned	move_flag:1;
	unsigned	redraw_delay_flag:1;
	unsigned	redrow_flag:1;
	
	struct gbview_flame *	next;
} GBVIEW_FLAME;


typedef struct wf_loading_status {
	int		data_request;
	int		indicate_request;
	int		raw_image_request;
	int		indicate;
	unsigned	draw:1;
	unsigned	exit:1;
	unsigned	load_structure:1;
	unsigned	dirty:1;
} WF_LOADING_STATUS;

typedef struct gbview_layer_status {
	struct gbview_layer_status *	next;
	WF_ID				id;
	L_CHAR * 			entry_url;
	L_CHAR *			target_url;
	RESOURCE *			r;
	int				flags;
	int				mh_length;
	
	INTEGER64			hide_time;
	I_RECT				small_rect;
	GB_POINT			center[2];
	REAL1				distance;
} GBVIEW_LAYER_STATUS;

typedef struct gbview_status {
	int		flags;
#define SF_LAYER_NOS	0x00000001
#define SF_WIDTH	0x00000002
#define SF_HEIGHT	0x00000004
#define SF_INDICATE	0x00000008
#define SF_INFOLIST	0x00000010
#define SF_EVENT	0x00000020
#define SF_DEFAULT_WS	0x00000040
#define SF_CURRENT	0x00000080
#define SF_LAYERS	0x00000100
#define SF_STATUS	0x00000200
#define SF_LOADING	0x00000400
#define SF_HIS_ENABLE	0x00000800
#define SF_HIS_FLAG	0x00001000

#define SF_ERROR	0x80000000
#define SF_CENTER	0x40000000
#define SF_RESOLUTION	0x20000000
#define SF_ROTATE	0x10000000
#define SF_UNIT		0x08000000
#define SF_MAP_TYPE	0x04000000
#define SF_GEO_TYPE	0x02000000
#define SF_PP_RADIUS	0x01000000
#define SF_REFERENCE	0x00800000
#define SF_RADAR	0x00400000

#define SF_DONT_SEQ	0x00200000

#define SF_BASE		0x00001fff
#define SF_ALL		0xffe01fff

#define SF_LAYER_DETAILS 0x00100000

	int		status;
	int		layer_nos;
	int		width;
	int		height;
	GB_POINT	flame_base_center;
	REAL1		flame_base_resolution;
	REAL1		flame_base_rotate;
	L_CHAR *	flame_base_unit;
	int		flame_base_display_map_type;
	int		flame_base_geo_type;

	INDICATE *	indicate;
	INFO_LIST *	infolist;
	void		(*event)(struct gbview_flame*,int,void*,void*);
	void *		event_user_arg;
	LC_WRITING_STYLE * default_ws;
	WF_ID		current;
	GBVIEW_LAYER_STATUS * current_ls;

	GBVIEW_LAYER_STATUS *	layers;

	WF_LOADING_STATUS	loading_status;
	
	unsigned	history_enable:1;
	unsigned	history_flag:1;

	/* option */

	REAL1		pp_radius;
	L_CHAR *	reference;

} GBVIEW_STATUS;


typedef struct gbview_header {
	int		type;
	int		seq;
} GBVIEW_HEADER;


typedef struct gbview_redraw {
	GBVIEW_HEADER	h;
#define GPT_REDRAW	1
	I_RECT		r;
	unsigned long *	plane;
} GBVIEW_REDRAW;

typedef struct gbview_zoom {
	GBVIEW_HEADER	h;
#define GPT_ZOOM	2
	int *		index_x;
	int *		index_y;
} GBVIEW_ZOOM;


typedef union gbview_plane{
	GBVIEW_HEADER	h;
	GBVIEW_REDRAW	r;
	GBVIEW_ZOOM	z;
} GBVIEW_PLANE;


typedef struct gbview_plot_element {
	struct gbview_plot_element *	next;
	int				rno;
	int				code;
	int				sub;
	GB_RECT				rect;
	L_CHAR *			ref;
} GBVIEW_PLOT_ELEMENT;

typedef struct si_gbview {
	char		dm_sched_type;
#define DMST_FIFO	1
#define DMST_SIZE	2
} SI_GBVIEW;

typedef struct wfid_include_resource {
	struct wfid_include_resource *	next;
	WF_ID				id;
	GBVIEW_FLAME * 			gf;
} WFID_INCLUDE_RESOURCE;

typedef struct info_req_queue {
	Q_HEADER		h;
	int			cmd;
#define IRQ_ONLY_FETCH		1
#define IRQ_INDICATE_CARD	2
#define IRQ_INDICATE_ONMAP	3
	int			code;
	RESOURCE *		r;
	GBVIEW_FLAME *		gf;
	WF_ID			wfid;
	int			counter;
} INFO_REQ_QUEUE;



#define SIG_DM_SCHED_TYPE	0x00000001

INDICATE * _search_indicate(INDICATE*,URL *);
INDICATE * _insert_indicate(INDICATE**,URL *);
INDICATE * _copy_indicate(GBVIEW_FLAME *);
void free_indicate(INDICATE *);

void wakeup_wf(GBVIEW_FLAME * gf,WF_ID wfid);
RESOURCE * wf_get_resource(GBVIEW_FLAME * gf,WF_ID id);
void xx_free_win_flame(GBVIEW_FLAME * gf,WF_ID wfid,char * __file,int __line);
#define free_win_flame(gf,wfid)	xx_free_win_flame((gf),(wfid),__FILE__,__LINE__)
void wakeup_wf(GBVIEW_FLAME * gf,WF_ID wfid);
int
wf_space_check_si(
	GBVIEW_FLAME * 	gf,
	WF_ID		wfid,
	int 		rno,
	int		code,
	int		sub,
	GB_RECT * 	rect,
	int		percent);

WF_ID wf_get_current(GBVIEW_FLAME *);
void _calc_pitch(GBVIEW_FLAME *,int);
void calc_pitch(GBVIEW_FLAME *,int);
int cache_image(
	GBVIEW_FLAME * gf,
	WF_ID wf_id,
	RESOURCE * c,
	GB_POINT * pt_list,
	REAL1 * pt_reso,
	unsigned long * buf,
	int size,
	GB_RECT * r,
	MAP_HISTORY *mh,
	SURP_SET * surp,
	int methd,
	int flags,
	void * dw_work);


int wf_redraw(GBVIEW_FLAME * gf,GBVIEW_PLANE * p,int x,int y,int w,int h);
int wf_select(GBVIEW_PLANE * p,OBJ *);
void wf_allredraw(WF_ID);
GBVIEW_FLAME * wf_search(WF_ID * ret_id,RESOURCE *);
int new_win_flame(
	WF_ID*		ret_wf,
	GBVIEW_FLAME *	gf,
	REAL1		v_reso,
	RESOURCE * 	draw,
	MAP_HISTORY * 	mh,
	GB_POINT	center,
	REAL1		rotate,
	REAL1		resolution);
int wf_zoom(GBVIEW_FLAME * ,GBVIEW_PLANE* ,REAL1);
void wf_redraw_buffer(WF_ID wfid,int mode);
int wf_rotate(GBVIEW_FLAME * gf,GB_POINT from,GB_POINT to);



extern char http_hostname[100];
extern int http_port;

int wf_goto_point(
	GBVIEW_FLAME * gf,
	L_CHAR * url,
	GB_POINT ptr,
	REAL1 rotate,
	REAL1 reso,
	int flags);

#define GP_IGN_PTR	0x00000001
#define GP_IGN_ROTATE	0x00000002
#define GP_IGN_RESO	0x00000004



int read_pixelmap(unsigned char col[3],int,int);
int draw_image(
/*	VOBJECT * obj,*/
	int ix,
	int iy,
	int w,
	int h);
int draw_resource(GBVIEW_FLAME *,RESOURCE*,DRAW_WORK *);
int check_resource(RESOURCE*,CHECK_WORK*);
int get_point_resource(GBVIEW_FLAME * ,RESOURCE*,GET_POINT_WORK *);
int get_point_object(GBVIEW_FLAME *,RESOURCE *,OBJ*,GET_POINT_WORK *);
int draw_object(GBVIEW_FLAME * gf,OBJ *,DRAW_WORK *);

DRAW_MATRIX * new_draw_matrix(WF_ID,
	RESOURCE*,DRAW_MATRIX *,int,int);
void digging_matrix(int *,WF_ID,RESOURCE *,GB_RECT * r,int lev);
DRAW_MATRIX * get_dm_of_position(RESOURCE * r,int lod,GB_POINT pt);

void *
get_ri(int * w,int * h,GBVIEW_FLAME * gf,WF_ID req,L_CHAR * path);
int free_object(RESOURCE*,OBJ*);
void free_object_list(RESOURCE*);
XL_SEXP * get_card_info(RESOURCE * r,INFO_SCHEME *,XL_SEXP * org);
XL_SEXP * get_onmap_info(RESOURCE * r,INFO_SCHEME *,XL_SEXP * org,REAL1 * reso);
PIC get_onmap_string_pic(GBVIEW_FLAME * gf,XL_SEXP*);
void test_draw_object(RESOURCE * r);

void
wf_indicate(GBVIEW_FLAME * gf,GBVIEW_STATUS *,int,int,int);
int wf_click(GBVIEW_FLAME * gf,GBVIEW_STATUS * ,GBVIEW_PLANE *,int,int);

int
wf_insert_si(
	GBVIEW_FLAME * gf,
	int	cmd,
	WF_ID wf,
	int rno,
	int	code,
	int	sub,
	GB_RECT * rect,
	unsigned int * data,
	unsigned char * alpha,
	int flags,
	L_CHAR * ref);
WF_ID wf_get(GBVIEW_FLAME * gf,int);
void
indicate_onmap(GBVIEW_FLAME *,int,WF_ID wf,RESOURCE * r,OBJ * o,GB_POINT ind_ptr);
INFO_LIST * copy_infolist(GBVIEW_FLAME * );
INFO_LIST * copy_infolist_r(INFO_LIST * il);
void free_infolist(INFO_LIST *);
WFID_INCLUDE_RESOURCE * wf_search_wfid_include_resource(RESOURCE * r);
void free_wfid_include_resource(WFID_INCLUDE_RESOURCE * wir);
int min_route_wf(GBVIEW_FLAME * gf,int ses);


void
insert_ic(L_CHAR * url,int type);
#define ICT_OVERWRAP	0
#define ICT_ZOOM	1

int insert_point(
	RESOURCE *,
	OBJ *,
	RING_TYPE *,int,REAL1,REAL1,int,int,GB_POINT*,GB_POINT*,
	unsigned int code);

XL_SEXP * _dgb_p2d_trailer(RESOURCE * r,XL_SEXP * data);

void
wf_insert_dirty_rect(RESOURCE * r,GB_RECT * d_rect,int flags,
		     int ofs_w,int ofs_h);



unsigned long put_color(unsigned long a,GB_COLOR_INT * col);

int set_si_gbview(char * server,int active_flags,SI_GBVIEW * data);

int
wf_button_action(GBVIEW_FLAME * gf,OBJ * o,char * type);
void wf_status(GBVIEW_FLAME * gf,GBVIEW_STATUS *);
void wf_status_flags(GBVIEW_FLAME * gf,GBVIEW_STATUS *,int);
void wf_init_status(GBVIEW_STATUS * e);
void wf_free_status(GBVIEW_STATUS *);
int wf_set_status(GBVIEW_FLAME * gf,GBVIEW_STATUS *);
void wf_free_plane(GBVIEW_PLANE * p);

int list2gvstatus(XL_SEXP * list, GBVIEW_STATUS *gs);
XL_SEXP * gvstatus2list(GBVIEW_STATUS * gs);

int list2gbp(XL_SEXP * list, GBVIEW_PLANE * gbp);
XL_SEXP * gbp2list(GBVIEW_PLANE * gbp, XL_SYM_FIELD * sf);
XL_SEXP * _gbp2list(GBVIEW_PLANE  * gbp, L_CHAR * format, int jpeg_quality);


void _sleep_at_exit_task_wp(GBVIEW_FLAME*,int);
void _wakeup_at_exit_task_wp(GBVIEW_FLAME*);
void sleep_at_exit_task_wp(GBVIEW_FLAME*);
void wakeup_at_exit_task_wp(GBVIEW_FLAME*);

void _sleep_at_redraw_wp(GBVIEW_FLAME*,int);
void _wakeup_at_redraw_wp(GBVIEW_FLAME*);
void sleep_at_redraw_wp(GBVIEW_FLAME*);
void wakeup_at_redraw_wp(GBVIEW_FLAME*);

void xx_wf_lock(GBVIEW_FLAME * gf,char *,int);
#define wf_lock(gf)	xx_wf_lock(gf,__FILE__,__LINE__)
void wf_unlock(GBVIEW_FLAME * gf);
void wf_sleep_task(GBVIEW_FLAME * gf,int key);
void ch_lock(LOCK_D *,char * file,int line);
void ch_unlock(LOCK_D *,void (*f)(),void* wk);
void ch_sleep_task(int key,LOCK_D * bit,void (*f)(),void* wk);
int _ch_locked(LOCK_D * d);

void assert_ls(GBVIEW_FLAME *,int flags);
void assert_ls_all(int flags);

GBVIEW_FLAME * wf_get_gf_from_id(int);
void wf_apply_all_gf(int (*func)(),void * work,int status,int lock_flag);
void wf_init_status(GBVIEW_STATUS * e);
void set_pointer_indicate(GBVIEW_FLAME * gf,int flags,URL * u);
void _setup_wf_flags(GBVIEW_FLAME *,struct win_flame * );
void _call_flame_insert_event(GBVIEW_FLAME * gf);
void call_flame_insert_event(GBVIEW_FLAME * gf);
void call_flame_change_base_event(GBVIEW_FLAME * gf);
void _call_flame_change_base_event(GBVIEW_FLAME * gf);
int wf_set_overlay(GBVIEW_FLAME *,L_CHAR*,int,int);
void force_change_task();

void view_init(int,char**);

int select_resource(
	RESOURCE * r,
	SELECT_WORK * sw);
int get_point_default(
	GBVIEW_FLAME * gf,
	RESOURCE * r,
	GET_POINT_WORK * p);
int select_default();
int check_default(RESOURCE * r,CHECK_WORK * chk);
int exit_lock_resource(RESOURCE * r,int data);


int check_error_time(RESOURCE * r);
void init_coordinate_browse();
void in_memcpy(void * a,void * b,int size);
void setup_minrect(MAP * m);
int browse_children(RESOURCE * r,BROWSE_WORK * bw,int * hit_route);
LOAD_RESOURCE_WORK * load_children_map(RESOURCE * r,BROWSE_WORK * bw);
int browse_children_map(int ses,RESOURCE * r,BROWSE_WORK * bw,
	LOAD_RESOURCE_WORK * w);
int browse_children_obj(RESOURCE * r,BROWSE_WORK * bw);
int browse_parents(RESOURCE * r,BROWSE_WORK * bw,int *hit_route);
int browse_coord_route(RESOURCE * r,BROWSE_WORK * bw);
void do_initial(RESOURCE * r);
int do_button_action(RESOURCE * r,char * type,L_CHAR * name);
int browse_coord(RESOURCE * r,BROWSE_WORK * bw);
void limit_reso_control(
	REAL1 * dest,
	REAL1 src);
void draw_coordinate(
	GBVIEW_FLAME * gf,
	RESOURCE * r,
	DRAW_WORK * dw);
int select_coordinate(
	RESOURCE * r,
	SELECT_WORK * sw);
int check_coordinate(
	RESOURCE * r,
	CHECK_WORK * chk);
void get_point_coordinate(
	GBVIEW_FLAME * gf,
	RESOURCE* r,
	GET_POINT_WORK * w);
int exit_lock_coord(
	RESOURCE * r,
	int data);
XL_SEXP * dgb_end(XLISP_ENV * e,XL_SEXP * s);
XL_SEXP * dgb_information(XLISP_ENV * e,XL_SEXP * s,
	XLISP_ENV * a,XL_SYM_FIELD * sf);
int _get_tile_id(RESOURCE * r,int code);
XL_SEXP * dgb_mark(XLISP_ENV * e,XL_SEXP * s,
	XLISP_ENV * a,
	XL_SYM_FIELD * sf);
int draw_mark(
	GBVIEW_FLAME * gf,
	OBJ * o,
	DRAW_WORK * dw);
int get_point_mark(
	GBVIEW_FLAME * gf,
	RESOURCE * r,
	OBJ * o,
	GET_POINT_WORK * w);
void free_mark(
	OBJ * o);
int select_mark(
	OBJ * o,
	SELECT_WORK * sw);
int olist_mark(OBJ * o,XL_SEXP ** ret);
XL_SEXP * dgb_p2d_trailer(XLISP_ENV * e,XL_SEXP * s);
XL_SEXP * dgb_point(XLISP_ENV * e,XL_SEXP * s,
	XLISP_ENV * a,
	XL_SYM_FIELD * sf);
int get_lod_of_position(RESOURCE * r,GB_POINT pt);
void touch_obj_mem(int size);
void scan_polygon2d(RESOURCE * r);
void scan_dm_point_list(DRAW_MATRIX * dm);
POINT_LIST * lod_next(POINT_LIST * n,RING_TYPE * h,int lod,GB_RECT * tr);
POINT_LIST * lod_prev(POINT_LIST * n,RING_TYPE * h,int lod,GB_RECT * tr);
XL_SEXP * dgb_polygon2d(XLISP_ENV * e,XL_SEXP * s,
	XLISP_ENV * a,
	XL_SYM_FIELD * sf);
int reasion(
	int *	low_flag,
	int *	high_flag,
	int	target,
	REAL1 * low,
	REAL1 * high,
	REAL1 * low_pt,
	REAL1 * high_pt,
	int top,
	int bottom,
	REAL1 a,
	REAL1 b);
void line_to(
	unsigned long * buf,
	GB_POINT a,
	GB_POINT b,
	GB_COLOR_INT * col,
	int ix,
	int iy,
	int w,
	int h,
	int ww);
void fill(char * fill_buf,GB_RECT * r2d,
	int w,int h,
	I_POINT p1,I_POINT p2,
	int fg1,int fg2);
I_POINT gb2i_point(GB_POINT p);
void get_objrect(GB_RECT * r,OBJ * o,DRAW_WORK * dw);
int padding(GB_POINT * indp,OBJ * o,DRAW_WORK * dw);
int draw_polygon2d(
	GBVIEW_FLAME * gf,
	OBJ * o,
	DRAW_WORK * dw);
int check_ptr(GB_POINT p1,GB_POINT p2,int fg1,int fg2,GB_POINT pt);
int get_point_polygon2d(
	GBVIEW_FLAME * gf,
	RESOURCE * r,
	OBJ * o,
	GET_POINT_WORK * w);
void indicate_info_card(GBVIEW_FLAME * gf,RESOURCE * r,OBJ * o);
INFO_LIST * get_perfect_infolist(GBVIEW_FLAME * gf);

int free_polygon2d(
	OBJ * o);
int select_padding(OBJ * o,SELECT_WORK * sw,GB_RECT * minrect,GB_COLOR_INT * c);
int select_polygon2d(
	OBJ * o,
	SELECT_WORK * sw);
int olist_polygon2d(OBJ * o,XL_SEXP ** ret);
XL_SEXP * get_gb_color(GB_COLOR_INT * col,GB_COLOR * gbc);
XL_SEXP * get_color(GB_COLOR_INT * col,XL_SEXP * s);
XL_SEXP * dgb_line_color(XLISP_ENV * e,XL_SEXP * s,
	XLISP_ENV * a,XL_SYM_FIELD * sf);
XL_SEXP * dgb_padding_color(XLISP_ENV * e,XL_SEXP * s,
	XLISP_ENV * a,XL_SYM_FIELD * sf);

void init_draw_gb();
void init_draw_matrix();
GB_RECT * get_object_minrect(OBJ * o);
WF_ID free_dm(DRAW_MATRIX * dm);
void insert_scheme(
	INFO_SCHEME ** is_header,
	L_CHAR * scheme,
	int	card_type,
	int	onmap_type,
	L_CHAR * card,
	L_CHAR * onmap);
int get_object_list_func(AVT_NODE * a,XL_SEXP ** ret);
int object_list(OBJ * o,XL_SEXP ** ret);
XL_SEXP * get_object_list(RESOURCE * r);
int get_point_draw(
	GBVIEW_FLAME * gf,
	RESOURCE *	r,
	GET_POINT_WORK * w);
void divide_ol(RT_OBJ_LIST * ol,RT_OBJ_LIST ** ret1,RT_OBJ_LIST ** ret2);
int cmp_ol(RT_OBJ_LIST * ol1,RT_OBJ_LIST * ol2);
RT_OBJ_LIST * marge_ol(RT_OBJ_LIST * ol1,RT_OBJ_LIST * ol2);
void check_obj_list(RT_OBJ_LIST * ol);
void draw_draw_gb(
	GBVIEW_FLAME * gf,
	RESOURCE* r,
	DRAW_WORK * dw);
int select_draw_gb_func(AVT_NODE * a,SELECT_WORK * sw);
int select_object(OBJ * o,SELECT_WORK *sw);
int select_draw_gb(
	RESOURCE * r,
	SELECT_WORK * sw);
int check_vector(RESOURCE * r,CHECK_WORK * chk);
int exit_lock_vector(RESOURCE * r,int data);

void make_dg();
RT_OBJ_LIST * sort_obj_list(RT_OBJ_LIST * ol);
void dm_gc_obj();
void gc_dm();
int get_dm_th();
void _aboat_dm_loading();
void _reset_tile_id(RESOURCE * r);
int check_request();
int loading_draw(
	DRAW_MATRIX * dm,
	int lev_min,
	int lev_max,
	GB_RECT * rct,
	DRAW_MATRIX ** dm_list,
	int ses);
int loading_draw_tile(
	DRAW_MATRIX * dm,
	int lev_min,
	int lev_max,
	GB_RECT * rct,
	DRAW_MATRIX ** dm_list,
	int ses);
int set_dm_list(DRAW_MATRIX ** list,int ptr,DRAW_MATRIX * dm);
int check_loaded(DRAW_MATRIX * dm,DRAW_MATRIX ** dm_list,int dm_ptr);
void set_dm_ac(DRAW_MATRIX * dm);
int load_dm(int ses,DRAW_MATRIX *dm);
DRAW_MATRIX * get_next_dm1();
DRAW_MATRIX * get_next_dm2();
DRAW_MATRIX * get_next_dm();
int dm_last_access(int * ret_p);
int _get_lod_of_position(RESOURCE * r,DRAW_MATRIX * dm,GB_POINT pt);
DRAW_MATRIX * _get_dm_of_position(RESOURCE * r,DRAW_MATRIX * dm,int lod,GB_POINT pt);

void dsc_init();
L_CHAR * get_attr(XL_SEXP * sym,L_CHAR * name);
void ds_centerize(PIC_LIST * pl);
void ds_pair_non_symbol(GBVIEW_FLAME * gf,PIC_LIST * pl,XL_SEXP * info);
void ds_cr(PIC_LIST * pl);
void ds_pair_symbol(GBVIEW_FLAME * gf,PIC_LIST * pl,XL_SEXP * info);
void ds_pair(GBVIEW_FLAME* gf,PIC_LIST * pl,XL_SEXP * info);
void ds_string_data(GBVIEW_FLAME * gf,PIC_LIST * pl,L_CHAR * data);
void ds_integer(GBVIEW_FLAME * gf,PIC_LIST * pl,XL_SEXP * info);
void ds_float(GBVIEW_FLAME * gf,PIC_LIST * pl,XL_SEXP * info);
void ds_string(GBVIEW_FLAME * gf,PIC_LIST * pl,XL_SEXP * info);
void free_pic(PIC p);

int dummy();

XL_SEXP *
gv_goto_point(XLISP_ENV * e,XL_SEXP * s,
	XLISP_ENV * a,XL_SYM_FIELD * sf);
void init_gv_goto_point(XLISP_ENV * env);
void gc_view_lock();
void gc_indicate_lock();
void gc_view_unlock();
void gc_indicate_unlock();
void gc_view();
void gc_setup();
void gc_indicate();
void gc_style();

XL_SEXP * gv_set_visible_resolution(XLISP_ENV * env,XL_SEXP * s,
	XLISP_ENV * a,XL_SYM_FIELD * sf);
void gf_init_indicate(GBVIEW_FLAME * gf);
void xx_wf_indicate_lock(GBVIEW_FLAME * gf,char * file,int line);
#define wf_indicate_lock(gf)	xx_wf_indicate_lock(gf,__FILE__,__LINE__)
void wf_indicate_unlock(GBVIEW_FLAME * gf);
void wf_irq_lock(GBVIEW_FLAME * gf);
void wf_irq_unlock(GBVIEW_FLAME * gf);
void xx_wf_iom_lock(char*,int);
void xx_wf_iom_unlock(char*,int);
#define wf_iom_lock()	xx_wf_iom_lock(__FILE__,__LINE__)
#define wf_iom_unlock()	xx_wf_iom_unlock(__FILE__,__LINE__)
void gc_indicate_func(GBVIEW_FLAME * gf);
void _delete_indicate(INDICATE**,URL * u);
void _clear_info(GBVIEW_FLAME * gf);
INFO_LIST * _copy_infolist(GBVIEW_FLAME * gf);
L_CHAR * get_info_url(XL_SEXP * info);
void click_info_url(GBVIEW_FLAME * gf,L_CHAR * url);
void click_infolist(GBVIEW_FLAME * gf);
void click_info_error(GBVIEW_FLAME * gf);
void ready_indicate(GBVIEW_FLAME * gf);
void free_info_req_queue(INFO_REQ_QUEUE * q);
void insert_irq(GBVIEW_FLAME * gf,RESOURCE * r,int code,int cmd,WF_ID wfid);
int ir_cmp_code(INFO_REQ_QUEUE * q,int * code);
void delete_irq(int rno,int code);
int invoke_indicate(GBVIEW_FLAME * gf,void (* func)(),void * func_work);
void request_onmap_info(GBVIEW_FLAME * gf,RESOURCE * r,OBJ * o,WF_ID wfid);
void _indicate_onmap(GBVIEW_FLAME * gf,int draw_flag,
	WF_ID wfid,RESOURCE * r,OBJ * o,GB_POINT ind_ptr);
void insert_indicate_info(GBVIEW_FLAME * gf,
	RESOURCE * r,int code,int flags,XL_SEXP * data);
void formating_info(RESOURCE * r,OBJ * o);
int setup_info(GBVIEW_FLAME * gf,WF_ID wfid,RESOURCE * r,XL_SEXP * info);
XL_SEXP * setup_info_cmd(GBVIEW_FLAME * gf,WF_ID wfid,RESOURCE * r,int code,XL_SEXP * info);
int check_irq(int ses,GBVIEW_FLAME * gf,RESOURCE * r);

XL_SEXP * gv_default_dgb_pixels(XLISP_ENV * env,XL_SEXP * s);
XL_SEXP * initial_query(XLISP_ENV * env,XL_SEXP * s,
	XLISP_ENV * a,XL_SYM_FIELD * sf);

XL_SEXP * get_initial_query(XLISP_ENV * env,XL_SEXP * s);
XL_SEXP * image_enhancement(XLISP_ENV * e,XL_SEXP * s);
XL_SEXP * window_size(XLISP_ENV * e,XL_SEXP * s);
XL_SEXP * font_size(XLISP_ENV * e,XL_SEXP * s,XLISP_ENV * a,XL_SYM_FIELD * sf);
XL_SEXP * overlay_transparent(URL * u,XLISP_ENV * e,XL_SEXP * s);
XL_SEXP * overlay_csuperinpose(URL * u,XLISP_ENV * e,XL_SEXP * s);
XL_SEXP * overlay(XLISP_ENV * e,XL_SEXP * s);
XL_SEXP * indicate(XLISP_ENV * e,XL_SEXP * s);
XL_SEXP *  set_http_client(XLISP_ENV * e,XL_SEXP * s);
XL_SEXP * xl_set_cache(XLISP_ENV * env,XL_SEXP * s,XLISP_ENV * a,XL_SYM_FIELD * sf);
XL_SEXP * xl_get_cache(XLISP_ENV * env,XL_SEXP * s);
XL_SEXP * xl_status_param(XLISP_ENV * env,XL_SEXP * s);
void write_proxy_server_list(STREAM * st,XL_SEXP * sl);
void write_proxy_info(STREAM * st);
void write_native_proxy_server_list(STREAM * st,XL_SEXP * sl);
void write_native_proxy_info(STREAM * st);
void write_cache_info(STREAM * st);
XL_SEXP * xl_write_status(XLISP_ENV * e,XL_SEXP * s);
XL_SEXP * xl_reset_status(XLISP_ENV * e,XL_SEXP * s);
void init_param_script(STREAM * st);
void init_init();
void init_gv_resource_option(XLISP_ENV * env);
void init_style();
void init_gbview();
void init_obj_memory();
void init_luster_r64();
XL_SEXP * loading_from_network(L_CHAR * url, XLISP_ENV * e);
void open_control_port();
void load_parameter(L_CHAR * parameter, int initialize_on_err);
void load_peripheral(L_CHAR * peripheral);

DRAW_MATRIX * get_dm(RESOURCE * r,POINT_LIST * p);
int cmp_obj_code(OBJ * o1,OBJ * o2);
int insert_code_tree(RESOURCE * r,OBJ * o);
int print_mem_size();

void copy_buf_p(unsigned long * buf,
	char * ptr,
	int w,int h);
void copy_buf_g(unsigned long * buf,
	char * ptr,
	int w,int h);
int get_query_r64(
	XL_SEXP ** query_p,
	XL_SEXP ** tmp_p,
	I_RECT * ir,
	TREE_CACHE * 	tc,
	TREE_NODE *	tn);
int get_pixel_r64(
	TREE_CACHE * 	tc,
	TREE_NODE *	tn,
	XL_SEXP *	reply,
	XL_SEXP *	tmp);
unsigned long * get_cr_buf(
	I_RECT * ir,
	TREE_NODE * parent,
	XL_SEXP * ret,
	XL_SEXP * query,
	int ww,int hh);
int get_query_cr(
	XL_SEXP ** query_p,
	XL_SEXP ** tmp_p,
	I_RECT * ir,
	TREE_CACHE * 	tc,
	TREE_NODE *	tn);
int get_pixel_cr(
	TREE_CACHE * 	tc,
	TREE_NODE *	tn,
	XL_SEXP *	reply,
	XL_SEXP *	tmp);


void insert_pixel_req(WF_ID wfid,RESOURCE * r,int lev,int x,int y);
void draw_pixel_data(
	GBVIEW_FLAME * gf,
	RESOURCE* r,
	DRAW_WORK * dw);
int get_point_pixel_data(
	GBVIEW_FLAME * gf,
	RESOURCE *	r,
	GET_POINT_WORK * w);


void init_sring(STYLE_FILE * sf);
void insert_sring(STYLE_FILE * s1,STYLE_FILE * s2);
void delete_sring(STYLE_FILE * s);
void gc_style_file(STYLE_FILE * sf);
int gc_style_func(AVT_NODE * a);
int  cmp_style(STYLE_FILE * sf1,STYLE_FILE * sf2);
STYLE_FILE * _insert_style_file(L_CHAR * name,int type,int sts,XL_SEXP * style);
STYLE_FILE * insert_style_file(L_CHAR * name,int type,int sts,XL_SEXP * style);
XL_SEXP * get_xl_env(XL_SEXP * style);
void fetch_style_file(int ses,STYLE_FILE * sf);
STYLE_FILE *search_style_file(L_CHAR * name,int type,int wait_flag);
INFO_SCHEME *search_scheme(INFO_SCHEME * is,L_CHAR * scheme);
STYLE_FILE *get_info_style(INFO_SCHEME * is_org,L_CHAR * scheme,int type,int wait_flag);
void setup_onmap_env(RESOURCE * r,XLISP_ENV * env);
XL_SEXP * _get_styled_info(RESOURCE * r,INFO_SCHEME*is_org,int type,XL_SEXP * org,REAL1 * reso);
void style_load_task();

char * skip_space(char * p);
char * skip_char(char * p);
char *  skip_element(char * p);
XL_SEXP * svg_path(XLISP_ENV * e,XL_SEXP * s,
	XLISP_ENV * a,
	XL_SYM_FIELD * sf);

XL_SEXP * rqr_list(XL_SEXP * q);
XL_SEXP * rqr_URL(XL_SEXP * q);
XL_SEXP * rqr_pair(XL_SEXP * q);

void gv_set_version();
XL_SEXP * start_gbview();

XL_SEXP * dgb_tile(XLISP_ENV * e,XL_SEXP * s,
	XLISP_ENV * a,XL_SYM_FIELD * sf);
int tile_id_cmp(TILE_ID_LIST * tl1,TILE_ID_LIST * tl2);
int _new_tile_id(RESOURCE * r,int code);
void loading_file(L_CHAR *, L_CHAR *,int);

void get_dsc(LC_STRING_PIC * pp,L_CHAR * str,LC_WRITING_STYLE * ws,int size);

XL_SEXP *gv_lang(XLISP_ENV * e,XL_SEXP * s,XLISP_ENV * a,XL_SYM_FIELD * sf);
XL_SEXP * gv_theme(XLISP_ENV * e,XL_SEXP * s,XLISP_ENV * a,XL_SYM_FIELD * sf);
XL_SEXP * xl_dummy();
void _call_re_base_lock(GBVIEW_FLAME * gf,int type);


void touch_object(RESOURCE * ,OBJ * o);
void release_object(RESOURCE * ,OBJ * o);
int client_quit();
void wf_set_data_request(GBVIEW_FLAME * gf,WF_ID id,int r);


void wf_free_plot_element(GBVIEW_PLOT_ELEMENT *);
GBVIEW_PLOT_ELEMENT * wf_plot_element(GBVIEW_FLAME * gf,WF_ID id);
GBVIEW_PLOT_ELEMENT * wf_all_plot_element(GBVIEW_FLAME * gf);
int
get_object_minrect2(GB_RECT * rct,RESOURCE * r,unsigned int code);
void *
get_from_network(XL_SEXP ** err,int ses,int * size,L_CHAR * path);
int
set_hwf(int d,int save_flag);
int
set_draw_mapping(int d,int save_flag);
unsigned long
convert_rgba_to_cc(unsigned int cc);
void
_wf_set_delay_redraw_exec(GBVIEW_FLAME * gf);
void
wf_set_delay_redraw_exec(GBVIEW_FLAME * gf);
void
_wf_set_delay_redraw(GBVIEW_FLAME * gf);
void
wf_set_delay_redraw(GBVIEW_FLAME * gf);
void
wf_set_delay_redraw_flag(GBVIEW_FLAME * gf,int fg);
void
_wf_set_delay_redraw_flag(GBVIEW_FLAME * gf,int fg);
void
wf_mouse_mode(GBVIEW_FLAME * gf,int mode,I_POINT ptr,INTEGER64 tim);



extern XLISP_ENV * vector_env;

#endif

