/**********************************************************************
 
	Copyright (C) 2003 Hirohisa MORI <joshua@nichibun.ac.jp>
 
	This program is free software; you can redistribute it 
	and/or modify it under the terms of the GLOBALBASE 
	Library General Public License (G-LGPL) as published by 

	http://www.globalbase.org/
 
	This program is distributed in the hope that it will be 
	useful, but WITHOUT ANY WARRANTY; without even the 
	implied warranty of MERCHANTABILITY or FITNESS FOR A 
	PARTICULAR PURPOSE.

**********************************************************************/


#ifndef ___RECORDLIST64_H___
#define ___RECORDLIST64_H___

#include	"pdb64_basic.h"

typedef struct chain_list64 {
	struct chain_list64 *	next;
	void *			ptr;
	INTEGER64		len;
	int			free_flag;
} CHAIN_LIST64;

typedef struct record_list64 {
	struct record_list64 *	next;
	PN64_HEADER		header;
	U_INTEGER64		fofs;
	void *			data;
	void *			ptr;
	INTEGER64		body;
	CHAIN_LIST64 *		chain_head;
	CHAIN_LIST64 *		chain_tail;
	unsigned		enable_header;
} RECORD_LIST64;



RECORD_LIST64 *
read_recordlist64(int * sts,char * filename);
int write_recordlist64(char * filename,RECORD_LIST64 * lst,int mode);
void set_recordlist_ptr64(RECORD_LIST64 * lst,INTEGER64 body);
int check_recordlist_ptr64(RECORD_LIST64 * lst);
void set_recordlist_chain64(RECORD_LIST64 * lst,void * ptr,INTEGER64 len,int free_flag);
void free_recordlist64(RECORD_LIST64 * lst);
RECORD_LIST64 * xx_new_recordlist64(unsigned short type,U_INTEGER64 size,char*,int);
#define new_recordlist64(type,size)	xx_new_recordlist64((type),(size),__FILE__,__LINE__)
int setup_recordlist64(RECORD_LIST64 * lst);
void
set_recordlist_chain64_middle(
	RECORD_LIST64 * lst,CHAIN_LIST64 * before,void * ptr,INTEGER64 len,int free_flag);
void
setup_recordlist64_size(RECORD_LIST64 * lst);

#define RLS_OK	0
#define RLS_CANNOT_OPEN	(-1)
#define RLS_READ_ERROR	(-2)
#define RLS_CORRUPT	(-3)

#endif

