/**********************************************************************
 
	Copyright (C) 2003 Hirohisa MORI <joshua@nichibun.ac.jp>
 
	This program is free software; you can redistribute it 
	and/or modify it under the terms of the GLOBALBASE 
	Library General Public License (G-LGPL) as published by 

	http://www.globalbase.org/
 
	This program is distributed in the hope that it will be 
	useful, but WITHOUT ANY WARRANTY; without even the 
	implied warranty of MERCHANTABILITY or FITNESS FOR A 
	PARTICULAR PURPOSE.

**********************************************************************/

#include	"long_char.h"
#include	"lc_encode.h"
#include	"text_render.h"

extern TR_LANG black_box_render;
extern TR_LANG en_render,ctl_render,ja_render;
extern TR_L_CHAR_TBL2_HEADER unicode_ja_h;

TR_LANG * default_tr_lang = &en_render;

extern TR_L_CHAR_TBL2 unicode_ja[];

TR_L_CHAR_TBL tr_l_char_table[] = {
	{'\n',LCZM_ALL,&ctl_render,0},
	{'\r',LCZM_ALL,&ctl_render,0},
	{LCZ_2BC_UNICODE_v1_1_JP,LCZM_2B_TYPE,0,&unicode_ja_h},
	{LCZ_1BC_JISX0201,LCZM_1B_TYPE,&ja_render,0},
	{LCZ_2BC_JISX0208_1990,LCZM_2B_TYPE,&ja_render,0},
	{LCZ_2BC_JISX0208_1983,LCZM_2B_TYPE,&ja_render,0},
	{LCZ_2BC_JISX0208_1978,LCZM_2B_TYPE,&ja_render,0},
	{LCZ_2BC_JISX0212_1990,LCZM_2B_TYPE,&ja_render,0},
	{LCZ_2BC_MAC_JAPANESE,LCZM_2B_TYPE,&ja_render,0},
	{LCZ_3BC_NICHIBUN,LCZM_2B_TYPE,&ja_render,0},
	{LCZ_3BC_KONJAKU,LCZM_3B_TYPE,&ja_render,0},
	{LCC_ERROR,LCZM_ALL,&black_box_render,0},
	{0,0,0,0}
};

TR_L_CHAR_TBL2 unicode_ja[] = {
	{0x3040,0x30a0,&ja_render},	/* hiragana */
	{0x30a0,0x3100,&ja_render},	/* katakana */
	{0x31f0,0x3200,&ja_render},	/* Katakana Phonetic Ext. */
	{0x3200,0x3300,&ja_render},	/* Enclosed CJK Letter and Months */ 
	{0x3300,0x3400,&ja_render},	/* CJK compatibility */
	{0x3400,0x4dc0,&ja_render},	/* CJK ideographic Ext. A */
	{0x4e00,0x9fb0,&ja_render},	/* CJK unified ideographs */
	{0xf900,0xfb00,&ja_render},	/* CJK compatibility ideographs */
	{0xfe30,0xfe50,&ja_render},	/* CJK compatibility forms */
	{0x20000,0x2a6e0,&ja_render},	/* CJK unified ideographs Ext. B */
	{0x2f800,0x2fa20,&ja_render},	/* CJK compatibility ideographs supplement */
	{0,0,0,}
};

TR_L_CHAR_TBL2_HEADER unicode_ja_h = {&unicode_ja[0],0};


