/**********************************************************************
 
	Copyright (C) 2003 Hirohisa MORI <joshua@nichibun.ac.jp>
 
	This program is free software; you can redistribute it 
	and/or modify it under the terms of the GLOBALBASE 
	Library General Public License (G-LGPL) as published by 

	http://www.globalbase.org/
 
	This program is distributed in the hope that it will be 
	useful, but WITHOUT ANY WARRANTY; without even the 
	implied warranty of MERCHANTABILITY or FITNESS FOR A 
	PARTICULAR PURPOSE.

**********************************************************************/

#include "vpf_std.h"
#include "vpf_node.h"
#include "vpf_table.h"
#include "vpf_file.h"
#include "coordinate_conv.h"

// VPF_NODE_RECORD
VPF_RECORD_READER_BEGIN(
	node_record_read, 
	VPF_NODE_RECORD)

	VPF_READ_FIELD(id)
	VPF_READ_FIELD_MULTI(pft_id)
	VPF_READ_FIELD(containing_face)
	VPF_READ_FIELD(first_edge)
	VPF_READ_FIELD(coordinate)

VPF_RECORD_READER_END()


void node_record_delete(VPF_NODE_RECORD *e){
	if(e==0)
		return;
	free(e);
}


VPF_NODE_RECORD *vpf_table_get_node(VPF_TABLE *table, LONG id)
{
	VPF_LIST_ITEM *it;
	VPF_NODE_RECORD *r;
	for(it = table->records->head; it; it=it->next){
		r = (VPF_NODE_RECORD *)it->data;
		if(r->id == id)
			return r;
	}
	return NULL;
}
