/**********************************************************************
 
	Copyright (C) 2007- Hirohisa MORI <joshua@nichibun.ac.jp>
 
	This program is free software; you can redistribute it 
	and/or modify it under the terms of the GLOBALBASE 
	Library General Public License (G-LGPL) as published by 

	http://www.globalbase.org/
 
	This program is distributed in the hope that it will be 
	useful, but WITHOUT ANY WARRANTY; without even the 
	implied warranty of MERCHANTABILITY or FITNESS FOR A 
	PARTICULAR PURPOSE.

**********************************************************************/

#include	"machine/include.h"
#include	"memory_debug.h"
#include	"pri_level.h"
#include	"lock_level.h"
#include	"utils.h"
#include	"task.h"
#include	"matrix.h"
#include	"xl.h"
#include	"xlerror.h"
#include	"pg_vector.h"
#include	"xl_zlib.h"

void mem_test();
void gc_tick_notin_tick();


XL_SEXP *
xl_mxObjID(XLISP_ENV * env,XL_SEXP * s,XLISP_ENV * a,XL_SYM_FIELD * sf);

void
init_mxObjID(XLISP_ENV * env)
{
	set_env(env,l_string(std_cm,"mxObjID"),
		get_func_prim(xl_mxObjID,FO_APPLICATIVE,0,1,2));
}


XL_SEXP *
xl_mxObjID(XLISP_ENV * env,XL_SEXP * s,XLISP_ENV * a,XL_SYM_FIELD * sf)
{
XL_SEXP *dc;
INTEGER64 * dim_code1;
MATRIX_ALLOC_BLOCK_PARAM * d1,pb;
L_CHAR * compress;
int _compress_flag;
int p_size;
char * ptr,*pp;
int free_flag;
char * err_msg;
INTERNAL_PLOT * _ch,*ip;
RECORD_LIST64 * rl;
void * d;
XL_SEXP * ret;
MATRIX_TOKEN * t;
MATRIX * m;
SIMPLE_ALLOC_T sat;

	t = get_env_work(env);
	if ( t == 0 )
		return 0;
	m = t->process_node->matrix;

	compress = get_sf_attribute(sf,l_string(std_cm,"compress"));
	if ( compress == 0 )
		_compress_flag = 0;
	else if ( l_strcmp(compress,l_string(std_cm,"on")) == 0 )
		_compress_flag = 1;
	else if ( l_strcmp(compress,l_string(std_cm,"off")) == 0 )
		_compress_flag = 0;
	else {
		err_msg = "compress";
		goto inv_param;
	}

	dc = get_el(s,1);
	dim_code1 = get_dim_code_from_sexp(m,get_el(dc,1));
	d1 = get_vdata_from_sexp(get_el(dc,2));
	err_msg = "CH data type(2)";
	if ( d1 == 0 )
		goto type_missmatch;
	if ( _compress_flag ) {
		ptr = pp = zlib_uncompress(&p_size,d1->block,d1->size);
		err_msg = "zlib uncompress";
		if ( pp == 0 )
			goto inv_param;
		ptr ++;
		p_size --;
		free_flag = 1;
	}
	else {
		p_size = d1->size;
		ptr = pp = d1->block;
		free_flag = 0;
	}
	_ch = code2internal(m,(PRIMITIVE_PLOT*)ptr,p_size,&sat);
	err_msg = "internal plot code";
	if ( _ch == 0 )
		goto inv_param;

	for ( ip = _ch ; ip ; ip = ip->next ) {
		if ( ip->flags & PP_ID )
			continue;
		ip->flags |= PP_ID;
		ip->id = get_matrix_obj_id(m);
ss_printf("---IP %p %x\n",ip,ip->id);
	}

	pb.block = (void*)internal2code(&pb.size,m,_ch);
	pb.h.type = MDT_BLOCK;
	free_smp(&sat);	
	if ( _compress_flag ) {
		rl = new_recordlist64(0,0);
		set_recordlist_chain64(rl,&pb.h.type,sizeof(pb.h.type),0);
		set_recordlist_chain64(rl,pb.block,pb.size,1);
		p_size = setup_recordlist64(rl);
		
		pb.block = zlib_compress(&pb.size,rl->data,p_size,7);
		
		free_recordlist64(rl);
	}
	d = (*mx_type_block.alloc_data)(&mx_type_block,MD_MMALLOC,&pb,0,
			__FILE__,__LINE__);
	d_f_ree(pb.block);

	ret = List(n_get_symbol("data"),
		get_sexp_from_dim_code(m,dim_code1),
		get_ptr(d,gc_mtx_block),
		-1);

	d_f_ree(dim_code1);

	return ret;
	
type_missmatch:
	ret = get_error(
		s->h.file,
		s->h.line,
		XLE_SEMANTICS_TYPE_MISSMATCH,
		l_string(std_cm,"mxPgPlotSort"),
		List(n_get_string("type missmatch"),n_get_string(err_msg),-1));
	return ret;
inv_param:
	ret = get_error(
		s->h.file,
		s->h.line,
		XLE_PROTO_INV_PARAM,
		l_string(std_cm,"mxPgPlotSort"),
		List(n_get_string("invalid parameter in mxPgPlotDiff"),n_get_string(err_msg),-1));
	return ret;
}





