/**********************************************************************
 
	Copyright (C) 2003 Hirohisa MORI <joshua@nichibun.ac.jp>
 
	This program is free software; you can redistribute it 
	and/or modify it under the terms of the GLOBALBASE 
	Library General Public License (G-LGPL) as published by 

	http://www.globalbase.org/
 
	This program is distributed in the hope that it will be 
	useful, but WITHOUT ANY WARRANTY; without even the 
	implied warranty of MERCHANTABILITY or FITNESS FOR A 
	PARTICULAR PURPOSE.

**********************************************************************/


#include	<fcntl.h>

#include	"xlerror.h"
#include	"xl.h"
#include	"xl2pdb_p.h"
#include	"svg2gb.h"

STREAM * info_tmp;

XL_SEXP * xl_information();
XL_SEXP * xl_information_tmpfile();

void
init_information(XLISP_ENV * env)
{    
	set_env(env,l_string(std_cm,"information"),
		get_func_prim(xl_information,FO_NORMAL,0,1,-1));
	set_env(env,l_string(std_cm,"information-tmpfile"),
		get_func_prim(xl_information_tmpfile,FO_APPLICATIVE,
				0,1,1));
}

XL_SEXP *
xl_information_tmpfile(XLISP_ENV * env,XL_SEXP * s,
	XLISP_ENV * a,XL_SYM_FIELD * sf)
{
L_CHAR * target;
	target = get_sf_attribute(sf,
			l_string(std_cm,"target"));
	if ( l_strcmp(target,l_string(std_cm,"open")) == 0 ) {
		info_tmp = s_open_file("info.tmp",
			O_RDWR|O_CREAT|O_TRUNC,0644);
		if ( info_tmp == 0 ) {
			ss_printf("information cannot open the info.tmp");
			exit(1);
		}
		s_printf(info_tmp,"(\"information tempolary file\")\n");
	}
	else {
		s_printf(info_tmp,"(\"end of file\")\n");
	}
	return 0;
}

int information_cnt;

XL_SEXP *
xl_information(XLISP_ENV * env,XL_SEXP * s,
	XLISP_ENV * a,XL_SYM_FIELD * sf)
{
PDB_POLYGON2D * p;
XL_SEXP * ret;

if ( information_cnt == 0 )
ss_printf("infomation %i      \r",s->h.line);
information_cnt ++;
if ( information_cnt >= 200 )
information_cnt = 0;

	p = get_polygon(&ret, sf, s->h.file, s->h.line);
	if ( p == 0 ){
		PDB_MARK_TAGS *mark;
		mark = get_mark(&ret, sf, s->h.file, s->h.line);
		if(mark==0){
			return ret;
		}
		else{
			/*
			if(info_tmp == 0)
				mark->info = s;
			else{
				p->info_ofs = s_seek_file(info_tmp,0,SEEK_CUR);
				print_sexp(info_tmp,s,0);
				s_printf(info_tmp,"\n");
			}
			*/
			mark->info = s;
			return 0;
		}
	}

	if ( info_tmp == 0 )
		p->info = s;
	else {
		p->info_ofs = s_seek_file(info_tmp,0,SEEK_CUR);
		print_sexp(info_tmp,s,0);
		s_printf(info_tmp,"\n");
	}
	return 0;
}


