/**********************************************************************
 
	Copyright (C) 2003 Hirohisa MORI <joshua@nichibun.ac.jp>
 
	This program is free software; you can redistribute it 
	and/or modify it under the terms of the GLOBALBASE 
	Library General Public License (G-LGPL) as published by 

	http://www.globalbase.org/
 
	This program is distributed in the hope that it will be 
	useful, but WITHOUT ANY WARRANTY; without even the 
	implied warranty of MERCHANTABILITY or FITNESS FOR A 
	PARTICULAR PURPOSE.

**********************************************************************/




#ifdef VA2
#include	<varargs.h>
#else
#include	<stdarg.h>
#endif
#include	<fcntl.h>


#include	"log.h"


int (*__log_vprintf)(int,int,void *,char*,va_list);


int
log_vprintf(int level,int layer,void * opt,const char * fmt,va_list p)
{
int (*f)(int,int,void*,char*,va_list);

	f = __log_vprintf;
	if ( f )
		return (*f)(level,layer,opt,(char*)fmt,p);
	else	return -1;
}

int
log_printf(
	int level,
	int layer,
	void * opt,
	const char * fmt,...)
{
va_list p;
int ret;
int (*f)(int,int,void*,char*,va_list);

	f = __log_vprintf;
	if ( f == 0 )
		return -1;
#ifdef VA2
	va_start(p);
#else
	va_start(p,fmt);
#endif

	ret = (*f)(level,layer,opt,(char*)fmt,p);
	va_end(p);


	return ret;
}



