/**********************************************************************
 
	Copyright (C) 2003 Hirohisa MORI <joshua@nichibun.ac.jp>
 
	This program is free software; you can redistribute it 
	and/or modify it under the terms of the GLOBALBASE 
	Library General Public License (G-LGPL) as published by 

	http://www.globalbase.org/
 
	This program is distributed in the hope that it will be 
	useful, but WITHOUT ANY WARRANTY; without even the 
	implied warranty of MERCHANTABILITY or FITNESS FOR A 
	PARTICULAR PURPOSE.

**********************************************************************/



#include	"xl.h"
#include	"xlerror.h"


XL_SEXP *
gb_while(XLISP_ENV * e,XL_SEXP * s)
{
XL_SEXP * cond;
XL_SEXP * rr;
XLISP_ENV * ee;
XL_SEXP * ret;
XL_SEXP * er;
	ret = 0;
	er = 0;
	for ( ; ; ) {
		cond = eval(e,get_el(s,1));
		switch ( get_type(cond) ) {
		case XLT_ERROR:
			return cond;
		case XLT_INTEGER:
			if ( cond->integer.data == 0 )
				return ret;
			break;
		case XLT_FLOAT:
			if ( cond->floating.data == 0 )
				return ret;
			break;
		default:
			return get_error(
				cond->h.file,
				cond->h.line,
				XLE_SEMANTICS_TYPE_MISSMATCH,
				l_string(std_cm,"while"),
				list(n_get_string(
				"type missmatch for condition"),
					0));
		}
		ee = new_env(e);
		rr = cdr(cdr(s));
		for ( ; get_type(rr) ; rr = cdr(rr) ) {
			ret = eval(ee,car(rr));
			if ( get_type(ret) == XLT_ERROR ) {
				er = ret;
				break;
			}
		}
		if ( er )
			return er;
	}
}
