/**********************************************************************
 
	Copyright (C) 2003 Hirohisa MORI <joshua@nichibun.ac.jp>
 
	This program is free software; you can redistribute it 
	and/or modify it under the terms of the GLOBALBASE 
	Library General Public License (G-LGPL) as published by 

	http://www.globalbase.org/
 
	This program is distributed in the hope that it will be 
	useful, but WITHOUT ANY WARRANTY; without even the 
	implied warranty of MERCHANTABILITY or FITNESS FOR A 
	PARTICULAR PURPOSE.

**********************************************************************/


#include	"xlerror.h"
#include	"xl.h"
#include	"xllock.h"

XL_SEXP * xl_LockInfo();

extern XL_LOCK_LIST * xl_lock_hash[XL_LOCK_HASH_SIZE];
extern SEM xl_lock_lock;

void
init_LockInfo(XLISP_ENV * env)
{
	set_env(env,l_string(std_cm,"LockInfo"),
		get_func_prim(xl_LockInfo,FO_APPLICATIVE,0,1,1));
}

XL_SEXP *
xli_list(XLL_XLI_LIST * x)
{
XL_SEXP * ret;
	ret = 0;
	for ( ; x ; x = x->next ) {
		if ( x->file )
			ret = cons(
				List(
					get_integer(x->iid,0),
					get_integer(x->count,0),
					get_integer(x->seq,0),
					get_string(x->file),
					get_integer(x->line,0),
					get_integer(x->data,0),
					-1),
				ret);
		else	ret = cons(
				List(
					get_integer(x->iid,0),
					get_integer(x->count,0),
					get_integer(x->seq,0),
					-1),
				ret);
	}
	return ret;
}

XL_SEXP *
xl_LockInfo(XLISP_ENV * env,XL_SEXP * s)
{
int i;
XL_LOCK_LIST * x;
XL_SEXP * ret;
	lock_task(xl_lock_lock);
	ret = 0;
	for ( i = 0 ; i < XL_LOCK_HASH_SIZE ; i ++ )
		for ( x = xl_lock_hash[i] ; x ; x = x->next ) {
			ret = cons(List(get_string(x->name),
					get_integer(x->count,0),
					xli_list(x->xli_list),
					-1),
				ret);
		}
	unlock_task(xl_lock_lock,"xl_LockInfo");
	return ret;
}


