/**********************************************************************
 
	Copyright (C) 2003 Hirohisa MORI <joshua@nichibun.ac.jp>
 
	This program is free software; you can redistribute it 
	and/or modify it under the terms of the GLOBALBASE 
	Library General Public License (G-LGPL) as published by 

	http://www.globalbase.org/
 
	This program is distributed in the hope that it will be 
	useful, but WITHOUT ANY WARRANTY; without even the 
	implied warranty of MERCHANTABILITY or FITNESS FOR A 
	PARTICULAR PURPOSE.

**********************************************************************/

#include <windows.h>
#include	<winsock2.h>
#include	"memory_debug.h"
#include	"netutils.h"
#include "task.h"

extern SEM netutils_lock;

int
get_localhostip()
{
static int localip=0;
char hostname[256];
struct hostent *he;
int ret;

	if(localip != 0){
		return localip;
	}

	get_localhostname(hostname);
	
	lock_task(netutils_lock);
	he = gethostbyname(hostname);
	if(he){
		ret = ntohl(*(int*)he->h_addr_list[0]);
	}
	else{
		ret = 0x7f000001;
	}
	unlock_task(netutils_lock, "gethostbyname");
	
	localip = ret;
	return ret;
/*
struct hostent * hp;
char ** q;
int len;
int ret;
#ifndef WIN32
	sethostent(0);
#endif
	for ( ; ; ) {
#ifndef WIN32
		hp = gethostent();
#endif
		if ( hp == 0 ) {
#ifndef WIN32
			endhostent();
#endif
			return 0x7f000001;
		}
		q = hp->h_aliases;
		for ( ; *q ; q ++ ) {
			if ( strcmp((*q),"localhost") == 0 ) {
				q = 0;
				break;
			}
			if ( strcmp((*q),"loghost")
					== 0 )
				break;
		}
		if ( q == 0 )
			continue;
		if ( *q == 0 )
			continue;
		ret = ntohl(*(int*)hp->h_addr_list[0]);
#ifndef WIN32
		endhostent();
#endif
		return ret;
	}
	*/
}
