/**********************************************************************
 
	Copyright (C) 2003 Hirohisa MORI <joshua@nichibun.ac.jp>
 
	This program is free software; you can redistribute it 
	and/or modify it under the terms of the GLOBALBASE 
	Library General Public License (G-LGPL) as published by 

	http://www.globalbase.org/
 
	This program is distributed in the hope that it will be 
	useful, but WITHOUT ANY WARRANTY; without even the 
	implied warranty of MERCHANTABILITY or FITNESS FOR A 
	PARTICULAR PURPOSE.

**********************************************************************/



#include	"pfc.h"
#include	"task.h"
#include	"lock_level.h"

extern SEM pfc_lock_lock;

void
init_pcc()
{
	pfc_lock_lock = new_lock(LL_PCC);
}

int
new_pfc(PFC * p)
{
PFC p1;
int id;

	if ( lock_pfc(p) < 0 )
		return -1;
	p1 = *p;
	if ( load_pfc(&p1) >= 0 ) {
		p1.target = p->target;
		save_pfc(&p1);
		id = p->lock_id;
		*p = p1;
		p->lock_id = id;
		unlock_pfc(p);
		return -1;
	}
	p->last_checkpoint = get_xltime();
	p->accumulate = 0;
	save_pfc(p);
	unlock_pfc(p);
	return 0;
}
