/**********************************************************************
 
	Copyright (C) 2003 Hirohisa MORI <joshua@nichibun.ac.jp>
 
	This program is free software; you can redistribute it 
	and/or modify it under the terms of the GLOBALBASE 
	Library General Public License (G-LGPL) as published by 

	http://www.globalbase.org/
 
	This program is distributed in the hope that it will be 
	useful, but WITHOUT ANY WARRANTY; without even the 
	implied warranty of MERCHANTABILITY or FITNESS FOR A 
	PARTICULAR PURPOSE.

**********************************************************************/



#include	"jis.h"


extern JIS_TABLE	jis_table[];

void
jis_unicode2local(WCT * w)
{
WRITABLE_CODE_TABLE * t1,* t;
int i;
	t1 = set_wct(w,LCZ_2BC_UNICODE_v1_1_JP,LCZM_2B_TYPE,0,0);
	for ( i = 0 ; jis_table[i].unicode ; i ++ ) {
		if ( jis_table[i].jisx0212_1990 &&
				wct_check(w,jis_table[i].jisx0212_1990)
				== 0 ) {
			set_convert(w,
				jis_table[i].unicode|LCZ_2BC_UNICODE_v1_1_JP,
				LCZM_2B_TYPE,
				jis_table[i].jisx0212_1990,
				SC_ALL);
			continue;
		}
		if ( jis_table[i].jisx0208_1990 &&
				wct_check(w,jis_table[i].jisx0208_1990)
				== 0 ) {
			set_convert(w,
				jis_table[i].unicode|LCZ_2BC_UNICODE_v1_1_JP,
				LCZM_2B_TYPE,
				jis_table[i].jisx0208_1990,
				SC_ALL);
			continue;
		}
		if ( jis_table[i].jisx0208_1983 &&
				wct_check(w,jis_table[i].jisx0208_1983)
				== 0 ) {
			set_convert(w,
				jis_table[i].unicode|LCZ_2BC_UNICODE_v1_1_JP,
				LCZM_2B_TYPE,
				jis_table[i].jisx0208_1983,
				SC_ALL);
			continue;
		}
		if ( jis_table[i].jisx0208_1978 &&
				wct_check(w,jis_table[i].jisx0208_1978)
				== 0 ) {
			set_convert(w,
				jis_table[i].unicode|LCZ_2BC_UNICODE_v1_1_JP,
				LCZM_2B_TYPE,
				jis_table[i].jisx0208_1978,
				SC_ALL);
			continue;
		}
		if ( jis_table[i].jisx0201 &&
				wct_check(w,jis_table[i].jisx0201)
				== 0 ) {
			set_convert(w,
				jis_table[i].unicode|LCZ_2BC_UNICODE_v1_1_JP,
				LCZM_2B_TYPE,
				jis_table[i].jisx0201,
				SC_ALL);
			continue;
		}
	}
	set_wct(w,LCZ_2BC_UNICODE_v2_0_JP,LCZM_2B_TYPE,t1,0);
	set_wct(w,LCZ_2BC_UNICODE_v3_0_JP,LCZM_2B_TYPE,t1,0);
}


void
jis_convert(WCT * w,int bitmap)
{
WRITABLE_CODE_TABLE * rk,* jis1978,* jis1983,* jis1990,* jis_s;
int i;
	if ( bitmap & LCB_JISX0201 )
		rk = set_wct(w,LCZ_1BC_JISX0201,LCZM_1B_TYPE,0,0);
	if ( bitmap & LCB_JISX0212_1990 )
		jis_s = set_wct(w,LCZ_2BC_JISX0212_1990,LCZM_2B_TYPE,0,0);
	else	jis_s = 0;
	if ( bitmap & LCB_JISX0208_1978 )
		jis1978 = set_wct(w,LCZ_2BC_JISX0208_1978,LCZM_2B_TYPE,0,0);
	else	jis1978 = 0;
	if ( bitmap & LCB_JISX0208_1983 )
		jis1983 = set_wct(w,LCZ_2BC_JISX0208_1983,LCZM_2B_TYPE,0,0);
	else	jis1983 = 0;
	if ( bitmap & LCB_JISX0208_1990 )
		jis1990 = set_wct(w,LCZ_2BC_JISX0208_1990,LCZM_2B_TYPE,0,0);
	else	jis1990 = 0;



	for ( i = 0 ; jis_table[i].unicode ; i ++ ) {

		if ( jis_s && jis_table[i].jisx0212_1990 ) {
			set_convert(
				w,
				jis_table[i].jisx0212_1990,
				LCZM_2B_TYPE,
				jis_table[i].jisx0212_1990,
				SC_ALL);
			continue;
		}
		if ( rk && jis_table[i].jisx0201 ) {
			set_convert(
				w,
				jis_table[i].jisx0201,
				LCZM_2B_TYPE,
				jis_table[i].jisx0201,
				SC_ALL);
			continue;
		}
	}

	if ( jis1978 ) {
		for ( i = 0 ; jis_table[i].unicode ; i ++ ) {
			if ( jis_table[i].jisx0208_1978 == 0 )
				continue;
			set_convert(
				w,
				jis_table[i].jisx0208_1978,
				LCZM_2B_TYPE,
				jis_table[i].jisx0208_1978,
				SC_ALL);
		}
	}
	if ( jis1983 ) {
		for ( i = 0 ; jis_table[i].unicode ; i ++ ) {
			if ( jis_table[i].jisx0208_1983 == 0 )
				continue;
			set_convert(
				w,
				jis_table[i].jisx0208_1983,
				LCZM_2B_TYPE,
				jis_table[i].jisx0208_1983,
				SC_ALL);
			if ( jis_table[i].jisx0208_1978 == 0 )
				continue;
			set_convert(
				w,
				jis_table[i].jisx0208_1978,
				LCZM_2B_TYPE,
				jis_table[i].jisx0208_1983,
				SC_ALL);
		}
	}
	if ( jis1990 ) {
		for ( i = 0 ; jis_table[i].unicode ; i ++ ) {
			if ( jis_table[i].jisx0208_1990 == 0 )
				continue;
			set_convert(
				w,
				jis_table[i].jisx0208_1990,
				LCZM_2B_TYPE,
				jis_table[i].jisx0208_1990,
				SC_ALL);
			if ( jis_table[i].jisx0208_1978 ) {
				set_convert(
					w,
					jis_table[i].jisx0208_1978,
					LCZM_2B_TYPE,
					jis_table[i].jisx0208_1990,
					SC_ALL);
			}
			if ( jis_table[i].jisx0208_1983 ) {
				set_convert(
					w,
					jis_table[i].jisx0208_1983,
					LCZM_2B_TYPE,
					jis_table[i].jisx0208_1990,
					SC_ALL);
			}
		}
	}

	if ( jis1990 )
		return;
	for ( i = 0 ; jis_table[i].unicode ; i ++ ) {
		if ( jis_table[i].jisx0208_1990 == 0 )
			continue;
		if ( jis1983 && jis_table[i].jisx0208_1983 ) {
			set_convert(
				w,
				jis_table[i].jisx0208_1990,
				LCZM_2B_TYPE,
				jis_table[i].jisx0208_1983,
				SC_ALL);
			continue;
		}
		if ( jis1978 && jis_table[i].jisx0208_1978 ) {
			set_convert(
				w,
				jis_table[i].jisx0208_1990,
				LCZM_2B_TYPE,
				jis_table[i].jisx0208_1978,
				SC_ALL);
		}
	}
	if ( jis1983 )
		return;
	for ( i = 0 ; jis_table[i].unicode ; i ++ ) {
		if ( jis_table[i].jisx0208_1983 == 0 )
			continue;
		if ( jis1978 && jis_table[i].jisx0208_1978 ) {
			set_convert(
				w,
				jis_table[i].jisx0208_1983,
				LCZM_2B_TYPE,
				jis_table[i].jisx0208_1978,
				SC_ALL);
		}
	}
}


void
jis_local2unicode(WCT * w)
{
WRITABLE_CODE_TABLE * rk,* jis1978,* jis1983,* jis1990,* jis_s;
int i;
	rk = get_wct(w,LCZ_1BC_JISX0201);
	jis_s = get_wct(w,LCZ_2BC_JISX0212_1990);
	jis1978 = get_wct(w,LCZ_2BC_JISX0208_1978);
	jis1983 = get_wct(w,LCZ_2BC_JISX0208_1983);
	jis1990 = get_wct(w,LCZ_2BC_JISX0208_1990);

	for ( i = 0 ; jis_table[i].unicode ; i ++ ) {
		if ( jis_table[i].jisx0201 ) {
			set_convert(
				w,
				jis_table[i].jisx0201,
				LCZM_1B_TYPE,
				jis_table[i].unicode|LCZ_2BC_UNICODE_v1_1_JP,
				SC_IF_NOTEXIST);
		}
		if ( jis_table[i].jisx0208_1978 ) {
			set_convert(
				w,
				jis_table[i].jisx0208_1978,
				LCZM_2B_TYPE,
				jis_table[i].unicode|LCZ_2BC_UNICODE_v1_1_JP,
				SC_IF_NOTEXIST);
		}
		if ( jis_table[i].jisx0208_1983 ) {
			set_convert(
				w,
				jis_table[i].jisx0208_1983,
				LCZM_2B_TYPE,
				jis_table[i].unicode|LCZ_2BC_UNICODE_v1_1_JP,
				SC_IF_NOTEXIST);
		}
		if ( jis_table[i].jisx0208_1990 ) {
			set_convert(
				w,
				jis_table[i].jisx0208_1990,
				LCZM_2B_TYPE,
				jis_table[i].unicode|LCZ_2BC_UNICODE_v1_1_JP,
				SC_IF_NOTEXIST);
		}
		if ( jis_table[i].jisx0212_1990 ) {
			set_convert(
				w,
				jis_table[i].jisx0212_1990,
				LCZM_2B_TYPE,
				jis_table[i].unicode|LCZ_2BC_UNICODE_v1_1_JP,
				SC_IF_NOTEXIST);
		}
	}
}

void
jis_setup_unicode(WCT * w)
{
WRITABLE_CODE_TABLE * t1;
int i;
	t1 = set_wct(w,LCZ_2BC_UNICODE_v1_1_JP,LCZM_2B_TYPE,0,0);
	set_wct(w,LCZ_2BC_UNICODE_v2_0_JP,LCZM_2B_TYPE,t1,0);
	set_wct(w,LCZ_2BC_UNICODE_v1_1_JP,LCZM_2B_TYPE,t1,0);
	for ( i = 0x4e00 ; i <= 0x9fa5 ; i ++ )
		t1->tbl[i] = i|LCZ_2BC_UNICODE_v1_1_JP;
}

void
wct_jp(WCT * w,int bitmap)
{
#define UNICODE_JP	\
	(LCB_UNICODE_v1_1_JP|LCB_UNICODE_v2_0_JP|LCB_UNICODE_v3_0_JP)
#define JIS (LCB_JISX0201| \
	LCB_JISX0208_1978|LCB_JISX0208_1983|LCB_JISX0208_1990| \
	LCB_JISX0212_1990)

	if ( bitmap == 0 ) {
		return;
	}
	else if ( (bitmap & UNICODE_JP) && (bitmap & JIS) == 0 ) {
		jis_convert(w,bitmap);
		jis_local2unicode(w);
		jis_setup_unicode(w);
		return;
	}
	else if ( (bitmap & UNICODE_JP) == 0 && (bitmap & JIS) ) {
		jis_convert(w,bitmap);
		jis_unicode2local(w);
		return;
	}
	else {
		jis_convert(w,bitmap);
		jis_local2unicode(w);
		jis_setup_unicode(w);
		return;
	}
}
