/**********************************************************************
 
	Copyright (C) 2003 Hirohisa MORI <joshua@nichibun.ac.jp>
 
	This program is free software; you can redistribute it 
	and/or modify it under the terms of the GLOBALBASE 
	Library General Public License (G-LGPL) as published by 

	http://www.globalbase.org/
 
	This program is distributed in the hope that it will be 
	useful, but WITHOUT ANY WARRANTY; without even the 
	implied warranty of MERCHANTABILITY or FITNESS FOR A 
	PARTICULAR PURPOSE.

**********************************************************************/



#include	<stdlib.h>
#include	"memory_debug.h"
#include	"utils.h"
#include	"task.h"
#include	"gbparam.h"



L_CHAR *
get_url_str(URL * u)
{
char * buf;
int len;
L_CHAR * ret;
	len = 0;
	if ( u->proto )
		len += l_strlen(u->proto);
	if ( u->server )
		len += l_strlen(u->server);
	if ( u->port != GBP_PORT )
		len += 5;
	if ( u->db )
		len += l_strlen(u->db);
	if ( u->resource )
		len += l_strlen(u->resource);
	buf = d_alloc((len + 10)*sizeof(L_CHAR),125);
	if ( u->proto ) {
		if ( u->server == 0 )
			goto from_db;
		if ( u->port != GBP_PORT ) {
			if ( u->db[l_strlen(u->db)-1] == '/' )
				sprintf(buf,"%s://%s:%i/%s%s",
					n_string(std_cm,u->proto),
					n_string(std_cm,u->server),
					u->port,
					n_string(std_cm,u->db),
					n_string(std_cm,u->resource));
			else	sprintf(buf,"%s://%s:%i/%s/%s",
					n_string(std_cm,u->proto),
					n_string(std_cm,u->server),
					u->port,
					n_string(std_cm,u->db),
					n_string(std_cm,u->resource));
		}
		else {
			if ( u->db[l_strlen(u->db)-1] == '/' )
				sprintf(buf,"%s://%s/%s%s",
					n_string(std_cm,u->proto),
					n_string(std_cm,u->server),
					n_string(std_cm,u->db),
					n_string(std_cm,u->resource));
			else	sprintf(buf,"%s://%s/%s/%s",
					n_string(std_cm,u->proto),
					n_string(std_cm,u->server),
					n_string(std_cm,u->db),
					n_string(std_cm,u->resource));
		}
	}
	else if ( u->server ) {
		if ( u->port != GBP_PORT ) {
			if ( u->db[l_strlen(u->db)-1] == '/' )
				sprintf(buf,"gbp://%s:%i/%s%s",
					n_string(std_cm,u->server),
					u->port,
					n_string(std_cm,u->db),
					n_string(std_cm,u->resource));
			else	sprintf(buf,"gbp://%s:%i/%s/%s",
					n_string(std_cm,u->server),
					u->port,
					n_string(std_cm,u->db),
					n_string(std_cm,u->resource));
		}
		else {
			if ( u->db[l_strlen(u->db)-1] == '/' )
				sprintf(buf,"gbp://%s/%s%s",
					n_string(std_cm,u->server),
					n_string(std_cm,u->db),
					n_string(std_cm,u->resource));
			else	sprintf(buf,"gbp://%s/%s/%s",
					n_string(std_cm,u->server),
					n_string(std_cm,u->db),
					n_string(std_cm,u->resource));
		}
	}
	else {
	from_db:
		if ( u->db ) {
			if ( u->db[l_strlen(u->db)-1] == '/' )
				sprintf(buf,"/%s%s",
					n_string(std_cm,u->db),
					n_string(std_cm,u->resource));
			else	sprintf(buf,"/%s/%s",
					n_string(std_cm,u->db),
					n_string(std_cm,u->resource));
		}
		else {
			sprintf(buf,"%s",n_string(std_cm,u->resource));
		}
	}
	ret = l_string(std_cm,buf);
	d_f_ree(buf);
	return ret;
}
