/**********************************************************************
 
	Copyright (C) 2003 Hirohisa MORI <joshua@nichibun.ac.jp>
 
	This program is free software; you can redistribute it 
	and/or modify it under the terms of the GLOBALBASE 
	Library General Public License (G-LGPL) as published by 

	http://www.globalbase.org/
 
	This program is distributed in the hope that it will be 
	useful, but WITHOUT ANY WARRANTY; without even the 
	implied warranty of MERCHANTABILITY or FITNESS FOR A 
	PARTICULAR PURPOSE.

**********************************************************************/




#include	"xlerror.h"
#include	"xl.h"


XL_SEXP * xl_LocalEval();

void
init_LocalEval(XLISP_ENV * env)
{
	set_env(env,l_string(std_cm,"LocalEval"),
		get_func_prim(xl_LocalEval,FO_NORMAL,0,3,3));
}

XL_SEXP *
xl_LocalEval(XLISP_ENV * env,XL_SEXP * s)
{
XL_SEXP * ret;
XL_SEXP * line;
XL_SEXP * cmd;
XL_INTERPRETER * xli;

	line = get_el(s,1);
	cmd = get_el(s,2);
	switch ( get_type(line) ) {
	case XLT_ERROR:
		return line;
	case XLT_INTEGER:
		break;
	default:
		goto typemissmatch;
	}

	return local_eval(line->integer.data,cmd);
typemissmatch:

	return get_error(
		s->h.file,
		s->h.line,
		XLE_SEMANTICS_TYPE_MISSMATCH,
		l_string(std_cm,"LocalEval"),
		list(	get_string(
			 l_string(std_cm,
				  "type missmatch in parameter")),
			0));
}

