/**********************************************************************
 
	Copyright (C) 2003 Hirohisa MORI <joshua@nichibun.ac.jp>
 
	This program is free software; you can redistribute it 
	and/or modify it under the terms of the GLOBALBASE 
	Library General Public License (G-LGPL) as published by 

	http://www.globalbase.org/
 
	This program is distributed in the hope that it will be 
	useful, but WITHOUT ANY WARRANTY; without even the 
	implied warranty of MERCHANTABILITY or FITNESS FOR A 
	PARTICULAR PURPOSE.

**********************************************************************/


#include	"xl.h"
#include	"xlerror.h"

XL_SEXP * xl_Projection();
XL_SEXP * sort_list();
XL_SEXP * get_join_option();
XL_SEXP * njoin_cmp_s();
XL_SEXP * xl_GetElement();
XL_SEXP * make_record();
void gc_gb_sexp();

int
njoin_cmp_field_list(XL_SEXP ** retp,XL_SEXP * flist,
	XL_SEXP * s1,XL_SEXP * s2);

void
init_Projection(XLISP_ENV * env)
{
	set_env(env,l_string(std_cm,"Projection"),
		get_func_prim(xl_Projection,FO_APPLICATIVE,0,2,2));
}

XL_SEXP * 
get_top_core(XL_SEXP * flist,XL_SEXP * s)
{
XL_SEXP * ret;
	ret = 0;
	for ( ; get_type(flist) ; flist = cdr(flist) ) {
		ret = cons(xl_GetElement(0,
			List(n_get_symbol("GetElement"),s,car(flist),-1)),
			ret);
	}
	if ( get_type(car(s)) == XLT_SYMBOL )
		return cons(car(s),ret);
	else	return cons(n_get_symbol("record"),ret);
}


XL_SEXP *
xl_Projection(XLISP_ENV * env,XL_SEXP * s,
	      XLISP_ENV * a,XL_SYM_FIELD * sf)
{
int opt;
XL_SEXP * s1,* s2, * sp1, * sp2;
XL_SEXP * m;
XL_SEXP * field_list;
XL_SEXP * nj_cmp;
XLISP_ENV * e;
int cmp;
XL_SEXP * ret;
XL_SEXP * result;
XL_SEXP * top;
XL_SEXP * table;
	table = n_get_symbol("table");
	opt = get_sort_option(sf);
	field_list = get_join_option(sf);
	s1 = get_el(s,1);
	e = new_env(gblisp_top_env0);
	set_env(e,l_string(std_cm,"field-list"),field_list);
	nj_cmp = get_func_prim(njoin_cmp_s,FO_APPLICATIVE,0,3,3);
	if ( opt & RO_SORT1 )
		s1 = sort_list(e,s1,nj_cmp);
	top = 0;
	result = 0;
	m = 0;
	gc_push(0,0,"Projection");
	gc_push(0,0,"Projection");
	for ( ; ; ) {


		sp1 = car(s1);
		cmp = njoin_cmp_field_list(&ret,field_list,
			top,sp1);
		if ( cmp == -2 ) {

			gc_pop(result,gc_gb_sexp);

			return ret;
		}
		if ( cmp ) {
			gc_pop(m,gc_gb_sexp); /* section 2 */
			if ( m ) {
				result = cons(
					append(top,
						cons(cons(table,m),0)),
					result);
			}

			gc_pop(result,gc_gb_sexp); /* section 1 */

			gc_push(result,gc_gb_sexp,"Proejction"); 
								/* section 1 */
			top = get_top_core(field_list,sp1);

			gc_push(0,0,"Projection"); /* section 2*/

			m = cons(make_record(field_list,
				List(n_get_symbol("record"),-1),
				sp1),0);
		}
		else {
			m = cons(make_record(field_list,
				List(n_get_symbol("record"),-1),
				sp1),m);

			gc_pop(m,gc_gb_sexp); /* section 2 */
			gc_push(m,gc_gb_sexp,"Projection"); /*section 2*/
		}
		s1 = cdr(s1);
		if ( get_type(s1) == 0 ) {
			if ( m ) {
				result = cons(
					append(top,
						cons(cons(table,m),0)),
					result);
			}

			break;
		}

	}
	gc_pop(result,gc_gb_sexp);
	gc_pop(result,gc_gb_sexp);
	return result;
}
