/**********************************************************************
 
	Copyright (C) 2003 Hirohisa MORI <joshua@nichibun.ac.jp>
 
	This program is free software; you can redistribute it 
	and/or modify it under the terms of the GLOBALBASE 
	Library General Public License (G-LGPL) as published by 

	http://www.globalbase.org/
 
	This program is distributed in the hope that it will be 
	useful, but WITHOUT ANY WARRANTY; without even the 
	implied warranty of MERCHANTABILITY or FITNESS FOR A 
	PARTICULAR PURPOSE.

**********************************************************************/


#include	"memory_debug.h"
#include	"xlerror.h"
#include	"xl.h"

XL_SEXP * xl_ReplaceString();

void
init_ReplaceString(XLISP_ENV * env)
{
	set_env(env,l_string(std_cm,"ReplaceString"),
		get_func_prim(xl_ReplaceString,FO_APPLICATIVE,0,4,4));
}

XL_SEXP *
replace_string_pair(XL_SEXP * str,L_CHAR * org,L_CHAR * new)
{
XL_SEXP * replace_string();
XL_SEXP * ret1, * ret2;
	ret1 = 0;
	for ( ; get_type(str) == XLT_PAIR ; str = cdr(str) )
		ret1 = cons(replace_string(car(str),org,new),ret1);
	ret2 = 0;
	for ( ; get_type(ret1) ; ret1 = cdr(ret1) )
		ret2 = cons(car(ret1),ret2);
	return ret2;
}

XL_SEXP *
replace_string_string(XL_SEXP * str,L_CHAR * org,L_CHAR* new)
{
L_CHAR * buf;
L_CHAR * ptr, * ptr_org;
int size_org, size_new, diff;
int cnt;
int len;
XL_SEXP * ret;

int len1,len2,cnt2;

	size_org = l_strlen(org);
	size_new = l_strlen(new);
	cnt = 0;
	for ( ptr = str->string.data ; *ptr ; )
		if ( memcmp(ptr,org,size_org*sizeof(L_CHAR)) == 0 ) {
			cnt ++;
			ptr += size_org;
		}
		else ptr ++;
	if ( cnt == 0 )
		return str;
	diff = size_new - size_org;
	if ( diff <= 0 ) {
		len1 = l_strlen(str->string.data);
		buf = ll_copy_str(str->string.data,1456);
	}
	else {
		len = l_strlen(str->string.data);
		buf = d_alloc(sizeof(L_CHAR)*(len1=len + cnt * diff + 2),1);
		memcpy(buf,str->string.data,(len+1)*sizeof(L_CHAR));
	}
	ptr_org = str->string.data; 
	for ( ptr = buf ; *ptr ; ) {
		if ( memcmp(ptr,org,size_org*sizeof(L_CHAR)) == 0 ) {
			l_strcpy(ptr+size_new,ptr_org+size_org);
			memcpy(ptr,new,sizeof(L_CHAR)*size_new);
			ptr += size_new;
			ptr_org += size_org;
		}
		else {
			ptr ++;
			ptr_org ++;
		}
	}
	ret = get_string(buf);
	d_f_ree(buf);
	return ret;
}


XL_SEXP *
replace_string(XL_SEXP * str,L_CHAR * org,L_CHAR * new)
{
	switch ( get_type(str) ) {
	case XLT_PAIR:
		return replace_string_pair(str,org,new);
	case XLT_STRING:
		return replace_string_string(str,org,new);
	}
	return str;
}




XL_SEXP *
xl_ReplaceString(XLISP_ENV * env,XL_SEXP * s)
{
XL_SEXP * new,* org,* str;
XL_SEXP * ret;
	str = get_el(s,1);
	org = get_el(s,2);
	new = get_el(s,3);
	if ( get_type(org) != XLT_STRING )
		goto type_missmatch;
	if ( get_type(new) != XLT_STRING )
		goto type_missmatch;
	ret = replace_string(str,org->string.data,new->string.data);
	return ret;
type_missmatch:
	return get_error(
		s->h.file,
		s->h.line,
		XLE_SEMANTICS_TYPE_MISSMATCH,
		l_string(std_cm,"ReplaceString"),
		0);
}

