/**********************************************************************
 
	Copyright (C) 2003 Hirohisa MORI <joshua@nichibun.ac.jp>
 
	This program is free software; you can redistribute it 
	and/or modify it under the terms of the GLOBALBASE 
	Library General Public License (G-LGPL) as published by 

	http://www.globalbase.org/
 
	This program is distributed in the hope that it will be 
	useful, but WITHOUT ANY WARRANTY; without even the 
	implied warranty of MERCHANTABILITY or FITNESS FOR A 
	PARTICULAR PURPOSE.

**********************************************************************/



#ifndef ___V_TYPES_H___
#define ___V_TYPES_H___

#define NeedFunctionPrototypes 1
#include	<X11/Xlib.h>
#include	<X11/Xutil.h>

#include <sys/errno.h>
#include "machine/msequence.h"
#include "machine/include.h"

typedef struct vobj_header {
	int			type;
	union vobject *		next;
	struct vwindow *	win;
	void			(*handler)(/* obj, cmd, ...*/);
	/* cmd */
#define VE_REDRAW	1
#define VE_BUTTON	2
#define VE_MAX		3

#define VES_BUTTON_PRESS	1
#define VES_BUTTON_RELEASE	2
#define VES_BUTTON_MOTION	3
} VOBJ_HEADER;

typedef struct vimage {
	VOBJ_HEADER		_h;
	char *			buf_8;
	short *			buf_16;
	long *			buf_32;
	int			x;
	int			y;
	int			w;
	int			h;
	int			w_border;

	int			select_flag;
		/* 1 --> select */
		/* 0 --> not select */
	VPOINT			select[2];

	XImage *		ximage;
} VIMAGE;

typedef struct vtext {
	VOBJ_HEADER		_h;
	int			mode;
#define VT_TRANS		1
#define VT_BACKGROUND		2
 	int			size;
	int			dir;
	int			st_x;
	int			st_y;
	L_CHAR *		data;
	int			length;
	unsigned long		color;
	unsigned long		background;
	VRECT			minrect;
} VTEXT;

typedef union vobject {
	VOBJ_HEADER	header;
#define VT_IMAGE	1
#define VT_TEXT		2
	VIMAGE		vimage;
	VTEXT		vtext;
} VOBJECT;


typedef struct v_map_tbl {
	unsigned int *		map[3];
#define GB2M_R	0
#define GB2M_G	1
#define GB2M_B	2
	int			pixel_bits;

	char			red_shift;
	char			green_shift;
	char			blue_shift;
	unsigned long		red_mask;
	unsigned long		green_mask;
	unsigned long		blue_mask;
	unsigned long		red_mul;
	unsigned long		green_mul;
	unsigned long		blue_mul;
} V_MAP_TBL;


typedef struct vfont {
	char *		fontname;
	short			id;
	XFontStruct *	fs;
} VFONT;

typedef struct vdisplay {
	/* machine indipendent members */

	int			(*err_handler)();
	struct vwindow *	win_list;
	void			(*handler[VE_MAX])();
	WCT *			wct;

	/* machine dipendent members */

	struct vdisplay *	next;
	Display *		d;
	Window			r; /* root window */
	Visual *		visual;
	Colormap		cmap;
	V_MAP_TBL		gb2m_map;

	VFONT			jisx0201;
	VFONT			jisx0208_1978;
	VFONT			jisx0208_1983;
	VFONT			jisx0208_1990;
	VFONT			jisx0212_1990;
	VFONT			iso8859_1;
	VFONT			iso8859_2;
	VFONT			iso8859_3;
	VFONT			iso8859_4;
	VFONT			iso8859_5;
	VFONT			iso8859_6;
	VFONT			iso8859_7;
	VFONT			iso8859_8;
	VFONT			iso8859_9;
	VFONT			iso8859_10;
	VFONT			iso8859_11;
	VFONT			iso8859_12;
	VFONT			iso8859_13;
	VFONT			iso8859_14;
	VFONT			iso8859_15;
	WCT *			font_work;
	int			font_flag;
	int			depth;

	struct vwindow *	for_string_pic;
} VDISPLAY;


#define GB2MCOLOR(tbl,f)	\
	((tbl).map[0][(f)&COL_MASK]|			\
		(tbl).map[1][((f)>>COL_BIT)&COL_MASK]|	\
		(tbl).map[2][((f)>>(COL_BIT*2))&COL_MASK])

#define GB2MCOLOR_D(d,f)	GB2MCOLOR(d->gb2m_map,f)

#define MCOLOR2GB(r,g,b,tbl,f)	\
	{							\
		(r) = ((((unsigned long)(f))&(tbl).red_mask)	\
				>>(tbl).red_shift)		\
				*(tbl).red_mul;			\
		(g) = ((((unsigned long)(f))&(tbl).green_mask)	\
				>>(tbl).green_shift)		\
				*(tbl).green_mul;		\
		(b) = ((((unsigned long)(f))&(tbl).blue_mask)	\
				>>(tbl).blue_shift)		\
				*(tbl).blue_mul;		\
	}


typedef struct vwindow {
	struct vwindow *	next;
	VOBJECT *		obj_list;

	VDISPLAY *		d;
	Window 			w;
	GC			gc;
} VWINDOW;

typedef struct vwindow_attributes {
	int			x;
	int			y;
	int			w;
	int			h;
} VWINDOW_ATTRIBUTES;

typedef struct v_open_win_s {
	VWINDOW * ret;
	VERROR * err;
	VDISPLAY * d;
	int x;
	int y;
	int w;
	int h;
	int map;
} V_OPEN_WIN_S;

VWINDOW * _get_vwin(VDISPLAY *,Window);

/*
#define CB_MACHINE_ORDER	CB_MSB_FIRST
*/

#endif
