/**********************************************************************
 
	Copyright (C) 2003 Hirohisa MORI <joshua@nichibun.ac.jp>
 
	This program is free software; you can redistribute it 
	and/or modify it under the terms of the GLOBALBASE 
	Library General Public License (G-LGPL) as published by 

	http://www.globalbase.org/
 
	This program is distributed in the hope that it will be 
	useful, but WITHOUT ANY WARRANTY; without even the 
	implied warranty of MERCHANTABILITY or FITNESS FOR A 
	PARTICULAR PURPOSE.

**********************************************************************/


#include	<stdlib.h>
#include	"change_endian.h"
#include	"memory_debug.h"
#include	"long_char.h"

typedef struct int_work {
	int		cnt;
	unsigned int	data;
} INT_WORK;

void * open_internal();
int close_internal(unsigned char *,void *);
int i2int(L_CHAR *,void*,unsigned char);
int int2i(unsigned char *,void*,L_CHAR);

CODE_METHOD int_cm = {
	"Internal",
	LCC_INTERNAL,
	0,
	4,
	0,
	{0,0},
	open_internal,
	close_internal,
	i2int,
	int2i,
	0
};


void *
open_internal()
{
INT_WORK * ret;
	ret = d_alloc(sizeof(INT_WORK));
	ret->cnt = 0;
	ret->data = 0;
	return ret;
}

int
close_internal(unsigned char * ret,void * work)
{
	d_f_ree(work);
	return 0;
}

int
i2int(L_CHAR * ret,void * _work,unsigned char ch)
{
unsigned int data;
INT_WORK * work;

	work = (INT_WORK*)_work;
	work->cnt ++;
	if ( endian_flag == 0 )
		work->data = (work->data<<8)|ch;
	else	work->data = (ch<<24)|((work->data>>8)&0xffffff);
	if ( work->cnt == 4 ) {
		work->cnt = 0;
		*ret = work->data;
		work->data = 0;
		return 1;
	}
	else {
		return 0;
	}
}

int
int2i(unsigned char * ret,void * _work,L_CHAR ch)
{
unsigned int * d;
	d = (unsigned int*)ret;
	*d = ch;
	return 4;
}
