/**********************************************************************
 
	Copyright (C) 2003 Hirohisa MORI <joshua@nichibun.ac.jp>
 
	This program is free software; you can redistribute it 
	and/or modify it under the terms of the GLOBALBASE 
	Library General Public License (G-LGPL) as published by 

	http://www.globalbase.org/
 
	This program is distributed in the hope that it will be 
	useful, but WITHOUT ANY WARRANTY; without even the 
	implied warranty of MERCHANTABILITY or FITNESS FOR A 
	PARTICULAR PURPOSE.

**********************************************************************/


#include	"memory_routine.h"
#include	"xl.h"
#include	"mlong_char.h"


XL_SEXP *
get_error(
	XL_FILE * f,
	int	line,
	int	er_code,
	L_CHAR * func,
	XL_SEXP * data)
{
XL_SEXP * s;

	s = get_sexp(0,XLT_ERROR);
	if ( f ) {
		if ( f->site )
			s->err.site = f->site;
		else	s->err.site = nl_copy_mstr(std_cm,"");
		if ( f->name )
			s->err.filename = ll_copy_mstr(f->name);
		else	s->err.filename = nl_copy_mstr(std_cm,"");
	}
	else {
		s->err.site = nl_copy_mstr(std_cm,"");
		s->err.filename = nl_copy_mstr(std_cm,"");
	}
	s->err.line = line;
	s->err.func = ll_copy_mstr(func);
	s->err.code = er_code;
	s->err.data = data;
	return s;
}

