/**********************************************************************
 
	Copyright (C) 2003 Hirohisa MORI <joshua@nichibun.ac.jp>
 
	This program is free software; you can redistribute it 
	and/or modify it under the terms of the GLOBALBASE 
	Library General Public License (G-LGPL) as published by 

	http://www.globalbase.org/
 
	This program is distributed in the hope that it will be 
	useful, but WITHOUT ANY WARRANTY; without even the 
	implied warranty of MERCHANTABILITY or FITNESS FOR A 
	PARTICULAR PURPOSE.

**********************************************************************/

#ifndef ___M_TASK_H___
#define ___M_TASK_H___

#include	<pthread.h>
#include	<semaphore.h>

#define THREAD_BLOCK_SIZE	2000

#define __M_THREAD_1_H__

#include	"m_thread.h"

#ifndef __M_THREAD_1_END_H__
typedef sem_t _SEM;
#endif

#ifdef DEADLOCK_CHECK
typedef struct _sem {
	struct _sem *	next;
	int		level;
	int		tid;
	sem_t		s;
	char *		lock_file;
	int		lock_line;
	char *		unlock_file;
	int		unlock_line;
} _SEM;

#endif

typedef _SEM * SEM;


typedef struct rw_lock {
	SEM		lock;
	int		read_cnt;
} RW_LOCK;



typedef struct fifo_el {
	struct fifo_el *	next;
} FIFO_EL;

typedef struct fifo {
	SEM			lock;
	int			length;
	struct fifo_el *	head;
	struct fifo_el *	tail;
} FIFO;

typedef int TKEY;
#define GET_TKEY(x)	(x)
int get_hard_tid(int);


void * new_block();
void free_block();

#define __M_THREAD_2_H__

#include	"m_thread.h"

#endif

