/**********************************************************************
 
	Copyright (C) 2003 Hirohisa MORI <joshua@nichibun.ac.jp>
 
	This program is free software; you can redistribute it 
	and/or modify it under the terms of the GLOBALBASE 
	Library General Public License (G-LGPL) as published by 

	http://www.globalbase.org/
 
	This program is distributed in the hope that it will be 
	useful, but WITHOUT ANY WARRANTY; without even the 
	implied warranty of MERCHANTABILITY or FITNESS FOR A 
	PARTICULAR PURPOSE.

**********************************************************************/


#include	<stdio.h>
#include	<stdlib.h>
#include	"memory_debug.h"
#include	"v.h"
#include	"gbf.h"
#include	"utils.h"

extern int fontsize;
extern char * display_key;

#define GBF_HASH_SIZE	20
GBF_DATA * gbf_hash[GBF_HASH_SIZE];

void
gbf_init()
{
int i;
	for ( i = 0 ; i < GBF_HASH_SIZE ; i++ )
		gbf_hash[i] = 0;
}

GBF_DATA *
gbf_search(short id)
{
int key;
GBF_DATA * ret;
	if ( id == 0 )
		return 0;
	key = id % GBF_HASH_SIZE;
	for ( ret = gbf_hash[key] ; ret ; ret = ret->next )
		if ( ret->id == id )
			break;
	return ret;
}

void
gbf_get_font(
	VFONT *		vf,
	VDISPLAY * 	d,
	char * 		fontname)
{
GBF_HEADER head;
GBF_DATA * dat;
FILE * f;
int key;
static short font_id = 1;

	dat = d_alloc(sizeof(GBF_DATA));
	
	sprintf(dat->path, "%s/%d/%s.gbf", display_key, fontsize, fontname);
	fprintf(stderr, "gbf load : %s\t", dat->path);
	f = fopen(dat->path, "r");
	if ( f == 0 || fread(&head, sizeof(head), 1, f) != 1 ) {
		perror(" ");
		vf->fontname = 0;
		vf->id = 0;
		d_f_ree(dat);
		if ( f )
			fclose(f); 
		return;
	}
	fclose(f);
	fprintf(stderr, " : OK (id = %d)\n", font_id);
	
	vf->fontname = copy_str(head.fontname);
	vf->id = font_id;
	
	dat->st_no = head.st_no;
	dat->end_no = head.end_no;
	dat->nos = head.nos;
	
	key = font_id % GBF_HASH_SIZE;
	dat->id = font_id;
	dat->ofs = 0;
	dat->next = gbf_hash[key];
	gbf_hash[key] = dat;
	
	font_id++;
}

