/**********************************************************************
 
	Copyright (C) 2003 Hirohisa MORI <joshua@nichibun.ac.jp>
 
	This program is free software; you can redistribute it 
	and/or modify it under the terms of the GLOBALBASE 
	Library General Public License (G-LGPL) as published by 

	http://www.globalbase.org/
 
	This program is distributed in the hope that it will be 
	useful, but WITHOUT ANY WARRANTY; without even the 
	implied warranty of MERCHANTABILITY or FITNESS FOR A 
	PARTICULAR PURPOSE.

**********************************************************************/


#include "kibandata.h"

typedef struct zuyou_data{
	char szDataFileKind[32];
	char szOrganization[32];
	char szCreatedDate[32];
	char szModifiedDate[1024];
	char szMapName[16];
	int nMapInfoLevel;
	int nCoordinate;
	MAP_RECT rMap;
	char szUnit[16];/* ɸñ */
	char pszSurroundMapNames[8][16]; /* ܣ̾ */
	int nFileCount;
	char *pszUsingFileNames[96];
} ZUYOU_DATA;

void free_zuyou_data(ZUYOU_DATA *pData);
int ReadZuyouDataFile(const char *szFileName, ZUYOU_DATA **ppData);
int Zuyou2XML(FILE *fp, ZUYOU_DATA *pData);
int ZuyouFile2XML(FILE *fp, const char *szInputFileName);
