require 'time'
require "Sports_data.rb"

class HRM

  attr_accessor :params, :other, :hrdata

  def initialize()
    @hrdata = {};
    @params = {};
    @other = [];
  end

  def HRM.load(file) 
    hrm = new
    io = open(file)

    while "[Note]" != (tmp = io.readline.chomp)
      if tmp != "[Params]" && tmp != ""
        tmp2 = tmp.split("=")
        hrm.params[tmp2[0]] = tmp2[1]
      end
    end
     
    if hrm.params["Version"] != "106"
      return nil
    end

    if hrm.params["Monitor"] != "12"
      return nil
    end

    smode_flag = []
    smode_flag[0] =  "Speed"
    smode_flag[1] =  "Cadence"
    smode_flag[2] =  "Altitude"
    smode_flag[3] =  "Power"
    smode_flag[4] =  "Power Balance and Pedalling Index"
    smode_flag[5] =  "Power Pedalling Index"
    smode_flag[6] =  "HR/CC data"
    smode_flag[7] =  "US/Euro unit"
    smode_flag[8] =  "Air pressure"

    hash = {}
    smode = hrm.params["SMode"]
    for index in 0...smode.length
      hash[smode_flag[index]] = 
        if index == 6
          if smode[index] == ?1 then "HR and cycling data" else "HR data only" end
        elsif index == 7
          if smode[index] == ?1 then "US" else "Euro" end
        else
          if smode[index] == ?1 then "on" else "off" end
        end
    end
    hrm.params["SMode"] = hash

    i=0
    while "[HRData]" != (tmp = io.readline.chomp)
      hrm.other[i] = tmp
      i=i+1
    end

    hrdatas = ["Heart Rates", "Speed", "Cadence", "Altitude", "Power", "Power Balance and Pedalling Index", "Air pressure"]

    i = Time.parse(hrm.params["Date"]+" "+hrm.params["StartTime"]).to_i
    hash = {}
    while tmp = io.gets
      hrm.hrdata[i] = Parse_hrm(tmp.chomp.split, hrm.params["SMode"])
      i=i+hrm.params["Interval"].to_i
    end

    io.close
    
    hrm
  end
  
  def HRM.Parse_hrm(record, smode)
    ret = {}
    i = 0

    ret["Heart Rates"] = record[i]
    i=i+1
    
    if smode["Speed"]    == "on" 
      ret["Speed"] = record[i]
      i=i+1
    end
    if smode["Cadence"]  == "on"
      ret["Cadence"] = record[i]
      i=i+1
    end
    if smode["Altitude"] == "on" 
      ret["Altitude"] = record[i] 
      i=i+1
    end
    if smode["Power"]    == "on" 
      ret["Power"] = record[i] 
      i=i+1
    end
    if smode["Power Balance and Pedalling Index"]    == "on"
      ret["Power Balance and Pedalling Index"] = record[i]
      i=i+1
    end
    if smode["Air pressure"]    == "on" 
      ret["Air pressure"] = record[i] 
      i=i+1
    end
    
    ret
  end

  def save(file)
    io = open(file, "w")
    io.printf("[Params]\r\n")
    for k in ["Version", "Monitor", "SMode", "Date", "StartTime", "Length", "Interval", "Upper1", "Lower1", "Upper2", "Lower2", "Upper3", "Lower3", "Timer1", "Timer2", "Timer3", "ActiveLimit", "MaxHR", "RestHR", "StartDelay", "VO2max", "Weight"] do
      v = @params[k]
      if k == "SMode"
        ary = []
        ary.push(if v["Speed"] == "on" then "1" else "0" end )
        ary.push(if v["Cadence"] == "on" then "1" else "0" end )
        ary.push(if v["Altitude"] == "on" then "1" else "0" end )
        ary.push(if v["Power"] == "on" then "1" else "0" end )
        ary.push(if v["Power Balance and Pedalling Index"] == "on" then "1" else "0" end )
        ary.push( if v["Power Pedalling Index"] == "on" then "1" else "0" end )
        ary.push( if v["HR/CC data"] == "HR and cycling data" then "1" else "0" end )
        ary.push( if v["US/Euro unit"] == "US" then "1" else "0" end )
        ary.push( if v["Air pressure"] == "on" then "1" else "0" end )
        io.printf("%s=%s\r\n", k, ary)
      else
        io.printf("%s=%s\r\n", k, v)
      end
    end  
    io.printf("\r\n[Note]\r\n")
    @other.each{|i| io.printf("%s\r\n",i)}
    io.printf("[HRData]\r\n")
    @hrdata.keys.sort.each{|k| 
      v = @hrdata[k]
      io.printf("%d", v["Heart Rates"])
      if @params["SMode"]["Speed"] == "on" then io.printf("\t%d", v["Speed"]) end
      if @params["SMode"]["Cadence"] == "on" then io.printf("\t%d", v["Cadence"]) end
      if @params["SMode"]["Altitude"] == "on" then io.printf("\t%d", v["Altitude"]) end
      if @params["SMode"]["Power"] == "on" then io.printf("\t%d", v["Power"]) end
      if @params["SMode"]["Power Balance and Pedalling"] == "on" 
        io.printf("\t%d", v["Power Balance and Pedalling"]) 
      end
      if @params["SMode"]["Air pressure"] == "on" 
        io.printf("\t%d", v["Air pressure"]) 
      end
      io.printf("\r\n")
    }
    io.close
  end

  def add_speed(sportsData, delta=0)
    @params["SMode"]["Speed"] = "on"
    @hrdata.keys.sort.each{|time|
      @hrdata[time]["Speed"] = sportsData.get_speed(time+delta).to_f * 10
    }
  end

end
